/* 
 * Standalone driver for VMEBUS ISI Graphics Processor (GIP):
 *	NOTE: non-UCODE version is out of date...
 *   	comment following out definition of GIP for stubs, see ./sio.c.
 */
#define GIP

#include "sais68k.h"
#include "../h/param.h"

#ifndef	GIP
putgip(c){}				/* stub */
#else	GIP

#include "../is68k/board.h"
#include "../is68kdev/gpreg.h"

/*
 * possible graphics processor address tuples
 */
#define	GP_NADDR	8

struct gp_addr_tuple {
	ushort		*dm;		/* display memory */
	struct gpdevice	*addr;		/* gip address */
} gp_addrs[GP_NADDR] = {
	{(ushort *)&vme_std[0xE00000],(struct gpdevice *)&vme_stdio[0xFFC000]},
	{(ushort *)&vme_std[0xD00000],(struct gpdevice *)&vme_stdio[0xFF8000]},
	{(ushort *)&vme_std[0xC00000],(struct gpdevice *)&vme_stdio[0xFF4000]},
	{(ushort *)&vme_std[0xB00000],(struct gpdevice *)&vme_stdio[0xFF0000]},
	{(ushort *)&vme_std[0xA00000],(struct gpdevice *)&vme_stdio[0xFEC000]},
	{(ushort *)&vme_std[0x900000],(struct gpdevice *)&vme_stdio[0xFE8000]},
	{(ushort *)&vme_std[0x800000],(struct gpdevice *)&vme_stdio[0xFE4000]},
	{(ushort *)&vme_std[0x700000],(struct gpdevice *)&vme_stdio[0xFE0000]},
};

#define	SCREENW_MAX	1280		/* MAX (1280, 1024) */
#define	SCREENH_MAX 	1440		/* MAX (1024, 1440) */
#define CHAR_HEIGHT	20
#define CHAR_WIDTH	12
#define GIP_DELAY	50000

int	screenw = 1280;			/* default screen width */
int	screenh = 1024;			/* default screen height */
int	g_init;				/* processor initialized */
struct gpdevice *gpaddr;		/* pointer to gip registers */
int gpucode = 1;			/* use micro code for commands */
static int	col;			/* current column */
static int	g_ing; 			/* stop recursion on printfs */
#ifdef	M68010
/* remap on display memory */
/*char gp_mem_map[((SCREENW_MAX*SCREENH_MAX)/8) + NBPG*4]; /**/
char gp_mem_map[(256*1024) + NBPG];
#endif	M68010
static int xxx;

static unsigned short gp_initcmds[] = {
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,
	GP_INTOF, GP_INTOF, GP_INTOF, GP_INTOF,		/* flush fifo*/
	GP_CLIPOF,
	GP_ALUC,
	GP_SPTCH, 0x28,
	GP_DPTCH, 0x28,
	0xFFFF						/* end marker */
};
unsigned short gp_iscrollcmd[] = {
#define	ISCROLL_PATCH_W	5	/* screenw */
#define	ISCROLL_PATCH_H 4	/* (((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT) */
	GP_BOX,0,0,0,ISCROLL_PATCH_H,ISCROLL_PATCH_W,CHAR_HEIGHT*3,0xFFFF
};
unsigned short gp_scrollcmd[] = {
#define	SCROLL_PATCH_W	9	/* screenw */
#define	SCROLL_PATCH_H	10	/* screenh */
	GP_BOXC,0,0,0,CHAR_HEIGHT,0,0,0,0,SCROLL_PATCH_W,SCROLL_PATCH_H,0xFFFF
};


/*
 * Screen parameters
 */
struct raster
{
	short    width;
	short   *address;
} screen;


extern int plane_desc;

typedef int	    *COLOR;
/* Video Colors */
#define BLACK	0
int black = BLACK;
#define WHITE	1
int white = WHITE;

#define UCODE_WAIT(x)	{   x->gp_fifo = GP_INTOF;			\
			    DELAY(128);					\
			    while ((x->gp_fifo&(1<<GPFIFOEMPTY)) == 0);	\
			    DELAY(128);					\
			}

static
g_iscroll()
{
	if (gpucode)
		gp_cmd(gp_iscrollcmd);
	else
		ClearRaster(&screen, 0, ((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT,
			screenw, CHAR_HEIGHT*3, BLACK);
}

static
g_scroll()
{
	if (gpucode)
		gp_cmd(gp_scrollcmd);
	else
		CopyRaster(&screen, 0, CHAR_HEIGHT, &screen, 0, 0, screenw, 
			screenh);
}

static
g_putchar(ccol,c)
int ccol;
char *c;
{
	register struct gpdevice *gp = gpaddr;

	if (gpucode)
		UCODE_WAIT(gp);
	DrawString(40+ccol*CHAR_WIDTH,
		(((screenh/CHAR_HEIGHT))*CHAR_HEIGHT)-5,
		&plane_desc,&white,1,c);
}

static
g_blank(ccol)
{
	register struct gpdevice *gp = gpaddr;

	if (gpucode) {
		gp->gp_fifo = GP_BOX;			/* box */
		gp->gp_fifo = 0;			/* dest_h */
		gp->gp_fifo = 0;			/* dest_l */
		gp->gp_fifo = 40+ccol*CHAR_WIDTH;	/* xd */
		gp->gp_fifo=
			(((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT);/* yd */
		gp->gp_fifo = CHAR_WIDTH;		/* w */
		gp->gp_fifo = CHAR_HEIGHT*2;		/* h */
		UCODE_WAIT(gp);
	} else {
		ClearRaster(&screen, 40+ccol*CHAR_WIDTH,
			(((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT),
			CHAR_WIDTH, CHAR_HEIGHT*2, BLACK);
	}
}

static
g_block(ccol)
{
	register struct gpdevice *gp = gpaddr;

	if (gpucode) {
		gp->gp_fifo = GP_ALUS;
		gp->gp_fifo = GP_BOX;			/* box */
		gp->gp_fifo = 0;			/* dest_h */
		gp->gp_fifo = 0;			/* dest_l */
		gp->gp_fifo = 40+ccol*CHAR_WIDTH;	/* xd */
		gp->gp_fifo=
			(((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT);/* yd */
		gp->gp_fifo = CHAR_WIDTH;		/* w */
		gp->gp_fifo = CHAR_HEIGHT*2;		/* h */
		gp->gp_fifo = GP_ALUC;
		UCODE_WAIT(gp);
	} else {
		ClearRaster(&screen, 40+ccol*CHAR_WIDTH,
			(((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT),
			CHAR_WIDTH, CHAR_HEIGHT*2, WHITE);
	}
}

g_putc(c)
register int c;
{
#ifdef	M68010
	extern ushort *shortio;
#endif	M68010
	register int x, dm, i;
	register unsigned short *p, pv;
	char ch;
	register short ccol = col;

	if (g_ing)
		return;
	g_ing = 1;

	if (!g_init) {
	    g_init++;
	    DELAY(GIP_DELAY);		/* wait for mem so probe's will work */
	    i = vbnum;
	    if (i >= 0 && i < GP_NADDR	/* first clusters get graphics */
#ifdef	M68010
	        && gp_addrs[i].dm > (shortio+0x8000)
#endif	M68010
		) {
		    dm = (int)gp_addrs[i].dm;
#ifdef	M68020
		    screen.address = (short *)dm;
#else	M68020
		    screen.address = (short *)
				((((int)gp_mem_map)+PGOFSET) & 0x007FF000);
		    mapin(screen.address, dm, 256*1024);
#endif	M68020
		    if (probe(screen.address, &xxx)) {
		    	if (gpucode && probe(gp_addrs[i].addr, &xxx) && 
			    !probeb((int)gp_addrs[i].addr + 1, &xxx)) {
				gpaddr = gp_addrs[i].addr;
/*printf("GIP at (%x,%x)\n",screen.address,gpaddr);/**/
				gp_cmd(gp_initcmds);
			} else {
				gpucode = 0;
		    		gpaddr = (struct gpdevice *)
				    (((char *)screen.address) + GPCSR_256_OFF);
/*printf("MWS at (%x,%x,%x)\n",screen.address,gpaddr,gpaddr->gp_csr);/**/
				if ((gpaddr->gp_csr & GPCSR_R_MASK) == 
				    GPCSR_R_1024x1440) {
					screenw = 1024;
					screenh = 1440;
				}
			}
			screen.width = screenw/8;
			gp_iscrollcmd[ISCROLL_PATCH_W] = screenw;
			gp_iscrollcmd[ISCROLL_PATCH_H] = 
				((screenh/CHAR_HEIGHT)-1)*CHAR_HEIGHT;
			gp_scrollcmd[SCROLL_PATCH_W] = screenw;
			gp_scrollcmd[SCROLL_PATCH_H] = screenh;
			g_iscroll();
			g_scroll();
		    }
		}
	}

	if (gpaddr == 0) {
		g_ing = 0;
		return;
	} 
	g_blank(ccol);
	if (c == '\r')
		ccol = 0;
	else if (c == '\n') {
		g_scroll();
		ccol = 0;
	} else if (c == '\t') {
		for (i = 8 - (ccol&7); i > 0 ; i--) {
			g_blank(ccol);
			ccol++;
		}
	} else if (c == ' ') {
		g_blank(ccol);
		ccol++;
	} else if (c == '\b') {
		ccol--;
		if (ccol < 0)
			ccol = 0;
		g_blank(ccol);
	} else if (c >= ' ' && c < '') {
		ch = c;
		g_blank(ccol);
		g_putchar(ccol, &ch);
		ccol++;
	}
	g_block(ccol);
	g_ing = 0;
	col = ccol;
	return;
}

gp_cmd(cmdstr)
register ushort *cmdstr;
{
	register struct gpdevice *gp = gpaddr;

	while (*cmdstr != 0xFFFF) {
		gp->gp_fifo = *cmdstr;
		cmdstr++;
	}
	UCODE_WAIT(gp);
}
#endif	GIP
