#define	ASCII_SNS_7_KEY
#define	ASCII_DCB_CERR

#include "saio.h"
#include "sais68k.h"
#include <setjmp.h>
#include <ctype.h>
#include "../is68kdev/scsi.h"
#include "../is68kdev/gsreg.h"

/*                          /-----ctlr----\
 *             ________________________________
 * i_unit:     | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
 *             --------------------------------
 *                          \_____/ \_____/ \_/
 *                           cont    device  lun
 */
#define	NGD			4
#define	NGD_DEV			4
#define	NGD_LUN			2
#define	GD_UNIT(cont, dev, lun)	(((cont&3)<<3)|((dev&3)<<1)|(lun&1))
#define GD_GSCTLR(cont, dev)	((cont << 3) | dev)
#define	GDU_LUN(unit)		(unit&1)
#define	GDU_CTLR(unit)		((unit >> 1)&0xF)
#define	GDU_DEVICE(unit)	(GDU_CTLR(unit) & 3)
#define	GDU_CONT(unit)		((GDU_CTLR(unit) >> 2) & 3)
#define	GDU_GSCTLR(unit)	((GDU_CONT(unit) << 3) | GDU_DEVICE(unit))

#define GD_MAXCNT	0x1FE00
#define GD_MAXRETRY	3

int	forbb, xbad144, xbad144_soft, xbad144_hadsoft, gdstrat();
int	gd_formatting	= 0;

union scsi_sns		gd_sns;
struct scsi_inq		gd_inq;
struct scsi_msen	gd_msen;
struct scsi_msel	gd_msel;
struct scsi_rcap	gd_rcap;

gdopen(io)
	register struct iob *io;
{
	if (gsopen(GDU_GSCTLR(io->i_unit)) || gdinq(io->i_unit) || gdsize(io)) {
		printf("gd%d: device not responding\n", io->i_unit);
		return (-1);
	}
	if ((io->i_boff = diskpart(io)) < 0) {
		printf("gd%d: bad offset\n", io->i_unit);
		return (-1);
	}
	if (gdslctmod(io->i_unit))
		return (0);
	return (0);
}

gdstrategy(io, func)
	register struct iob	*io;
{
	register int	bleft, bpart, bn = io->i_bn;

	func = (func == READ) ? CMD_XREAD : CMD_XWRITE;
	bleft = io->i_cc;
	do {
		bpart = (bleft < GD_MAXCNT) ? bleft : GD_MAXCNT;
		if (forbb) {
			if (gdstrat(io, bn, bpart, func) == -1)
				return (-1);
			io->i_ma += bpart;
		} else if (badstrat(io,bn,bpart,func,gdstrat,CMD_XREAD) == -1)
			return (-1);
		bleft -= bpart;
		bn += bpart / io->i_st.nbsec;
	} while (bleft > 0);
	return (io->i_cc);
}

gdstrat(io, bn, bpart, func)
	register struct iob	*io;
{
	register struct hacb_dcb	*dcb = gsgetdcb(GDU_GSCTLR(io->i_unit));
	int				count = 0;

	while (1) {
	    SET_CDB_1(&dcb->dcb_cdb, func,  GDU_LUN(io->i_unit), 0, bn,
		(bpart+511)>>9, 0, 0);
	    SET_DCB(dcb, DCB_NOIE, (func==CMD_XREAD) ? DCB_DIR_IN : DCB_DIR_OUT,
		DCB_NOSW, DCB_NODISC, sizeof (struct cdb_1), DCB_BW_16,
		DCB_AM_STD_S_D, 0, io->i_ma, bpart & ~0x1, 512);
	    switch (gdissue((func==CMD_XREAD)?"READ":"WRITE",dcb,io->i_unit,0)){
		case  0:	return (0);			/* ok */
		case  -1:	return (-1);			/* hard error */
		case  1:	if (++count == GD_MAXRETRY)	/* retry */
					return (-1);
	    }
	}
}

gdissue(command, dcb, unit, silient)
	register char			*command;
	register struct hacb_dcb	*dcb;
	register int			silient;
{
	register int nsense = 0;
#define	SHHHH(x)	{ if (!silient) x;}

	dcb->dcb_err = 0;
	if (gspoll(GDU_GSCTLR(unit), gd_formatting ? 1000000 : 80000))
		return (-1);
	if (dcb->dcb_err == 0)		/* return if no error */
		return (0);
	if ((dcb->dcb_scsi_status & SCSI_STATUS_CHECK) == 0) {
	    SHHHH(printf("gd%d: %s: fatal error: %s: scsi %b\n", unit, command,
		ascii_dcb_cerr[dcb->dcb_cerr], dcb->dcb_scsi_status,
		SCSI_STATUS_BITS));
	    return (-1);
	}
sns:	SET_CDB_0(&dcb->dcb_cdb, CMD_SENSE, GDU_LUN(unit), 0, sizeof (gd_sns),
	    0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, paddr(&gd_sns),
	    sizeof (gd_sns), 1);
	if (gspoll(GDU_GSCTLR(unit), 8000)) {
	    SHHHH(printf("gd%d: SENSE timeout\n", unit));
	    return (-1);
	}
	if (dcb->dcb_err) {
	    dcb->dcb_err = 0;
	    if (nsense++ < 5)
		goto sns;
	    SHHHH(printf("gd%d: SENSE: fatal error: %s: scsi %b\n", unit,
		ascii_dcb_cerr[dcb->dcb_cerr], dcb->dcb_scsi_status,
		SCSI_STATUS_BITS));
	    return (-1);
	}
	if (gd_sns.sns_7.sns_7_class != 7) {
	    SHHHH(printf("gd%d: invalid sense class %d\n", unit,
		gd_sns.sns_7.sns_7_class));
	    return (-1);
	}
	SHHHH(printf("gd%d: %s: %s: code %x", unit, command,
	    ascii_sns_7_key[gd_sns.sns_7.sns_7_key], gd_sns.sns_7.sns_7_err));
	if (gd_sns.sns_7.sns_7_valid)
	    SHHHH(printf(": bn %d", SCSI_HMML(gd_sns.sns_7.sns_7_info)));
	switch (gd_sns.sns_7.sns_7_key) {
	    case SNS_7_KEY_RECOVERED:
		SHHHH(printf(": soft error\n"));
		if (xbad144_soft) {
		    xbad144_hadsoft = 1;
		    return (-1);
		}
		return (0);

	    case SNS_7_KEY_ABORT_CMD:
	    case SNS_7_KEY_UNIT_ATTN:
		SHHHH(printf(": reissued\n"));
		return (1);

	    default:
		SHHHH(printf(": hard error\n"));
		return (-1);
	}
}

gdinq(unit)
{
	register int			lun  = GDU_LUN(unit);
	register int			ctlr = GDU_CTLR(unit);
	register int			gsctlr = GDU_GSCTLR(unit);
	register struct hacb_dcb	*dcb = gsgetdcb(gsctlr);

	/* do an inquiry command and find out what kind of device it is */
	SET_CDB_0(&dcb->dcb_cdb, CMD_INQUIRY, lun, 0, sizeof(gd_inq), 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, paddr(&gd_inq),
	    sizeof (gd_inq), 1);
	if (gdissue("INQUIRY", dcb, unit, 1)) {
	    SET_CDB_0(&dcb->dcb_cdb, CMD_INQUIRY, lun, 0, sizeof(gd_inq), 0, 0);
	    SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
		sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
		paddr(&gd_inq), sizeof (gd_inq), 1);
	    if (gdissue("INQUIRY", dcb, unit, 1))
		return (-1);
	}
	if (gd_inq.inq_pdtype != INQ_PDT_DISK) {
		printf("gd%d: not a disk\n", unit);
		return (0);
	}

	/* spin unit up and see if it is ready */
	SET_CDB_0(&dcb->dcb_cdb, CMD_STARTSTOP, lun, 0, 1, 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_NO, 0, DCB_NODISC, sizeof(struct cdb_0),
	    0, 0, 0, 0, 0, 0);
	if (gdissue("START", dcb, unit, 0))
		return (-1);
	DELAY(200000);			/* warm up, dont want BUSY status */

	SET_CDB_0(&dcb->dcb_cdb, CMD_TESTREADY, lun, 0, 0, 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_NO, 0, DCB_NODISC, sizeof (struct cdb_0),
	    0, 0, 0, 0, 0, 0);
	if (gdissue("TESTREADY", dcb, unit, 0))
		return (-1);
	return (0);
}

gdsize(io)
	register struct iob	*io;
{
	register int			lun  = GDU_LUN(io->i_unit);
	register struct hacb_dcb	*dcb = gsgetdcb(GDU_GSCTLR(io->i_unit));
	register struct pag_desc	*pd;
	register int			spd, spc;

	/* get capacity information */
	SET_CDB_1(&dcb->dcb_cdb, CMD_RCAPAC, lun, 0, 0, 0, 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_1), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_rcap), sizeof(gd_rcap), 1);
	if (gdissue("RCAPAC", dcb, io->i_unit, 0))
		return (-1);
	spd = gd_rcap.rcap_lba + 1;	/* sectors per disk */
	io->i_st.nbsec = gd_rcap.rcap_bl;
	if (io->i_st.nbsec != 512) {
		printf("gd%d: bad blocksize (%d)\n", io->i_unit, io->i_st.nbsec);
		return (-1);
	}

	/* Get cylinder boundary, by setting PMI */
	SET_CDB_1(&dcb->dcb_cdb, CMD_RCAPAC, lun, 0, 1, 1, 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_1), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_rcap), sizeof(gd_rcap), 1);
	if (gdissue("RCAPAC PMI", dcb, io->i_unit, 0))
		return (-1);
	spc = gd_rcap.rcap_lba + 1;	/* sectors per cylinder */

	/* get current value geometry information */
	SET_CDB_0(&dcb->dcb_cdb, CMD_MSENSE, lun, PD_GEOMETRY<<8,
	    sizeof(gd_msen), 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_msen), sizeof(gd_msen), 1);
	if (gdissue("MSENSE GEO", dcb, io->i_unit, 0))
		return (-1);
	pd = (struct pag_desc *)(((char *)&gd_msen.msen_bd)+gd_msen.msen_bdl);
	io->i_st.ncyl = SCSI_HML(pd->pd_pg.pg_geo.geo_cyl);
	io->i_st.ntpc =  pd->pd_pg.pg_geo.geo_heads;

	/* get current value format information */
	SET_CDB_0(&dcb->dcb_cdb, CMD_MSENSE, lun, PD_FORMAT<<8, sizeof(gd_msen),
	    0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_msen), sizeof(gd_msen), 1);
	if (gdissue("MSENSE FMT", dcb, io->i_unit, 0))
		return (-1);
	pd = (struct pag_desc *)(((char *)&gd_msen.msen_bd)+gd_msen.msen_bdl);
	io->i_st.nsect =  pd->pd_pg.pg_fmt.fmt_spt;

	/* test geometry for consistency */
	if ((io->i_st.nsect * io->i_st.ntpc * io->i_st.ncyl) == 0) {
		printf("gd%d: nonsense geometry (%dx%dx%d)\n", io->i_unit,
		    io->i_st.nsect, io->i_st.ntpc, io->i_st.ncyl);
		return (-1);  /* nonsense geometry */
	}

	/* if capacity is less than calculated size, try various adjustments */
	if ((io->i_st.nsect * io->i_st.ntpc * io->i_st.ncyl) != spd) {
	    /* if cylinder size too small, try subtracting alternate sectors */
	    if ((io->i_st.nsect * io->i_st.ntpc) > spc &&
		pd->pd_pg.pg_fmt.fmt_tpz != 0)
		    io->i_st.nsect - = pd->pd_pg.pg_fmt.fmt_alt_spz /
					pd->pd_pg.pg_fmt.fmt_tpz;

	    /* if cylsize still too small, try subtracting alt tracks */
	    if (((io->i_st.nsect * io->i_st.ntpc) > spc)  &&
		 (io->i_st.ntpc == pd->pd_pg.pg_fmt.fmt_tpz))
		      io->i_st.ntpc -= pd->pd_pg.pg_fmt.fmt_alt_tpz;

	    /* if spc still wrong */
	    if ((io->i_st.nsect * io->i_st.ntpc) != spc) {
		/* if spc not multiple of headcount */
		if (spc % io->i_st.ntpc) {
		    /* and spc not multiple of tracksize */
		    /* then just take blocks off end of disk */
		    if (spc % io->i_st.nsect)
			spc = io->i_st.nsect * io->i_st.ntpc;
		    else		/* spc multiple of tracksize  */
			io->i_st.ntpc = spc / io->i_st.nsect;
		} else			/* spc multiple of headcount */
		    io->i_st.nsect = spc / io->i_st.ntpc;
	    }

	    /* spc now ok; if still unequal, drop cylinders at end */
	    if ((io->i_st.nsect * io->i_st.ntpc * io->i_st.ncyl) != spd)
		io->i_st.ncyl = spd / spc;
	}
	io->i_st.nspc = io->i_st.nsect * io->i_st.ntpc;
	io->i_st.off = NULL;
	return (0);
}

gdslctmod(unit)
{
	register int			lun  = GDU_LUN(unit);
	register struct hacb_dcb	*dcb = gsgetdcb(GDU_GSCTLR(unit));
	register struct pag_desc	*pdn, *pdl;
	int				len;

	/* get the current error recovery parameter page in msen */
	SET_CDB_0(&dcb->dcb_cdb, CMD_MSENSE, lun, PD_ERROR<<8, sizeof(gd_msen),
	    0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_msen), sizeof(gd_msen), 1);
	if (gdissue("MSENSE ERR", dcb, unit, 0))
		return (-1);
	pdn = (struct pag_desc *)(((char *)&gd_msen.msen_bd)+gd_msen.msen_bdl);
	if (pdn->pd_pg.pg_err.err_per)
		return (0);
	len = gd_msen.msen_len + 1;
	gd_msen.msen_len = 0;
	gd_msen.msen_wprot = 0;
	gd_msel = *((struct scsi_msel *)&gd_msen);

	/* get changable status of error recovery parameters page in msen */
	SET_CDB_0(&dcb->dcb_cdb, CMD_MSENSE, lun, (0x40 | PD_ERROR)<<8,
	    sizeof(gd_msen), 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_IN, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_msen), sizeof(gd_msen), 1);
	if (gdissue("MSENSE CERR", dcb, unit, 0))
		return (-1);

	pdl = (struct pag_desc *)(((char *)&gd_msel.msel_bd)+gd_msel.msel_bdl);
	if (pdn->pd_pg.pg_err.err_per)
		pdl->pd_pg.pg_err.err_per = 1;

	/* send page to drive */
	SET_CDB_0(&dcb->dcb_cdb, CMD_MSELECT, lun, pdl->pd_save<<16, len, 0, 0);
	SET_DCB(dcb, DCB_NOIE, DCB_DIR_OUT, DCB_SW, DCB_NODISC,
	    sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0,
	    paddr(&gd_msel), len, 1);
	pdl->pd_save = 0;
	if (gdissue("MSELECT ERR", dcb, unit, 0))
		return (-1);
	return (0);
}

#ifdef	DISK_FORMAT
static char buf[100];
#define	BSIZE	400
static u_short fmtlist[BSIZE];
static u_char deflist[BSIZE];

gdformat()
{
	register struct hacb_dcb	*dcb;
	int	unit, cont, target, lun, count, i;
	char	test;
	u_int	pat = 0;		/* default data pattern for format */
	u_int	ilv = 0;		/* default interleave value */
	u_char	fmtdata = 0;		/* default format data bit */
	u_char	cmplist = 0;		/* default complete list bit */
	u_char	listfmt = 0;		/* default defect list format */
	u_char	listsize = 0;		/* default defect list length */

	gd_formatting = 1;
	printf("\nFormatting GD disk\n");
loop:	printf("\nFunctions available:\n");
    	printf(" a) Format Disk\n b) Reassign Bad Blocks\n c) Command Monitor\n");
	printf("\nEnter letter of desired function ('H' for help): ");
	stripwhite(gets(buf));
	test = buf[0];
	if (test == 'H')
		goto loop;
	if (test == 'c' || test == 'C') {
		ggmon();
		goto loop;
	}
	if (test != 'a' && test != 'A' && test != 'b' && test != 'B')
		goto loop;
    ctl:printf("Controller number (0-%d) ? ", NGD-1);
	stripwhite(gets(buf));
	cont = getnum(buf);
	if (cont < 0 || cont >= NGD) {
		printf("illegal controller number\n");
		goto ctl;
	}
	if (gsopen(GDU_GSCTLR(GD_UNIT(cont, 0, 0)))) {
		printf("controller %d not fount\n", cont);
		goto ctl;
	}
    dev:printf("Target number (0-%d) ? ", NGD_DEV-1);
	stripwhite(gets(buf));
	target = getnum(buf);
	if (target < 0 || target >= NGD_DEV) {
		printf("illegal target number\n");
		goto dev;
	}
    lun:printf("Logical Unit number (0-%d) ? ", NGD_LUN-1);
	stripwhite(gets(buf));
	lun = getnum(buf);
	if (lun < 0 || lun >= NGD_LUN) {
		printf("illegal logical unit number\n");
		goto lun;
	}
	unit = GD_UNIT(cont, target, lun);
	dcb = gsgetdcb(GDU_GSCTLR(unit));

	if (gsopen(GDU_GSCTLR(unit)) || gdinq(unit)) {
		printf("gd%d: target not responding\n", unit);
		goto loop;
	}

	if (test == 'a' || test == 'A') {	/* FORMAT DRIVE */
	    printf("Use default parameters? Y\b");
	    stripwhite(gets(buf));
	    if (buf[0] == 'N' || buf[0] == 'n') {
		printf("Data Pattern for format(0-256)? (default=%d) ", pat);
		    stripwhite(gets(buf));
		if (buf[0])
		    pat = getnum(buf);
		printf("Interleave factor X:1? (default=%d) ", ilv);
		stripwhite(gets(buf));
		if (buf[0])
		    ilv = getnum(buf);
		printf("FMTDATA bit (0-1)? %x\b", fmtdata);
		stripwhite(gets(buf));
		if (buf[0])
		    fmtdata = getnum(buf);
		printf("CMPLIST bit (0-1)? %x\b", cmplist);
		stripwhite(gets(buf));
		if (buf[0])
		    cmplist = getnum(buf);
		printf("Defect List Format (0-7)? %x\b", listfmt);
		stripwhite(gets(buf));
		if (buf[0])
		    listfmt = getnum(buf);
		if (fmtdata) {
		    printf("Size of defect data in 16 bit words (0-255)? %x\b",
			listsize);
		    stripwhite(gets(buf));
		    if (buf[0])
			listsize = getnum(buf);
		    if (listsize) do {
			for (i=0; i<listsize; i++) {
			    printf("word %2d: %4x    : ", i, fmtlist[i]);
			    stripwhite(gets(buf));
			    if (buf[0])
				fmtlist[i] = getnum(buf);
			}
			printf("see it again? N\b");
			stripwhite(gets(buf));
			i = buf[0];
		    } while (i == 'y' || i == 'Y');
		}
	    }

	    i = ((((fmtdata&1)<<4)|((cmplist&1)<<3)|(listfmt&7))<<16) |
		(pat << 8) | (ilv >> 8);
	    SET_CDB_0(&dcb->dcb_cdb, CMD_FORMAT, GDU_LUN(unit), i, ilv, 0, 0);
	    SET_DCB(dcb, DCB_NOIE, DCB_DIR_OUT, DCB_SW, DCB_NODISC,
		sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, fmtlist,
		listsize << 1, 1);
	    printf("WARNING: this test destroys disk contents\n");
	    printf("Do you want to proceed? (y or n) ");
	    stripwhite(gets(buf));
	    if (buf[0] != 'y' && buf[0] != 'Y')
		goto loop;

	    count = 0;
	    while (1)
		switch (gdissue("FORMAT", dcb, unit, 0)) {
		    case 0:	printf("SUCCESSFUL FORMAT\n");
				goto loop;
		    case  -1:	printf("retry ? N\b");
				stripwhite(gets(buf));
				if (buf[0] == 'y' || buf[0] == 'Y')
				    break;
				else
				    goto loop;
		    case  1:	if (++count == GD_MAXRETRY)
				    goto loop;
		}
	} else if (test == 'b' || test == 'B') { /* REASSIGN DEFECTIVE BLOCKS */
	    printf("Enter Logical Block Addresses in decimal: <CR> to end list\n");
	    for (i=1;i<100;i++) {
		printf("lba:   ");
		stripwhite(gets(buf));
		if (buf[0] == 0)
		    break;
		*(u_int *)&fmtlist[i*4] = getnum(buf);
	    }
	    *(u_int *)fmtlist = (i-1)*4;

	    SET_CDB_0(&dcb->dcb_cdb, CMD_REASSIGN, GDU_LUN(unit), 0, 0, 0, 0);
	    SET_DCB(dcb, DCB_NOIE, DCB_DIR_OUT, DCB_SW, DCB_NODISC,
		sizeof (struct cdb_0), DCB_BW_16, DCB_AM_STD_S_D, 0, fmtlist,
		i * 4, 1);
	    count = 0;
	    while (1)
		switch (gdissue("REASSIGN", dcb, unit, 0)) {
		    case  0:	printf("SUCCESSFUL REASSIGNMENT\n");
				goto loop;
		    case  -1:	printf("retry ? N\b");
				stripwhite(gets(buf));
				if (buf[0] == 'y' || buf[0] == 'Y')
				    break;
				else
				    goto loop;
		    case  1:	if (++count == GD_MAXRETRY)
				    goto loop;
		}
	}
}

/*------------------- GGMON -------------------*/

int	cmd_setctu(),	cmd_slctmem(),	cmd_slctdcb(),	cmd_filldcb(),
	cmd_senddcb(),	cmd_exammem(),	cmd_fmtdk(),	cmd_cleardk(),
	cmd_reset(),	cmd_dotur(),	cmd_reqsense(),	cmd_exit();

struct commands {
	char	*cmd_name;
	int	(*cmd_exec)();
} diag[] = {
    /* Commands which require parameters */
	"Select controller/target/lun",			cmd_setctu,
	"Select DCB",					cmd_slctdcb,
	"Fill in DCB",					cmd_filldcb,
	"Select memory block",				cmd_slctmem,
	"Examine/Modify memory block",			cmd_exammem,
	"Fill/verify entire disk",			cmd_cleardk,

#define	MENU_SPLIT	6
    /* Commands which require NO parameters */
	"Execute DCB",					cmd_senddcb,
	"Do Test Unit Ready",				cmd_dotur,
	"Do Request Sense",				cmd_reqsense,
	"Format disk",					cmd_fmtdk,
	"Reset SCSI bus",				cmd_reset,
	"Exit",						cmd_exit,
#define	MENU_END	12

	0,						0
};

int	cont, target, lun;
int	active_mem, active_dcb;
#define	NDCB		8
struct hacb_dcb	dcb_mem[NDCB];
struct hacb_dcb tdcb_mem;
int ggmon_exit = 0;
struct {
	u_int	len;
	u_char	*addr;
	u_char	mem[0x1000];
} mem[NDCB];
static jmp_buf menu_display;

#define	GETFIELD(s, v, min, max)	v = getfield(s, v, min, max)

ggmon()
{
	register int i, test;

	for (i = 0; i < NDCB; i++) {
	    mem[i].addr = mem[i].mem;
	    mem[i].len = 0x1000;
	    dcb_mem[i].dcb_nodisc = 1;
	}

	setjmp(menu_display);

	if (ggmon_exit) {
		ggmon_exit = 0;
		return;
	}

	while (1) {
	    printf("\nState: Controller %d Target %d Lun %d: MEM %x DCB %x\n",
		cont, target, lun, active_mem, active_dcb);
	    for (i = 0 ; i < MENU_SPLIT; i++ ) {
		printf("    %c: %-35s", 'a' + i, diag[i].cmd_name);
		if (diag[i + MENU_SPLIT].cmd_name)
		    printf("    %c: %s", 'a' + i + MENU_SPLIT, 
			diag[i + MENU_SPLIT].cmd_name);
		printf("\n");
	    }
    sel:    printf("\nSelect a function (a-%c): ", 'a' + i-1);
	    gets(buf);
	    test = buf[0] - 'a';
	    if (test < 0 || test >= MENU_END) {
		printf("Bad selection\n");
		goto sel;
	    }
	    (*(diag[test].cmd_exec))();
	}
}

cmd_exit()
{
	ggmon_exit = 1;
	longjmp(menu_display, 1);
}

cmd_setctu()
{
	GETFIELD("Controller", cont, 0, 3);
	GETFIELD("Target Device", target, 0, 7);
	GETFIELD("Lun", lun, 0, 7);
}

cmd_slctmem()
{
	GETFIELD("Active Memory Block", active_mem, 0, 7);
}

cmd_slctdcb()
{
	GETFIELD("Active DCB", active_dcb, 0, 7);
}

cmd_dotur()
{
	register struct hacb_dcb	*dcb = &tdcb_mem;

	SET_CDB_0(&dcb->dcb_cdb, CMD_TESTREADY, lun, 0, 0, 0, 0);
	SET_DCB(dcb, 0, DCB_DIR_NO, 0, DCB_NODISC, sizeof(struct cdb_0), 0, 0,
		0, 0, 0, 0);
	if (sendcmd("TEST_UNIT_READY", dcb))
		return;
	if (dcb->dcb_scsi_status & SCSI_STATUS_CHECK)
		sendcmd("TEST_UNIT_READY again", dcb);
}

cmd_reqsense()
{
	register struct hacb_dcb	*dcb = &tdcb_mem;
	union scsi_sns			sns_data;
	register u_char			*p = (char *)&sns_data;
	register int			i;

	SET_CDB_0(&dcb->dcb_cdb, CMD_SENSE, lun, 0, sizeof(union scsi_sns),0,0);
	SET_DCB(dcb, 0, DCB_DIR_IN, DCB_SW, DCB_NODISC, sizeof(struct cdb_0),
		0, 0, 0, p, sizeof(union scsi_sns), 1);
	bzero(p, sizeof(union scsi_sns));
	if (sendcmd("REQUEST SENSE", dcb))
		return;
	printf("  SENSE DATA: ");
	for (i = 0 ; i < sizeof(union scsi_sns); i++) 
		printf("%2x ", *p++);
	printf("\n");
}

cmd_reset()
{
	register struct hacb_dcb	*dcb = &tdcb_mem;
	char				oldtarg;

	oldtarg = target;
	target = 7;
	SET_CDB_0(&dcb->dcb_cdb, CMD_RESET, 0, 0, 0, 0, 0);
	SET_DCB(dcb, 0, DCB_DIR_NO, 0, DCB_NODISC, sizeof(struct cdb_0),
		0, 0, 0, 0, 0, 0);
	sendcmd("RESET CONTROLLER", dcb);
	target = oldtarg;
}

cmd_fmtdk()
{
	register struct hacb_dcb	*dcb = &tdcb_mem;

	SET_CDB_0(&dcb->dcb_cdb, CMD_FORMAT, lun, 0, 0, 0, 0);
	SET_DCB(dcb, 0, DCB_DIR_NO, 0, DCB_NODISC, sizeof(struct cdb_0), 0, 0,
		0, 0, 0, 0);
	if (getfield("This will overwrite the disk!! Proceed? (Yes = 1)",
	    0, 0, 0))
		sendcmd("FORMAT", dcb);
}

cmd_cleardk()
{
	register struct hacb_dcb	*dcb = &tdcb_mem;
	register int			i, j;
	int				hexval, incre, lba, dir;

	dir = getfield("Do write or read/verify (1 = write)", 0, 0, 0);
	if (dir && getfield("This will overwrite the disk!! Proceed? (Yes = 1)",
	     0, 0, 0) == 0)
		return;
	incre = getfield("Number of sectors per op", 0x200, 0, 0);
	hexval = getfield("Hex value", 0, 0, 0);
	if (0x200 * incre > 0x1000) {
		printf("  alloc failed\n");
		return;
	}
	mem[active_mem].len = 0x200 * incre;
	bzero(mem[active_mem].addr, 0x200 * incre);
	if (dir)
		for (i=0;i<0x200 * incre;i++)
			*(mem[active_mem].addr+i) = hexval;

	for (lba = 0 ;; lba += incre) {
	    printf("  %s 0x%x sectors starting at lba %x...\n",
		dir ? "filling" : "comparing", incre, lba);
	    SET_CDB_1(&dcb->dcb_cdb, dir ? CMD_XWRITE : CMD_XREAD, lun, 0, lba,
		incre, 0, 0);
	    SET_DCB(dcb, 0, dir, DCB_NOSW, DCB_NODISC, sizeof(struct cdb_0), 0,
		 0, 0, mem[active_mem].addr, incre * 0x200, 0x200);
	    if (sendcmd(dir ? "WRITE" : "READ", dcb))
		    return;
	    if (dcb->dcb_err == 0) {
		if (dir == 0) {
		    for (i=0;i<0x200 * incre;i++)
			if (*(mem[active_mem].addr+i) != hexval) {
			    printf("\n  COMPARE FAILED:");
			    printf("0x%x:", i);
			    for (j=i;j<i+16;j++)
				printf(" %02x", mem[active_mem].addr[j]);
			    printf("\n");
			    return(0);
			}
		}
		printf("\r");
	    } else if (dcb->dcb_scsi_status & SCSI_STATUS_CHECK) {
		printf("\n");
		incre /= 2;
		if (incre == 0) {
		    printf("\ndone\n");
		    return(0);
		}
	    } else {
		    printf("\nFatal Error - Operation Halted\n");
		    return(0);
	    }
	}
}

cmd_senddcb()
{
	sprintf(buf, "DCB %d", active_dcb);
	sendcmd(buf, &dcb_mem[active_dcb]);
}

cmd_filldcb()
{
	register struct hacb_dcb	*dcb = &dcb_mem[active_dcb];
	register int			i, cformat;

	printf("  DCB %d\n", active_dcb);
	cformat = getfield("Command group",dcb->dcb_cdb.cdb_0.cdb_0_cmd>>5,0,7);
	if (cformat == 0) {
	    struct cdb_0	*c = &dcb->dcb_cdb.cdb_0;

	    dcb->dcb_cdblen = 6;
	    GETFIELD("Command", c->cdb_0_cmd, 0, 0);
	    GETFIELD("Lun", c->cdb_0_lun, 0, 7);
	    i = getfield("lba", SCSI_HML(c->cdb_0_lba), 0, 0);
	    SCSI_HML_SET(c->cdb_0_lba, i);
	    GETFIELD("block count", c->cdb_0_len, 0, 0);
	} else if (cformat == 1) {
	    struct cdb_1	*c = &dcb->dcb_cdb.cdb_1;

	    dcb->dcb_cdblen = 10;
	    GETFIELD("Command", c->cdb_1_cmd, 0, 0);
	    GETFIELD("Lun", c->cdb_1_lun, 0, 0);
	    GETFIELD("lba", c->cdb_1_lba, 0, 0);
	    i = getfield("block count", SCSI_HL(c->cdb_1_len), 0, 0);
	    SCSI_HL_SET(c->cdb_1_len, i);
	} else {
	    u_char		*c = &dcb->dcb_cdb.cdb_raw[0];

	    GETFIELD("CDB length", dcb->dcb_cdblen, 1, 16);
	    for (i = 0; i < dcb->dcb_cdblen; i++) {
		sprintf(buf, "Command byte %d", i);
		GETFIELD(buf, c[i], 0, 0);
	    }
	}
	GETFIELD("Data Length", dcb->dcb_dlen, 0, 0);
	GETFIELD("Prohibit Disconnect", dcb->dcb_nodisc, 0, 0);
	if (dcb->dcb_dlen) {
	    if (dcb->dcb_dlen != mem[active_mem].len) {
		if (dcb->dcb_dlen > 0x1000) {
		    printf("alloc failed\n");
		    return;
		}
		mem[active_mem].len = dcb->dcb_dlen;
		dcb->dcb_dadr = mem[active_mem].addr;
	    }
	    GETFIELD("Data Direction (to unit = 1)", dcb->dcb_dir, 0, 0);
	    GETFIELD("Swap Bytes (Yes = 1)", dcb->dcb_sw, 0, 0);
	    GETFIELD("Data BlockSize", dcb->dcb_dbsz, 0, 0);
	}
}

cmd_exammem()
{
	register u_short	*a;
	register int		offs, count;

	printf("  Memory Block %d\n", active_mem);
	offs = getfield("Relative address in block", 0, 0, 0);
	count = getfield("Number of words", mem[active_mem].len/2, 0, 0);
	if (offs > mem[active_mem].len)
		offs = mem[active_mem].len - 2;
	if (2*count+offs > mem[active_mem].len)
		count = (mem[active_mem].len - offs) >> 1;
	a = (u_short *)(mem[active_mem].addr + offs);
	for (;count>0;count--) {
		sprintf(buf, "0x%x", offs);
		*a = getfield(buf, *a, 0, 0);
		offs += 2;
		a++;
	}
}

sendcmd(s, dcb)
	char				*s;
	register struct hacb_dcb	*dcb;
{
	register struct hacb_dcb	*cdcb = gsgetdcb(GD_GSCTLR(cont, target));
	static int opened[NGD];

	if (opened[cont] == 0 && gsopen(GD_GSCTLR(cont, target)))
		return;
	opened[cont] = 1;

	bcopy(dcb, cdcb, sizeof(struct hacb_dcb));
	cdcb->dcb_err = 0;

	if (gspoll(GD_GSCTLR(cont, target), 1000000))
		return;

	dcb->dcb_err = cdcb->dcb_err;
	dcb->dcb_cerr = cdcb->dcb_cerr;
	dcb->dcb_scsi_status = cdcb->dcb_scsi_status;

	if (dcb->dcb_err == 0)		/* return if no error */
		return;
	printf("%s: ERROR: %s: scsi %b\n", s, ascii_dcb_cerr[dcb->dcb_cerr],
		dcb->dcb_scsi_status, SCSI_STATUS_BITS);
}

getfield(field, value, min, max)
	char	*field;
	u_int	value;
{
	register int	i = 0, j = 0, x = value;
	char		backspace[9];
	int		newvalue;

	x = value;
	i = 0;
	do {
		backspace[i] = '\b';
		i++;
		x >>= 4;
	} while (x);
	backspace[i] = 0;
range:	if (min != max)
		sprintf(buf,"%s (%d-%d)", field, min, max);
	else
		sprintf(buf,"%s", field, value, backspace);
	printf("    %30s: %x%s", buf, value, backspace);
	buf[0] = 0;
	gets(buf);
	if (buf[0] && !isxdigit(buf[0]))
		longjmp(menu_display, 1);
	if (sscanf(buf, "%x", &newvalue) > 0) {
		if (min != max && ((newvalue < min) || (newvalue > max)))
			goto range;
		value = x = newvalue;
		j = 0;
		do {
			j++;
			x >>= 4;
		} while (x);
		if (j < i)
			printf("    %30s: %x\n", " ", value);
	}
	return value;
}
#endif	DISK_FORMAT
