/* 
 * VBUS 68020 Specific, 
 *	test translation buffer and memory PTE updates by sequencer
 */

#include "../is68k/pte.h"
#include "../is68k/board.h"

#ifdef	M68025
#define	btop(x)		(((unsigned)(x)) >> 13)
#else	M68025
#define	btop(x)		(((unsigned)(x)) >> 12)
#endif	M68025
#define btoptp(x)	(PTP_VALID|btop(x)|(((int)x&PTP_LSBMASK)<<PTP_LSBSHIFT))

#define	TESTPAT		0xCACAFECE

main()
{
	int *ptp;
	register int *pte;
	register int *tbuf;
	register int *vaddr, *paddr;
	register int  p0, p1, tb, t0, t1, pattern, verbose, pass1;
	int x, bok;
	char buf[20];
	int c;

	printf("\n--- %i Standalone MMU Page Fault Test ---\n\n");

loop:	printf("\nEnter context to test (0): ");
	stripwhite(gets(buf));
	if (buf[0])
		x = gethex(buf);
	else 
		x = 0;
	if (x < 0 || x >= NCTX) {
		printf("valid contexts are between 0 and %d\n", NCTX-1);
		goto loop;
	}
	*CTX = x;				/* set context */
	if (x != 0) {
		tbuf = (int *)TBUF_BASE_USR;
		vaddr = (int *)USRV_BASE;
	} else {
		tbuf = (int *)TBUF_BASE_SYS;
		vaddr = (int *)SYSV_BASE;
	}
	pte = (int *)0x2000;
	paddr = (int *)0x4000;			/* vaddr should point here */ 
	ptp = (int *)PTP_BASE;
	*ptp = btoptp(pte);			/* point ptp to page of ptes */
	pattern = TESTPAT;			

	printf("\nEnter hex value to 'or' into TBUF entry :");
	stripwhite(gets(buf));
	tb = gethex(buf);
	verbose = 1;
	printf("Verbose? (default yes): ");
	stripwhite(gets(buf));
	if (buf[0] == 'n' || buf[0] == 'N')
		verbose = 0;

	p0 = PG_V|PG_KR|PG_R|PG_M|btop(paddr);
	p1 = p0;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nread with PG_R|PG_M set\n");
	*tbuf = t0; *pte = p0;
	printf("PTP     TBUF            PTE\n");
	printf("%8x %b   %b\n", *ptp&PTP_MASK,
		(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (c = getlocal()) {
			if (c == 0x04) exit();
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		*paddr = pattern;
		bok = probel(vaddr, &x);
		if (verbose || pass1)
		    printf("%8x %b   %b\r", *ptp&PTP_MASK,
			(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
		if (bok == 0)
			perror("\nBUS ERROR\n");
		else if (((*tbuf)&TBUF_MASK) != t1)
			perror("\nTBUF: %b should be %b\n", 
				(*tbuf)&TBUF_MASK, TBUF_BITS, t1, TBUF_BITS);
		else if (((*pte)&PG_MASK) != p1)
			perror("\nPTE: %b should be %b\n",
				(*pte)&PG_MASK, PG_BITS, p1, PG_BITS);
		else if (x != TESTPAT)
			perror("\ntranslation incorrect: %8x shoud be %8x\n",
				x, TESTPAT);
	}

	p0 = PG_V|PG_KR|PG_M|btop(paddr);
	p1 = p0 | PG_R;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nread with PG_M, should set PG_R\n");
	*tbuf = t0; *pte = p0;
	printf("PTP     TBUF            PTE\n");
	printf("%8x %b   %b\n", *ptp&PTP_MASK,
		(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (c = getlocal()) {
			if (c == 0x04) exit();
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		*paddr = pattern;
		bok = probel(vaddr, &x);
		if (verbose || pass1)
		    printf("%8x %b   %b\r", *ptp&PTP_MASK,
			(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
		if (bok == 0)
			perror("\nBUS ERROR\n");
		else if (((*tbuf)&TBUF_MASK) != t1)
			perror("\nTBUF: %b should be %b\n", 
				(*tbuf)&TBUF_MASK, TBUF_BITS, t1, TBUF_BITS);
		else if (((*pte)&PG_MASK) != p1)
			perror("\nPTE: %b should be %b\n",
				(*pte)&PG_MASK, PG_BITS, p1, PG_BITS);
		else if (x != TESTPAT)
			perror("\ntranslation incorrect: %8x shoud be %8x\n",
				x, TESTPAT);
	}

	p0 = PG_V|PG_KW|PG_R|btop(paddr);
	p1 = p0 | PG_M;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nwrite with PG_R, should set PG_M\n");
	*tbuf = t0; *pte = p0;
	printf("PTP     TBUF            PTE\n");
	printf("%8x %b   %b\n", *ptp&PTP_MASK,
		(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (c = getlocal()) {
			if (c == 0x04) exit();
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		bok = probelw(vaddr, pattern);
		x = *paddr;
		if (verbose || pass1)
		    printf("%8x %b   %b\r", *ptp&PTP_MASK,
			(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
		if (bok == 0)
			perror("\nBUS ERROR\n");
		else if (((*tbuf)&TBUF_MASK) != t1)
			perror("\nTBUF: %b should be %b\n", 
				(*tbuf)&TBUF_MASK, TBUF_BITS, t1, TBUF_BITS);
		else if (((*pte)&PG_MASK) != p1)
			perror("\nPTE: %b should be %b\n",
				(*pte)&PG_MASK, PG_BITS, p1, PG_BITS);
		else if (x != TESTPAT)
			perror("\ntranslation incorrect: %8x shoud be %8x\n",
				x, TESTPAT);
	}

	p0 = PG_V|PG_KW|btop(paddr);
	p1 = p0 | PG_R|PG_M;
	t0 = p0 | tb;
	t1 = p1 | TBUF_VALID;
	printf("\nwrite, should set PG_R and PG_M\n");
	*tbuf = t0; *pte = p0;
	printf("PTP     TBUF            PTE\n");
	printf("%8x %b   %b\n", *ptp&PTP_MASK,
		(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
	for (pass1=1;;pass1=0) {
		if (c = getlocal()) {
			if (c == 0x04) exit();
			printf("\n"); break;
		}
		*tbuf = t0; *pte = p0;
		bok = probelw(vaddr, pattern);
		x = *paddr;
		if (verbose || pass1)
		    printf("%8x %b   %b\r", *ptp&PTP_MASK,
			(*tbuf)&TBUF_MASK,TBUF_BITS,(*pte)&PG_MASK,PG_BITS);
		if (bok == 0)
			perror("\nBUS ERROR\n");
		else if (((*tbuf)&TBUF_MASK) != t1)
			perror("\nTBUF: %b should be %b\n", 
				(*tbuf)&TBUF_MASK, TBUF_BITS, t1, TBUF_BITS);
		else if (((*pte)&PG_MASK) != p1)
			perror("\nPTE: %b should be %b\n",
				(*pte)&PG_MASK, PG_BITS, p1, PG_BITS);
		else if (x != TESTPAT)
			perror("\ntranslation incorrect: %8x shoud be %8x\n",
				x, TESTPAT);
	}
	goto loop;
}
