/*
 * Excelan EXOS 202(VME) EX)S 203(QBUS)  Link Level Ethernet Interface 
 * Standalone Boot Protocol Driver
 */

#include "saio.h"
#include "sais68k.h"
#include "saboot.h"
#include "../is68kif/if_exreg.h"

struct exdevice *exstd[] = { 
#ifdef	QBUS
#define	NEX	3
		(struct exdevice *)0x3FE800,
		(struct exdevice *)0x3FE810,
		(struct exdevice *)0x3FE820,
#else	QBUS
#define	NEX	2
		(struct exdevice *)&vme_stdio[0xFF0000],
		(struct exdevice *)&vme_stdio[0xFE0000],
#endif	QBUS
		0 };

#define	NH2X 1			/* Host to eXcelan message queues */
#define	NX2H 1			/* eXcelan to Host message queues */

#ifdef	QBUS
#define	BUSADDR(x)	((u_long)paddr(x))
#define	P_BUSADDR(x)	((u_long)paddr(x))
#else	QBUS
#define	BUSADDR(x)	(0x3D000000 | ((u_long)paddr(x)))
#define	P_BUSADDR(x)	(0x3D000000 | ((u_long)paddr(x)))
#endif	QBUS
#define	INCORE_BASE	(((u_long)(&xs_h2xhdr)) & 0xFFFFFFF0)
#define	RVAL_OFF(n)	((u_long)(&(n)) - INCORE_BASE)
#define	LVAL_OFF(n)	((u_long)(n) - INCORE_BASE)
struct ex_msg		*xs_h2xnext;		/* host's request queue ptr */
struct ex_msg		*xs_x2hnext;		/* host's reply queue ptr */
u_short			xs_h2xhdr;		/* EXOS request queue header */
u_short			xs_x2hhdr;		/* EXOS reply queue header */
struct ex_msg		xs_h2xent[NH2X];	/* request msg buffers */
struct ex_msg		xs_x2hent[NX2H];	/* reply msg buffers */
struct confmsg		xs_cm;			/* configuration message */
struct ex_msg		*exgetcbuf();
#define	H2XHDR_OFFSET	RVAL_OFF(xs_h2xhdr)
#define	X2HHDR_OFFSET	RVAL_OFF(xs_x2hhdr)
#define	H2XENT_OFFSET	LVAL_OFF(xs_h2xent)
#define	X2HENT_OFFSET	LVAL_OFF(xs_x2hent)
#define	CM_OFFSET	RVAL_OFF(xs_cm)

extern u_char		broaddr[6];	/* Ethernet broadcast address */
u_char			exme[6];	/* Ethernet address of this machine */
u_char			exhost[6];	/* Ethernet address of host machine */
struct exrcv {
	struct boot_packet	pk_rcv;
	int			crc;
	int			pad;
}			ex_rcv;
struct boot_packet	ex_xmt;
int 			exsend();
int			expkid;
struct st		exst = {512, -1, -1, -1, -1, NULL};
char			ex_opened[NEX];

exopen(io)
	register struct iob *io;
{
	register struct exdevice *exaddr = exstd[io->i_unit];
	register struct ex_msg *mb;
	register int i;

	if (io->i_unit >= NEX || !probeb(((char *)exaddr)+1, &expkid)
#ifdef	QBUS
		|| *(u_short *)exaddr
#endif	QBUS
	    ) {
		printf("ex: not present\n");
		return -1;
	}
	expkid = 0;
	io->i_st = exst;
	ex_opened[io->i_unit] = 0;

	/*
	 * Reset EXOS and run self-test (should complete within 2 seconds).
	 */
	exaddr->ex_porta = EX_RESET;
	i = 1000000;
	while (((exaddr->ex_portb & EX_TESTOK) == 0) && --i) ;
	if ((exaddr->ex_portb & EX_TESTOK) == 0) {
		printf("ex: selftest failed\n");
		return -1;
	}
	exconfig(exaddr);

	/*
	 * Get Ethernet address.
	 */
	mb = exgetcbuf();
	mb->mb_rqst = LLNET_ADDRS;
	mb->mb_na.na_mask = READ_OBJ;
	mb->mb_na.na_slot = PHYSSLOT;
	mb->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	mb = xs_x2hnext;
	if (exwait(io, mb, 0))
		return -1;
	mb->mb_length = MBDATALEN;
	mb->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs_x2hnext = xs_x2hnext->mb_next;
	bcopy((caddr_t)mb->mb_na.na_addrs, exme, 6);

	/*
	 * Put EXOS on the Ethernet, using NET_MODE command
	 */
	mb = exgetcbuf();
	mb->mb_rqst = LLNET_MODE;
	mb->mb_nm.nm_mask = WRITE_OBJ;
	mb->mb_nm.nm_optn = 0;
	mb->mb_nm.nm_mode = MODE_PERF;
	mb->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;

	mb = xs_x2hnext;
	if (exwait(io, mb, 0))
		return -1;
	mb->mb_length = MBDATALEN;
	mb->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs_x2hnext = xs_x2hnext->mb_next;

	if (netopen(exsend, io, &ex_xmt, &ex_rcv, &expkid, exme, exhost))
		return -1;
	ex_opened[io->i_unit] = 1;
	return 0;
}

exclose(io)
	register struct iob *io;
{
	if (ex_opened[io->i_unit])
		return netclose(exsend, io, &ex_xmt, &ex_rcv, &expkid, 
			exme, exhost);
	else
		return -1;
}

exstrategy(io, func)
	register struct iob *io;
{
	return netstrategy(exsend, io, func, &ex_xmt, &ex_rcv, &expkid, 
		exme, exhost);
}

/* Get a request buffer, fill in standard values, advance pointer. */
struct ex_msg *
exgetcbuf()
{
	register struct ex_msg *mb = xs_h2xnext;

	mb->mb_1rsrv = 0;
	mb->mb_length = MBDATALEN;
	xs_h2xnext = mb->mb_next;
	return mb;
}

/*
 * Reset, test, and configure EXOS. Returns 0 if successful, 1 if failure.
 */
exconfig(exaddr)
	register struct exdevice *exaddr;
{
	register struct confmsg *cm = &xs_cm;
	register struct ex_msg 	*mb;
	register int 	i;
	register u_long	shiftreg;
	static	u_char	cmaddr[8] = {0xFF, 0xFF, 0, 0};

	/*
	 * Set up configuration message.
	 */
	cm->cm_1rsrv = 1;
	cm->cm_cc = 0xFF;
	cm->cm_opmode = 0;		/* link-level controller mode */
	cm->cm_dfo = 0x0101;		/* enable host data order conversion */
	cm->cm_dcn1 = 1;
	cm->cm_2rsrv[0] = cm->cm_2rsrv[1] = 0;
	cm->cm_ham = 3;			/* absolute address mode */
	cm->cm_3rsrv = 0;
	cm->cm_mapsiz = 0;
	cm->cm_byteptrn[0] = 0x01;	/* EXOS deduces data order of host */
	cm->cm_byteptrn[1] = 0x03;	/*  by looking at this pattern */
	cm->cm_byteptrn[2] = 0x07;
	cm->cm_byteptrn[3] = 0x0F;
	cm->cm_wordptrn[0] = 0x0103;
	cm->cm_wordptrn[1] = 0x070F;
	cm->cm_lwordptrn = 0x0103070F;
	for (i=0; i<20; i++) cm->cm_rsrvd[i] = 0;
	cm->cm_mba = 0xFFFFFFFF;
	cm->cm_nproc = 0xFF;
	cm->cm_nmbox = 0xFF;
	cm->cm_nmcast = 0xFF;
	cm->cm_nhost = 1;
	cm->cm_h2xba = P_BUSADDR(INCORE_BASE);
	cm->cm_h2xhdr = H2XHDR_OFFSET;
	cm->cm_h2xtyp = 0;		/* should never wait for rqst buffer */
	cm->cm_x2hba = cm->cm_h2xba;
	cm->cm_x2hhdr = X2HHDR_OFFSET;
	cm->cm_x2htyp = 0;		/* 0 for no interupts */

	/*
	 * Set up message queues and headers: first the request queue
	 */
	for (mb = &xs_h2xent[0]; mb < &xs_h2xent[NH2X]; mb++) {
		mb->mb_link = (u_short)((char *)(mb+1)-INCORE_BASE);
		mb->mb_rsrv = 0;
		mb->mb_length = MBDATALEN;
		mb->mb_status = MH_HOST;
		mb->mb_next = mb+1;
	}
	xs_h2xhdr = xs_h2xent[NH2X-1].mb_link = (u_short)H2XENT_OFFSET;
	xs_h2xnext = xs_h2xent[NH2X-1].mb_next = xs_h2xent;

	/* now the reply queue */
	for (mb = &xs_x2hent[0]; mb < &xs_x2hent[NX2H]; mb++) {
		mb->mb_link = (u_short)((char *)(mb+1)-INCORE_BASE);
		mb->mb_rsrv = 0;
		mb->mb_length = MBDATALEN;
		mb->mb_status = MH_EXOS;
		mb->mb_next = mb+1;
	}
	xs_x2hhdr = xs_x2hent[NX2H-1].mb_link = (u_short)X2HENT_OFFSET;
	xs_x2hnext = xs_x2hent[NX2H-1].mb_next = xs_x2hent;

	/*
	 * Write config msg address to EXOS and wait for configuration to 
	 * complete (guaranteed response within 2 seconds).
	 */
	shiftreg = P_BUSADDR(INCORE_BASE) + CM_OFFSET;
	for (i = 4; i < 8; i++) {
		cmaddr[i] = (u_char)(shiftreg & 0xFF);
		shiftreg >>= 8;
	}
	for (i = 0; i < 8; i++) {
		while (exaddr->ex_portb & EX_UNREADY) ;
		DELAY(500);
		exaddr->ex_portb = cmaddr[i];
	}
	for (i = 100000; (cm->cm_cc == 0xFF) && i; --i) DELAY(10);
	if (cm->cm_cc)
		printf("ex: config failed cc=%x\n", cm->cm_cc);
}

/*
 * output the packet in the tansmit buffer.  Wait for a non-broadcast packet 
 * with the same 'pkid' to come back in the recieve buffer as an acknoldge.  
 * If nothing comes back then wait and do retransmitions.  Return 1 if we
 * recieved a reply packet, return 0 if a timeout occured.  The ethernet
 * source field of a recieved CONNECT packet will have the address of the
 * host that responded to the broadcasted CONNECT packet.  The data portion
 * of a recieved READ packed will have the data read.  The data portion of
 * a transmited (and recieved) WRITE packet will have the data to be writen.
 * The host acknoldges packets by performing the specified action, swaping the
 * source and destination addresses in the packet, and sending the packet back 
 * out onto the network.  The host should never change the 'pkid' field of a 
 * boot packet.
 */
exsend(io, bpx, bpr, pkidp)
	struct iob *io;
	register struct boot_packet *bpx, *bpr;
	int *pkidp;
{
	register struct ex_msg *mb;
	register struct exdevice *exaddr = exstd[io->i_unit];
	register int retry = 0, w, rcv = 21;

	do {
		if (rcv++ > 20) {
			rcv = 0;
			if ((exxmit(io, bpx) == 0) || (retry++ > 40))
				goto lost;
		}
		mb = exgetcbuf();
		mb->mb_rqst = LLRECEIVE;
		mb->mb_er.er_nblock = 1;
		/*                                DATA + CRC */
		mb->mb_er.er_blks[0].bb_len = sizeof(struct boot_packet) + 4;
		*(u_long *)mb->mb_er.er_blks[0].bb_addr = BUSADDR(bpr);
		mb->mb_status |= MH_EXOS;
		exaddr->ex_portb = EX_NTRUPT;
		mb = xs_x2hnext;
		while (w = exwait(io, mb, 1))
			if (w == -1 || (retry++ > 40) || (exxmit(io, bpx)==0)) {
				if (w == -2)
					goto lost;
				return 0;
			}
		if (mb->mb_rply != LL_OK)		/* ignore errors */
			bpr->bp_eh.ether_type = 0;
		mb->mb_length = MBDATALEN;
		mb->mb_status |= MH_EXOS;		/* free up buffer */
		exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
		xs_x2hnext = xs_x2hnext->mb_next;
	} while (bcmp(bpr->bp_eh.ether_dhost, broaddr, 6) == 0 || 
		 bpr->bp_eh.ether_type != ETHERTYPE_ISIBOOT ||
		 bpr->bp_pkid != *pkidp );
	bpx->bp_cmd = bpr->bp_cmd;
	*pkidp = (*pkidp) + 1;
	return 1;
lost:	printf("ex: lost connection\n");
	return 0;
}

exxmit(io, bpx)
	struct iob *io;
	register struct boot_packet *bpx;
{
	register struct ex_msg *mb;
	register struct exdevice *exaddr = exstd[io->i_unit];

	mb = exgetcbuf();
	mb->mb_rqst = LLRTRANSMIT;
	mb->mb_et.et_nblock = 1;
	mb->mb_et.et_blks[0].bb_len = sizeof(struct boot_packet);
	*(u_long *)mb->mb_et.et_blks[0].bb_addr = BUSADDR(bpx);
	mb->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	mb = xs_x2hnext;
	if (exwait(io, mb, 0))
		return(0);
	mb->mb_length = MBDATALEN;
	mb->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs_x2hnext = xs_x2hnext->mb_next;
	return(1);
}

exwait(io, mb, timeout)
	struct iob *io;
	register struct ex_msg *mb;
{
	register int i;

	i = (timeout ? 2000 : 80000);
	while (--i) {
		if ((mb->mb_status & MH_OWNER) != MH_EXOS) 
			return (0);
		if (getlocal() == 'x') {
			printf("ex: aborted\n");
			goto err;
		}
		DELAY(100);
	}
	if (timeout)
		return (-2);
	printf("ex: timeout\n");
err:	ex_opened[io->i_unit] = 0;
	return (-1);
}
