#define BSIZE	512

char buf[50];
int rerr, werr;

main()
{
	register char *start, *end, *pbuf;
        register int inc, nlap, i;
	int fi;
	int patlen;
	char pat[80];

	printf("\n--- %i Standalone Disk Write Test ---\n\n");
loop:   do  {
                printf("device: "); gets(buf);
                fi = open(buf, 2);
        } while (fi < 0);
	printf("Starting disk sector: ");
	gets(buf);
	start = (char *) getnum(buf);
	printf("Ending disk sector:   ");
	gets(buf);
	end = (char *) getnum(buf);
	printf("Disk sector increment:    ");
	gets(buf);
	inc = getnum(buf);
	if (start < 0 || end < 0 || inc <= 0) {
		printf("Illegal number\n\n");
		close(fi);
		goto loop;
	}
	printf("Address of disk buffer area:	");
	gets(buf);
	pbuf = (char *)gethex(buf);
	printf("Length of byte pattern (1-%d):	", sizeof(pat));
	gets(buf);
	patlen = getnum(buf);
	if (patlen <= 0 || patlen > sizeof(pat)) {
		printf("Illegal pattern length\n\n");
		close(fi);
		goto loop;
	}
	for (i = 0 ; i < patlen; i++) {
		printf("Byte %2d of pattern:	", i);
		gets(buf);
		pat[i] = gethex(buf);
	}
	do  {
		printf("Number of Laps (0 means forever, default 1): ");
		gets(buf);
		if (!buf[0]) 
			nlap = 1;
		else {
			nlap = getnum(buf);
			if (nlap < 0)
				printf("Illegal number\n");
		}
	} while (nlap < 0);
	for (i = 0 ; ((nlap == 0) ? 1 : (i < nlap)) ; i++) {
	    printf("Lap %d  (%x,%x,%x,%x,%x)                       \n",
			i, fi, start, end, inc, pbuf);
	    dtest(fi, start, end, inc, pbuf, patlen, pat);
	}
	printf("\nDone Disk Read: \n");
	close(fi);
	goto loop;
}

/*
 * dtest - do a from sector 'start' to sector 'end'
 *	   with sector increment 'inc'
 */
dtest(fi, start, end, inc, buf2, patlen, pat)
	char *buf2, *pat;
{
	register int bno, i, j;
	register char *p;

	for (i = 0, p = buf2 ; i < BSIZE ;)
	    for (j = 0; (i < BSIZE) && (j < patlen); j++) {
		*p++ = pat[j];
		i++;
	    }
	for (bno = start; bno <= end; bno += inc) {
		lseek(fi, bno*BSIZE, 0);
		if (write(fi, buf2, BSIZE) != BSIZE) {
			rerr++;
			printf("\007Bad write on block %d\n", bno);
		}
	}
}
