#define BSIZ	16*1024

char fbuf[50], tbuf[50];
unsigned char buffer0[BSIZ];
unsigned char buffer1[BSIZ];

/*
 * Intended for disk duplication
 */
main()
{
	int from, to;
	register int record;
	extern int errno;
	register int i;
	register int rcc, wcc;
	register int rcc0, rcc1;

	printf("\n--- %i Standalone Dcopy ---\n\n");
	from = getdev("From", fbuf, 0);
	to = getdev("To", tbuf, 2);
	for (record = 0; ; record++) {
		rcc = read(from, buffer0, sizeof (buffer0));
		if (rcc == 0)
			break;
		if (rcc < 0) {
			printf("Record %d: read error, errno=%d\n",
				record, errno);
			break;
		}
		if (rcc < sizeof (buffer0))
			printf("Record %d: read short; expected %d, got %d\n",
				record, sizeof (buffer0), rcc);
		wcc = write(to, buffer0, rcc);
		if (wcc < 0) {
			printf("Record %d: write error: errno=%d\n",
				record, errno);
			break;
		}
		if (wcc < rcc) {
			printf("Record %d: write short; expected %d, got %d\n",
				record, rcc, wcc);
			break;
		}
	}
	printf("Copy completed: %d records copied\n", record);
	lseek(from, 0, 0);
	lseek(to, 0, 0);
	printf("Verify: ");
	for (record = 0; ; record++) {
		rcc0 = read(from, buffer0, sizeof (buffer0));
		if (rcc0 == 0)
			break;
		if (rcc0 < 0) {
			printf("Record %d: read error, errno=%d\n",
				record, errno);
			break;
		}
		if (rcc0 < sizeof (buffer0))
			printf("Record %d: read short; expected %d, got %d\n",
				record, sizeof (buffer0), rcc);
		rcc1 = read(to, buffer1, sizeof (buffer1));
		if (rcc1 == 0)
			break;
		if (rcc1 < 0) {
			printf("Record %d: read error, errno=%d\n",
				record, errno);
			break;
		}
		if (rcc1 < sizeof (buffer1))
			printf("Record %d: read short; expected %d, got %d\n",
				record, sizeof (buffer1), rcc);
		for (i=0; i < rcc0 ; i++)
			if (buffer0[i] != buffer1[i])
				printf("%x	:%x %x\n",
					(record*BSIZ)+i, buffer0[i],buffer1[i]);
	}
	close (from);
	close (to);
	exit();
}

getdev(prompt, buf, mode)
	char *prompt, *buf;
	int mode;
{
	register int i;

	do {
		printf("%s: ", prompt);
		gets(buf);
		i = open(stripwhite(buf), mode);
	} while (i <= 0);
	return (i);
}
