#define	BSIZE	8*1024

unsigned char buffer0[BSIZE];
unsigned char buffer1[BSIZE];

char fbuf[50], tbuf[50];

/*
 * compare two files in 8K units.
 */
main()
{
	register int i;
	register int from0, from1;
	register int rcc0, rcc1;
	register int record;
	register unsigned char *bp0, *bp1;
	extern int errno;

	printf("\n--- %i Standalone Cmp ---\n\n");
	from0 = getdev("File 0", fbuf, 0);
	from1 = getdev("File 1", tbuf, 0);
	for (record = 0; ; record++) {
		rcc0 = read(from0, buffer0, sizeof (buffer0));
		if (rcc0 == 0) {
			printf("File 0: EOF\n");
			break;
		} else if (rcc0 < 0) {
			printf("File 0: record %d: read error, errno=%d\n",
				record, errno);
			break;
		} else if (rcc0 < sizeof (buffer0))
			printf("File 0: record %d: read short; expected %d, got %d\n",
				record, sizeof (buffer0), rcc0);

		rcc1 = read(from1, buffer1, sizeof (buffer1));
		if (rcc1 == 0) {
			printf("File 1: EOF\n");
			break;
		} else if (rcc1 < 1) {
			printf("File 1: record %d: read error, errno=%d\n",
				record, errno);
			break;
		} else if (rcc1 < sizeof (buffer1))
			printf("File 1: record %d: read short; expected %d, got %d\n",
				record, sizeof (buffer1), rcc1);

		for ( bp0 = buffer0, bp1 = buffer1, i = 0; i < BSIZE; i++) {
			if (*bp0 != *bp1)
			    printf("%d: %x %x\n", record*BSIZE +i, *bp0, *bp1);
			bp0++; bp1++;
		}
	}
	printf("Cmp completed: %d records compaired\n", record);
	close (from0);
	close (from1);
	exit();
}

getdev(prompt, buf, mode)
	char *prompt, *buf;
	int mode;
{
	register int i;

	do {
		printf("%s: ", prompt);
		gets(buf);
		i = open(stripwhite(buf), mode);
	} while (i <= 0);
	return (i);
}
