/*
 * The "ring" data structures.
 *  Contains some number of slots, and read & write indexes thereinto.
 *  Also a size field, specifying the number of slots allocated.
 */
#ifndef	IF_RING
#define	IF_RING

struct ring {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	char		r_tas;		/* TAS multiprocessor interlock flag */
	char		r_pad;		/* unused */
	int		r_slot[1];	/* slots -- actually more than 1 */
};

struct ring16 {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	char		r_tas;		/* TAS multiprocessor interlock flag */
	char		r_pad;		/* unused */
	int		r_slot[16];	/* slots */
};

struct ring32 {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	char		r_tas;		/* TAS multiprocessor interlock flag */
	char		r_pad;		/* unused */
	int		r_slot[32];	/* slots */
};

struct ring128 {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	char		r_tas;		/* TAS multiprocessor interlock flag */
	char		r_pad;		/* unused */
	int		r_slot[128];	/* slots */
};

struct ring256 {
	short		r_rdidx;	/* read index */
	short		r_wrtidx;	/* write index */
	short		r_size;		/* number of slots in ring */
	char		r_tas;		/* TAS multiprocessor interlock flag */
	char		r_pad;		/* unused */
	int		r_slot[256];	/* slots */
};
#endif	IF_RING
