#include "../is68kif/if_ring.h"

/*
 * Initialize the ring pointed to by "rp" to contain "size" slots.
 *  The ring is set up to be empty.
 */
#ifdef LOCAL	[
nwringinit(rp, size)
	register struct ring *rp;
	short size;
{
	register int i;

	rp->r_rdidx = rp->r_wrtidx = 0;
	rp->r_size = size;
	for (i=0; i < size; i++)
		rp->r_slot[i] = 0;
}
#endif LOCAL	]

/*
 * Add a new entry "v" to the ring "rp".
 *  Returns 0 if ring was full, else the new number of entries in the ring.
 *  Masks all interrupts, in order to prevent reentrancy.
 */
nwringput(rp, v)
	register struct ring *rp;
	int v;
{
	int s = splhigh();		/* don't interrupt this routine */
	int x;

	if ((x = (rp->r_wrtidx + 1) & (rp->r_size - 1)) != rp->r_rdidx) {
#ifdef LOCAL	[
		register struct bcb *bcbp, *bcbp2;
#ifdef LENCHK	[
		{
		register count = 1;
		bcbp = (struct bcb *) v;
		while (bcbp->b_link) {
		    ++count;
		    bcbp = bcbp->b_link;
		}
		if (count > NWNBUFS) asm("trap #14");
		}
#endif LENCHK	]
		bcbp = (struct bcb *) v; /* convert local to VME addresses */
		while (bcbp2 = bcbp->b_link) {
		    bcbp->b_addr = ltov(char *, bcbp->b_addr);
		    bcbp->b_link = ltov(struct bcb *, bcbp2);
		    bcbp = bcbp2;
		}
		bcbp->b_addr = ltov(char *, bcbp->b_addr);
#ifdef ADDRCHK	[
		bcbp = (struct bcb *) v;
		if ((((int)(bcbp->b_addr) & 0xf00000) == 0xe00000) ||
			((((u_int)(bcbp->b_addr)) & 0xfffffff) > 0xf00000))
			asm("trap #14");
#endif ADDRCHK	]
		rp->r_slot[rp->r_wrtidx] = ltov(int,v);
#else  LOCAL	][
		rp->r_slot[rp->r_wrtidx] = v;
#endif LOCAL	]
		rp->r_wrtidx = x;
	}				/* if x == rdidx then ring is full */
	if ((x -= rp->r_rdidx) < 0)
		x += rp->r_size;
  	splx(s);			/* restore previous ipl */
	return x;	/* return 0 if failure, else new number of entries */
}


/*
 * Extract next entry from the ring "rp".
 *  Returns 0 if ring is empty, else the extracted entry.
 *  Masks all interrupts, in order to prevent reentrancy.
 */
nwringget(rp)
	register struct ring *rp;
{
	register int x = 0;
	int s = splhigh();		/* don't interrupt this routine */

	if (rp->r_rdidx != rp->r_wrtidx) {
#ifdef LOCAL	[
		register struct bcb *bcbp;
		x = vtol(int,rp->r_slot[rp->r_rdidx]);
		bcbp = (struct bcb *) x; /* convert VME to local addresses */
		while (bcbp->b_link) {
		    bcbp->b_link = vtol(struct bcb *, bcbp->b_link);
		    bcbp->b_addr = vtol(char *, bcbp->b_addr);
		    bcbp = bcbp->b_link;
		}
		bcbp->b_addr = vtol(char *, bcbp->b_addr);
#ifdef ADDRCHK	[
		bcbp = (struct bcb *) x;
		if (((int)(bcbp->b_addr)-(int) buffer_pool)%ENETBUFLEN)
			asm("trap #14");
#endif ADDRCHK	]
#else  LOCAL	][
		x = rp->r_slot[rp->r_rdidx];
#endif LOCAL	]
		rp->r_slot[rp->r_rdidx] = 0;
		rp->r_rdidx = (rp->r_rdidx + 1) & (rp->r_size - 1);
	}
	splx(s);			/* restore previous ipl */
	return x;	/* return 0 if ring was empty; else extracted value */
}
