/*	VME Network Card Ethernet driver header file */

#define NWPHYS0	&vme_std[0xF80000]	/* physical address system interface */
#define NWPHYS1	&vme_std[0xF40000]
#define NWSIZE	0x040000	/* size of system interface area */

#define ENETBUFLEN	1518		/* size of buffers in bcb's */
#define NWMAXMTU	4096		/* Maximum rcv/xmt packet size */
#define CRCLENGTH	4		/* At the end of every receive pkt */


/* structure of system interface area (dual ported ram). */
#ifndef	ASSEMBLY	[
struct nwdevice {
    union dp_ram {
	u_long	nw_ram_lo[(NWSIZE - 4)/sizeof (u_long)];
	u_short	nw_ram_wd[(NWSIZE - 4)/sizeof (u_short)];
	u_char	nw_ram_ch[(NWSIZE - 4)/sizeof (u_char)];
	struct	hw_ram {
	    struct vjtbl {		/* Vector jump table */
		u_short jmp_inst;	/* jump opcode */
		int *jmp_addr;		/* actual vector */
	    } vjtbl[47];		/* Real vect tbl is in PROM. */
	    struct rom_var {
		u_short	testno;		/* failing diagnostic test */
		u_short *erradr;	/* failing address */
		u_short expected;	/* expected test data */
		u_short received;	/* received test data */
		u_short cwra_copy;	/* RAM copy of write-only reg */
		u_short cwrb_copy;	/* RAM copy of write-only reg */
		u_char	jumper;		/* jumpers installed 0 => no jumper */
#endif	ASSEMBLY	]
#define HAVE_256K	0x1		/* not in => 256K */
#define ACTION 		0xe
#define ENTER_DEBUGGER	0x0
#define ENTER_ROM	0x2
#define WAIT_DOWNLOAD	0x4
#define SKIP_DIAG	0x6
#define LOOP_DIAG	0x8
#define ENTER_STD	0xA
#ifndef	ASSEMBLY	[
	 	u_char	owned;		/* ownership smaphore for diag*/
		u_short command;	/* for command from VME side */
		u_short ctl_stat;	/* reports card status */
		void	(*fw_address)();/* jump here on go command */
		u_char	rom_ethaddr[6];	/* Ethernet address from ROM */
		u_char	c_tohost;	/* host terminal emulator */
		u_char	c_fromhost;	/* host terminal emulator */
	    } rom_var;
	} hw_ram;
#ifdef	DIAG
	struct diag_ram	diag_ram;
#endif	DIAG
	struct op_ram {			/* ethernet firmware specific */
	    u_char	nw_rsvd[0x400];	/* reserved for above & debugger */
	    u_int	base_addr;	/* card addr in VME space */
	    u_char	ipend_tonw;	/* inlck for int to card */
	    u_char	ipend_tohost;	/* inlck for int to host */
	    u_char	ivector;	/* int vector for normal operation */
	    u_char	version;	/* firmware version */
#define	NW_VERSION_OLD		0x55
#define NUMBER_OF_STATS		27
	    u_int	nw_stats [NUMBER_OF_STATS]; /* interface statistics */
#define				xmit_successful		0
#define				mult_retry		1
#define				one_retry		2
#define				fail_retry		3
#define				deferrals		4
#define				xmit_buff_err		5
#define				silo_underrun		6
#define				late_coll		7
#define				lost_carrier		8
#define				babble			9
#define				collision		10
#define				xmit_mem_err		11
#define				rcv_successful		12
#define				rcv_missed		13
#define				crc_err			14
#define				frame_err		15
#define				rcv_buff_err		16
#define				silo_overrun		17
#define				rcv_mem_err		18
#define				bad_addr		19
#define				oversize_rcv_pkt	20
#define				initializations		21
#define				xmit_init_lost		22
#define				synch			23
#define				rcv_nwfree		24
#define				bad_host_format		25
#define				rcv_tohost		26
#define		NWSTATREPORT_MASK	(	\
		    (1<<xmit_buff_err) | (1<<silo_underrun) | (1<<late_coll) | \
		    (1<<lost_carrier) | (1<<babble) | (1<<xmit_mem_err) | \
		    (1<<rcv_buff_err) | (1<<silo_overrun) | (1<<synch))
#define		NWSTAT_IERRORS(x)	x[crc_err] + x[frame_err]
#define		NWSTAT_OERRORS(x)	x[fail_retry] + x[lost_carrier]
#define		NWSTAT_CERRORS(x)	x[mult_retry] + x[one_retry]
#define		NWSTAT_BITS 	\
"\20\33TOHOST\32HOSTF\31NWFREE\30SYNCH\27XILOST\26INIT\25RCVBIG\24BADADR\
\23RCVMERR\22SILOO\21RCVBERR\20FRAME\17CRC\16RCVMISS\15RCVOK\14XMERR\
\13COLLISION\12BABBLE\11LOSTCARRIER\10LATEC\7SILOU\6XBERR\5DEFER\4FRETRY\
\3RETRY1\2MRETRY\1SUCC"

	    struct ring	*re_tonw;	/* Enet xmit bcb ring */
	    struct ring *re_hostfree;	/* Enet free bcb's for host */
	    struct ring *re_tohost;	/* Enet receive bcb ring */
	    struct ring *re_nwfree;	/* Enet free bcb's for card */
	} op_ram;
    } dp_ram;
    u_short	nw_irq;			/* interrupt request */
    u_short	nw_reset;		/* put card in reset state */
};

#define	nw_ram_long			dp_ram.nw_ram_wd
#define	nw_ram_word			dp_ram.nw_ram_wd
#define	nw_ram				dp_ram.nw_ram_ch
#define	rom_vars			dp_ram.hw_ram.rom_var
#define		nw_testno		rom_vars.testno
#define		nw_erradr		rom_vars.erradr
#define		nw_expected		rom_vars.expected
#define		nw_recieved		rom_vars.recieved
#define		nw_cwra_copy		rom_vars.cwra_copy
#define		nw_cwrb_copy		rom_vars.cwrb_copy
#define		nw_jumper		rom_vars.jumper
#define		nw_owned		rom_vars.owned
#define		nw_command		rom_vars.command
#endif	ASSEMBLY	]
#define			COMMAND_GO	0x8080
#ifndef	ASSEMBLY	[
#define		nw_ctl_stat		rom_vars.ctl_stat
#endif	ASSEMBLY	]
#define			CTL_STAT_RESET	0xFFFF
#define			CTL_STAT_READY	0x0004
#define			CTL_STAT_ONLINE	0x0002
#ifndef	ASSEMBLY	[
#define		nw_fw_address		rom_vars.fw_address
#define		nw_etheraddr		rom_vars.rom_ethaddr
#define		nw_c_tohost		rom_vars.c_tohost
#define		nw_c_fromhost		rom_vars.c_fromhost
#define	op_rams				dp_ram.op_ram
#define		nw_base_addr		op_rams.base_addr
#define		nw_ipend_tonw		op_rams.ipend_tonw
#define		nw_ipend_tohost		op_rams.ipend_tohost
#define		nw_ivector		op_rams.ivector
#define		nw_version		op_rams.version
#define		nw_stat			op_rams.nw_stats
#define		nw_tonw			op_rams.re_tonw
#define		nw_hostfree		op_rams.re_hostfree
#define		nw_tohost		op_rams.re_tohost
#define		nw_nwfree		op_rams.re_nwfree

/* Macros device operations */
#define RESET_NW(nwp)	{ u_short nw_xxx = nwp->nw_reset; }
#define UNRESET_NW(nwp)	INTR_NW(nwp)
#define INTR_NW(nwp)	{ u_short nw_xxx = nwp->nw_irq; }
#ifndef	DIAG	[
#define GO_NW(nwp)	{ nwp->nw_base_addr = (u_int)nwp; \
			nwp->nw_command = COMMAND_GO;}
#endif	DIAG	]

/* NW Buffer Control Blocks */
struct bcb
{
	struct bcb	*b_link;
	short		b_stat;
#define				BCB_DONE	1<<15
#define				BCB_MERR	1<<1
#define				BCB_MISS	1<<0
	short		b_len;
	char		*b_addr;
	short		b_msglen;
	char		b_type;
#define				BCB_TYPE_DATA		0
#define				BCB_TYPE_COMMAND	1
	char		b_pad;
};

struct bcblist {
	u_short		bl_count;
	struct bcb	*bl_head;
};

/* NW Command Packets */
#ifndef	DIAG	[
union command_packet {
	u_char max_size[ENETBUFLEN];
	struct command {
	    u_short command;
#define			NW_CMD_CONFIG_READ	0
#define			NW_CMD_CONFIG_WRITE	1
	    u_int user_id;
	    struct config {
		u_short mode;
#define			NW_MODE_PROMISCUOUS		0x8000
#define			NW_MODE_SELF_RCV_OWN_ADDR	0x4000
#define			NW_MODE_SELF_RCV_BROADCAST	0x2000
#define			NW_MODE_SELF_RCV_ALL		0x1000
                u_short cf_rsrvd[15];		/* reserved for later use */
                u_short multicast_count;	/* # of mc addresses */
#define			NW_ENET_ADDR_ARRAY_SIZE		256
#define			NW_BROADCAST_ENET_ADDR		0
#define			NW_MY_ENET_ADDR			1
                char enet_addresses[NW_ENET_ADDR_ARRAY_SIZE][6];
            } config;
    	} command;
};

struct cpcb {
    union command_packet *c_addr;
    int c_len;
};

#define nw_commandp			command.command
#define nw_user_id			command.user_id
#define   nw_config			command.config
#define     nw_mode			nw_config.mode
#define     nw_cf_rsrvd			nw_config.cf_rsrvd
#define     nw_mcc			nw_config.multicast_count
#define     nw_enet_addresses		nw_config.enet_addresses
#endif  DIAG	]

/* Ioctl commands for firmware download */
#define NWIOGO		_IO(S, 1)	/* start downloaded firmware */
#define NWIORESET	_IO(S, 2)	/* reset */
#define NWIOUNRESET	_IO(S, 3)	/* unreset */
#define NWIOCMDPKT	_IOWR(S, 4, struct cpcb)  /* send a command packet */

#ifdef	NW_STATS
char *nw_stat_names[NUMBER_OF_STATS] = {
	"xmit_successful", "mult_retry", "one_retry", "fail_retry",
	"deferrals", "xmit_buff_err", "silo_underrun", "late_coll",
	"lost_carrier", "babble", "collision", "xmit_mem_err",
	"rcv_successful", "rcv_missed", "crc_err", "frame_err",
	"rcv_buff_err", "silo_overrun", "rcv_mem_err", "bad_addr",
	"oversize_rcv_pkt", "initializations", "xmit_init_lost", "synch",
	"rcv_nwfree", "bad_host_format", "rcv_tohost",
};
#endif	NW_STATS
#endif  ASSEMBLY	]
