/*
 * Excelan EXOS 202(VME) & 203(QBUS) Link Level Ethernet Interface Drivers
 */
#ifdef 	QBUS
#define	ONE_REPLY_BUF
#endif 	QBUS
#ifdef	M68025
int	ex_usefrags	= 0;		/* KLUDGE */
#else	M68025
int	ex_usefrags	= 1;		/* use fragments on Xmits */
#endif	M68025

#include "ex.h"

#if	NEX > 0
#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "mbuf.h"
#include "buf.h"
#include "protosw.h"
#include "socket.h"
#include "time.h"
#include "kernel.h"
#include "syslog.h"
#include "vmmac.h"
#include "ioctl.h"
#include "errno.h"

#include "../net/if.h"
#include "../net/netisr.h"
#include "../net/route.h"

#ifdef	INET
#include "../netinet/in.h"
#include "../netinet/in_systm.h"
#include "../netinet/in_var.h"
#include "../netinet/ip.h"
#include "../netinet/ip_var.h"
#include "../netinet/if_ether.h"
#endif	INET

#ifdef	NS
#include "../netns/ns.h"
#include "../netns/ns_if.h"
#endif	NS

#ifdef	TRFS
#include "../wipc/wipc.h"
#include "../wipc/wipc_packet.h"
#include "../wipc/wipc_pklink.h"
#define	PKLEN		(ETHERMTU - 32 - 4)
#define	PKBURST		8
#endif	TRFS

#ifdef	APPLETALK
#include "../netddp/atalk.h"
#include "../netddp/katalk.h"
#include "../netddp/aarp.h"
#endif	APPLETALK

#ifdef	ENETFILTER
#include "../is68kif/enet.h"
#endif	ENETFILTER

#include "../is68kif/if_qb.h"
#include "../is68kif/if_pkbuf.h"
#include "../is68kif/if_exreg.h"
#include "../is68kdev/qbvar.h"

#define	NH2X		32	/* Host to eXcelan request buffers */
#ifdef	ONE_REPLY_BUF
#define	NX2H		1	/* eXcelan to Host reply buffers */
#else	ONE_REPLY_BUF
#define	NX2H		16	/* eXcelan to Host reply buffers */
#endif	ONE_REPLY_BUF
#define	NREC		8	/* max number of hung recieve buffers */

#define EXWATCHINTVL	20	/* call exwatch every x secs */

int	exprobe(), exslave(), exattach(), exintr();
#ifdef	TRFS
int	ex_xmit(), ex_relse();
#endif	TRFS
struct	qb_device *exinfo[NEX];
u_short *exstd[] = { 
#ifdef	QBUS
		(u_short *)0x3FE800,
		(u_short *)0x3FE810,
		(u_short *)0x3FE820,
		(u_short *)0x3FE830,
#else	QBUS
		(u_short *)&vme_stdio[0xFF0000],
		(u_short *)&vme_stdio[0xFE0000],
		(u_short *)&vme_stdio[0xFB0000],
		(u_short *)&vme_stdio[0xFA0000],
#endif	QBUS
		0 };

struct	qb_driver EXdriver =
	{ exprobe, exslave, exattach, exstd, "ex", exinfo, "EX"};
int	exinit(),exoutput(),exioctl(),exreset(),exwatch();
struct	ex_msg *exgetcbuf();

/*
 * Ethernet software status per interface.
 *
 * Each interface is referenced by a network interface structure, xs_if, which 
 * the routing code uses to locate the interface.  This structure contains the 
 * output queue for the interface, its address, ... NOTE: To configure multiple
 * controllers, the sizeof this structure must be a multiple of 16 (xs_h2xhdr).
 */
struct	ex_softc {
	struct		arpcom xs_ac;	/* Ethernet common part */
#define	xs_if		xs_ac.ac_if	/* network-visible interface */
#define	xs_addr		xs_ac.ac_enaddr	/* hardware Ethernet address */
	int		xs_flags;	/* private flags */
#define	EX_XPENDING	1		/*   xmit rqst pending on EXOS */
#define	EX_STATPENDING	(1<<1)		/*   stats rqst pending on EXOS */
#define	EX_RUNNING	(1<<2)		/*   board is running */
#define EX_SETADDR	(1<<3)		/*   physaddr has been changed */
	int		xs_cvec;	/* probe stores cvec here */
	short		xs_enetunit;	/* ENET: unit number for filtering */
	short		xs_enetinit;	/* ENET: inetrface is initialized */
	struct	ex_msg	*xs_h2xnext;	/* host pointer to request queue */
	struct	ex_msg 	*xs_x2hnext;	/* host pointer to reply queue */
	u_long		xs_qbaddr;	/* map info for structs below */
#ifdef	QBUS
#define	BUSADDR(x)	((u_long)x)
#define	P_BUSADDR(x)	(((u_long)(x)&0x3FFFF0))
#else	QBUS
#define	BUSADDR(x)	(0x3D000000 | ((u_long)x))
#define	P_BUSADDR(x)	(0x3D000000 | ((u_long)(x)&0xFFFFF0))
#endif	QBUS
	/* the following structures are always mapped in */
	u_short		xs_h2xhdr;	/* EXOS's request queue header */
	u_short		xs_x2hhdr;	/* EXOS's reply queue header */
	struct ex_msg 	xs_h2xent[NH2X];/* request msg buffers */
	struct ex_msg 	xs_x2hent[NX2H];/* reply msg buffers */
	struct confmsg	xs_cm;		/* configuration message */
	struct stat_array xs_xsa;	/* EXOS writes stats here */
#define	INCORE_BASE(p)	(((u_long)(&(p)->xs_h2xhdr)) & 0xFFFFFFF0)
#define	RVAL_OFF(n)	((u_long)(&(ex_softc[0].n)) - INCORE_BASE(&ex_softc[0]))
#define	LVAL_OFF(n)	((u_long)(ex_softc[0].n) - INCORE_BASE(&ex_softc[0]))
#define	H2XHDR_OFFSET	RVAL_OFF(xs_h2xhdr)
#define	X2HHDR_OFFSET	RVAL_OFF(xs_x2hhdr)
#define	H2XENT_OFFSET	LVAL_OFF(xs_h2xent)
#define	X2HENT_OFFSET	LVAL_OFF(xs_x2hent)
#define	CM_OFFSET	RVAL_OFF(xs_cm)
#define	SA_OFFSET	RVAL_OFF(xs_xsa)
	/* end mapped area */

	char		xs_nrec;	/* number of pending receive buffers */
	u_char		xs_ix;		/* TRFS: Attached slot */
	u_char		xs_atnode;	/* APPLETALK: assigned node number */
#ifdef	ONE_REPLY_BUF
	char	pad[15];		/* make BUSADDR macros */
#else	ONE_REPLY_BUF
	char	pad[19];		/* make BUSADDR macros */
#endif	ONE_REPLY_BUF
} ex_softc[NEX];

#ifdef	RFS
extern struct ifqueue rfsintrq;
#endif	RFS

exprobe(exaddr, unit)
register struct exdevice *exaddr;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ex_msg *bp;
	register int	i;

	if (badaddr(exaddr, 2)  ||  badaddr(&exaddr->ex_porta, 1))
		return 0;
#ifdef	QBUS
	/* read porta (does nothing), INTERLAN board will have IL_CDONE set */
	if (*(u_short *)exaddr)
		return(0);
#endif	QBUS
	if (i = (sizeof(struct ex_softc) & 0xF)) {
		printf("   EX%d:  ex_softc misalligned, add %d to pad\n", 
			unit, 0x10 - i);
		return 0;
	}

	/* Reset EXOS and run self-test (should complete within 2 seconds). */
	exaddr->ex_porta = EX_RESET;
	for (i = 1000000; i && ((exaddr->ex_portb & EX_TESTOK) == 0); i--)
		;
	if ((exaddr->ex_portb & EX_TESTOK) == 0) {
		printf("   EX%d  failed self test\n", unit);
		return 0;
	}

	/* configure the board */
	xs->xs_cvec = freevec();
	xs->xs_qbaddr = INCORE_BASE(xs);
	exconfig(exaddr, unit);
	if (xs->xs_cm.cm_cc) {
		printf("   EX%d  configuration failed: %x\n", unit, 
			xs->xs_cm.cm_cc);
		return 0;
	}

	/* get ethernet address, should cause interrupt */
	if ((bp = exgetcbuf(xs, LLNET_ADDRS)) == (struct ex_msg *)0)
		return 0;
	bp->mb_na.na_mask = READ_OBJ;
	bp->mb_na.na_slot = PHYSSLOT;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	for (i = 1000000; i && ((bp->mb_status & MH_OWNER) == MH_EXOS); i--)
		;
	if ((bp->mb_status & MH_OWNER) == MH_EXOS)
		return 0;
	bcopy((caddr_t)bp->mb_na.na_addrs, xs->xs_addr, sizeof(xs->xs_addr));
	clevmax = clev_impmax;
	clev_imp = MAX(clev, clev_imp);
	return (sizeof(struct exdevice));
}

exslave()
{
	return 1;
}

/*
 * Interface exists: make available by filling in network interface record.  
 * System will initialize the interface when it is ready to accept packets.  
 * A NET_ADDRS command is done to get the ethernet address.
 */
exattach(qi)
struct qb_device	*qi;
{
	register struct ex_softc *xs = &ex_softc[qi->qi_unit];
	register struct ifnet *ifp = &xs->xs_if;
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;

	ifp->if_unit = qi->qi_unit;
	ifp->if_name = "ex";
	ifp->if_mtu = ETHERMTU;
	ifp->if_flags = IFF_BROADCAST;
	printf("	(%e) HW %c.%c NX %c.%c", xs->xs_addr, 
		xs->xs_cm.cm_vc[2], xs->xs_cm.cm_vc[3], 
		xs->xs_cm.cm_vc[0], xs->xs_cm.cm_vc[1]);
	ifp->if_init = exinit;
	ifp->if_output = exoutput;
	ifp->if_ioctl = exioctl;
	ifp->if_reset = exreset;
	if_attach(ifp);
#ifdef	TRFS
	xs->xs_ix = IfaceAttach(ifp->if_unit, ex_xmit, ex_relse,
		PKLEN, PKBURST, etherbroadcastaddr, sizeof(xs->xs_addr));
#endif	TRFS
#ifdef	RFS
	RfsAttach(ifp, &xs->xs_ac);
#endif	RFS
}

/* Reset of interface. */
exreset(unit)
int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct qb_device *qi = exinfo[unit];
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;
	register struct ex_msg 	*bp;
	int 			s;

	if (unit >= Nex || (qi = exinfo[unit]) == 0 || qi->qi_alive == 0)
		return;
	if ((xs->xs_if.if_flags & IFF_RUNNING) == 0)
		return;
	s = splimp();
	/* Take EXOS off the Ethernet, using NET_MODE command */
	if ((bp = exgetcbuf(xs, LLNET_MODE)) == (struct ex_msg *)0)
		panic("exreset");
	bp->mb_nm.nm_mask = WRITE_OBJ;
	bp->mb_nm.nm_optn = 0;
	bp->mb_nm.nm_mode = MODE_OFF;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	while ((bp->mb_status & MH_OWNER) == MH_EXOS)	/* poll for reply */
		;
	bp->mb_length = MBDATALEN;
	bp->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs->xs_x2hnext = xs->xs_x2hnext->mb_next;
	xs->xs_if.if_flags &= ~IFF_RUNNING;
	xs->xs_flags &= ~EX_RUNNING;
	splx(s);
}

/*
 * Initialization of interface; clear recorded pending operations, and 
 * reinitialize BUS usage. Called at boot time, and at ifconfig time via 
 * exioctl, with interrupts disabled.
 */
exinit(unit)
int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct qb_device *qi = exinfo[unit];
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;
	register struct ifnet *ifp = &xs->xs_if;
	register struct ex_msg 	*bp;
	int 			s;

#ifndef	TRFS
	/* not yet, if address still unknown */
	if (ifp->if_addrlist == (struct ifaddr *)0)
		return;
#endif	TRFS
	if (xs->xs_flags & EX_RUNNING)
		return;

	if ((ifp->if_flags & IFF_RUNNING) == 0)
		xs->xs_qbaddr = INCORE_BASE(xs);
	exconfig(exaddr, unit);

	/* Put EXOS on the Ethernet, using NET_MODE command */
	if ((bp = exgetcbuf(xs, LLNET_MODE)) == (struct ex_msg *)0)
		panic("exinit");
	bp->mb_nm.nm_mask = WRITE_OBJ;
	bp->mb_nm.nm_optn = 0;
	bp->mb_nm.nm_mode = MODE_PERF;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	while ((bp->mb_status & MH_OWNER) == MH_EXOS)	/* poll for reply */
		;
	bp->mb_length = MBDATALEN;
	bp->mb_status |= MH_EXOS;		/* free up buffer */
	exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
	xs->xs_x2hnext = xs->xs_x2hnext->mb_next;

	ifp->if_watchdog = exwatch;
	ifp->if_timer = EXWATCHINTVL;
	s = splimp();
	exhangrcv(unit);
	ifp->if_flags |= IFF_RUNNING;
	xs->xs_flags |= EX_RUNNING;
	if (xs->xs_flags & EX_SETADDR)
		ex_setaddr(xs->xs_addr, unit);
	exstart(unit);				/* start transmits */
	splx(s);

#ifdef	ENETFILTER
	if (!xs->xs_enetinit) {
	    	struct endevp enp;
	    
		xs->xs_enetinit++;
	    	enp.end_dev_type = ENDT_10MB;
	    	enp.end_addr_len = sizeof(xs->xs_addr);
	    	enp.end_hdr_len = sizeof(struct ether_header);
	    	enp.end_MTU = ETHERMTU;
		bcopy((caddr_t)xs->xs_addr, (caddr_t)enp.end_addr,
			sizeof(xs->xs_addr));
		bcopy((caddr_t)etherbroadcastaddr, (caddr_t)enp.end_broadaddr,
			sizeof(xs->xs_addr));
	    	xs->xs_enetunit = enetattach(ifp, &enp);
	}
#endif	ENETFILTER
}

/*
 * Reset, test, and configure EXOS.  It is called by exinit, and exattach.
 * Returns 0 if successful, 1 if self-test failed.
 */
exconfig(exaddr, unit)
	register struct exdevice *exaddr;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct confmsg *cm = &xs->xs_cm;
	register struct ex_msg 	*bp;
	u_long 	shiftreg;
	int 	i;
	static	u_char	cmaddr[8] = {0xFF, 0xFF, 0, 0};

	xs->xs_flags = 0;

	/* Reset EXOS, wait for self-test to complete */
	exaddr->ex_porta = EX_RESET;
	while ((exaddr->ex_portb & EX_TESTOK) == 0) 
		;

	/* Set up configuration message. */
	cm->cm_1rsrv = 1;
	cm->cm_cc = 0xFF;
	cm->cm_opmode = 0;		/* link-level controller mode */
	cm->cm_dfo = 0x0101;		/* enable host data order conversion */
	cm->cm_dcn1 = 1;
	cm->cm_2rsrv[0] = cm->cm_2rsrv[1] = 0;
	cm->cm_ham = 3;			/* absolute address mode */
	cm->cm_3rsrv = 0;
	cm->cm_mapsiz = 0;
	cm->cm_byteptrn[0] = 0x01;	/* EXOS deduces data order of host */
	cm->cm_byteptrn[1] = 0x03;	/*  by looking at this pattern */
	cm->cm_byteptrn[2] = 0x07;
	cm->cm_byteptrn[3] = 0x0F;
	cm->cm_wordptrn[0] = 0x0103;
	cm->cm_wordptrn[1] = 0x070F;
	cm->cm_lwordptrn = 0x0103070F;
	for (i=0; i<20; i++) cm->cm_rsrvd[i] = 0;
	cm->cm_mba = 0xFFFFFFFF;
	cm->cm_nproc = 0xFF;
	cm->cm_nmbox = 0xFF;
	cm->cm_nmcast = 0xFF;
	cm->cm_nhost = 1;
	cm->cm_h2xba = P_BUSADDR(xs->xs_qbaddr);
	cm->cm_h2xhdr = H2XHDR_OFFSET;
	cm->cm_h2xtyp = 0;		/* should never wait for rqst buffer */
	cm->cm_x2hba = cm->cm_h2xba;
	cm->cm_x2hhdr = X2HHDR_OFFSET;
	cm->cm_x2htyp = 4;		/* 4 for vectored interrupts */
	cm->cm_x2haddr = xs->xs_cvec;	/* ivec allocated in exprobe */

	/* Set up message queues and headers: first the request queue */
	for (bp = &xs->xs_h2xent[0]; bp < &xs->xs_h2xent[NH2X]; bp++) {
		bp->mb_link = (u_short)((char *)(bp+1)-INCORE_BASE(xs));
		bp->mb_rsrv = 0;
		bp->mb_length = MBDATALEN;
		bp->mb_status = MH_HOST;
		bp->mb_next = bp+1;
	}
	xs->xs_h2xhdr = xs->xs_h2xent[NH2X-1].mb_link = (u_short)H2XENT_OFFSET;
	xs->xs_h2xnext = xs->xs_h2xent[NH2X-1].mb_next = xs->xs_h2xent;

	/* now the reply queue */
	for (bp = &xs->xs_x2hent[0]; bp < &xs->xs_x2hent[NX2H]; bp++) {
		bp->mb_link = (u_short)((char *)(bp+1)-INCORE_BASE(xs));
		bp->mb_rsrv = 0;
		bp->mb_length = MBDATALEN;
		bp->mb_status = MH_EXOS;
		bp->mb_next = bp+1;
	}
	xs->xs_x2hhdr = xs->xs_x2hent[NX2H-1].mb_link = (u_short)X2HENT_OFFSET;
	xs->xs_x2hnext = xs->xs_x2hent[NX2H-1].mb_next = xs->xs_x2hent;

	/*
	 * Write config msg address to EXOS and wait for configuration to 
	 * complete (guaranteed response within 2 seconds).
	 */
	shiftreg = P_BUSADDR(xs->xs_qbaddr) + CM_OFFSET;
	for (i = 4; i < 8; i++) {
		cmaddr[i] = (u_char)(shiftreg & 0xFF);
		shiftreg >>= 8;
	}
	for (i = 0; i < 8; i++) {
		while (exaddr->ex_portb & EX_UNREADY) 
			;
		DELAY(200);
		exaddr->ex_portb = cmaddr[i];
	}
	for (i = 100000; (cm->cm_cc == 0xFF) && i; --i) DELAY(10);
	if (cm->cm_cc)
		printf("ex%d: configuration failed; cc=%x\n", unit, cm->cm_cc);
}

/*
 * Start or re-start output on interface. Get another datagram to send off of 
 * the interface queue, and map it to the interface before starting the output.
 * This routine is called by exinit(), exoutput(), and excdint().  In all cases,
 * interrupts by EXOS are disabled.
 */
exstart(unit)
	int unit;
{
	struct qb_device *qi = exinfo[unit];
	register struct ex_softc *xs = &ex_softc[unit];
	register struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;
	register struct ex_msg *bp;
	register struct mbuf *m, *m0;
	register struct pkbuf *pkb;
	register int nb, tlen;
	int addr, len;
	char *p;

loop:	IF_DEQUEUE(&xs->xs_if.if_snd, m);
	if (m == 0)
		return;
	if ((pkb = GetPkBuf()) == (struct pkbuf *)0) {
		IF_PREPEND(&xs->xs_if.if_snd, m);
		return;
	}
	if ((bp = exgetcbuf(xs, LLRTRANSMIT)) == (struct ex_msg *)0) {
		FreePkBuf(pkb);
		IF_PREPEND(&xs->xs_if.if_snd, m);
		return;
	}

	/*
	 * point directly to the first group of mbufs to be transmitted. The
	 * hardware can only support NFRAGMENTS descriptors.
	 */
	nb = 0; tlen = 0; m0 = 0;
	while (ex_usefrags && m && ((nb < NFRAGMENTS-1) || (m->m_next == 0))) {
		if (m->m_len > 0) {
			p = mtod(m, char *);
			if (btop(p) != btop(p+m->m_len))
				break;
/* must set up map for this!! ... how am i going to free this ??? */
			*(u_long *)bp->mb_et.et_blks[nb].bb_addr = BUSADDR(svtop(p));
			bp->mb_et.et_blks[nb].bb_len = (u_short)m->m_len;
			tlen += m->m_len;
			nb++;
		}
		if (m0 == 0)
			pkb->pkb_mbuf = m;
		m0 = m;
		m = m->m_next;
	}
	if (m0)
		m0->m_next = 0;

	/*
	 * if not all of the descriptors would fit then merge remaining data 
	 * into the transmit buffer, and point to it.  Note: the mbufs are 
	 * freed during the merge, they do not have to be freed when we get 
	 * the transmit interrupt.  Do NOT pad the fragment to an even length,
	 * as this may cause the total packet length to excede the MTU!!!
	 */
	if (m) {
		bp->mb_pkb = pkb;
		len = if_wqbput(pkb->pkb_buffer, m, 0);
		*(u_long *)bp->mb_et.et_blks[nb].bb_addr = 
						BUSADDR(pkb->pkb_dma_buffer);
		bp->mb_et.et_blks[nb].bb_len = (u_short)len;
		tlen += len;
		nb++;
	} else {
		/* did not use the packet buffer */
		bp->mb_pkb = (struct pkbuf *)pkb->pkb_mbuf;
		FreePkBuf(pkb);
	}
	bp->mb_et.et_nblock = nb;

	/* If the total length of the packet is too small, pad the last frag */
	if (tlen - sizeof(struct ether_header) < ETHERMIN) {
		len = (ETHERMIN + sizeof(struct ether_header)) - tlen;
		bp->mb_et.et_blks[nb-1].bb_len += (u_short)len;
	}

	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	goto loop;
}

/* interrupt service routine. */
exintr(unit)
	int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ex_msg *bp = xs->xs_x2hnext;
	register struct ifnet *ifp = &xs->xs_if;
	struct qb_device *qi = exinfo[unit];
	struct exdevice *exaddr = (struct exdevice *)qi->qi_mi->qm_addr;

	while ((bp->mb_status & MH_OWNER) == MH_HOST) {
		switch (bp->mb_rqst) {
		    case LLRECEIVE:
			if (--xs->xs_nrec < 0)
				xs->xs_nrec = 0;
			if (exrecv(unit, bp) == 0)
				FreePkBuf(bp->mb_pkb);
			bp->mb_pkb = (struct pkbuf *)0;
			exhangrcv(unit);
			break;

		    case LLTRANSMIT:
		    case LLRTRANSMIT:
			ifp->if_opackets++;
			if (bp->mb_rply == LL_OK)
				;
			else if (bp->mb_rply & LLXM_1RTRY)
				ifp->if_collisions++;
			else if (bp->mb_rply & LLXM_RTRYS)
				ifp->if_collisions += 2;	/* guess */
			else if (bp->mb_rply & LLXM_ERROR)
				if (ifp->if_oerrors++ % 100 == 0)
				    log(LOG_WARNING, 
					"ex%d: 100 transmit errors=%b\n",
					unit, bp->mb_rply, XMIT_BITS);
			if (IsPkBuf(bp->mb_pkb)) {
				if (bp->mb_pkb->pkb_mbuf)
					m_freem(bp->mb_pkb->pkb_mbuf);
				FreePkBuf(bp->mb_pkb);
			} else if (bp->mb_pkb)
				m_freem((struct mbuf *)bp->mb_pkb);
			bp->mb_pkb = (struct pkbuf *)0;
			exstart(unit);
			exhangrcv(unit);
			break;

		    case LLNET_STSTCS:
			ifp->if_ierrors = xs->xs_xsa.sa_crc;
			xs->xs_flags &= ~EX_STATPENDING;
			break;

		    default:
			printf("ex%d: unknown reply 0x%x\n", unit, bp->mb_rqst);
		}
		bp->mb_length = MBDATALEN;
		bp->mb_status |= MH_EXOS;	/* free up buffer */
		exaddr->ex_portb = EX_NTRUPT;		/* tell EXOS about it */
		bp = bp->mb_next;
	}
	xs->xs_x2hnext = bp;
}

/* Get a request buffer, fill in standard values, advance pointer. */
struct ex_msg *
exgetcbuf(xs, req)
struct ex_softc *xs;
int req;
{
	register struct ex_msg *bp;
	int s = splimp();

	bp = xs->xs_h2xnext;
	if ((bp->mb_status & MH_OWNER) == MH_EXOS) {
		splx(s);
		return (struct ex_msg *)0;
	}
	xs->xs_h2xnext = bp->mb_next;
	bp->mb_1rsrv = 0;
	bp->mb_rqst = req;
	bp->mb_length = MBDATALEN;
	bp->mb_pkb = (struct pkbuf *)0;
	splx(s);
	return bp;
}

/*
 * Process Ethernet receive completion:  If input error just drop packet, 
 * otherwise examine packet to determine type.  If can't determine length from 
 * type, then have to drop packet, otherwise decapsulate packet based on type 
 * and pass to type-specific higher-level input routine.
 */
exrecv(unit, bp)
int unit;
register struct ex_msg *bp;
{
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ifnet *ifp = &xs->xs_if;
	register struct ether_header *eh;
    	register struct mbuf *m;
	int len, off, resid;
	register struct ifqueue *inq;
	int s;

	ifp->if_ipackets++;
	if (bp->mb_rply != LL_OK) {
		if (ifp->if_ierrors++ % 100 == 0)
			log(LOG_WARNING, "ex%d: 100 receive errors=%b\n",
				unit, bp->mb_rply, RECV_BITS);
		return 0;
	}

	/*
	 * Deal with trailer protocol: if type is trailer get true type from
	 * first 16-bit word past data.  Remember that type was trailer by 
	 * setting off.
	 */
	/*     total length               - header                      - crc */
	len = bp->mb_er.er_blks[0].bb_len - sizeof(struct ether_header) - 4;
	eh = (struct ether_header *)(bp->mb_pkb->pkb_buffer);
	eh->ether_type = ntohs((u_short)eh->ether_type);
#ifdef	TRFS
	if (eh->ether_type == ETHERTYPE_WIPC)
		return !ex_recv(xs - ex_softc, bp->mb_pkb);
#endif	TRFS
#define	exdataaddr(eh, off, type)	((type)(((caddr_t)((eh)+1)+(off))))
	if (eh->ether_type >= ETHERTYPE_TRAIL &&
	    eh->ether_type < ETHERTYPE_TRAIL+ETHERTYPE_NTRAILER) {
		if ((off = (eh->ether_type - ETHERTYPE_TRAIL)*512) >= ETHERMTU)
			return 0;			/* sanity */
		eh->ether_type = ntohs(*exdataaddr(eh, off, u_short *));
		resid = ntohs(*(exdataaddr(eh, off+2, u_short *)));
		if (off + resid > len)
			return 0;			/* sanity */
		len = off + resid;
	} else
		off = 0;
	if (len == 0)
		return 0;

	/*
	 * Pull packet off interface.  Off is nonzero if packet has trailing 
	 * header; if_rqbget will then force this header information to be at 
	 * the front and drop the type and length at the head of trailers.
	 */
	if ((m = if_rqbget(bp->mb_pkb->pkb_buffer, len, off, 
	    sizeof(struct ether_header), ifp)) == 0)
		return 0;

	switch (eh->ether_type) {
#ifdef INET
	    case ETHERTYPE_IP:
		schednetisr(NETISR_IP);
		inq = &ipintrq;
		break;

	    case ETHERTYPE_ARP:
		arpinput(&xs->xs_ac, m);
		return 0;
#endif
#ifdef NS
	    case ETHERTYPE_NS:
		schednetisr(NETISR_NS);
		inq = &nsintrq;
		break;

#endif
#ifdef	RFS
	      case ETHERTYPE_RFS:
		schednetisr(NETISR_RFS);
		inq = &rfsintrq;
		break;
#endif
#ifdef	APPLETALK
	    case ETHERTYPE_AARP:
		aarpinput(&xs->xs_ac, m);
		return 0;

	    case ETHERTYPE_APPLETALK:
		if (xs->xs_atnode) {
			ddp_setifp(ifp, xs->xs_atnode);
			inq = &ddpintq;
			schednetisr(NETISR_DDP);
			break;
		}
		/* fall thru */
#endif	APPLETALK
	    default:
#ifdef	ENETFILTER
		if (xs->xs_enetinit && xs->xs_enetunit >= 0) {
			register struct mbuf *mtop;

			/*
			 * We need the local net header after all.  Oh well,
			 * this could be improved.
			 */
			MGET(mtop, M_DONTWAIT, MT_DATA);
			if (mtop) {
				/* undo the swap done earlier */
				eh->ether_type = htons((u_short)eh->ether_type);
				bcopy((struct ether_header *)eh->ether_dhost,
					mtod(mtop, struct ether_header *),
					sizeof(struct ether_header));
				mtop->m_len = sizeof(struct ether_header);
				/* remove interface pointer */
				m->m_len -= sizeof(ifp);
				m->m_off += sizeof(ifp);
				mtop->m_next = m;
				enetFilter(xs->xs_enetunit, mtop,
					(len + sizeof(struct ether_header)) );
				return 0;
			}
		}
#endif	ENETFILTER
		m_freem(m);
		return 0;
	}

	s = splimp();
	if (IF_QFULL(inq)) {
		IF_DROP(inq);
		m_freem(m);
	} else
		IF_ENQUEUE(inq, m);
	splx(s);
	return 0;
}

/*
 * Hang a receive request. This routine is called by exinit and excdint,
 * with interrupts disabled in both cases.
 */
exhangrcv(unit)
	int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	struct exdevice *exaddr = (struct exdevice *)exinfo[unit]->qi_mi->qm_addr;
	register struct ex_msg *bp;
	register struct pkbuf *pkb;
	short hung = 0;

	while (xs->xs_nrec < NREC) {
		if ((pkb = GetPkBuf()) == (struct pkbuf *)0)
			break;
		if ((bp = exgetcbuf(xs, LLRECEIVE)) == (struct ex_msg *)0) {
			FreePkBuf(pkb);
			break;
		}
		bp->mb_pkb = pkb;

		xs->xs_nrec += 1;
		bp->mb_er.er_nblock = 1;
		bp->mb_er.er_blks[0].bb_len = EXMAXRBUF;
		*(u_long *)bp->mb_er.er_blks[0].bb_addr =
						BUSADDR(pkb->pkb_dma_buffer);
		bp->mb_status |= MH_EXOS;
		hung++;
	}
	if (hung)
		exaddr->ex_portb = EX_NTRUPT;
}

/*
 * Ethernet output routine. Encapsulate a packet of type family for the local 
 * net.  Use trailer local net encapsulation if enough data in first packet 
 * leaves a multiple of 512 bytes of data in remainder.
 */
exoutput(ifp, m0, dst)
register struct ifnet *ifp;
struct mbuf *m0;
struct sockaddr *dst;
{
	int type, s, error;
	u_char edst[6];
	struct in_addr idst;
	register struct ex_softc *xs = &ex_softc[ifp->if_unit];
	register struct mbuf *m = m0;
	register struct ether_header *eh;
	register int off;
	int usetrailers;
#ifdef	RFS
	extern struct ifnet loif;
	extern int useloopback;
#endif
#ifdef	APPLETALK
	struct mbuf *mcopy = (struct mbuf *)0;
	struct sockaddr_at *dat = (struct sockaddr_at *)dst;
	struct lap *lap;
	struct a_addr *appleaddr;
	int ltype, dnode;
#endif	APPLETALK

	switch (dst->sa_family) {
#ifdef INET
	    case AF_INET:
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (!arpresolve(&xs->xs_ac, m, &idst, edst, &usetrailers))
			return (0);	/* if not yet resolved */
		off = ntohs((u_short)mtod(m, struct ip *)->ip_len) - m->m_len;
		if (usetrailers && off > 0 && (off & 0x1ff) == 0 &&
		    m->m_off >= MMINOFF + 2 * sizeof (u_short)) {
			type = ETHERTYPE_TRAIL + (off>>9);
			m->m_off -= 2 * sizeof (u_short);
			m->m_len += 2 * sizeof (u_short);
			*mtod(m, u_short *) = htons((u_short)ETHERTYPE_IP);
			*(mtod(m, u_short *) + 1) = htons((u_short)m->m_len);
			goto gottrailertype;
		}
		type = ETHERTYPE_IP;
		off = 0;
		goto gottype;
#endif
#ifdef NS
	    case AF_NS:
		type = ETHERTYPE_NS;
 		bcopy((caddr_t)&(((struct sockaddr_ns *)dst)->sns_addr.x_host),
		(caddr_t)edst, sizeof (edst));
		off = 0;
		goto gottype;
#endif
#ifdef	RFS
	      case AF_RFS:
		/*
		 * Normally we would call arpresolve directly.  But when
		 * out source and destination are the same arpresolve will
		 * pass the mbuf onto the loopback driver changing the
		 * sa_family type to AF_INET.  So we do the check here and
		 * call looutput if necessary.
		 */
		idst = ((struct sockaddr_in *)dst)->sin_addr;
		if (idst.s_addr == xs->xs_ac.ac_ipaddr.s_addr && useloopback) {
			(void) looutput (&loif, m, dst);
			return (0);
		} else if (!arpresolve(&xs->xs_ac, m, &idst, edst,
				     &usetrailers))
			return (0);	/* if not yet resolved */
		type = ETHERTYPE_RFS;
		off = 0;
		goto gottype;
#endif
#ifdef	APPLETALK
	    case AF_APPLETALK:
		if (xs->xs_atnode == 0) {
			error = ENETUNREACH;
			goto bad;
		}
		lap = mtod(m, struct lap *);
		lap->src = xs->xs_atnode;
		ltype = lap->type & 0xff;
		if (ltype == LT_DDP) {
			/* this is remote net - send it to the bridge */
			appleaddr = ddp_getaddr(ifp);
			if (appleaddr->at_Net)
				lap->dst = dnode = appleaddr->at_Abridge & 0xff;
			else
				lap->dst = dnode = dat->at_node;
		} else
			/* local net - lap->dst already filled in */
			dnode = lap->dst & 0xff;

		idst.s_addr = 0L;
		/* fake out arpresolve */
		((char *)(&idst))[3] = dnode;

		if (dnode == 0xff) {		/* broadcast */
			if ((mcopy = m_copy(m, 0, M_COPYALL)) == NULL) {
				error = ENOBUFS;
				goto bad;
			}
			bcopy((caddr_t)etherbroadcastaddr, edst, sizeof(edst));
		} else {
			/* can't send long ddp's to one's self */
			if ((dnode == xs->xs_atnode) && (ltype == LT_SHORTDDP)) {
				/* this is for me */
				mcopy = m;
				goto gotlocal;
			} else {
				if (!aarpresolve(&xs->xs_ac, m, &idst,
					edst, &usetrailers))
					return (0);	/* if not yet resolved */
			}
		}
		type = ETHERTYPE_APPLETALK;
		goto gottype;
#endif APPLETALK
	    case AF_IMPLINK:
		eh = mtod(m, struct ether_header *);
		goto gotheader;

	    case AF_UNSPEC:
		eh = (struct ether_header *)dst->sa_data;
		bcopy((caddr_t)eh->ether_dhost, (caddr_t)edst, sizeof (edst));
		type = eh->ether_type;
		goto gottype;

	    default:
		log(LOG_WARNING, "ex%d: can't handle af%d\n", ifp->if_unit,
			dst->sa_family);
		error = EAFNOSUPPORT;
		goto bad;
	}

gottrailertype:
	/*
	 * Packet to be sent as trailer: move first packet (control information)
	 * to end of chain.
	 */
	while (m->m_next)
		m = m->m_next;
	m->m_next = m0;
	m = m0->m_next;
	m0->m_next = 0;
	m0 = m;

gottype:
	/* Add local net header. If no space in first mbuf, allocate another. */
	if (m->m_off > MMAXOFF ||
	    MMINOFF + sizeof (struct ether_header) > m->m_off) {
		MGET(m, M_DONTWAIT, MT_HEADER);
		if (m == 0) {
			error = ENOBUFS;
			goto bad;
		}
		m->m_next = m0;
		m->m_off = MMINOFF;
		m->m_len = sizeof (struct ether_header);
	} else {
		m->m_off -= sizeof (struct ether_header);
		m->m_len += sizeof (struct ether_header);
	}
	eh = mtod(m, struct ether_header *);
	eh->ether_type = htons((u_short)type);
	bcopy((caddr_t)edst, (caddr_t)eh->ether_dhost, sizeof (edst));

gotheader:
	bcopy((caddr_t)xs->xs_addr, (caddr_t)eh->ether_shost, 6);

	/* Queue message on interface, start output if not yet active. */
	s = splimp();
	if (IF_QFULL(&ifp->if_snd)) {
		IF_DROP(&ifp->if_snd);
		splx(s);
		m_freem(m);
		return (ENOBUFS);
	}
	IF_ENQUEUE(&ifp->if_snd, m);
	exstart(ifp->if_unit);
	splx(s);
#ifdef	APPLETALK
gotlocal:
	return(mcopy ? looutput(&loif, mcopy, dst) : 0);
#else	APPLETALK
	return (0);
#endif	APPLETALK

bad:
	m_freem(m0);
	return (error);
}

/*
 * Watchdog routine.
 */
exwatch(unit)
int unit;
{
	struct exdevice *exaddr = (struct exdevice *)exinfo[unit]->qi_mi->qm_addr;
	register struct ex_softc *xs = &ex_softc[unit];
	register struct ex_msg *bp;
	int s = splimp();

	if (xs->xs_flags & EX_STATPENDING)
		goto exspnd;
	if ((bp = exgetcbuf(xs, LLNET_STSTCS)) == (struct ex_msg *)0) {
		splx(s);
		return;
	}
	xs->xs_flags |= EX_STATPENDING;
	bp->mb_ns.ns_mask = READ_OBJ;
	bp->mb_ns.ns_rsrv = 0;
	bp->mb_ns.ns_nobj = 8;
	bp->mb_ns.ns_xobj = 0;
	bp->mb_ns.ns_bufp = P_BUSADDR(xs->xs_qbaddr) + SA_OFFSET;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
exspnd:	splx(s);
	xs->xs_if.if_timer = EXWATCHINTVL;
}

/* Process an ioctl request. */
exioctl(ifp, cmd, data)
	register struct ifnet *ifp;
	int cmd;
	caddr_t data;
{
	register struct ifaddr *ifa = (struct ifaddr *)data;
	register struct ex_softc *xs = &ex_softc[ifp->if_unit];
	struct exdevice *exaddr = 
		(struct exdevice *)exinfo[ifp->if_unit]->qi_mi->qm_addr;
	int s = splimp(), error = 0;

	switch (cmd) {
	    case SIOCSIFADDR:
		ifp->if_flags |= IFF_UP;
		exinit(ifp->if_unit);

		switch (ifa->ifa_addr.sa_family) {
#ifdef INET
		    case AF_INET:
			((struct arpcom *)ifp)->ac_ipaddr =
				IA_SIN(ifa)->sin_addr;
			arpwhohas((struct arpcom *)ifp, &IA_SIN(ifa)->sin_addr);
#ifdef	APPLETALK
			if (xs->xs_atnode)
				ddp_deleteifp(xs->xs_atnode);
			xs->xs_atnode = getatnode(&xs->xs_ac);
#endif	APPLETALK
			break;
#endif
#ifdef NS
		    case AF_NS:
		    {
			register struct ns_addr *ina = &(IA_SNS(ifa)->sns_addr);
			
			if (ns_nullhost(*ina))
				ina->x_host = *(union ns_host *)(xs->xs_addr);
			else
				ex_setaddr(ina->x_host.c_host,ifp->if_unit);
			break;
		    }
#endif
		}
		break;

	    case SIOCSIFFLAGS:
		if ((ifp->if_flags & IFF_UP) == 0 && xs->xs_flags & EX_RUNNING){
			exaddr->ex_porta = EX_RESET;
			xs->xs_flags &= ~EX_RUNNING;
		} else if (ifp->if_flags & IFF_UP && 
		    (xs->xs_flags & EX_RUNNING) == 0)
			exinit(ifp->if_unit);
		break;

	    default:
		error = EINVAL;
	}
	splx(s);
	return (error);
}

/*
 * set ethernet address for unit
 */
ex_setaddr(physaddr, unit)
	u_char *physaddr;
	int unit;
{
	register struct ex_softc *xs = &ex_softc[unit];
	struct exdevice *exaddr = (struct exdevice *)exinfo[unit]->qi_mi->qm_addr;
	register struct ex_msg *bp;
	
	if (! (xs->xs_flags & EX_RUNNING))
		return;
	if (physaddr) {
		xs->xs_flags |= EX_SETADDR;
		bcopy((caddr_t)physaddr, (caddr_t)xs->xs_addr, 6);
	}
	if ((bp = exgetcbuf(xs, LLNET_ADDRS)) == (struct ex_msg *)0)
		panic("ex_setaddr");
	bp->mb_rqst = LLNET_ADDRS;
	bp->mb_na.na_mask = READ_OBJ|WRITE_OBJ;
	bp->mb_na.na_slot = PHYSSLOT;
	bcopy((caddr_t)xs->xs_addr, (caddr_t)bp->mb_na.na_addrs, 6);
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	while ((bp->mb_status & MH_OWNER) == MH_EXOS)	/* poll for reply */
		;

	/* Now, re-enable reception on phys slot. */
	bp = exgetcbuf(xs);
	if ((bp = exgetcbuf(xs, LLNET_RECV)) == (struct ex_msg *)0)
		panic("ex_setaddr");
	bp->mb_nr.nr_mask = ENABLE_RCV|READ_OBJ|WRITE_OBJ;
	bp->mb_nr.nr_slot = PHYSSLOT;
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	bp = xs->xs_x2hnext;
	while ((bp->mb_status & MH_OWNER) == MH_EXOS)	/* poll for reply */
		;
}

#ifdef	TRFS
ex_xmit(unit, naddr, p, len, fp0, fp1)
	int unit;
	struct ether_addr *naddr;
	struct packet *p;
	register unsigned long len;
	struct fragment *fp0, *fp1;
{
	register struct ex_msg *bp;
	register struct ether_header *eh;
	register struct ex_softc *xs = &ex_softc[unit];
	struct exdevice *exaddr =
				(struct exdevice *)exinfo[unit]->qi_mi->qm_addr;
	register struct pkbuf *pkb;
	int s = splimp();

	if (NFreePkBuf() < NEX || (pkb = GetPkBuf()) == (struct pkbuf *)0) {
		splx(s);
/*		log(LOG_WARNING, "ex%d: TRFS: no xmit packet buffers\n", unit); /**/
		return EBUSY;
	}
	if ((bp = exgetcbuf(xs, LLRTRANSMIT)) == (struct ex_msg *)0) {
		FreePkBuf(pkb);
		splx(s);
/*		log(LOG_WARNING, "ex%d: TRFS: no xmit command buffers\n", unit); /**/
		return EBUSY;
	}
	bp->mb_pkb = pkb;
	pkb->pkb_mbuf = (struct mbuf *)0;
	eh = (struct ether_header *)pkb->pkb_buffer;
	bcopy((caddr_t)naddr, (caddr_t)eh->ether_dhost, sizeof (eh->ether_dhost));
	bcopy((caddr_t)xs->xs_addr, (caddr_t)eh->ether_shost, sizeof (eh->ether_shost));
	eh->ether_type = ETHERTYPE_WIPC;
	len = (sizeof(struct pklink) - sizeof(struct packet)) +
		pkbuild(&((struct pklink *)eh)->packet, p, len, fp0, fp1);
	if (len - sizeof(struct ether_header) < ETHERMIN)
		len = ETHERMIN + sizeof(struct ether_header);
	bp->mb_et.et_nblock = 1;
	bp->mb_et.et_blks[0].bb_len = (unsigned short)len;
	*(u_long *)bp->mb_et.et_blks[0].bb_addr = BUSADDR(pkb->pkb_dma_buffer);
	bp->mb_status |= MH_EXOS;
	exaddr->ex_portb = EX_NTRUPT;
	splx(s);
	return 0;
}

ex_recv(unit, pkb)
	int unit;
	register struct pkbuf *pkb;
{
	register struct pklink *p = (struct pklink *)pkb->pkb_buffer;

	ovbcopy(((struct ether_header *)p)->ether_shost, p->netaddr, 6);
	p->buflen = PKBUFSIZE;
	p->prelen = 0;
	p->ix = ex_softc[unit].xs_ix;
	p->handle = (int)pkb;
	return ReceivePacket(p);
}

ex_relse(unit, p)
	int unit;
	struct pklink *p;
{
	int s = splimp();

	FreePkBuf((struct pkbuf *)p->handle);
	exhangrcv(unit);
	splx(s);
}
#endif	TRFS
#endif	NEX > 0
