struct	smdevice {			/* device registers */
    u_char	sm_dstatus[2];		/* drive status registers for 1 & 0 */
#define	sm_DSTATUS(x)	sm_dstatus[(x&1)?0:1]	/* drive 0 is index 1 !!! */
#define		DS_DREADY	0x01	/*    drive ready */
#define		DS_WPROT	0x02	/*    write protected */
#define		DS_BUSY		0x04	/*    busy */
#define		DS_FAULT	0x08	/*    fault */
#define		DS_ONCYL	0x10	/*    on cylinder */
#define		DS_SEEKER	0x20	/*    seek error */
#define		DS_UPRESENT	0x40	/*    unit present (selectable) */
#define		DS_UREADY	0x80	/*    unit ready */
#define		DS_BITS 	\
"\20\10URDY\7UPRE\6SEEKE\5ONCYL\4FAULT\3DBSY\2WPROT\1DRDY"
    u_short	sm_cstatus;		/* command status register */
#define		CS_SLED		0x8000	/*    Status LED */
#define		CS_BOK		0x4000	/*    board ok */
#define		CS_SFEN		0x2000	/*    sysfail enable */
#define		CS_BDCLR	0x1000	/*    board clear */
#define		CS_BERR		0x0100	/*    bus error */
#define		CS_GO		0x0080	/*    start a command */
#define		CS_BUSY		CS_GO	/*    executing command */
#define		CS_DONE		0x0040	/*    operation complete (interrupt) */
#define		CS_STCHG	0x0020	/*    disk status changed (interrupt) */
#define		CS_ERR_LC	0x0010	/*    error on last command */
#define		CS_SCHGSRC	0x0008	/*    status change source */
#define		CS_ERR		(CS_BERR | CS_ERR_LC)
#define		CS_BITS 	\
"\20\20SLED\17BOK\16SFEN\15BCLR\11BERR\10GO\7DONE\6STCHG\5ELC\4SC1"
    struct sm_iopb {			/* IOPB - I/O Parameter Block */
	u_char	iopb_cmd;		/* command register */
#define		CMD_DIAG	0x70	
#define		CMD_READ_L	0x71	
#define		CMD_WRITE_L	0x72	
#define		CMD_READ_H	0x74	
#define		CMD_GIVE_CONFIG	0x77	
#define		CMD_WRITE_SB	0x78	
#define		CMD_READ_SB	0x79	
#define		CMD_READ	0x81	
#define		CMD_WRITE	0x82
#define		CMD_VERIFY	0x83
#define		CMD_FMT_TRK	0x84	
#define		CMD_MAP_TRK	0x85	
#define		CMD_INIT	0x87
#define		CMD_RECALB	0x89
#define		CMD_SEEK	0x8A
#define		CMD_REFORMAT	0x8B
#define		CMD_FMT_SDATA	0x8C
#define		CMD_RESET	0x8F
#define		CMD_MAP_SECTOR	0x90	
#define		CMD_READ_NC	0x94	
#define		CMD_CLRFAULT	0x97
#define		CMD_VERIFY_TRK	0x99	
#define		CMD_TRACK_ID	0x9A	
#define		CMD_FETCHNEXT	0x9B
	u_char	iopb_coptions;		/* command code options */
#define		COP_UNIT_N	0x80	/*    unit number for command */
#define		COP_VOLUME_N	0x40	/*    volume number for command */
#define		COP_LINK_EN	0x20	/*    link enable */
#define		COP_LOG_TRAN	0x10	/*    logical translation */
#define		COP_RESERV_EN	0x08	/*    reserve enable (dual port) */
#define		COP_EDET_DI	0x04	/*    error detection disable */
#define		COP_INT_EN	0x02	/*    interrupt on completion */
#define		COP_ECC_EN	0x01	/*    apply ecc */
#define		COP_BITS 	\
"\20\10UNIT1\7VOL1\6LINK\5LOGT\4RESV\3EDD\2INT\1DOECC"
	u_char	iopb_status;		/* status code register */
#define		STA_NO_ERROR	0x80	/*    completed with no errors */
#define		STA_CNTR_BUSY	0x81	/*    command in progress */
#define		STA_COMP_ERR	0x82	/*    completed with error */
#define		STA_COMP_EX	0x83	/*    completed with exception */
	u_char	iopb_error_code;	/* error code register */
#define		ERR_DNR		0x10	/*    disk not ready */
#define		ERR_SEEK	0x12	/*    seek error, cant find sector */
#define		ERR_ECC		0x13	/*    ecc mismatch */
#define		ERR_INV_CMD	0x14	/*    invalid command code */
#define		ERR_ILL_FE	0x15	/*    illegal fetch and execute */
#define		ERR_INV_SEC	0x16	/*    invalid sector */
#define		ERR_ILL_MEM	0x17	/*    illegal memory type */
#define		ERR_BUS_TIMEOUT	0x18	/*    bus timeout */
#define		ERR_WRITE_PROT	0x1A	/*    disk is write protected */
#define		ERR_NOT_SEL	0x1B	/*    unit not selected */
#define		ERR_SEEK_TO	0x1C	/*    seek timeout */
#define		ERR_FAULT_TO	0x1D	/*    fault timeout */
#define		ERR_FAULTED	0x1E	/*    drive faulted */
#define		ERR_READY_TO	0x1F	/*    ready timeout */
#define		ERR_END_MEDIA	0x20
#define		ERR_TRANS_FAULT	0x21
#define		ERR_UNCORR	0x23
#define		ERR_TRANS_CYL	0x24
#define		ERR_TRANS_HEAD	0x25
#define		ERR_TRANS_SEC	0x26
#define		ERR_D_OVERRUN	0x27
#define		ERR_NO_INDEX	0x28
#define		ERR_SEC_NOT_FND	0x29
#define		ERR_ID_HEAD	0x2A
#define		ERR_INV_SYNC_D	0x2B
#define		ERR_SEEK_TO2	0x2D
#define		ERR_BUSY_TO	0x2E
#define		ERR_CYLINDER	0x2F
#define		ERR_RTZ_TIMEOUT	0x30
#define		ERR_INV_SNC_HDR	0x31
#define		ERR_NOT_INIT	0x40
#define		ERR_GAP		0x42
#define		ERR_SEEK2	0x4B
#define		ERR_MAPED_HDR	0x4C
#define		ERR_SEC_TRK	0x50
#define		ERR_BYTE_SEC	0x51
#define		ERR_INTERLEAVE	0x52
#define		ERR_INV_HEAD	0x53
#define		ERR_INV_BURST	0x5D
#define		ERR_IOPB_FAIL	0x60
#define		ERR_DMA_FAIL	0x61
#define		ERR_COR_BITS 	\
"\20\10ECC\7BADD\5RSEEK"
	union iopb_dsk_addr {		/* address on disk */
	    struct	{		/* logical block */
		u_short	logh;
		u_short	logl;
	    }		log;
	    struct physcal {
		u_short	cyl;		/*    physical cylinder */
		u_char	hd;		/*    physical head */
		u_char	sec;		/*    physical sector */
	    }		phys;
	}	iopb_dsk_addr;
#define	UIB_DSK_ADDR		0x0	/* address of uib on disk */
	u_short	iopb_blk_count;		/* block count */
	u_short	iopb_buf_addrh;		/* buffer address */
	u_short	iopb_buf_addrl;		/* buffer address */
	u_char	iopb_mem_type;		/* memory type */
#define	MEMT_8BIT		0x00	/*    8 bit memory */
#define	MEMT_16BITI		0x01	/*    16 bit internal memory */
#define	MEMT_16BIT		0x02	/*    16 bit memory */
#define	MEMT_32BIT		0x03	/*    32 bit memory */
	u_char	iopb_adr_mod;		/* address modifier code */
#define	ADRM_STD_S_P		0x3E	/*    Standard Supervisory Program */
#define	ADRM_STD_S_D		0x3D	/*    Standard Supervisory Data */
#define	ADRM_STD_N_P		0x3A	/*    Standard Normal Program */
#define	ADRM_STD_N_D		0x39	/*    Standard Normal Data */
#define	ADRM_SHT_S_IO		0x2D	/*    Short Supervisory IO */
#define	ADRM_SHT_N_IO		0x29	/*    Short Normal IO */
#define	ADRM_EXT_S_P		0x0E	/*    Extended Supervisory Program */
#define	ADRM_EXT_S_D		0x0D	/*    Extended Supervisory Data */
#define	ADRM_EXT_N_P		0x0A	/*    Extended Normal Program */
#define	ADRM_EXT_N_D		0x09	/*    Extended Normal Data */
	u_char	iopb_int_level;		/* interrupt level */
	u_char	iopb_n_vector;		/* normal interrupt vector */
	u_char	iopb_dma_burst;		/* DMA	burst count */
#define DMA_BURST	0		/*    sector at a time */
	u_char	iopb_e_vector;		/* error Interrupt vector */
	u_short	iopb_iopb_pntrh;	/* IOPB pointer */
	u_short	iopb_iopb_pntrl;	/* IOPB pointer */
	u_char	iopb_i_mem_type;	/* IOPB memory type */
	u_char	iopb_i_adr_mod;		/* IOPB address modifier code */
	u_char	iopb_skew_offset;	/* skew offset */
	u_char	iopb_reserved;		/* reserved */
#define	NUM_IOPBS		18
    }		sm_iopb[NUM_IOPBS];
    u_char	sm_filler[4];		/* pad */
};	

struct smuib {				/* Unit Initialization Block */
    struct vol_head {			/* volume extent information */
	u_char	start_head;		/* 	starting head for volume */
	u_char	num_heads;		/* 	number of heads for volume */
    }		uib_vol_head[2];
    u_char	uib_sec_trk;		/* sectors per track */
    u_char	uib_skew_factor;	/* spiral skewing factor */
    u_short	uib_bytes_sec;		/* bytes per sector */
    u_char	uib_gap1_words;		/* number of words in gap1 */
    u_char	uib_gap2_words;		/* number of words in gap2 */
    u_char	uib_sct_int;		/* sector interleace factor */
#define		UIB_INT_1TO1	1
    u_char	uib_retries;		/* number of retries on errors */
    u_short	uib_num_cyl;		/* number of cylinders */
    u_char	uib_attrib;		/* attributes */
#define		UIB_AT_SSE	0x40	/*    spare sector enable */
#define		UIB_AT_CE	0x20	/*    cache enable */
#define		UIB_AT_STC	0x10	/*    status chg interrupt enable */
#define		UIB_AT_DLP	0x08	/*    dual port */
#define		UIB_AT_INH	0x04	/*    increment by head */
#define		UIB_AT_MBD	0x02	/*    enable bad memory transfers */
#define		UIB_AT_RSK	0x01	/*    restore and reseek on err */
#define		UIB_AT_BITS 	\
"\20\7SPARES\6CACHE\5STI\4DPORT\3IHEAD\2EBADM\1RRSEEK"
    u_char	uib_ext;		/* extenede features */
#define		UIB_EXT_SMD_E	0x80	/*    SMD-E extended address enable */
#define		UIB_EXT_4DRV	0x40	/*    support 4 drives/controller */
#define		UIB_MAGIC	0xCE	/*    ISI KLUDGE for early formats! */
#define		UIB_EXT_BITS 	"\20\10SMD_E\7FOUR_DRIVE"
    u_char	uib_d0_level;		/* drive 0 status change int. level */
    u_char	uib_d0_vector;		/* drive 0 status change int. vector */
};
