/* 
 * 68020: Signetics 2681 sio driver
 */
/*#define PORT1PRINTF     	/**/

#include "../h/types.h"

#include "../machine/pte.h"
#include "../machine/psl.h"
#include "../machine/board.h"

#include "param.h"
#include "systm.h"
#include "conf.h"
#include "user.h"
#include "proc.h"
#include "ioctl.h"
#include "tty.h"
#include "file.h"
#include "uio.h"
#include "kernel.h"
#include "syslog.h"

#include "../is68kdev/sioreg.h"
#include "../is68kdev/pdma.h"

#ifdef	GWS
#include "../is68kdev/gpreg.h"
#endif	GWS
#ifdef	SYSV
#include "../sysv/sys/termio.h"
#endif	SYSV
#define	TTY_NODELAY

#define SIOCONSOLE	((struct s2681device *)S2681_ADDR)
#define SIOPORT1	((struct s2681device *)(S2681_ADDR+0x10))

/*
 * There is no driver information for auto-configuration.  It is assumed that
 * you always have two sio ports, and their major number is 0.
 */
int			sio_ispeed;
struct tty		sio_tty[NSIO];
int			nsio_tty = NSIO;
int			sio_overrun = 0;
struct pdma		sio_pdma[NSIO];
struct s2681device 	*sio_addr[NSIO] = { SIOCONSOLE, SIOPORT1};
u_char			s2681_imr = 0;

int	siostart(), sioxint(), ttrstrt();
#ifdef	SYSV
int	sv_sioproc();
#endif	SYSV

#define	IFLAGS	(EVENP|ODDP|ECHO|XTABS|CRMOD);

/*
 * baud rate conversion	:                           1  1  2  4  9  1  3
 *			          1  1  1  2  3  6  2  8  4  8  6  9  8
 *			    5  7  1  3  5  0  0  0  0  0  0  0  0  .  .
 *			 0  0  5  0  4  0  0  0  0  0  0  0  0  0  2  4 */
/* NOTE: ACR7 is set in the PROMS */
char sio_bconv[16]= {	 0, 0, 0, 1, 2, 3, 4, 4, 5, 6,10, 8, 9,11,12,15, };
/*char sio_bconv[16]= {	 0, 0, 0, 1, 2, 3, 3, 4, 5, 6, 6, 8, 9,11,11,12, };*/

#ifdef	BSR_KEY_BOARD
int iws_keyboard = 0;
#endif	BSR_KEY_BOARD

/* Sio initialization, called from startup(). */
sioinit()
{
	register int i;
	static int sio_init = 0;
	register struct tty *tp;
	
	if (sio_init++)
		return;
	switch (*BSR & BSR_BAUD) {
	    case BSR_BAUD_9600:
		sio_ispeed = B9600;
		break;
	    case BSR_BAUD_19200:
		sio_ispeed = EXTA;
		break;
	    case BSR_BAUD_1200:
		sio_ispeed = B1200;
		break;
	    case BSR_BAUD_300:
		sio_ispeed = B300;
		break;
	}
#ifdef	BSR_KEY_BOARD
	if (((*BSR)&BSR_KEY_BOARD) == BSR_KEY_IWS)
		iws_keyboard = 1;
#endif	BSR_KEY_BOARD

	/* set up pseudo dma structures */
	for (i = 0 ; i < NSIO ; i++) {
		sio_pdma[i].p_addr = (int)sio_addr[i];
		sio_pdma[i].p_arg = (int)&sio_tty[i];
		sio_pdma[i].p_fcn = sioxint;
	}

	/* bring the console part way up */
	tp = &sio_tty[0];
	tp->t_ospeed = tp->t_ispeed = sio_ispeed;
	tp->t_flags = IFLAGS;
	tp->t_addr = (caddr_t)&sio_pdma[0];
	s2681_imr |= 0x02;
	sioparam(0);
}

sioopen(dev, flag)
dev_t	dev;
{
	register int unit = minor(dev);
	register struct tty *tp = &sio_tty[unit];
	int s, old_discipline;

	if (unit >= NSIO)
		return (ENXIO);
#ifdef	GWS
	/* with graphics, dont open mouse! */
	if ((gptype & GPEXISTS) && unit == 1)
		return (EBUSY);
#endif	GWS
	tp->t_addr = (caddr_t)&sio_pdma[unit];
	tp->t_oproc = siostart;
#ifdef	SYSV
	tp->svt_proc = sv_sioproc;
#endif	SYSV
	if ((tp->t_state&TS_ISOPEN) == 0) {
		ttychars(tp);
		tp->t_ospeed = tp->t_ispeed = sio_ispeed;
		tp->t_flags = IFLAGS;
#ifdef	SYSV
		/*
		 * sv_ttinit initializes svt_line to zero.  This is a
		 * very bad thing to do on the graphics console because
		 * write will then go to the keyboard instead of the screen
		 * causing all sorts of havoc.
		 * The line discipline has been setup during GP_initialize().
		 * Go check for yourself if you don't believe me.
		 */
		old_discipline = tp->svt_line;
		sv_ttinit(tp);
		tp->svt_line = old_discipline;
#endif	SYSV
		sioparam(unit);
	} else if ((tp->t_state&TS_XCLUDE) && 
	    ((u.u_uid!=0) || (u.u_procp->p_flag & SLOGIN)))
		return (EBUSY);
	s = spltty();
	if (siomdm(unit, 1))
#ifdef	SYSV
		if (tp->t_universe == UNIVERSE_SYSV)
			(void)(*sv_linesw[tp->svt_line].l_mdmint)(tp, 1);
		else
#endif	SYSV
		(void)(*linesw[tp->t_line].l_modem)(tp, 1);

#ifdef TTY_NODELAY
	if ((flag & FNDELAY) == 0)
#endif
	while ((tp->t_state & TS_CARR_ON) == 0) {
		tp->t_state |= TS_WOPEN;
#ifdef	SYSV
		map_state(tp, TOSV);
#endif	SYSV
		sleep((caddr_t)&tp->t_rawq, TTIPRI);
		if ((tp->t_state&TS_XCLUDE) && (u.u_procp->p_flag&SLOGIN)) {
			splx(s);
			return (EBUSY);
		}
	}
	splx(s);
#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		return ((*sv_linesw[tp->svt_line].l_open)(dev, tp, flag));
	else
#endif	SYSV
		return ((*linesw[tp->t_line].l_open)(dev, tp));
}

sioclose(dev, flag)
dev_t	dev;
{
	register struct tty *tp = &sio_tty[minor(dev)];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		(*sv_linesw[tp->svt_line].l_close)(tp);
	else
#endif	SYSV
		(*linesw[tp->t_line].l_close)(tp);
/* TODO: should remove break */
	if (tp->t_state&(TS_HUPCLS|TS_WOPEN) || (tp->t_state&TS_ISOPEN)==0)
		siomdm(minor(dev), 0);
#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		sv_ttyclose(tp);
	else
#endif	SYSV
		ttyclose(tp);
}

sioread(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct tty *tp = &sio_tty[minor(dev)];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		return ((*sv_linesw[tp->svt_line].l_read)(tp, uio));
	else
#endif	SYSV
		return((*linesw[tp->t_line].l_read)(tp, uio));
}

siowrite(dev, uio)
dev_t		dev;
struct uio	*uio;
{
	register struct tty *tp = &sio_tty[minor(dev)];

#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV)
		return ((*sv_linesw[tp->svt_line].l_write)(tp, uio));
	else
#endif	SYSV
		return((*linesw[tp->t_line].l_write)(tp, uio));
}

sioioctl(dev, cmd, addr, flag)
dev_t	dev;
caddr_t	addr;
{
	register int error, unit;
	register struct tty *tp;

	tp = &sio_tty[(unit = minor(dev))];
#ifdef	SYSV
	if (u.u_procp->p_universe == UNIVERSE_SYSV) {
		if ((error = sv_ttiocom(tp, cmd, addr)) > 0)
			return error;
		if (cmd == TCSETAF || cmd == TCSETA || cmd == TCSETAW)
			sioparam(unit);
		if (cmd == TCSBRK)
			;		/* ??? */
		return 0;
	}
#endif	SYSV
	if ((error = (*linesw[tp->t_line].l_ioctl)(tp,cmd,addr,flag)) >= 0)
		return (error);
	if ((error = ttioctl(tp, cmd, addr, flag)) >= 0) {
		if (cmd == TIOCSETP || cmd == TIOCSETN ||
		    cmd == TIOCLSET || cmd == TIOCLBIS || cmd == TIOCLBIC)
			sioparam(unit);
		return (error);
	} 
	switch (cmd) {
	    case TIOCSDTR:
		siomdm(tp->t_addr, 1);
		break;

	    case TIOCCDTR:
		siomdm(tp->t_addr, 0);
		break;

/* TODO: support these
	    case TIOCSBRK:
	    case TIOCCBRK:
	    case TIOCMSET:
	    case TIOCMBIS:
	    case TIOCMBIC:
	    case TIOCMGET:
/**/

	    default:
		return (ENOTTY);
	}
	return (0);
}

sioparam(unit)
register int unit;
{
	register struct tty *tp = &sio_tty[unit];
	register struct s2681device *sioaddr = sio_addr[unit];
	u_char mr1, mr2, csr;
	int s;

	if ((tp->t_ispeed)==0) {
		siomdm(unit, 0);
		return;
	}
#ifdef	SYSV
	if (tp->t_universe == UNIVERSE_SYSV) {
		if ((tp->svt_cflag&SV_CSIZE) == SV_CS8)
			mr1 = MR1_8_BIT;
		else if ((tp->svt_cflag&SV_CSIZE) == SV_CS7)
			mr1 = MR1_7_BIT;
		else if ((tp->svt_cflag&SV_CSIZE) == SV_CS6)
			mr1 = MR1_6_BIT;
		else
			mr1 = MR1_5_BIT;
		if (tp->svt_cflag&SV_CSTOPB)
			mr2 = MR2_2_STOP;
		else
			mr2 = MR2_1_STOP;
		if (tp->svt_cflag&SV_PARENB) {
			mr1 |= MR1_PAR_WITH;
			if (tp->svt_cflag&SV_PARODD)
				mr1 |= MR1_PAR_ODD;
			else
				mr1 |= MR1_PAR_EVEN;
		}
		else
			mr1 = MR1_8_BIT|MR1_PAR_NONE;
	} else {
#endif	SYSV
		if (tp->t_ispeed == B134)
			mr1 = MR1_6_BIT|MR1_PAR_WITH;
		else if (tp->t_flags & (RAW|LITOUT|PASS8))
			mr1 = MR1_8_BIT|MR1_PAR_NONE;
		else
			mr1 = MR1_7_BIT|MR1_PAR_WITH;
		if ((tp->t_flags & EVENP) && (tp->t_flags & ODDP))
			mr1 = MR1_8_BIT|MR1_PAR_NONE;
		else if (tp->t_flags & EVENP)
			mr1 |= MR1_PAR_EVEN;
		else
			mr1 |= MR1_PAR_ODD;
		if ((tp->t_ospeed) == B110 || tp->t_state & TS_TWOSB)
			mr2 = MR2_2_STOP;
		else
			mr2 = MR2_1_STOP;
#ifdef	SYSV
	}
#endif	SYSV
#ifdef	BSR_KEY_BOARD
	/* force 600 baud 8 bit odd parity for IWS keyboard */
	if (unit == 0 && iws_keyboard) {
		mr1 = MR1_PAR_WITH | MR1_PAR_ODD | MR1_8_BIT;
		csr = (sio_bconv[B600] << 4) | sio_bconv[B600];
	} else
#endif	BSR_KEY_BOARD
	csr = (sio_bconv[tp->t_ispeed] << 4) | sio_bconv[tp->t_ospeed];

	s = spltty();
	/* if already enabled, wait for transimitter to go empty */
	if (s2681_imr & (0x02<<(unit*4)))
	    while ((sioaddr->s2681_r_sr&SR_TXEMT) == 0)
		;
	sioaddr->s2681_w_cr = CR_CMD_RST_MR|CR_DISABLE_TX|CR_DISABLE_RX;
	sioaddr->s2681_mr1 = mr1;
	sioaddr->s2681_mr2 = mr2;
	sioaddr->s2681_w_csr = csr;
	if (unit == 0)
		s2681_imr |= 0x02;
	else
		s2681_imr |= 0x20;
	SIOCONSOLE->s2681_w_imr = s2681_imr;
	sioaddr->s2681_w_cr = CR_CMD_RST_MR|CR_ENABLE_TX|CR_ENABLE_RX;
	splx(s);
}

#ifdef	SYSV
sv_sioproc(tp, cmd)
register struct tty *tp;
register cmd;
{
	sv_proc(tp, cmd, siostart, sioparam);
}
#endif	SYSV

siostart(tp)
register struct tty *tp;
{
	struct pdma *dp = (struct pdma *)tp->t_addr;
	register struct s2681device *sioaddr = (struct s2681device *)dp->p_addr;
	register int c;
	int s;
 
	s = spltty();
	if (tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP))
		goto out;
	if (tp->t_outq.c_cc <= TTLOWAT(tp)) {
		if (tp->t_state&TS_ASLEEP) {
			tp->t_state &= ~TS_ASLEEP;
#ifdef	SYSV
			map_state(tp, TOSV);
#endif	SYSV
			wakeup((caddr_t)&tp->t_outq);
		}
		if (tp->t_wsel) {
			selwakeup(tp->t_wsel, tp->t_state & TS_WCOLL);
			tp->t_wsel = 0;
			tp->t_state &= ~TS_WCOLL;
		}
	}
	if (tp->t_outq.c_cc == 0)
		goto out;
	tp->t_state |= TS_BUSY;
#ifdef	SYSV
	map_state(tp, TOSV);
#endif	SYSV
	c = getc(&tp->t_outq);
	sioaddr->s2681_w_thr = c;
	if (sioaddr == SIOCONSOLE)
		s2681_imr |= 0x01;
	else
		s2681_imr |= 0x10;
	SIOCONSOLE->s2681_w_imr = s2681_imr;
out:	splx(s);
}

siostop(tp, flag)
	register struct tty *tp;
{
	register int s;

	s = spltty();
	if (tp->t_state & TS_BUSY) {
		if ((tp->t_state&TS_TTSTOP)==0) {
			tp->t_state |= TS_FLUSH;
#ifdef	SYSV
			map_state(tp, TOSV);
#endif	SYSV
		}
	}
	splx(s);
}

sioint()
{
	register u_char isr = SIOCONSOLE->s2681_r_isr & s2681_imr;

	if (isr & 0x20)
		siorint(1);
	if (isr & 0x10)
		siotint(1);
	if (isr & 0x02)
		siorint(0);
	if (isr & 0x01)
		siotint(0);
}

siorint(unit)
{
	register struct tty *tp = &sio_tty[unit];
	register struct s2681device *sioaddr = sio_addr[unit];
	register u_int c, sr;

	while (1) {
		sr = sioaddr->s2681_r_sr;
		if ((sr&SR_RXRDY) == 0)
			return;
		c = sioaddr->s2681_r_rhr;
#ifdef	BSR_KEY_BOARD
		if (unit == 0 && ((sr & SR_ERROR) == 0) && iws_keyboard &&
		    ((c = iws_keyboard_map(c)) == 0))
			return;
#endif	BSR_KEY_BOARD
		if (unit == 0 && debug_input(c))
			continue;
		if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0
#ifdef	GWS
			&& (tp->t_line != KYBDDISC)
#endif	GWS
								)
			return;
		if (sr & SR_ERROR) {
			sioaddr->s2681_w_cr = 
				CR_CMD_RST_ERR|CR_ENABLE_TX|CR_ENABLE_RX;
			if (sr & SR_OVERRUN_ERR && sio_overrun++ == 0)
				log(LOG_WARNING, "sio%d: line overflow\n", unit);
#ifdef	SYSV
			if (tp->t_universe == UNIVERSE_SYSV) {
			    if (sr & SR_PARITY_ERR) {
				if (tp->svt_iflag & SV_IGNPAR)
					continue;
				if (tp->svt_iflag & SV_PARMRK)
					;		/* ??? */
			    }
			    if (sr & (SR_FRAME_ERR | SR_RCVED_BRK)) {
				if (tp->svt_iflag & SV_IGNBRK)
				    continue;
				if (tp->svt_iflag & SV_BRKINT)
				    (*sv_linesw[tp->svt_line].l_input)
						(c, tp, L_BREAK);
				c = 0;
			    }
			    if (tp->svt_iflag & SV_ISTRIP)
				c &= 0177;
			    else
				c &= 0377;
			} else {
#endif	SYSV
			    if (sr & SR_PARITY_ERR)
				if ((tp->t_flags&(EVENP|ODDP))==EVENP || 
				    (tp->t_flags&(EVENP|ODDP))==ODDP )
					    continue;
			    if (sr & (SR_FRAME_ERR | SR_RCVED_BRK))
				if (tp->t_flags&RAW)
				    c = 0;
				else
				    c = tp->t_intrc;
#ifdef	SYSV
			}
#endif	SYSV
		}
#ifdef	SYSV
		if (tp->t_universe == UNIVERSE_SYSV)
			(*sv_linesw[tp->svt_line].l_input)(c, tp, 0);
		else {
#endif	SYSV

#if NBK > 0 || Nbk > 0
			if (tp->t_line == NETLDISC) {
				c &= 0177;
				BKINPUT(c, tp);
			} else
#endif
				(*linesw[tp->t_line].l_rint)(c, tp);
#ifdef	SYSV
		}
#endif	SYSV
	}
}

siotint(unit)
{
	register struct tty *tp = &sio_tty[unit];
	register struct s2681device *sioaddr = sio_addr[unit];

	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	tp->t_state &= ~TS_BUSY;
#ifdef	SYSV
	map_state(tp, TOSV);
#endif	SYSV
	if (tp->t_state & TS_FLUSH)
		tp->t_state &= ~TS_FLUSH;
	if (unit == 0)
		s2681_imr &= ~0x01;
	else
		s2681_imr &= ~0x10;
	SIOCONSOLE->s2681_w_imr = s2681_imr;
#ifdef	SYSV
	map_state(tp, TOSV);
	if (tp->t_universe == UNIVERSE_SYSV) {
		if ((*sv_linesw[tp->svt_line].l_output)(tp))
			siostart(tp);
	}
	else {
#endif	SYSV
		if (tp->t_line)
			(*linesw[tp->t_line].l_start)(tp);
		else
			siostart(tp);
#ifdef	SYSV
	}
#endif	SYSV
}

sioxint(tp)
register struct tty *tp;
{
	register struct pdma *dp = (struct pdma *)tp->t_addr;

	if ((tp->t_state & (TS_ISOPEN|TS_WOPEN)) == 0)
		return;
	tp->t_state &= ~TS_BUSY;
	if (tp->t_state & TS_FLUSH)
		tp->t_state &= ~TS_FLUSH;
	else {
		ndflush(&tp->t_outq, dp->p_mem-tp->t_outq.c_cf);
		dp->p_end = dp->p_mem = tp->t_outq.c_cf;
	}
	if (tp->t_line)
		(*linesw[tp->t_line].l_start)(tp);
	else
		siostart(tp);
}

siomdm(unit, onoff)
{
	return (1);
}

sioputchar(c)
register c;
{
	while ((SIOCONSOLE->s2681_r_sr & SR_TXRDY) == 0)
		;
	SIOCONSOLE->s2681_w_thr = c;
	if (c == '\n') {
		while ((SIOCONSOLE->s2681_r_sr & SR_TXRDY) == 0)
			;
		SIOCONSOLE->s2681_w_thr = '\r';
	}
#ifdef	PORT1PRINTF
	while ((SIOPORT1->s2681_r_sr & SR_TXRDY) == 0)
		;
	SIOPORT1->s2681_w_thr = c;
	if (c == '\n')
		DELAY(1000000);
	DELAY(10000);
#endif	PORT1PRINTF
}

siogetchar()
{
	int c = -1;

	if (SIOCONSOLE->s2681_r_sr & SR_RXRDY) {
		c = SIOCONSOLE->s2681_r_rhr;
#ifdef	BSR_KEY_BOARD
		if (iws_keyboard && ((c = iws_keyboard_map(c)) == 0))
			c = -1;
		else
#endif	BSR_KEY_BOARD
		c &= 0177;
	}
	return c;
}

#ifdef	BSR_KEY_BOARD
/* IWS keyboard mapping from standalone code.  */

#define     BADCODE     0x00	/* ignore this character */
#define	    LSHIFTDN	0x68	/* left shift down */
#define	    LSHIFTUP	0xe8	/* left shift up */
#define	    RSHIFTDN	0x37	/* right shift down */
#define	    RSHIFTUP	0xb7	/* right shift up */
#define	    MSHIFTDN	0x76	/* mouse shift down */
#define	    MSHIFTUP	0xf6	/* mouse shift up */
#define	    LCTRLDN     0x2b	/* left control down */
#define	    LCTRLUP	0xab	/* left control up */
#define	    RCTRLDN	0x45	/* right control down */
#define	    RCTRLUP	0xc5	/* right control up */
#define	    MCTRLDN	0x77	/* mouse control down */
#define	    MCTRLUP	0xf7	/* mouse control up */
#define	    SQUEAKDN	0x75	/* squeak button down */
#define	    SQUEAKUP	0xf5	/* squeak button up */

static char table [] = { /* input translation table */
    BADCODE,			/* 00, No key, null map */
    BADCODE,			/* 01, Select Key */
    BADCODE,			/* 02, Numeric pad '.' key */
    BADCODE,			/* 03, Mark key */
    BADCODE,			/* 04, Center arrow key, null map */
    ' ',			/* 05, Space bar */
    '0',			/* 06, '0' key */
    'p',			/* 07, 'p' key */
    '//',			/* 08, '/' key */
    BADCODE,			/* 09, Soft function key 6 */
    ';',			/* 0a, ';' key */
    BADCODE,			/* 0b, Numeric pad '/' key */
    BADCODE,			/* 0c, Numeric pad '*' key */
    BADCODE,			/* 0d, Calc key */
    BADCODE,			/* 0e, Numeric pad 2nd key */
    BADCODE,			/* 0f, Numeric pad '7' key */
    BADCODE,			/* 10, Numeric pad '0' key */
    BADCODE,			/* 11, Numeric pad '4' key */
    BADCODE,			/* 12, Numeric pad '1' key */
    BADCODE,			/* 13, Numeric pad '3' key */
    BADCODE,			/* 14, Numeric pad '2' key */
    0x7f,			/* 15, Backspace key */
    BADCODE,			/* 16, Enter key */
    BADCODE,			/* 17, Up arrow key */
    BADCODE,			/* 18, Right arrow key */
    BADCODE,			/* 19, Down arrow key */
    BADCODE,			/* 1a, Numeric pad '6' key */
    BADCODE,			/* 1b, Numeric pad '5' key */
    BADCODE,			/* 1c, Prev key */
    BADCODE,			/* 1d, Numeric pad '+' key */
    BADCODE,			/* 1e, Delete key */
    BADCODE,			/* 1f, Goto key */
    BADCODE,			/* 20, Open key */
    BADCODE,			/* 21, Insert key */
    BADCODE,			/* 22, Numeric pad '9' key */
    BADCODE,			/* 23, Numeric pad '8' key */
    BADCODE,			/* 24, Next key */
    BADCODE,			/* 25, Numeric pad '-' key */
    BADCODE,			/* 26, Undo key */
    BADCODE,			/* 27, Run key */
    BADCODE,			/* 28, Close key */
    BADCODE,			/* 29, View key */
    's',			/* 2a, 's' key */
    BADCODE,			/* 2b, left control key */
    '4',			/* 2c, '4' key */
    'x',			/* 2d, 'x' key */
    'r',			/* 2e, 'r' key */
    'v',			/* 2f, 'v' key */
    BADCODE,			/* 30, Left arrow key */
    'f',			/* 31, 'f' key */
    'z',			/* 32, 'z' key */
    '`',			/* 33, '`' key right */
    '=',			/* 34, '=' key */
    'a',			/* 35, 'a' key */
    ']',			/* 36, ']' key */
    BADCODE,			/* 37, Shift right key */
    BADCODE,			/* 38, Soft function key 8 */
    '\n',			/* 39, Return key */
    '2',			/* 3a, '2' key */
    '1',			/* 3b, '1' key */
    BADCODE,		    	/* 3c, Soft function key 2 */
    'w',			/* 3d, 'w' key */
    '3',			/* 3e, '3' key */
    'q',			/* 3f, 'q' key */
    'e',			/* 40, 'e' key */
    'c',			/* 41, 'c' key */
    BADCODE,			/* 42, Soft function key 3 */
    'd',			/* 43, 'd' key */
    BADCODE,			/* 44, Soft function key 1 */
    BADCODE,			/* 45, Ctrl key right */
    '-',			/* 46, '-' key */
    '\t',			/* 47, Tab key */
    '[',			/* 48, '[' key */
    BADCODE,			/* 49, Soft function key 7 */
    '\'',			/* 4a, ''' key */
    BADCODE,			/* 4b, Again key */
    BADCODE,			/* 4c, Stop key */
    '6',			/* 4d, '6' key */
    0x1b,			/* 4e, Escape key */
    'y',			/* 4f, 'y' key */
    'n',			/* 50, 'n' key */
    'h',			/* 51, 'h' key */
    BADCODE,			/* 52, Find key */
    BADCODE,			/* 53, Aide key */
    '9',			/* 54, '9' key */
    BADCODE,			/* 55, Window key */ 
    'o',			/* 56, 'o' key */
    '.',			/* 57, '.' key */
    'l',			/* 58, 'l' key */
    BADCODE,			/* 59, Copy key */
    BADCODE,			/* 5a, Keys key */
    '7',			/* 5b, '7' key */
    BADCODE,			/* 5c, Device key */
    'u',			/* 5d, 'u' key */
    'm',			/* 5e, 'm' key */
    BADCODE,			/* 5f, Help key */
    'j',			/* 60, 'j' key */
    BADCODE,			/* 61, Move key */
    BADCODE,			/* 62, Script key */
    '8',			/* 63, '8' key */
    'i',			/* 64, 'i' key */
    ',',			/* 65, ',' key */
    BADCODE,			/* 66, Soft function key 5 */
    'k',			/* 67, 'k' key */
    BADCODE,			/* 68, Shift left key */
    '\\',		        /* 69, '\' key left */
    '5',			/* 6a, '5' key */
    BADCODE,			/* 6b, Caps lock key */
    't',			/* 6c, 't' key */
    'b',			/* 6d, 'b' key */
    BADCODE,    		/* 6e, Soft function key 4 */
    'g',			/* 6f, 'g' key */
    BADCODE,			/* 70, Mouse button down */
    BADCODE,			/* 71, Mouse shift down, no map */
    BADCODE,			/* 72, Mouse ctrl down, no map */
    BADCODE,			/* 73, No mapping for now */
    BADCODE,			/* 74, No mapping for now */
    BADCODE,			/* 75, No mapping for now */
    BADCODE,			/* 76, No mapping for now */
    BADCODE,			/* 77, No mapping for now */
    BADCODE,			/* 78, No mapping for now */
    BADCODE,			/* 79, No mapping for now */
    BADCODE,			/* 7a, No mapping for now */
    BADCODE,			/* 7b, No mapping for now */
    BADCODE,			/* 7c, No mapping for now */
    BADCODE,			/* 7d, No mapping for now */
    BADCODE,			/* 7e, No mapping for now */
    BADCODE,			/* 7f, No mapping for now */
    BADCODE,	/* Begin shift plane - 00, No key, null map */
    BADCODE,			/* 01, Select Key */
    BADCODE,			/* 02, Numeric pad '.' key */
    BADCODE,			/* 03, Mark key */
    BADCODE,			/* 04, Center arrow key, null map */
    ' ',			/* 05, Space bar */
    ')',			/* 06, ')' key */
    'P',			/* 07, 'p' key */
    '?',			/* 08, '/' key */
    BADCODE,			/* 09, Soft function key 6 */
    ':',			/* 0a, ';' key */
    BADCODE,			/* 0b, Numeric pad '/' key */
    BADCODE,			/* 0c, Numeric pad '*' key */
    BADCODE,			/* 0d, Calc key */
    BADCODE,			/* 0e, Numeric pad 2nd key */
    BADCODE,			/* 0f, Numeric pad '7' key */
    BADCODE,			/* 10, Numeric pad '0' key */
    BADCODE,			/* 11, Numeric pad '4' key */
    BADCODE,			/* 12, Numeric pad '1' key */
    BADCODE,			/* 13, Numeric pad '3' key */
    BADCODE,			/* 14, Numeric pad '2' key */
    0x7f,			/* 15, Backspace key */
    BADCODE,			/* 16, Enter key */
    BADCODE,			/* 17, Up arrow key */
    BADCODE,			/* 18, Right arrow key */
    BADCODE,			/* 19, Down arrow key */
    BADCODE,			/* 1a, Numeric pad '6' key */
    BADCODE,			/* 1b, Numeric pad '5' key */
    BADCODE,			/* 1c, Prev key */
    BADCODE,			/* 1d, Numeric pad '+' key */
    BADCODE,			/* 1e, Delete key */
    BADCODE,			/* 1f, Goto key */
    BADCODE,			/* 20, Open key */
    BADCODE,			/* 21, Insert key */
    BADCODE,			/* 22, Numeric pad '9' key */
    BADCODE,			/* 23, Numeric pad '8' key */
    BADCODE,			/* 24, Next key */
    BADCODE,			/* 25, Numeric pad '-' key */
    BADCODE,			/* 26, Undo key */
    BADCODE,			/* 27, Run key */
    BADCODE,			/* 28, Close key */
    BADCODE,			/* 29, View key */
    'S',			/* 2a, 's' key */
    BADCODE,			/* 2b, left control key */
    '$',			/* 2c, '4' key */
    'X',			/* 2d, 'x' key */
    'R',			/* 2e, 'r' key */
    'V',			/* 2f, 'v' key */
    BADCODE,			/* 30, Left arrow key */
    'F',			/* 31, 'f' key */
    'Z',			/* 32, 'z' key */
    '~',			/* 33, '~' key right */
    '+',			/* 34, '=' key */
    'A',			/* 35, 'a' key */
    '}',			/* 36, ']' key */
    BADCODE,			/* 37, Shift right key */
    BADCODE,			/* 38, Soft function key 8 */
    '\n',			/* 39, Return key */
    '@',			/* 3a, '2' key */
    '!',			/* 3b, '1' key */
    BADCODE,		    	/* 3c, Soft function key 2 */
    'W',			/* 3d, 'w' key */
    '#',			/* 3e, '3' key */
    'Q',			/* 3f, 'q' key */
    'E',			/* 40, 'e' key */
    'C',			/* 41, 'c' key */
    BADCODE,			/* 42, Soft function key 3 */
    'D',			/* 43, 'd' key */
    BADCODE,			/* 44, Soft function key 1 */
    BADCODE,			/* 45, Ctrl key right */
    '_',			/* 46, '-' key */
    '\t',			/* 47, Tab key */
    '{',			/* 48, '[' key */
    BADCODE,			/* 49, Soft function key 7 */
    '"',			/* 4a, ''' key */
    BADCODE,			/* 4b, Again key */
    0x03,			/* 4c, Stop key */
    '^',			/* 4d, '6' key */
    0x1b,			/* 4e, Escape key */
    'Y',			/* 4f, 'y' key */
    'N',			/* 50, 'n' key */
    'H',			/* 51, 'h' key */
    BADCODE,			/* 52, Find key */
    BADCODE,			/* 53, Aide key */
    '(',			/* 54, '9' key */
    BADCODE,			/* 55, Window key */ 
    'O',			/* 56, 'o' key */
    '>',			/* 57, '.' key */
    'L',			/* 58, 'l' key */
    BADCODE,			/* 59, Copy key */
    BADCODE,			/* 5a, Keys key */
    '&',			/* 5b, '7' key */
    BADCODE,			/* 5c, Device key */
    'U',			/* 5d, 'u' key */
    'M',			/* 5e, 'm' key */
    BADCODE,			/* 5f, Help key */
    'J',			/* 60, 'j' key */
    BADCODE,			/* 61, Move key */
    BADCODE,			/* 62, Script key */
    '*',			/* 63, '8' key */
    'I',			/* 64, 'i' key */
    '<',			/* 65, ',' key */
    BADCODE,			/* 66, Soft function key 5 */
    'K',			/* 67, 'k' key */
    BADCODE,			/* 68, Shift left key */
    '|',	       		/* 69, '`' key left */
    '%',			/* 6a, '5' key */
    BADCODE,			/* 6b, Caps lock key */
    'T',			/* 6c, 't' key */
    'B',			/* 6d, 'b' key */
    BADCODE,			/* 6e, Soft function key 4 */
    'G',			/* 6f, 'g' key */
    BADCODE,			/* 70, Mouse button down */
    BADCODE,			/* 71, Mouse shift down, no map */
    BADCODE,			/* 72, Mouse ctrl down, no map */
    BADCODE,			/* 73, No mapping for now */
    BADCODE,			/* 74, No mapping for now */
    BADCODE,			/* 75, No mapping for now */
    BADCODE,			/* 76, No mapping for now */
    BADCODE,			/* 77, No mapping for now */
    BADCODE,			/* 78, No mapping for now */
    BADCODE,			/* 79, No mapping for now */
    BADCODE,			/* 7a, No mapping for now */
    BADCODE,			/* 7b, No mapping for now */
    BADCODE,			/* 7c, No mapping for now */
    BADCODE,			/* 7d, No mapping for now */
    BADCODE,			/* 7e, No mapping for now */
    BADCODE,			/* 7f, No mapping for now */
};

/* translate keyboard code to ascii. */
iws_keyboard_map(c)
{
	static char shift = 0;		/* shift state */
	static char ctrl = 0;		/* ctrl state */
	int retchar = 0;		/* ascii char to return */

	if (c == 0xfc) {
		log(LOG_WARNING, "IWS keyboard parity error\n");
		return retchar;
	}

	switch(c) {			/* switch to correct action */
	    case LSHIFTDN:		/* left  shift key pressed */
	    case RSHIFTDN:		/* right shift key pressed */
		shift++;		/* increment shift count */
		break;

	    case LSHIFTUP:		/* left  shift key released */
	    case RSHIFTUP:		/* right shift key released */
		shift--;		/* decrement shift count */
		break;

	    case LCTRLDN:		/* left  control key pressed */
	    case RCTRLDN:		/* right control key pressed */
		ctrl++;			/* increment ctrl count */
		break;

	    case LCTRLUP:		/* left  control key released */
	    case RCTRLUP:		/* right control key released */
		ctrl--;			/* decrement ctrl count */
		break;

	    case MCTRLDN:		/* mouse control key pressed */
	    case MCTRLUP:		/* mouse control key released */
	    case SQUEAKUP:		/* mouse button gone up       */
	    case SQUEAKDN:		/* mouse button gone down     */
		break;			/* ignore */

	    default:
		if (c & 0x80)		/* throw away upstrokes */
			break;
		if (shift)		/* look in shift table if set */
			c += 128;
		retchar = table[c];
		if (ctrl)		/* convert to control character */
			retchar &= 0x1f;
		break;
	}
	return(retchar);	
}
#endif	BSR_KEY_BOARD
