/*
** PARALLAX RAMPAGE device parameters
**
** Copyright Fluency International Software  4/24/84
*/

/* Rampage Device Register Structure */
struct rpdevice
{
	short csr;	/* control/status register */
	short cdr;	/* command/data register */
} ;

/* Control/Status Register */

# define CS_ER 		0x8000		/* General purpose error bit */
# define CS_RST		0x8000		/* Reset bit */
# define CS_USR		0x4000		/* User/Kernal mode bit */
# define CS_ERC		0x3F00		/* Error code mask */
# define CS_RDY		0x0080		/* Ready for PIO data bit */
# define CS_IE		0x0040		/* Interrupt Enable bit */
# define CS_WAC		0x0004		/* Waiting for bus addr/word cnt bit */
# define CS_WC		0x0002		/* Waiting for command bit */
# define CS_DAV		0x0001		/* Command Available bit */

/* Error Codes */

# define ERR_MEM	0x0000		/* Non-existent memory */
# define ERR_INST	0x0100		/* Illegal instruction */
# define ERR_POLY	0x0200		/* Polygon vertex overflow */
# define ERR_FILL	0x0300		/* Fill stack overflow */

/* Rampage Buffer Data Definitions */

/*# define RPGBUFSIZ	0x050		/* Rampage DMA buffer size */
# define RPGBUFSIZ	0x0400		/* Rampage DMA buffer size */
# define RPGPRI		PZERO + 8	/* Rampage Write Priority */

/* Boolean States */

# define TRUE		0x01		
# define FALSE		0x00	

/* Rampage Buffer States */

# define RPGINIT	0x00		/* Rampage Init - trap interrupt */
# define RPGBLO		0x01		/* wait for low word of DMA bufr addr */
# define RPGBHI		0x02		/* wait for hi word of DMA bufr addr */
# define RPGWCNT	0x03		/* wait for DMA bufr word count */
# define RPGDONE	0x04		/* Rampage done sending DMA params */
# define RPGRDY		0x05		/* Rampage ready for next DMA command */

/* Rampage Buffer Transmission Direction */

# define RCV		0x00		/* recieving data from Rampage */
# define XMT		0x01		/* recieving data from Rampage */

/* Command Codes */

# define RESET		0x002D
# define JUMPB		0x0329
# define NOOP		0x0000

/* Rampage Ioctl Requests */

# define FLUSHBUF	0x00		/* flush rampage command buffer */
# define AUTOFLUSH_ON	0x01		/* flush buffer after every write */
# define AUTOFLUSH_OFF	0x02		/* don't flush after every write */

/* misc */

#define LOWORD 0x0000FFFF	/* mask for low word of int */
#define WORDBITS  0x10		/* number of bits in a word */
#define RPGUMSK 0x0		/* Rampage unit mask,allows for 1 device */
