/*
 * QBUS|VMEBUS: Diskless node swap pseudo device protocol driver
 */
#include "rd.h"
#if	NRD > 0

#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/dk.h"
#include "../h/dkbad.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/map.h"
#include "../h/vm.h"
#include "../h/cmap.h"
#include "../h/uio.h"
#include "../h/kernel.h"

#include "../wipc/wipc.h"

int	rdswapsize;	/* size in blocks of diskless/cluster swap file */

#define	SWAPRPID(mid)	(((unsigned long)mid << 16) + SERVER_PID)

rdopen(dev)
	dev_t dev;
{
	return 0;
}

rdstrategy(bp)
	register struct buf *bp;
{
	int err;
	int rpid, rw, blkno, bcount, addr;
	int retry = 5;

	rpid = SWAPRPID(minor(bp->b_dev));
	rw = bp->b_flags & B_READ;
	blkno = bp->b_blkno & 0xFFFFFF; 
	bcount = bp->b_bcount;
	addr = qbaddr(bp);

again:	if (err = SdSwap(rpid, rw, blkno, bcount, addr)) {
/*		printf("TRFS: swap error 0x%x,%d,0x%x,0x%x,0x%x %d... ", 
			rpid, rw, blkno, bcount, addr, err); /**/
		if (--retry) {
/*			printf("retrying\n"); /**/
			goto again;
		} else {
/*			printf("\nTRFS: fatal swap error\n"); /**/
			bp->b_flags |= B_ERROR;
		}
	}
	iodone(bp);
}

rdsize(dev)
	dev_t dev;
{
	return rdswapsize;
}

rdread()
{
	printf("rd: read\n");
}

rdwrite()
{
	printf("rd: write\n");
}

rdreset()
{
	printf("rd: reset\n");
}

rddump()
{
	return(ENODEV);
}
#endif	NRD > 0
