/*
 * QBUS|VMEBUS: bus mapping and bad block revectoring routines
 */
/*#define BAD144DEBUG	/* */

#include "../machine/pte.h"

#include "param.h"
#include "systm.h"
#include "buf.h"
#include "conf.h"
#include "user.h"
#include "map.h"
#include "vm.h"
#include "dk.h"
#include "cmap.h"
#include "dkbad.h"
#include "uio.h"
#include "kernel.h"
#include "proc.h"

#include "../is68kdev/qbvar.h"
#include "../machine/board.h"
#define		splqb	splhigh

struct buf dumpbuf;
struct buf badbuf;

/* return the pte used to map the given buffer */
struct pte *
bptopte(bp)
	register struct buf *bp;
{
	register unsigned v;
	register struct pte *pte;
	register struct proc *rp;

	v = btop(((int)bp->b_un.b_addr) & NONT_MASK);
	rp = (bp->b_flags&B_DIRTY) ? &proc[2] : bp->b_proc;
	if ((bp->b_flags & B_PHYS) == 0)
		pte = &Sysmap[v];
	else if (bp->b_flags & B_UAREA)
		pte = &rp->p_addr[v];
	else if (bp->b_flags & B_PAGET)
		pte = &Usrptmap[btokmx((struct pte *)bp->b_un.b_addr)];
	else
		pte = vtopte(rp, v);
	return pte;
}

/*
 * Allocate and program needed VDMA mapping resources and return the 
 * bus physical address for the dma associated with a kernel buffer.
 */
qbaddr(bp)
	register struct buf *bp;
{
	register int count = bp->b_bcount;
	register int pa;

	bp->b_flags |= B_VDMA;
	pa = qbmapin(bptopte(bp), bp->b_vdma = qballoc(bp->b_un.b_addr, count),
		bp->b_un.b_addr, count);
#ifdef	QBUS
	if ((bdevsw[major(bp->b_dev)].d_flags&B_18BIT) && 
		((pa+count) > 0x40000) )
			panic("buffer not addressable");
#endif	QBUS
	return pa;
}

/* Release VDMA mapping resources held by a given buffer */
qbdone(bp)
	register struct buf *bp;
{
	if (bp->b_flags & B_VDMA) {
		bp->b_flags &= ~B_VDMA;
		qbrelease(&bp->b_vdma);
	}
}

/*
 * Return the number of physicaly contiguous bytes associated with a buffer.
 * On machines which support VDMA everything is allways physically contifuous.
 */
qbaddrcontig(bp)
	register struct buf *bp;
{
#ifdef	M68025
	return bp->b_bcount;
#else	M68025
	register struct pte *pte;
	register int count = bp->b_bcount, ccount= 0, i = 0, pf, o;
	int npg;

	if ((bp->b_flags & B_PHYS) == 0)
		return count;
	pte = bptopte(bp);
	pf = pte->pg_pfnum;
	o = (int)bp->b_un.b_addr & PGOFSET;
	npg = btoc(count + o);
	while (npg > 0) {
		if (pte->pg_pfnum != pf+i)
			break;
		i++;
		pte++;
		npg--;
	}
	ccount = MIN(ctob(i) - o, count);
	return (ccount);
#endif	M68025
}

qbinit()
{
#ifdef	M68025
	register int *map = (int *)VDMA_BASE;
	register int i;

	/* invalidate VDMA map */
	for (i = 0 ; i < NVDMAS; i++)
		*map++ = ~VDMA_VALID;

	/* initialize resource map for lower 8 Meg of VDMA map */
	rminit(qbmap, btop(0x800000) - 1, 1, "qb", btop(0x800000));
#endif	M68025
}

/* 
 * Allocate VDMA mapping resources, returning mapping resource:
 *	Bits 24-31	Number of mapping registers.
 *	Bits 13-23	Start map register number
 */
qballoc(v, count)
{
#ifdef	M68025
	register int s, npg, reg;

	npg = btoc(count + (v & PGOFSET)) + 1;
	s = splqb();
	while ((reg = rmalloc(qbmap, npg)) == 0) {
		mapwant(qbmap)++;
		(void) sleep((caddr_t)qbmap, PZERO-1);
	}
	splx(s);
	reg--;
	return ((npg << (PGSHIFT+VDMA_SHIFT)) | (reg << PGSHIFT));
#endif	M68025
}

/* Release mapping resources */
qbrelease(amr)
	int *amr;
{
#ifdef	M68025
	register int mr, s;
	register int reg, npg;
	register int *map;
 
	s = splqb();
	if (mr = *amr) {
		*amr = 0;
		reg = (mr >> PGSHIFT) & (NVDMAS-1);
		npg = (mr >> (PGSHIFT+VDMA_SHIFT));
		map = (int *)(VDMA_BASE + (reg * VDMA_INCR));
		rmfree(qbmap, npg, reg+1);
		while (--npg)
			*map++ = ~VDMA_VALID;
	}
	splx(s);
#endif	M68025
}

/* Program VDMA mapping resource to virtual address range, return io address. */
qbmapin(pte, vdma, v, count)
	register struct pte	*pte;
{
	register int pf0, pf;
#ifdef	M68025
	register int npg;
	register int *map;

	pf = pf0 = (vdma >> PGSHIFT) & (NVDMAS-1);
	npg = (vdma >> (PGSHIFT+VDMA_SHIFT));
	map = (int *)(VDMA_BASE + (pf0 * VDMA_INCR));
	while (--npg) {
		if (pte->pg_pfnum >= physmem)
			panic("dma past EOM");
		*map++ = pte->pg_pfnum | VDMA_VALID;
		pte++;
	}
	*map = ~VDMA_VALID;
#else	M68025
	pf = pf0 = pte->pg_pfnum;
	while (count > 0) {
		if (pte->pg_pfnum >= physmem)
			panic("dma past EOM");
		else if (pte->pg_pfnum != pf)
			panic("non-contuguous DMA!");
		pf++;
		pte++;
		count -= NBPG;
	}
#endif	M68025
	return ((pf0 << PGSHIFT) | (v & PGOFSET));
}

/* Allocate and program VDMA resources for system virtual address */
svqballoc(v, count)
{
	return qbmapin(&Sysmap[btop(v&NONT_MASK)], qballoc(v, count), v, count);
}

badstrat(qi, bp, bad, strat, nspt, ntpc, ncpd, coff)
	register struct buf *bp;
	register struct qb_device *qi;
	register struct dkbad *bad;
	int (*strat)();
{
	int s, hadbad = 0, len = bp->b_bcount, error;
	daddr_t blkno;
	register int i, hi, lo;
	register int sbn = bp->b_blkno + (coff*nspt*ntpc);
	register int lbn = sbn + ((len+(DEV_BSIZE-1)) >> DEV_BSHIFT) - 1;
	register int bbn, nbs;
	register struct buf *bbp = &badbuf;
#define SAVE_BFLAGS	(B_WRITE|B_READ|B_BUSY|B_PHYS|B_AGE|B_DELWRI| \
			B_TAPE|B_UAREA|B_PAGET|B_DIRTY|B_PGIN|B_CACHE| \
			B_INVAL|B_LOCKED|B_HEAD|B_BAD|B_QUALIFY)

	/*
	 * if the bad sector map has not yet been read in then read it in
	 * and convert from DEC-144 (cyl/trk/sec) to block number.
	 */
  retry:if (bad->bt_csn == 0) {
	    if (bp != &dumpbuf) {
	    	s = splbio();
	    	if (bbp->b_flags & B_BUSY) {
		    bbp->b_flags |= B_WANTED;
		    sleep((caddr_t)bbp, PRIBIO);
		    splx(s);
		    goto retry;
		}
		splx(s);
	    }
	    nbs = 0;
	    bbp->b_flags = B_READ|B_BUSY;
	    bbp->b_dev = (bp->b_dev&~7) | 2;	/* partition C of drive */
	    bbp->b_bcount = sizeof (struct dkbad);
            bbp->b_un.b_addr = (caddr_t) bad;
	    bbp->b_blkno = blkno = ncpd * nspt * ntpc - nspt;
	    (*strat)(qi, bbp);
	    error = u.u_error;
	    biowait(bbp);
	    u.u_error = error;
	    error = bbp->b_flags & B_ERROR;
	    if (bbp->b_flags & B_WANTED)
		    wakeup((caddr_t)bbp);
	    bbp->b_flags = 0;
	    if (error) {
		    printf("%s%d: cannot read bad sector map\n",
			    qi->qi_driver->qd_dname, qi->qi_unit);
		    bad->bt_csn = -1;
		    goto done;	/* so we'll keep trying */
	    }
#ifdef	BAD144DEBUG
	    printf("%s%d: read bad144 map from block %d\n",
		    qi->qi_driver->qd_dname, qi->qi_unit, blkno);
#endif	BAD144DEBUG
	    if (bad->bt_csn != 0) {
		for (i = 0; i < MAXBADBLK; i++) {
		    if (bad->bt_bad[i].bt_cyl == 0xFFFF)
			bad->bt_bad[i].bt_bn = -1;
		    else if ((bad->bt_bad[i].bt_cyl > ncpd) ||
			(((bad->bt_bad[i].bt_trksec>>8)&0xff)>ntpc)||
			((bad->bt_bad[i].bt_trksec&0xff) > nspt) ) {
			    printf("%s%d: bad bad144 map\n",
				    qi->qi_driver->qd_dname, qi->qi_unit);
			    bad->bt_csn = -1;
			    break;
		    } else {
#ifdef	BAD144DEBUG
			    printf("%s%d:(cyl %d,trk %d,sec %d)",
				qi->qi_driver->qd_dname, qi->qi_unit,
				bad->bt_bad[i].bt_cyl,
				(bad->bt_bad[i].bt_trksec>>8) & 0xff,
				bad->bt_bad[i].bt_trksec&0xff);
#endif	BAD144DEBUG
			    bad->bt_bad[i].bt_bn = 
				(((bad->bt_bad[i].bt_cyl * ntpc) +
				((bad->bt_bad[i].bt_trksec>>8)&0xff))
				*nspt)+
				(bad->bt_bad[i].bt_trksec&0xff);
			    nbs++;
#ifdef	BAD144DEBUG
			    printf("[blk %d] remapped to %d\n",
				bad->bt_bad[i].bt_bn, blkno - nbs);
#endif	BAD144DEBUG
			    
		    }
		    
		}
		if (nbs != 0)
			printf("%s%d: %d remapped sectors\n",
			    qi->qi_driver->qd_dname, qi->qi_unit, nbs);
		bad->bt_csn = 1;
		bad->bt_mbz = nbs;
	    } else
		bad->bt_csn = -1;
	}

	/* binary search the bad sector map for remapped sectors */
	if (bad->bt_csn == 1 && bad->bt_mbz) {
	    lo = 0;
	    while (sbn <= lbn) {
	    	hi = bad->bt_mbz-1;
		while ((hi - lo) > 1) {
			i = lo + (hi - lo)/2;
			if (bad->bt_bad[i].bt_bn == sbn)
				hi = lo = i;
			else if (bad->bt_bad[i].bt_bn < sbn)
				lo = i;
			else
				hi = i;
		}
		if (bad->bt_bad[lo].bt_bn >= sbn)
			hi = lo;
		bbn = bad->bt_bad[hi].bt_bn;
		if (!hadbad) {
			if (bbn < sbn || bbn > lbn)
				goto done;		/* no remaps */
			hadbad++;
	    		if (bp != &dumpbuf) {
			    s = splbio();
			    while (bbp->b_flags & B_BUSY) {
				bbp->b_flags |= B_WANTED;
				sleep((caddr_t)bbp, PRIBIO);
			    }
			    splx(s);
			}
			*bbp = *bp;
			bbp->b_flags &= SAVE_BFLAGS;
			bbp->b_dev = (bp->b_dev&~7) | 2;
		}
		if (bbn < sbn || bbn > lbn) {	/* transfer from sbn to lbn */
		    bbp->b_blkno = sbn;
		    bbp->b_bcount = len;
		    bbp->b_flags &= SAVE_BFLAGS;
		    (*strat)(qi, bbp);
		    biowait(bbp);
		    len -= bbp->b_bcount-bbp->b_resid;
		    sbn = lbn+1;
		} else {
		    if (sbn < bbn) {	/* transfer from sbn to bad block bbn */
			    bbp->b_blkno = sbn;
			    bbp->b_bcount = MIN(len,(bbn - sbn) * 512);
			    bbp->b_flags &= SAVE_BFLAGS;
			    (*strat)(qi, bbp);
			    biowait(bbp);
			    bbp->b_un.b_addr += bbp->b_bcount;
			    len -= bbp->b_bcount-bbp->b_resid;
			    if (bbp->b_flags & B_ERROR)
				    break;
		    }

		    /* transfer remapped bbn */
		    bbp->b_blkno = ((ncpd*ntpc*nspt) - nspt - 1) - hi;
		    bbp->b_bcount = MIN(len, 512);
		    bbp->b_flags &= SAVE_BFLAGS;
		    (*strat)(qi, bbp);
		    biowait(bbp);
		    bbp->b_un.b_addr += bbp->b_bcount;
		    len -= bbp->b_bcount-bbp->b_resid;
		    sbn = bbn+1;
		}
		if (bbp->b_flags & B_ERROR)
			break;
	    }
	    bp->b_resid = len;
	    if (bbp->b_flags & B_ERROR) {
		    bp->b_flags |= B_ERROR;
		    bp->b_error = bbp->b_error;
	    }
	    if (bbp->b_flags & B_WANTED)
		    wakeup((caddr_t)bbp);
	    bbp->b_flags = 0;
	    iodone(bp);
	    return;
	}
done:	(*strat)(qi, bp);
}
