/*
 * Zilog CTC device registers.
 */
#define CTC_NCHAN	4

#ifdef	QBUS
#define CTC0_ADR	0xC20001
#define CTC1_ADR	0xC20003
#define CTC2_ADR	0xC20005
#define CTC3_ADR	0xC20007
#define CTC_RETI	0xC22000	/* RETI ED 4D bit bucket */
#else	QBUS
#define CTC0_ADR	0xC1C001
#define CTC1_ADR	0xC1C003
#define CTC2_ADR	0xC1C005
#define CTC3_ADR	0xC1C007
#define CTC_RETI	0xC1C021	/* RETI ED 4D bit bucket */
#endif	QBUS

#ifndef	LOCORE
struct ctcdevice {
	unsigned char	ctc_ctrl;
};
#endif  LOCORE

#define CTC_CTRL	0x01	/* control word */
#define CTC_RESET	0x02	/* software reset */
#define CTC_TCF		0x04	/* time constant follows */
#define CTC_PSTART	0x08	/* pulse starts timer */
#define CTC_RISE	0x10	/* rising edge */
#define CTC_SC256	0x20	/* prescaler value is 256 */
#define CTC_CNT		0x40	/* select counter mode */
#define CTC_IENBL	0x80	/* interrupt enable */

#define CTC_RETI0	0xED
#define CTC_RETI1	0x4D
