/*
 * Unique portion of vm_machdep.c for 68010's
 */
#define	C_segptes /**/
#define	C_newptes /**/
#define	PRMMU	/**/

#ifdef C_segptes	[
/*
 * return negitive number of ptes with same protection if none are valid.
 * return positive number of ptes with same protection if any are valid.
 */
segptes(pte,i)
	register struct pte *pte;
	register int i;
{
	register int prot = pte->pg_prot;
	register int j = 0;
	register int k = 0;

	for (;i>0;i--,j++,pte++) {
/*
		if (pte->pg_prot != prot)
			break;
*/
		if (pte->pg_v)
			k = 1;
	}
	return (k ? j : -j);
}
#endif	C_segptes	]

#ifdef	C_newptes	[
newptes(pte, v, size)
	register struct pte *pte;
	u_int v;
	register int size;
{
	register short		*page;	/* ptrs to hardware page regs */
	register SEGTYPE	*seg;	/* ptrs to hardware seg regs */
	register short i, prot, context, po;
	extern int end;
	extern segalloc();
	static char is68k_prot[] = { /* convert vax prot bits to is68k */
		SEGPROT_ALL, SEGPROT_REO
	};

	if (size <= 0)
		return;
	if (pte >= Sysmap && pte <= eSysmap)
		context = 0;
	else
		context = 1;
	seg = (SEGTYPE *)(SEGREGBASE + 
		((v & ~(NPAGPERSEG-1)) << (SEGREGSHIFT-PAGSEGSHIFT)) + 
		(context << SEGCTXSHIFT));
	po = v & (NPAGPERSEG-1);
	i =  NPAGPERSEG - po;
	i = ( size < i ) ? size : i;
	for (;;) {
		if (size <= 0)
			return;
		i =  segptes(pte, i);
		prot = pte->pg_prot;
		if ( i > 0 || ((*seg & SEGPROTMASK) != SEGPROT_NO)) {
			if (i < 0) 
				i = -i;
			if ((*seg & SEGPROTMASK) == SEGPROT_NO)
				*seg = segalloc(context);
			*seg = is68k_prot[prot] + (*seg & (NPAGBANKS-1));
			page = (short *)(PAGREGBASE + 
				((((*seg & (NPAGBANKS-1)) << PAGSEGSHIFT) + po)
				<< PAGREGSHIFT));
    			while (--i >= 0) {
				*page = pte->pg_v ? 
					(pte->pg_pfnum << PAGVALSHIFT) : 
					(PAGOUTPAGE << PAGVALSHIFT);
				--size;
				page += (PAGREGINCR / sizeof *page);
				pte += 1;
			}
		} else {
			*seg = SEGPROT_NO | SEGPAGEDOUT;
			size += i;		/* i is negative */
			pte -= i;
		}
		i = ( size < NPAGPERSEG ) ? size : NPAGPERSEG;
		po = 0;
		seg += (SEGREGINCR / sizeof *seg);
	}
}
#endif	C_newptes	]

segalloc(context)
	register context;
{
	register short i, *page;	/* ptrs to hardware page regs */
	register int segnum;
	extern int maxsysseg, minusrseg;
	static int randusrseg;

	segnum = context == 0 ? ++maxsysseg : --minusrseg;
	if (maxsysseg >= minusrseg) {
		if (context == 0)
			panic("segalloc");
		minusrseg++;
		randusrseg--;
		if (randusrseg <= minusrseg)
			randusrseg = 60;	/* leave bottom few alone */
		segnum = randusrseg;
		segfree(context, segnum);
	}
	page = (short *)(PAGREGBASE + (segnum << (PAGSEGSHIFT+PAGREGSHIFT)));
	for (i = NPAGPERSEG ; i > 0 ; i--) {
		*page = (PAGINVPAGE << PAGVALSHIFT);
		page += PAGREGINCR / sizeof *page;
	}
	return segnum;
}

segfree (context, segnum)
	register segnum;
{
	register short i;
	register SEGTYPE	*seg;	/* ptrs to hardware seg regs */

	refbits();
	seg = (SEGTYPE *)(SEGREGBASE + (context << SEGCTXSHIFT));
	for (i = 0;  i <= NSEGPERCTX-1;  i++) {
		if ( ((*seg & (NSEGPERCTX-1)) == segnum) &&(*seg&SEGPROTMASK)) {
			*seg = SEGPROT_NO | SEGPAGEDOUT;
			return;
		}
		seg += SEGREGINCR / sizeof *seg;
	}
	panic("segfree");
}

refptes(pte, v, size)
	register struct pte *pte;
	u_int v;
	register int size;
{
	register SEGTYPE *seg;		/* ptrs to hardware seg regs */
	register short *page, pg;	/* ptrs to hardware page regs */
	register short i, prot, context, po;
	extern int end;

	if (pte >= Sysmap && pte <= eSysmap)
		panic("refptes: context=0\n");
	else
		context = 1;
	seg = (SEGTYPE *)(SEGREGBASE + 
		((v & ~(NPAGPERSEG-1)) << (SEGREGSHIFT-PAGSEGSHIFT)) + 
		(context << SEGCTXSHIFT));
	po = v & (NPAGPERSEG-1);
	i = NPAGPERSEG - po;
	i = ( size < i ) ? size : i;
	for (;;) {
		if (size <= 0)
			return;
		i = segptes(pte, i);
		prot = pte->pg_prot;
		if ( i > 0 &&  (*seg & SEGPROTMASK) != SEGPROT_NO) {
		    page = (short *)(PAGREGBASE + 
			((((*seg & (NPAGBANKS-1)) << PAGSEGSHIFT) + po) 
			<< PAGREGSHIFT));
    		    while (--i >= 0) {	/* check each page reg of segment */
			if ((*(int *)pte & (PG_V|PG_FOD)) == PG_V) {
			    if ( ((pg = *page) != PAGINVPAGE) && 
				(pg != PAGOUTPAGE)) {
				if (pg & (1<<PAGREFBIT))
					pte->pg_r = 1;
				if (pg & (1<<PAGMODBIT))
					pte->pg_m = 1;
			    }
			}
			--size;
			page += (PAGREGINCR / sizeof *page);
			pte += 1;
		    }
		} else {
			if (i < 0)
				i = -i;
			size -= i;
			pte += i;
		}
		i = (size < NPAGPERSEG) ? size : NPAGPERSEG;
		po = 0;
		seg += SEGREGINCR / sizeof *seg;
	}
}

bcopyin(uv, kv, bcount)
	register long uv, kv;
	register long bcount;
{
	register struct pte *pte;
	register char *p;
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	int s;

	if (!useracc(uv, bcount, B_READ))
		return -1;
	pte = vtopte(u.u_procp, btop(uv));
	p = &VSCR0 + (uv & PGOFSET);
	while (bcount) {
		register long n = MIN(bcount, 32 * 1024);
		register long i = n;

		u.u_procp->p_flag |= SPHYSIO;
		vslock(uv, n);		/* could block here */
		scr0_sav = SCR0;
		scr1_sav = SCR1;
		do {
			SCR0 = pte++->pg_pfnum << PAGVALSHIFT;
			SCR1 = pte->pg_pfnum << PAGVALSHIFT;
			bcopy(p, kv, MIN(i, NBPG));
			kv += NBPG;
		} while ((i -= NBPG) > 0);
		SCR1 = scr1_sav;
		SCR0 = scr0_sav;
		s = spl6();
		vsunlock(uv, n, B_WRITE);	/* memory read, device write */
		u.u_procp->p_flag &= ~SPHYSIO;
		splx(s);
		bcount -= n;
		uv += n;
	}
	return 0;
}

bcopyout(kv, uv, bcount)
	register long uv, kv;
	register long bcount;
{
	register struct pte *pte;
	register char *p;
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	int s;

	if (!useracc(uv, bcount, B_WRITE))
		return -1;
	pte = vtopte(u.u_procp, btop(uv));
	p = &VSCR0 + (uv & PGOFSET);
	while (bcount) {
		register long n = MIN(bcount, 32 * 1024);
		register long i = n;

		u.u_procp->p_flag |= SPHYSIO;
		vslock(uv, n);		/* could block here */
		scr0_sav = SCR0;
		scr1_sav = SCR1;
		do {
			SCR0 = pte++->pg_pfnum << PAGVALSHIFT;
			SCR1 = pte->pg_pfnum << PAGVALSHIFT;
			bcopy(kv, p, MIN(i, NBPG));
			kv += NBPG;
		} while ((i -= NBPG) > 0);
		SCR1 = scr1_sav;
		SCR0 = scr0_sav;
		s = spl6();
		vsunlock(uv, n, B_READ);	/* memory write, device read */
		u.u_procp->p_flag &= ~SPHYSIO;
		splx(s);
		bcount -= n;
		uv += n;
	}
	return 0;
}

bcopyseg(uv, kv)
	register long uv, kv;
{
	register struct pte *pte;
	register char *p;
	register short scr0_sav;
	extern short SCR0;
	extern char VSCR0;
	int s;

	pte = vtopte(u.u_procp, btop(uv));
	p = &VSCR0;
	u.u_procp->p_flag |= SPHYSIO;
	vslock(uv, NBPG);		/* could block here */
	scr0_sav = SCR0;
	SCR0 = pte->pg_pfnum << PAGVALSHIFT;
	qbcopyp(p, kv);
	SCR0 = scr0_sav;
	s = spl6();
	vsunlock(uv, NBPG, B_READ);	/* memory write, device read */
	u.u_procp->p_flag &= ~SPHYSIO;
	splx(s);
}

/* print the mmu translation for context 'ctx' */
prmmu(ctx)
{
#ifdef	PRMMU	[
	SEGTYPE seg, *segp;
	short page, *pagep;
	int pro, vp;
	static char *prot[] = {"no access","read exec","read write","all"};
	/*
	 *	+r => referenced	-r => not referenced
	 *	+m => modified		-m => not modified
	 *	+o => paged out		-o => not paged out
	 *	+i => invalid		-i => not invalid
	 */
#ifdef	QBUS	[
	static char *rwbits[] = {"-r-w","-r+w","+r-w","+r+w"};
#else	QBUS	][
	static char *rwbits[] = {"-r-m-o-i","-r-m-o+i","-r-m+o-i","-r-m+o+i",
				 "-r+m-o-i","-r+m-o+i","-r+m+o-i","-r+m+o+i",
				 "+r-m-o-i","+r-m-o+i","+r-m+o-i","+r-m+o+i",
				 "+r+m-o-i","+r+m-o+i","+r+m+o-i","+r+m+o+i"};
#endif	QBUS	]
	int i,j,rw;
	int s;

	s = spl7();
	printf("Memory management for CONTEXT %d\n",ctx);
	printf("___________________________________\n");
	segp = (SEGTYPE *)(SEGREGBASE|((ctx&0xF) << SEGCTXSHIFT));
	for (i = 0 ; i < NSEGPERCTX ; i++) {
	    seg = *segp;
	    pro = (seg & SEGPROTMASK ) >> SEGPROTSHIFT;
	    seg = seg&(NPAGBANKS-1);
	    vp = NPAGPERSEG * i;
	    if (pro == 0) {
		printf("%x-",vp);
    		segp += SEGREGINCR/sizeof *segp;
		while ((((*segp&SEGPROTMASK)>>SEGPROTSHIFT) == pro) &&
		       ((*segp&(NPAGBANKS-1)) == seg) &&
		    i < NSEGPERCTX) {
			i++;
	    		vp = NPAGPERSEG * i;
	    		segp += SEGREGINCR/sizeof *segp;
		}
	    	printf("%x	%s", vp+(NPAGPERSEG-1), prot[pro]);
	        printf("=> bank %x\n",seg);
	    } else {
	    	printf("%x-%x	%s", vp, vp+(NPAGPERSEG-1), prot[pro]);
	        printf("=> bank %x\n",seg);
	    	pagep = (short *)(PAGREGBASE|(seg<<(PAGSEGSHIFT+PAGREGSHIFT)));
		for (j = 0 ; j < NPAGPERSEG ; j++) {
			page = *pagep;
			page = (page&PAGNUMMASK) >> PAGVALSHIFT;
#ifdef	QBUS	[
			rw = page&0x3;			/* KLUDGE */
#else	QBUS	][
			rw = (page>>PAGINVBIT)&0xF;	/* KLUDGE */
#endif	QBUS	]
			printf("   v %x -> p %x	%s\n",vp+j,page,rwbits[rw]);
			pagep += PAGREGINCR/sizeof *pagep;
		}
    		segp += SEGREGINCR/sizeof *segp;
	    }
	}
	splx(s);
#endif	PRMMU	]
}

#ifdef	VBUS	[
svtop(x)
long x;
{
	long ret;
	ret = ((long)((*(short *)(((long)((*(SEGTYPE *)
	  (SEGREGBASE|(x&0x7E0000))&(NSEGPERCTX-1))<<6)|
	  ((x&0x1F000)>>11)|PAGREGBASE))&PAGNUMMASK))<<PGSHIFT)|(x&(NBPG-1));
	return ret;
}
#endif	VBUS	]

pcopyin(p, k, bcount)
	register char *p, *k;
	register int bcount;
{
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	register unsigned pfnum;
	register int n;

	if (bcount <= 0)
		return;
	pfnum = (unsigned long)p >> PGSHIFT;
	p = &VSCR0 + ((unsigned long)p & PGOFSET);
	scr0_sav = SCR0;
	scr1_sav = SCR1;
	do {
		n = MIN(bcount, NBPG);
		SCR0 = pfnum++ << PAGVALSHIFT;
		SCR1 = pfnum << PAGVALSHIFT;
		bcopy(p, k, n);
		k += n;
	} while (bcount -= n);
	SCR0 = scr0_sav;
	SCR1 = scr1_sav;
}

pcopyout(k, p, bcount)
	register char *k, *p;
	register int bcount;
{
	short scr0_sav, scr1_sav;
	extern short SCR0, SCR1;
	extern char VSCR0;
	register unsigned pfnum;
	register int n;

	if (bcount <= 0)
		return;
	pfnum = (unsigned long)p >> PGSHIFT;
	p = &VSCR0 + ((unsigned long)p & PGOFSET);
	scr0_sav = SCR0;
	scr1_sav = SCR1;
	do {
		n = MIN(bcount, NBPG);
		SCR0 = pfnum++ << PAGVALSHIFT;
		SCR1 = pfnum << PAGVALSHIFT;
		bcopy(k, p, n);
		k += n;
	} while (bcount -= n);
	SCR0 = scr0_sav;
	SCR1 = scr1_sav;
}

pcopy(p, q, bcount)
	register char *p, *q;
	register int bcount;
{
	short scr0_sav, scr1_sav;
	short scr2_sav, scr3_sav;
	extern short SCR0, SCR1;
	extern short SCR2, SCR3;
	extern char VSCR0;
	extern char VSCR2;
	register unsigned spfnum, dpfnum;
	register int n;

	if (bcount <= 0)
		return;
	spfnum = (unsigned long)p >> PGSHIFT;
	dpfnum = (unsigned long)q >> PGSHIFT;
	p = &VSCR0 + ((unsigned long)p & PGOFSET);
	q = &VSCR2 + ((unsigned long)q & PGOFSET);
	scr0_sav = SCR0;
	scr1_sav = SCR1;
	scr2_sav = SCR2;
	scr3_sav = SCR3;
	do {
		n = MIN(bcount, NBPG);
		SCR0 = spfnum++ << PAGVALSHIFT;
		SCR1 = spfnum << PAGVALSHIFT;
		SCR2 = dpfnum++ << PAGVALSHIFT;
		SCR3 = dpfnum << PAGVALSHIFT;
		bcopy(p, q, n);
	} while (bcount -= n);
	SCR0 = scr0_sav;
	SCR1 = scr1_sav;
	SCR2 = scr2_sav;
	SCR3 = scr3_sav;
}

setctx()
{
}
