/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)scb.h	6.2 (Berkeley) 6/8/85
 */

/* 
 * ISI: IS68K vector table
 */

#define	STRAY	.long	_Xstray
#define	STRAY8	STRAY;STRAY;STRAY;STRAY;STRAY;STRAY;STRAY;STRAY
#define	STRAY16	STRAY8;STRAY8
#define	KS(a)	.long	_X/**/a

	.data
	.align	1
	.globl	_scb
/* System control block: */
_scb:
#ifdef	M68010
/*   0 */	STRAY;		STRAY;		KS(buserr);	KS(adderr);
#else	M68020
/*   0 */	.long 0;	.long 0;	KS(buserr);	KS(adderr);
#endif	M68010
/*   4 */	KS(illins);	KS(zerodiv);	KS(chk);	KS(trapv);
/*   8 */	KS(privvio);	KS(trace);	KS(l1010em);	KS(l1111em);
#ifdef	M68010
/*  12 */	STRAY;		STRAY;		KS(fmterr);	STRAY;
#else	M68020
/*  12 */	STRAY;		KS(coproc);	KS(fmterr);	STRAY;
#endif	M68010
/*  16 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  20 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  24 */	STRAY;		STRAY;		STRAY;		STRAY;
#ifdef	M68010
/*  28 */	STRAY;		KS(lclock);	STRAY;		KS(nmi);
#else	M68020
/*  28 */	STRAY;		KS(sio);	KS(clock);	KS(nmi);
#endif	M68020
/*  32 */	KS(trap0);	KS(trap1);	KS(trap2);	KS(trap3);
/*  36 */	KS(trap4);	KS(trap5);	KS(trap6);	KS(trap7);
/*  40 */	KS(trap8);	KS(trap9);	KS(trap10);	KS(trap11);
/*  44 */	KS(trap12);	KS(trap13);	KS(trap14);	KS(trap15);
#ifdef	M68010
/*  48 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  52 */	STRAY;		STRAY;		STRAY;		STRAY;
#else	M68020
/*  48 */	KS(fpe);	KS(fpe);	KS(fpe);	KS(fpe);
/*  52 */	KS(fpe);	KS(fpe);	KS(fpe);	STRAY;
#endif	M68010
/*  56 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  60 */	STRAY;		STRAY;		STRAY;		STRAY;
#ifdef	M68010
/*  64 */	KS(sioxint1);	STRAY;		KS(sioeint1);	STRAY;
/*  68 */	KS(siorint1);	STRAY;		KS(siosint1);	STRAY;
/*  72 */	KS(sioxint0);	STRAY;		KS(sioeint0);	STRAY;
/*  76 */	KS(siorint0);	STRAY;		KS(siosint0);	STRAY;
/*  80 */	KS(ctcint0);	STRAY;		KS(ctcint1);	STRAY;
/*  84 */	KS(ctcint2);	STRAY;		KS(ctcint3);	STRAY;
/*  88 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  92 */	STRAY;		STRAY;		STRAY;		STRAY;
/*  96 */	STRAY8;		STRAY8;		STRAY8;		STRAY8;
#else	M68020
/*  64 */	STRAY16;	STRAY16;	STRAY16;	STRAY16;
#endif	M68010
/* 128 */	STRAY16;	STRAY16;	STRAY16;	STRAY16;
/* 192 */	STRAY16;	STRAY16;	STRAY16;	STRAY16;
/* 256 */
	.text
