/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)pte.h	6.6 (Berkeley) 8/5/85
 */

/*
 * IS-68K{12}{05} pte.h
 *
 * There are two major kinds of pte's: those which have ever existed (and are
 * thus either now in core or on the swap device), and those which have
 * never existed, but which will be filled on demand at first reference.
 * There is a structure describing each.  There is also an ancillary
 * structure used in page clustering.
 */

#ifndef LOCORE
#define	PG_BITS	\
"\20\40PG_V\37PG_RO\36PG_M\35PG_R\30PG_FOD\27SWVM\26RVM\25PG_CACHE\24PG_STDAM"

struct pte {
unsigned int	pg_v:1,			/* valid bit */
		pg_prot:1,		/* access control */
		pg_m:1,			/* hardware maintained modified bit */
		pg_r:1,			/* referenced bit */
		:4,			/* TRASH, fileno */
		pg_fod:1,		/* is fill on demand (=0) */
		pg_swapm:1,		/* have to write back to swap */
		pg_vreadm:1,		/* modified since vread (or with _m) */
		pg_cache:1,		/* V25: cache enable */
		pg_vmestd:1,		/* V25: vme standard address space */
		:3,
		pg_pfnum:16;
};

/* NOTE: CLSIZE is 1 (no clustering), so this structure is not used. CTH */
struct hpte {
unsigned int	pg_high:11,		/* special for clustering */
		:5,
		pg_pfnum:16;
};

struct fpte {
unsigned int	pg_v:1,			/* valid bit */
		pg_prot:1,		/* access control */
		pg_m:1,			/* hardware maintained modified bit */
		pg_r:1,			/* referenced bit */
		:4,			/* TRASH */
		pg_fod:1,		/* is fill on demand (=1) */
		pg_fileno:1,		/* file mapped from or TEXT or ZERO */
		pg_blkno:22;		/* file system block number */
};
#endif	LOCORE

#define	PG_V		0x80000000
#define	PG_PROT		0x40000000
#define	PG_M		0x20000000
#define	PG_R		0x10000000
#define	PG_FOD		0x00800000
#define	PG_VREADM	0x00200000
#define PG_CACHE	0x00100000	/* enable external cache */
#define PG_CACHEK	PG_CACHE	/* enable external cache for kernel */
#define PG_VMESTD	0x000F0000	/* generate vme standard address mod */
#define	PG_PFNUM	0x0000FFFF
#define	PG_MASK		0xF0FFFFFF	/* Bits which are not TRASHED */

#define	PG_M_BIT	29
#define	PG_R_BIT	28

#define	PG_FZERO	0
#define	PG_FTEXT	1
#define	PG_FMAX		(PG_FTEXT)


#define	PG_NOACC	0
#define	PG_KW		0x00000000
#define	PG_KR		0x40000000
#define	PG_UW		0x00000000
#define	PG_URKR		0x40000000

#ifndef LOCORE
/* Pte related macros */
#define	dirty(pte)	((pte)->pg_fod == 0 && (pte)->pg_pfnum && \
			    ((pte)->pg_m || (pte)->pg_swapm))
#define	referenced(pte)	((pte)->pg_fod == 0 && (pte)->pg_pfnum && (pte)->pg_r)

#ifdef	KERNEL

/* utilities defined in locore.s */
extern	struct pte Sysmap[];
extern	struct pte Usrptmap[];
extern	struct pte usrpt[];
extern	struct pte Forkmap[];
extern	struct pte Xswapmap[];
extern	struct pte Xswap2map[];
extern	struct pte Swapmap[];
extern	struct pte Pushmap[];
extern	struct pte Vfmap[];
extern	struct pte mcrmap[];
extern	struct pte mmap[];
extern	struct pte msgbufmap[];
extern	struct pte camap[];
extern	struct pte shortiomap[];	/* ISI: VBUS: */
extern	struct pte vidbufmap[];		/* ISI: VBUS: GWS: */
extern	struct pte vbmap[];		/* ISI: VBUS: VB: */
extern	struct pte nwmap0[];		/* ISI: VBUS: NW: */
extern	struct pte nwmap1[];		/* ISI: VBUS: NW: */
extern	struct pte enpmap[];		/* ISI: VBUS: ENP: */
extern	struct pte usrdevmap[];		/* ISI: user configurable map */
extern	struct pte eSysmap[];		/* end marker */
#endif	KERNEL
#endif	LOCORE
