/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)mem.c	6.4 (Berkeley) 2/23/86
 */

/*
 * Memory special file
 */

#include "pte.h"

#include "param.h"
#include "dir.h"
#include "user.h"
#include "conf.h"
#include "buf.h"
#include "systm.h"
#include "vm.h"
#include "cmap.h"
#include "uio.h"

#include "board.h"

#ifdef	GWS
#include "../is68kdev/gpreg.h"
extern char	vidbuf[];		/* virtual address for display memory */
#endif	GWS
int		detachedmem;

mmread(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	return (mmrw(dev, uio, UIO_READ));
}

mmwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	return (mmrw(dev, uio, UIO_WRITE));
}

mmrw(dev, uio, rw)
	dev_t dev;
	struct uio *uio;
	enum uio_rw rw;
{
	register int o;
	register u_int c, v;
	register struct iovec *iov;
	int error = 0;

	if (uio->uio_iovcnt == 0)
		return (0);
	while (uio->uio_resid > 0 && error == 0) {
		iov = uio->uio_iov;
		if (iov->iov_len == 0) {
			uio->uio_iov++;
			uio->uio_iovcnt--;
			if (uio->uio_iovcnt < 0)
				panic("mmrw");
			continue;
		}
		switch (minor(dev)) {

		    case 0:		/* minor device 0 is physical memory */
			v = btop(uio->uio_offset);
pmem:			if (v >= (physmem + detachedmem))
				goto fault;
			*(int *)mmap = v|PG_V|PG_KW|PG_CACHE;
			newptes(mmap, btop(vmmap), 1);
			o = (int)uio->uio_offset & PGOFSET;
			c = (u_int)(NBPG - ((int)iov->iov_base & PGOFSET));
			c = MIN(c, (u_int)(NBPG - o));
			c = MIN(c, (u_int)iov->iov_len);
			error = uiomove((caddr_t)&vmmap[o], (int)c, rw, uio);
			continue;

		    case 1:		/* minor device 1 is kernel memory */
			c = iov->iov_len;
			if (!kernacc((caddr_t)uio->uio_offset, c, 
				rw == UIO_READ ? B_READ : B_WRITE))
					goto fault;
			error = uiomove((caddr_t)uio->uio_offset, (int)c, rw, 
				uio);
			continue;

		    case 2:		/* minor device 2 is EOF/RATHOLE */
			if (rw == UIO_READ)
				return (0);
			c = iov->iov_len;
			break;

#ifdef	GWS
		    case 4:		/* minor device 4 is video memory */
			if ((gptype & GPEXISTS) == 0 || uio->uio_offset < 0)
				goto fault;
			c = iov->iov_len;
			if (gptype & GPHASGIP) {	/* GIP */
			    if (gptype & GPCOLOR) {	/* color gip */
				if (uio->uio_offset+c <= 1024*1024){
		    ok:		    gpget();		/* display memory */
				    CPUgetdisp();
				    error = uiomove(&vidbuf[uio->uio_offset], 
						    (int)c, rw, uio);
				    gpgive();
				    continue;
				}
			    } else if (uio->uio_offset+c <= 512*1024)
				    goto ok;		/* monchrome */
			    /* gip registers */
			    o = uio->uio_offset - 1024*1024;
			    v = ((int)gpaddr) & PGOFSET;
			    if (o >= v && (o+c) <= (v+8)) {
				gpget();
				error = uiomove((int)gpaddr + o, 
					(int)c, rw, uio);
				gpgive();
				continue;
			    }
			} else if (uio->uio_offset+c <= 256*1024)
				goto ok;		/* 1 plane MWS card */
			goto fault;
#endif	GWS

		    case 5:		/* minor device 5 is detached memory */
			if (detachedmem == 0 || 
			    btop(uio->uio_offset) >= detachedmem)
				goto fault;
			v = btop(uio->uio_offset) + physmem;
			goto pmem;

		    default:
			error = EINVAL;
			break;
		}
		if (error)
			break;
		iov->iov_base += c;
		iov->iov_len -= c;
		uio->uio_offset += c;
		uio->uio_resid -= c;
	}
	return (error);
fault:	return (EFAULT);
}

#ifndef NOMMAP
/*
 * Return physical page frame # corresponding to byte offset.
 * Return -1 if illegal.
 */
	int
mmmap(dev, offset, prot)
	dev_t	dev;
	off_t	offset;			/* byte offset within device */
	int	prot;			/* mmap protection */
{
	register int	page;		/* physical page frame # */

	switch(minor(dev)) {
	    case 0:			/* physical memory */
		page = btop(offset);
		if (page & ~PG_PFNUM)	/* offset is too big (or negative) */
			break;
		return(page);

	    case 1:			/* kmem */
/*		if (!kernacc(SYSVBASE + offset, 1, B_WRITE))
			break;		/**/
		page = btop(svtop(offset));
		if (page & ~PG_PFNUM)	/* offset is too big (or negative) */
			break;
		return(page);

#ifdef	GWS
	    case 4:			/* video memory */
		if ((gptype & GPEXISTS) == 0 || offset < 0)
			break;
		if (gptype & GPHASGIP){			/* GIP */
			if (gptype & GPCOLOR){
			    if (offset < 1024*1024) {	/* color gip */
				/* display memory */
		ok:		page = btop(svtop(&vidbuf[offset]));
				if (page & ~PG_PFNUM)
					break;
				return(page);
			    }
			} else if (offset < 512*1024)	/* b/w gip */
				goto ok;
			/* registers */
			offset -= 1024*1024;
			if (offset == (((int)gpaddr) & PGOFSET)) {
				page = btop(svtop(gpaddr));
				if (page & ~PG_PFNUM)
					break;
				return(page);
			}
		} else if (offset < 256*1024)		/* 1 plane MWS card */
			goto ok;
#endif	GWS
	    case 5:				/* detached memory */
		page = btop(offset) + physmem;
		if (detachedmem == 0 || page > (physmem + detachedmem) || 
		    page & ~PG_PFNUM)
			break;
		return(page);
	}
	return(-1);
}
#endif	NOMMAP
