/*
 * Copyright (c) 1982 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)cons.c	6.3 (Berkeley) 6/8/85
 */

/*
 * IS68k console interface, send off to sio...
 */
cnputc(c)
	register int c;
{
	static int col = 0;
	register int i, n;

	if (c == '\t') {
	    n = 8 - (col % 8);
	    for (i = 0 ; i < n; i++) {
		sioputchar(' ');
		col++;
	    }
	} else {
	    if (c == '\n' || c == '\r')
		col = 0;
	    else if (c == '\b')
		col = (col > 0) ? (col - 1) : 0;
	    else
		col++;
	    sioputchar(c);
	}
}

cngetc()
{
	return siogetchar();
}
