/*
 * Copyright (c) 1982, 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)signal.h	7.1 (Berkeley) 6/4/86
 */

#ifndef	NSIG
#define NSIG	32
/* Because NSIG for BSD and SYSV are different, MAXSIG is introduced */
#define MAXSIG	NSIG	/* ISI: SYSV: also defined in ../sysv/sys/signal.h ! */

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt */
#define	SIGQUIT	3	/* quit */
#define	SIGILL	4	/* illegal instruction (not reset when caught) */
#define	    ILL_RESAD_FAULT	0x0	/* reserved addressing fault */
#define	    ILL_PRIVIN_FAULT	0x1	/* privileged instruction fault */
#define	    ILL_RESOP_FAULT	0x2	/* reserved operand fault */
/* CHME, CHMS, CHMU are not yet given back to users reasonably */
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGABRT	SIGIOT	/* compatibility */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#ifdef	vax
#define	    FPE_INTOVF_TRAP	0x1	/* integer overflow */
#define	    FPE_INTDIV_TRAP	0x2	/* integer divide by zero */
#define	    FPE_FLTOVF_TRAP	0x3	/* floating overflow */
#define	    FPE_FLTDIV_TRAP	0x4	/* floating/decimal divide by zero */
#define	    FPE_FLTUND_TRAP	0x5	/* floating underflow */
#define	    FPE_DECOVF_TRAP	0x6	/* decimal overflow */
#define	    FPE_SUBRNG_TRAP	0x7	/* subscript out of range */
#define	    FPE_FLTOVF_FAULT	0x8	/* floating overflow fault */
#define	    FPE_FLTDIV_FAULT	0x9	/* divide by zero floating fault */
#define	    FPE_FLTUND_FAULT	0xa	/* floating underflow fault */
#endif	vax
#ifdef	is68k
#define	    FPE_INTOVF_TRAP	0x1	/* integer overflow */
#define	    FPE_INTDIV_TRAP	0x2	/* integer divide by zero */
#define	    FPE_SUBRNG_TRAP	0x3	/* subscript out of range */
#define	    FPE_TRAPCC_TRAP	0x4	/* FTRAPcc instruction */
#define	    FPE_FLINE_TRAP	0x5	/* F-Line emulation trap */
#define	    FPE_COPROC_TRAP	0x6	/* coprocessor protocol violation */
#define	    FPE_FBSUN_TRAP	0x7	/* branch/set on unordered */
#define	    FPE_INEXCT_TRAP	0x8	/* inexact result */
#define	    FPE_FLTDIV_TRAP	0x9	/* floating divide by zero */
#define	    FPE_FLTUND_TRAP	0xa	/* floating underflow */
#define	    FPE_FOPERR_TRAP	0xb	/* operand error */
#define	    FPE_FLTOVF_TRAP	0xc	/* floating overflow */
#define	    FPE_FLTNAN_TRAP	0xd	/* NAN exception */
#endif	is68k

#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGURG	16	/* urgent condition on IO channel */
#define	SIGSTOP	17	/* sendable stop signal not from tty */
#define	SIGTSTP	18	/* stop signal from tty */
#define	SIGCONT	19	/* continue a stopped process */
#define	SIGCHLD	20	/* to parent on child stop or exit */
#define	SIGCLD	SIGCHLD	/* compatibility */
#define	SIGTTIN	21	/* to readers pgrp upon background tty read */
#define	SIGTTOU	22	/* like TTIN for output if (tp->t_local&LTOSTOP) */
#define	SIGIO	23	/* input/output possible signal */
#define	SIGXCPU	24	/* exceeded CPU time limit */
#define	SIGXFSZ	25	/* exceeded file size limit */
#define	SIGVTALRM 26	/* virtual time alarm */
#define	SIGPROF	27	/* profiling time alarm */
#define SIGWINCH 28	/* window size changes */
#define	SIGREF	SIGWINCH/* ISI: GWS: refresh window contents signal */	
#define	SIGADJ	29	/* ISI: GWS: adjust window size signal */	
#define	SIGLOST 30	/* ISI: NFS: resource lost (eg, record-lock lost) */
#define SIGUSR1 31	/* user defined signal 1 */
#define SIGUSR2 SIGADJ	/* ISI: KLUDGE: user defined signal 2 */


#ifndef KERNEL
int	(*signal())();
#endif

/*
 * Signal vector "template" used in sigvec call.
 */
struct	sigvec {
	int	(*sv_handler)();	/* signal handler */
	int	sv_mask;		/* signal mask to apply */
	int	sv_flags;		/* see signal options below */
};
#define SV_ONSTACK	0x0001	/* take signal on signal stack */
#define SV_INTERRUPT	0x0002	/* do not restart system on signal return */
#define sv_onstack sv_flags	/* isn't compatibility wonderful! */

/*
 * Structure used in sigstack call.
 */
struct	sigstack {
	char	*ss_sp;			/* signal stack pointer */
	int	ss_onstack;		/* current status */
};

/*
 * Information pushed on stack when a signal is delivered.
 * This is used by the kernel to restore state following
 * execution of the signal handler.  It is also made available
 * to the handler to allow it to properly restore state if
 * a non-standard exit is performed.
 */
struct	sigcontext {
	int	sc_onstack;		/* sigstack state to restore */
	int	sc_mask;		/* signal mask to restore */
	int	sc_sp;			/* sp to restore */
#ifdef vax
	int	sc_fp;			/* fp to retore */
	int	sc_ap;			/* ap to retore */
	int	sc_pc;			/* pc to retore */
	int	sc_ps;			/* psl to restore */
#endif
#ifdef mc68000
	int	sc_pc;			/* ISI: pc -- VAX order (not 68k)! */
	int	sc_psl;			/* ISI: pcl -- VAX order (not 68k)! */
#define	sc_ps	sc_psl
	short	sc_vector;
	short	sc_ssw;
	int	sc_faddr;
	short	sc_unused0;
	short	sc_dob;
	short	sc_unused1;
	short	sc_dib;
	short	sc_unused2;
	short	sc_iib;
	short	sc_unused3[16];
#endif
};

#define	BADSIG		(int (*)())-1
#define	SIG_DFL		(int (*)())0
#define	SIG_IGN		(int (*)())1

#ifdef KERNEL
#define	SIG_CATCH	(int (*)())2
#define	SIG_HOLD	(int (*)())3
#endif
#endif

/*
 * Macro for converting signal number to a mask suitable for
 * sigblock().
 */
#define sigmask(m)	(1 << ((m)-1))
