/* fill in kernel symbol table for symbolic address in kernel debugger */

#include <a.out.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/debug.h>

char vmunix[100] = "./vmunix";
char *core = vmunix;

#define	quit(x,y)	{ printf(x,y); exit (1);}
#define	clear(x)	((int)x & 0x0fffffff)

#define	address(x)	(clear(x) + fileoffset)

struct	nl {
	char	*n_name;	/* for use when in-core */
	unsigned char n_type;	/* type flag, i.e. N_TEXT etc; see below */
	char	n_other;	/* unused */
	short	n_desc;		/* see <stab.h> */
	unsigned long n_value;	/* value of this symbol (or sdb offset) */
};

struct	nl nl[] = {
#define	SYMTAB 0
	{ "_symtab" },
#define	SYM_SIZE 1
	{ "_sym_size" },
#define	STRTAB 2
	{ "_strtab" },
#define	STR_SIZE 3
	{ "_str_size" },
#define	SYM_MAGIC 4
	{ "_sym_magic" },
#define	ETEXT 5
	{ "_etext" },
	{ "" }
};

int compare();
int sym_size;
struct debug_nl *symtab, *ssymp;

main(argc, argv)
int argc;
char **argv;
{
	int str_size;
	register char *strtab, *strp;
	register struct nlist *sym, *esym, *symp;
	int fkern;
	struct exec header;
	int tmp;
	int magic;
	int fileoffset;

	if (argc > 2)
		quit("ksymbol: invalid arg count",0)
	else if (argc == 2)
		strcpy(vmunix,argv[1]);
	if ((fkern = open(vmunix, O_RDWR)) < 0)
		quit("ksymbol: can't open %s\n",vmunix)
	nlist(vmunix, nl);
	if (nl[SYMTAB].n_type == 0 || nl[SYM_SIZE].n_type == 0 || 
	    nl[STRTAB].n_type == 0 || nl[STR_SIZE].n_type == 0 || 
	    nl[SYM_MAGIC].n_type == 0 || nl[ETEXT].n_type == 0)
		exit(0);
	if (read(fkern, (char *)&header, sizeof header) != sizeof header ||
	    N_BADMAG(header))
		quit("ksymbol: can't reader header in %s\n",vmunix)
	if (header.a_syms == 0)
		quit("ksymbol: no symtab info in %s\n",vmunix)
	sym_size = header.a_syms/sizeof(struct nlist);

	fileoffset = sizeof(header) - clear(header.a_entry);

	if (lseek(fkern, (long)address(nl[SYM_MAGIC].n_value), 0) < 0 )
		quit("ksymbol: can't seek to magic number in %s\n",core)
	if (read(fkern, (char *)&magic, sizeof magic) != sizeof magic)
		quit("ksymbol: can't read magic no in %s\n",core)
	if (magic != DBG_MAGIC && magic != NEWDBG_MAGIC)
		quit("ksymbol: %s: magic number mismatch\n",vmunix)
	if (lseek(fkern, (long)address(nl[SYM_SIZE].n_value), 0) < 0)
		quit("ksymbol: can't seek to sym_size entry in %s\n",core)
	if (read(fkern, (char *)&tmp, sizeof tmp) != sizeof tmp)
		quit("ksymbol: can't read sym_size entry in %s\n",core)
	if (tmp < sym_size) {
	    printf("ksymbol: WARNING: symtab too small, %d allocated, %d needed\n",
		   			tmp, sym_size);
	    sym_size = tmp;
	}
	sym = (struct nlist *) malloc(header.a_syms);
	if (sym == 0)
		quit("ksymbol: can't malloc symtab\n",0)
	symtab = (struct debug_nl *) malloc(header.a_syms);
	if (symtab == 0)
		quit("ksymbol: can't malloc debug symtab\n",0)
	esym = sym + sym_size;
	if (lseek(fkern, N_SYMOFF(header), 0) < 0)
		quit("ksymbol: can't seek to symbol table in %s\n",core)
	if (read(fkern, sym, header.a_syms) != header.a_syms)
		quit("ksymbol: can't read symbol table in %s\n",vmunix)
	if (read(fkern, &str_size, sizeof (str_size)) != sizeof (str_size))
		quit("ksymbol: can't read string table size in %s\n",vmunix)
	str_size -= sizeof(str_size);
	strtab = (char *) malloc(str_size);
	if (strtab == 0)
		quit("ksymbol: can't malloc strtab\n",0)
	if (read(fkern, strtab + sizeof (str_size), str_size) != str_size)
		quit("ksymbol: can't read string table in %s\n",vmunix)
	if (nl[STR_SIZE].n_value == 0)
		quit("ksymbol: no strtab size in %s\n",vmunix)
	if (lseek(fkern, (long)address(nl[STR_SIZE].n_value), 0) < 0)
		quit("ksymbol: can't seek to str_size entry in %s\n",core)
	if (read(fkern, (char *)&tmp, sizeof tmp) != sizeof tmp)
		quit("ksymbol: can't read str_size entry in %s\n",core)
	if (tmp < str_size) {
	    printf("ksymbol: kernel strtab too small, %d allocated, %d in %s\n",
		   tmp, str_size, vmunix);
	    exit(2);
	}
	*(int *)strtab = str_size + sizeof(str_size);
	strp = (char *)clear(nl[STRTAB].n_value);
	sym_size = 0;
	for (symp = sym, ssymp = symtab; symp < esym; symp++, ssymp++)
		if (symp->n_un.n_strx) {
			ssymp->name = strp + symp->n_un.n_strx;
			ssymp->value = symp->n_value;
			sym_size++;
		}

	qsort(symtab, sym_size, sizeof(struct debug_nl), compare);
	if (lseek(fkern, (long)address(nl[SYM_SIZE].n_value), 0) < 0)
		quit("ksymbol: can't seek to sym_size entry in %s\n",core)
	if (write(fkern, (char *)&sym_size, sizeof sym_size) != sizeof sym_size)
		quit("ksymbol: can't write sym_size entry in %s\n",core)
	if (lseek(fkern, (long)address(nl[SYMTAB].n_value), 0) < 0)
		quit("ksymbol: can't seek to sym_addr entry in %s\n",core)
	if (write(fkern, (char *)symtab, (sizeof(struct debug_nl))*sym_size) 
					!= (sizeof(struct debug_nl))*sym_size)
		quit("ksymbol: can't write symtab in %s\n",core)
	if (lseek(fkern, (long)address(nl[STRTAB].n_value), 0) < 0)
		quit("ksymbol: can't seek to str_addr entry in %s\n",core)
	if (write(fkern, strtab, str_size) != str_size)
		quit("ksymbol: can't write strtab in %s\n",core)
	if (lseek(fkern, (long)address(nl[SYM_MAGIC].n_value), 0) < 0)
		quit("ksymbol: can't seek to magic entry in %s\n",core)
	magic = NEWDBG_MAGIC;
	if (write(fkern, (char *)&magic, sizeof magic) != sizeof magic)
		quit("ksymbol: can't write magic entry in %s\n",core)
	printf("ksymbol: successful patch\n");
	exit (0);
}

compare(x, y)
register struct debug_nl *x, *y;
{
	return ((x->value < y->value) ? -1 : ((x->value > y->value) ? 1 : 0));
}
