#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)shlibc:shlibc.mk	1.14"
#
#
# makefile for shared libc
# 
#
# there will be no profiled objects with shared libraries.
#

SGS=m68k
CFLAGS=-O
PCFLAGS=
PFX=
CC=$(PFX)cc
AR=ar
LORDER=$(PFX)lorder
ROOT=
LIB=$(ROOT)/lib
SHLIB=$(ROOT)/shlib
DEFLIST=
SDEFLIST=
MKSHLIB=mkshlib

# List of non-shared objects from libc-port
NONSH1=\
../port/gen/a64l.no	../port/gen/abort.no	../port/gen/assert.no 	\
../port/gen/bsearch.no	../port/gen/clock.no	../port/gen/closedir.no	\
../port/gen/ctype.no	../port/gen/ctime.no	../port/gen/dial.no	\
../port/gen/drand48.no	../port/gen/errlst.no	../port/gen/execvp.no	\
../port/sys/execl.no	../port/sys/execle.no	../port/sys/execv.no	\
../port/gen/fakcu.no							\
../port/gen/ftok.no	../port/gen/getcwd.no	../port/gen/getgrgid.no	\
../port/gen/ftw.no	../port/gen/getgrent.no	../port/gen/getpw.no	\
../port/gen/getgrnam.no	../port/gen/getlogin.no	../port/gen/getpwent.no	\
../port/gen/getpwnam.no	../port/gen/getpwuid.no	../port/gen/getut.no	\
../port/gen/hsearch.no	../port/gen/l3.no 	../port/gen/l64a.no	\
../port/gen/lfind.no	../port/gen/lsearch.no	../port/gen/modf.no	\
../port/gen/mon.no	../port/gen/nlist.no	../port/gen/opendir.no	\
../port/gen/perror.no	../port/gen/putenv.no	../port/gen/putpwent.no	\
../port/gen/qsort.no	../port/gen/rand.no	../port/gen/readdir.no	\
../port/gen/seekdir.no	../port/gen/sleep.no	../port/gen/ssignal.no	\
../port/gen/strcspn.no 	../port/gen/strdup.no	../port/gen/strpbrk.no	\
../port/gen/strspn.no	../port/gen/strtod.no	../port/gen/strtok.no	\
../port/gen/strtol.no	../port/gen/swab.no	../port/gen/tell.no	\
../port/gen/telldir.no	../port/gen/tfind.no 	../port/gen/tsearch.no   \
../port/print/vfprintf.no ../port/print/vprintf.no	../port/print/vsprintf.no \
../port/gen/ttyname.no	../port/gen/ttyslot.no	../port/stdio/clrerr.no	\
../port/stdio/ctermid.no	../port/stdio/cuserid.no	../port/stdio/data.no	\
../port/stdio/doscan.no	../port/stdio/fdopen.no	../port/stdio/ftell.no	\
../port/stdio/getpass.no	../port/stdio/popen.no	../port/stdio/rew.no	\
../port/stdio/scanf.no	../port/stdio/setvbuf.no	../port/stdio/system.no	\
../port/stdio/tempnam.no	../port/stdio/tmpfile.no	../port/stdio/tmpnam.no	\
../port/sys/lockf.no

# List of non-shared objects from libc-m68k
NONSH2=\
../m68k/gen/cuexit.o	../m68k/gen/setjmp.o	../m68k/sys/acct.o	\
../m68k/sys/alarm.o	../m68k/sys/chown.o	\
../m68k/sys/chroot.o	../m68k/sys/dup.o	\
../m68k/sys/execve.o	\
../m68k/sys/exit.o	../m68k/sys/fork.o	../m68k/sys/fstatfs.o	\
../m68k/sys/getdents.o	../m68k/sys/getegid.o	../m68k/sys/geteuid.o	\
../m68k/sys/getgid.o	../m68k/sys/getmsg.o	../m68k/sys/getppid.o	\
../m68k/sys/getuid.o	../m68k/sys/gtty.o	../m68k/sys/link.o	\
../m68k/sys/mkdir.o	../m68k/sys/mknod.o	../m68k/sys/mount.o	\
../m68k/sys/msgsys.o	../m68k/sys/nice.o	../m68k/sys/pause.o	\
../m68k/sys/pipe.o	../m68k/sys/plock.o	../m68k/sys/poll.o	\
../m68k/sys/profil.o	../m68k/sys/ptrace.o	../m68k/sys/putmsg.o	\
../m68k/sys/rmdir.o ../m68k/sys/setgid.o	\
../m68k/sys/setpgrp.o	../m68k/sys/setuid.o	\
../m68k/sys/shmsys.o	../m68k/sys/statfs.o	\
../m68k/sys/stime.o	../m68k/sys/stty.o	../m68k/sys/sync.o	\
../m68k/sys/syscall.o							\
../m68k/sys/times.o	../m68k/sys/uadmin.o	../m68k/sys/ulimit.o	\
../m68k/sys/umask.o	../m68k/sys/umount.o				\
../m68k/sys/uname.o	../m68k/sys/ustat.o	../m68k/sys/wait.o

all: 
	make -e -f shlibc.mk shared \
	PROF=# MACHINE=m68k SDEFLIST=-DSHLIB SRCDIR=../libc

shared:
	#
	# compile portable library modules
	cd port; make -e CC=$(CC) SRCDIR=$(SRCDIR)/port
	#
	# compile machine-dependent library modules
	cd $(MACHINE); make -e CC=$(CC)  SRCDIR=$(SRCDIR)/$(MACHINE)
	#
	# create the host and target modules
	-rm -f host target
	$(PFX)$(MKSHLIB) -q -s spec -t target -h host
	#
	# build the mixed archive in the temporary directory "shobject"
	-rm -rf shobject
	mkdir shobject
	cd shobject; make -e -f ../shlibc.mk mixed
	# 
	# remove temprary directory "shobject"
	-rm -rf shobject
mixed:
	#
	# extract from the host all the object files and
	# reorder the objects in the same way they are in libc.a
	#
	$(AR) -x ../host
	#
	# copy to the current directory the non-shared object files
	cp $(NONSH1) .
	cp $(NONSH2) .
	for i in *.no ; do mv $$i `basename $$i .no`.o ; done
	#
	# preserve libc.a object order
	mv cuexit.o             cuexit.x
	mv fakcu.o   		fakcu.x
	mv signal.o             signal.x
	mv kill.o               kill.x
	mv getpid.o             getpid.x
	mv cerror.o             cerror.x
	mv gen_def.o	        gen_def.x
	$(LORDER) *.o  |tsort > objlist
	mv cuexit.x	        cuexit.o
	mv fakcu.x 		fakcu.o
	mv signal.x 		signal.o
	mv kill.x 		kill.o
	mv getpid.x 		getpid.o
	mv cerror.x 		cerror.o
	mv gen_def.x 		gen_def.o
	# create mixed archive
	-rm -f ../libc_s.a
	$(AR) q ../libc_s.a  `cat objlist`  \
	signal.o kill.o getpid.o cerror.o gen_def.o cuexit.o fakcu.o hst*
	# clean up
move:
	# First change the name of the old shared library target 
	# module  so that the target just created can be installed
	# Move the shared archive into the correct directory
	# Move the target file into the correct directory
	#
	-mv $(SHLIB)/libc_s $(SHLIB)/libc_s-`date +%j\%H\%M`
	cp libc_s.a $(LIB)/libc_s.a 
	cp target $(SHLIB)/libc_s 

install:all move

clean:
	#
	# remove intermediate files
	-rm -rf *.o hst* *.x objlist 
	cd port ;  make clean
	cd m68k ;   make clean
	#
clobber:
	#
	# 
	#
	-rm -rf $(SHLIB)/libc_s-* 
	-rm -rf target libc_s.a
	-rm -rf *.o lib*.libc lib*.contents obj* hst* *.x
	cd port; make clobber;
	cd m68k ; make clobber
	# done
	#
