/*
 * $Header: signal.c,v 1.1 87/09/18 10:44:47 root Exp $
 */
/*
 * signal(n, 0);	default action on signal(n)
 * signal(n, odd);	ignore signal(n)
 * signal(n, label);	goto label on signal(n)
 *	returns old label, only one level.
 *
 * sigrte.s and sigtrap.s are also part of signal()
 */

#include <signal.h>
#include <errno.h>

#define NSIGS 32

int (*sigfunc[NSIGS])();	/* functions to be executed on signals */

typedef char	hndl[4];
extern hndl	sighnd[NSIGS];
extern long	errno;

int (*signal(sig, func))()
int (*func)();
{
	int (*sigtrap())();
	int (*old)();
	int (*rv)();

	if (sig < 0 || sig >= NSIGS) {
		errno = EINVAL;
		return((int (*)())-1);
	}
	old = sigfunc[sig];
	sigfunc[sig] = func;
	rv = sigtrap(sig, (func == SIG_DFL || func == SIG_IGN)?
			func: (int (*)())&sighnd[sig][0]);
	if ((int)rv & 1 && (int)rv != -1)
		old = rv;
	return(old);
}
