#
# $Header: t4014.mk,v 1.1 87/09/18 09:42:20 root Exp $
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)libplot:t4014/t4014.mk	1.7"

#	Makefile for t4014 library

ROOT =
LROOT =

DIR = $(ROOT)/$(LROOT)/usr/lib
USRLIB = $(DIR)

INC = $(ROOT)/usr/include

LDFLAGS =

CFLAGS = -O -I$(INC)

STRIP = strip

SIZE = size

LIST = lp

#top#
# Generated by makefile 1.47

MAKEFILE = t4014.mk

LIBRARY = lib4014.a

OBJECTS =  arc.o box.o circle.o close.o dot.o erase.o label.o line.o \
	linemod.o move.o open.o point.o scale.o space.o subr.o

SOURCES =  arc.c box.c circle.c close.c dot.c erase.c label.c line.c \
	linemod.c move.c open.c point.c scale.c space.c subr.c

ALL:		$(LIBRARY)

$(LIBRARY):	$(LIBRARY)(subr.o) $(LIBRARY)(space.o) \
		$(LIBRARY)(scale.o) $(LIBRARY)(point.o)	$(LIBRARY)(open.o) \
		$(LIBRARY)(move.o) $(LIBRARY)(linemod.o) \
		$(LIBRARY)(line.o) $(LIBRARY)(label.o) $(LIBRARY)(erase.o) \
		$(LIBRARY)(dot.o) $(LIBRARY)(close.o) $(LIBRARY)(circle.o) \
		$(LIBRARY)(box.o) $(LIBRARY)(arc.o) 


$(LIBRARY)(arc.o): 

$(LIBRARY)(box.o): 

$(LIBRARY)(circle.o):	 

$(LIBRARY)(close.o):	 $(INC)/stdio.h 

$(LIBRARY)(dot.o): 

$(LIBRARY)(erase.o):	 

$(LIBRARY)(label.o):	 

$(LIBRARY)(line.o): 

$(LIBRARY)(linemod.o):	 

$(LIBRARY)(move.o): 

$(LIBRARY)(open.o): 

$(LIBRARY)(point.o):	 

$(LIBRARY)(scale.o):	 

$(LIBRARY)(space.o):	 

$(LIBRARY)(subr.o): $(INC)/stdio.h 

GLOBALINCS = $(INC)/stdio.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(LIBRARY)

newmakefile:
	makefile -m -f $(MAKEFILE) -L $(LIBRARY)  -s INC $(INC)
#bottom#

all : ALL

install: ALL
	cpset $(LIBRARY) $(USRLIB)

size: ALL
	$(SIZE) $(LIBRARY)

strip: ALL

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(USRLIB) | tr ' ' '\012' | sort

product:
	@echo $(LIBRARY)  |  tr ' ' '\012'  | \
	sed 's;^;$(USRLIB)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(LIBRARY)

listing:
	pr -n $(MAKEFILE) $(SOURCES) | $(LIST)

listmk:
	pr -n $(MAKEFILE) | $(LIST)
