/*@(#)paslib.c	1.1 Copyright 1985 by Green Hills Software, Inc. 9/18/87 12:37:38*/
/************************************************************************/
#include <stdio.h>
#define true 1
#define false 0
struct filetype {
	char open;
	char read;
	char linemark;
	unsigned int valid : 1 ;/* is the thing in buffervar valid or not */
	unsigned int text : 1;
	unsigned int eof : 1 ;
	int elementsize;
	FILE *filevar;
/* if more fields are added above this, then the magic number FILESTRUCTSIZE in
    in pasext.h may need to be changed
    (FILESTRUCTSIZE=sizeof(filetype)-sizeof(buffervar)*/
	char buffervar;
};
/* make sure there is an eol before eof (?null file excepted?) */

struct filetype _input =  {1,1,1,0,1,0,1,stdin};
struct filetype _output = {1,0,1,0,1,1,1,stdout};

static char *copy(str) char *str ; {
    char *malloc();
    register char *pt ;

    pt = malloc(strlen(str)+1);
    strcpy( pt,str );
return( pt );
}

static char *mktemp(str) char *str ; {
    /* this is here because the standard mktemp only gives 26 names */
    static int which;
    register char *pt ;
    register unsigned int i;

    pt = str;
    str += strlen( str )-6 ;
    i=which/72;
    if ( i<=9 )
    	*(str++)= '0'+i;
    else if ( i<=35 )
    	*(str++)= 'a'-10+i;
    else
    	*(str++)= 'A'-36+i;
    i = which%72;
    if ( i<=9 )
    	*(str++)= '0'+i;
    else if ( i<=35 )
    	*(str++)= 'a'-10+i;
    else
    	*(str++)= 'A'-36+i;
    which++;
    i=getpid();
    while ( i!= 0 ) {
	if ((i&0xf)<=9 )
	    *(str++)= '0'+(i&0xf);
	else
	    *(str++)= 'a'-10+(i&0xf);
	i >>= 4;
    }
    while ( *str=='X' || *str == 'x' ) *(str++)= '0';
return( pt );
}

_rewrite(f, filename, elementsize)
struct filetype *f;
char *filename;
{
    char *mktemp();
    FILE *fopen();

    if (filename == 0)
	filename = mktemp(copy("/tmp/pasrtXXXXXX"));
    if (f->open) {
    	if (!f->linemark && f->text)
	    _writeln(f);
	fclose(f->filevar);
    }
    if ((f->filevar = fopen(filename, "w+")) == NULL) {
	perror(filename);
	exit(1);
    } else {
	f->open = true;
	f->read = false;
	f->elementsize = elementsize;
	f->linemark = true;
	f->valid = false;
	f->text = false;
	f->eof = true ;
    }
}

_put(f)
struct filetype *f;
{
    if (!f->open)
	_runtimeerror("File not open\n");
    else if (f->read)
	_runtimeerror("File not open for writing\n");
    else if (!f->valid)
    	_runtimeerror("Buffer variable undefined\n");
    else
	fwrite(&f->buffervar, f->elementsize, 1, f->filevar);
    f->valid = false ;
    f->linemark = false;
}

_writeln(f)
struct filetype *f;
{
    if(!f->open) _runtimeerror("File not open\n");
    putc('\n', f->filevar);
    f->linemark = true;
    f->text=true ;
}

_page(f)
struct filetype *f;
{
    if(!f->open) _runtimeerror("File not open\n");
    if (!f->linemark)
	_writeln(f);
    putc('\014', f->filevar);
}

_writechr(f, c, totalwidth)
struct filetype *f;
char c;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, "%*c", totalwidth, c);
    f->text=true ;
}

_writeint(f, i, totalwidth)
struct filetype *f;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, "%*d", totalwidth, i);
    f->text=true ;
}

_writeexp(f, r, totalwidth)
struct filetype *f;
double r;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
#ifdef GENIX
    fprintf(f->filevar, " %*.*e",(totalwidth-2>7)?totalwidth-2:7,
				 (totalwidth-8>1?totalwidth-8:1), r);
#else
    fprintf(f->filevar, " %*.*e",(totalwidth-1>7)?totalwidth-1:7,
				 (totalwidth-7>1?totalwidth-7:1), r);
#endif
    f->text=true ;
}

_writefix(f, r, totalwidth, fracdig)
struct filetype *f;
double r;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 || fracdig <= 0 ) 
    	_runtimeerror("Width or fracdig is not positive\n" );
    fprintf(f->filevar, "%*.*f", totalwidth, fracdig, r);
    f->text=true ;
}

_writeboo(f, b, totalwidth)
struct filetype *f;
char b;
{
    if (b == 1)
	_writestr(f, "true", totalwidth, 4);
    else
	_writestr(f, "false", totalwidth, 5);
}

_writestr(f, s, totalwidth, strlen)
struct filetype *f;
char *s;
{
    if(!f->open) _runtimeerror("File not open\n");
    if ( totalwidth<= 0 ) _runtimeerror("Width or fracdig is not positive\n" );
    if ( totalwidth < strlen )
    	strlen = totalwidth;
    fprintf(f->filevar, "%*.*s", totalwidth, strlen, s);
    f->text=true ;
}

_reset(f, filename, elementsize)
struct filetype *f;
char *filename;
{
    FILE *fopen();

    if (!f->linemark && f->open && f->text)
	_writeln(f);
    if (!f->open)
    	f->text=false ;
    if (filename != 0) {
	if (f->open)
	    fclose(f->filevar);
	if ((f->filevar = fopen(filename, "r")) == 0)
	    perror(filename);
	else {
	    f->open = true;
	    f->read = true;
	    f->elementsize = elementsize;
	}
    } else
	if (f->open) {
	    if (!f->read) {
		fflush(f->filevar);
		f->read = true;
	    }
	    fseek(f->filevar, 0, 0);
	} else
	    _runtimeerror("Cannot reset undefined file variable\n");
    f->linemark = false;	/* pascal says so */
    f->valid = false ;
    f->text = false ;
    f->eof = false ;
}

_setupfil(f) /* evar(f) */
struct filetype *f;
{
    if ( f->read && ! f->valid ) {
	_read(f, &f->buffervar);
	if (!f->eof)
	    f->valid = true ;
	f->linemark = false;
    } else if ( ! f->read )
    	f->valid = true ;
}

_eof(f)
struct filetype *f;
{
    if (!f->open) _runtimeerror("File not open\n" );
    if (!f->eof)
	_setupfil(f);
    return (f->eof);
}

_get(f)
struct filetype *f;
{
    /* this code is repeated in gettext */
    if ( !f->read )
    	_runtimeerror("File not open for reading\n");
    else if ( f->valid )
        f->valid = false ;
    else if ( f->eof )
    	_runtimeerror("Attempt to read past end of file\n");
    else if ( fseek(f->filevar, f->elementsize, 1)< 0 )
    	_runtimeerror("Attempt to read past end of file\n");
}

_read(f, v)
struct filetype *f;
char *v;
{
    register int cnt ;

    if (!f->open)
	_runtimeerror("File not open\n");
    else if (!f->read)
	_runtimeerror("File not open for reading\n");
    else if (f->eof)
	_runtimeerror("Attempt to read past end of file\n");
    else if (feof(f->filevar))
    	f->eof=true;
    else if ((cnt=fread(v, f->elementsize, 1, f->filevar)) == -1)
	_runtimeerror("File is not an even number of records long\n");
    else if (cnt==0 && f->text && ! f->linemark)
	*v = '\n';
    else if (cnt==0)
    	f->eof = true ;
    f->valid = false ;	/* since the buffervar doesn't contain it, v does */
}

_eoln(f)
struct filetype *f;
{
    if (!f->open)
	_runtimeerror("File not open\n");
    _setuptex(f);
    if ( f->eof ) _runtimeerror("Attempt to read beyond end of file\n" );
    return(f->linemark);
}

_setuptex(f) /* tfilevar(f) */
struct filetype *f;
{
    char c;

    if (f->valid) {
	if (f->buffervar == '\n' ) {
	    f->buffervar = ' ';
	    f->linemark = true;
	}
return;
    }
    f->text=true ;
    if (feof(f->filevar)) {
	fseek(f->filevar, -1, 2);
	fread(&c, 1, 1, f->filevar);
	if (c != '\n') {
	    f->valid = true;
	    f->buffervar = ' ';
	    f->linemark = true;
	}
    } else {
	_setupfil(f);
	if (f->buffervar == '\n') {
	    f->buffervar = ' ';
	    f->linemark = true ;
	} else
	    f->linemark = false ;
    }
}

_gettext(f)
struct filetype *f;
{
    int i;
    char c;

    /* this code is a copy of get */
    if ( !f->read )
    	_runtimeerror("File not open for reading\n");
    else if ( f->valid )
        f->valid = false ;
    else if ( f->eof )
    	_runtimeerror("Attempt to read past end of file\n");
    else if (fseek(f->filevar, f->elementsize, 1)< 0 )
	_setuptex(f);
/*
	fseek(f->filevar, -1, 1);
	fread(&c, 1, 1, f->filevar);
	if (c != '\n') {
	    f->valid = true;
	    f->linemark = true;
	    f->buffervar = ' ';
	} else
	    _runtimeerror("Attempt to read past end of file\n");
    } else
	_runtimeerror("Attempt to read past end of file\n");
*/
}

_readln(f)
struct filetype *f;
{
    while ( ! _eoln(f))
	_gettext(f);
    _gettext(f);
}

_readchr(f)
struct filetype *f;
{
    char ret;

    if (f->valid) {
	ungetc(f->buffervar,f->filevar);
	f->valid=false ;
    }
    if ( fscanf(f->filevar, "%c", &ret)!= 1 )
	_runtimeerror("Invalid character\n" );
    return ret;
}

_readint(f)
struct filetype *f;
{
    int ret;

    if (f->valid) {
	ungetc(f->buffervar,f->filevar);
	f->valid=false ;
    }
    if ( fscanf(f->filevar, "%d", &ret)!= 1 )
    	_runtimeerror( "Invalid integer\n" );
    return ret;
}

double _readreal(f)
struct filetype *f;
{
    double ret;

    if (f->valid) {
	ungetc(f->buffervar,f->filevar);
	f->valid=false ;
    }
    if ( fscanf(f->filevar, "%lf", &ret)!= 1 )
    	_runtimeerror( "Invalid real\n" );
    return ret;
}

_runtimeerror(msg)
char *msg;
{
	fprintf(stderr, msg);
	_exit(1);
}

_rnerr(num,linenum) int num,linenum ; {
    /* pascall runtime error msgs (in line) */
    switch(num) {
    case 1:
    	fprintf( stderr, "Array index/variable assignment out of bounds on line %d\n", linenum ); break ;
    }
#ifdef vms
    exit(1);
#else
    exit(num+1);
#endif
}

NEW(pt,size) char **pt ; int size ; {
    char *calloc();

    *pt = calloc(1,size);
    if (*pt == 0)
	_runtimeerror( "Memory Limit exceeded\n" );
}

DISPOSE(pt,size) char *pt ; int size ; {

    if ( pt == 0 )
	_runtimeerror( "Attempted to dispose NIL object\n" );
    else
	cfree( pt );
}

double _log(x) double x ; {
    double log();

    if ( x<=0.0 ) _runtimeerror("Negative or zero argument to ln\n");
return( log(x));
}

double _sqrt(x) double x ; {
    double sqrt();

    if ( x<0.0 ) _runtimeerror("Negative argument to sqrt\n");
return( sqrt(x));
}

_errno() {
    extern int errno ;

return(errno);
}

__exit() {
#ifdef vms
    exit(1);
#else
    exit(0);
#endif
}

char **_argv;
int _argc;
ARGV(argnum, dest, len)
char *dest;
{
    char *argp = _argv[argnum];

    while (*argp != '\0' && len-- > 0)
	*dest++ = *argp++;
    while (len-- > 0)
	*dest++ = ' ';
}
