#ident	"@(#):libm.mk	1.7"
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#
# makefile for libm
#
# Note that the object list given in FILES is in the order in which the files
# should be added to the archive when it is created.  If the files are not
# ordered correctly, linking of libm fails on the pdp11 and is slowed down
# on other machines.

.SUFFIXES: .no .np  .fo .fp
INC=$(ROOT)/usr/include
LIB=$(ROOT)/lib
LIBP=$(ROOT)/usr/lib/libp
USRLIB=$(ROOT)/usr/lib
LIB10NAME = libm.a
LIB81NAME = libmm.a
CFLAGS = -O
C81FLAGS = -f -20 $(CFLAGS)
AR=ar
MAKE=make

FILES = asin.no	atan.no	erf.no fabs.no floor.no fmod.no gamma.no \
	hypot.no jn.no j0.no j1.no pow.no log.no sin.no sinh.no \
	sqrt.no tan.no tanh.no exp.no matherr.no

PFILES = asin.np atan.np erf.np fabs.np floor.np fmod.np gamma.np \
	hypot.np jn.np j0.np j1.np pow.np log.np sin.np sinh.np \
	sqrt.np tan.np tanh.np exp.np matherr.np

FFILES = asin.fo atan.fo erf.fo fabs.fo floor.fo fmod.fo gamma.fo \
	hypot.fo jn.fo j0.fo j1.fo pow.fo log.fo sin.fo sinh.fo \
	sqrt.fo tan.fo tanh.fo exp.fo matherr.fo

FPFILES = asin.fp atan.fp erf.fp fabs.fp floor.fp fmod.fp gamma.fp \
	hypot.fp jn.fp j0.fp j1.fp pow.fp log.fp sin.fp sinh.fp \
	sqrt.fp tan.fp tanh.fp exp.fp matherr.fp


all: nonprof10 nonprof81 prof10 prof81 

nonprof10: $(FILES)
	-rm -f $(LIB10NAME)
	$(AR) rv $(LIB10NAME) $(FILES)

prof10: $(PFILES)
	-rm -f libp.$(LIB10NAME)
	$(AR) rv libp.$(LIB10NAME) $(PFILES)

nonprof81: $(FFILES)
	-rm -f $(LIB81NAME)
	$(AR) rv $(LIB81NAME) $(FFILES)

prof81: $(FPILES)
	-rm -f libp.$(LIB81NAME)
	$(AR) rv libp.$(LIB81NAME) $(FPFILES)

#$(LIBNAME): $(FILES)
#	if u3b15 || u3b5 || u3b2 ; then $(CC) -c -DM32 $(CFLAGS) $(?:.o=.c) ;\
#	else $(CC) -c $(CFLAGS) $(?:.o=.c) ; fi
#	$(AR) rv $(LIBNAME) $?
#	rm -f $?
#
asin.no asin.np asin.fo asin.fp: asin.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
atan.no atan.np atan.fo atan.fp: atan.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
erf.no erf.np erf.fo erf.fp: erf.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
fabs.no fabs.np fabs.fo fabs.fp: fabs.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
floor.no floor.np floor.fo floor.fp: floor.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
fmod.no fmod.np fmod.fo fmod.fp: fmod.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
gamma.no gamma.np gamma.fo gamma.fp: gamma.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
hypot.no hypot.np hypot.fo hypot.fp: hypot.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
jn.no jn.np jn.fo jn.fp: jn.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
j0.no j0.np j0.fo j0.fp: j0.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
j1.no j1.np j1.fo j1.fp: j1.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
pow.no pow.np pow.fo pow.fp: pow.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
log.no log.np log.fo log.fp: log.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
sin.no sin.np sin.fo sin.fp: sin.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
sinh.no sinh.np sinh.fo sinh.fp: sinh.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
sqrt.no sqrt.np sqrt.fo sqrt.fp: sqrt.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
tan.no tan.np tan.fo tan.fp: tan.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
tanh.no tanh.np tanh.fo tanh.fp: tanh.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
exp.no exp.np exp.fo exp.fp: exp.c $(INC)/math.h $(INC)/errno.h \
$(INC)/values.h $(INC)/sys/errno.h
matherr.no matherr.np matherr.fo matherr.fp:matherr.c $(INC)/math.h \
$(INC)/errno.h $(INC)/values.h $(INC)/sys/errno.h
#
#$(FILES): $(INC)/math.h $(INC)/values.h $(INC)/errno.h \
#		$(INC)/sys/errno.h
#
.c.no .c.np:
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(DEFLIST) $(SDEFLIST) $(INCLIST) $(CFLAGS) -c $*.c &&\
	$(NONPROF)mv $*.o $*.no
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(DEFLIST) $(INCLIST) $(CFLAGS) -c -p $*.c   && mv $(*F).o $*.np

.c~.no .c~.np:
	$(GET) s.$*.c
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(DEFLIST) $(SDEFLIST) $(INCLIST) $(CFLAGS) -c $*.c &&\
	$(NONPROF) mv $*.o $*.no
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(DEFLIST) $(INCLIST) $(CFLAGS) -c -p $*.c   && mv $(*F).o $*.np
	-rm -f $*.c

.c.fo .c.fp:
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(DEFLIST) $(SDEFLIST) $(INCLIST)$(C81FLAGS) -c $*.c &&\
	$(NONPROF) mv $*.o $*.fo
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(DEFLIST) $(INCLIST) $(C81FLAGS) -c -p $*.c   && mv $(*F).o $*.fp

.c~.fo .c~.fp:
	$(GET) s.$*.c
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(DEFLIST) $(SDEFLIST) $(INCLIST)$(C81FLAGS) -c $*.c &&\
	$(NONPROF) mv $*.o $*.fo
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(DEFLIST) $(INCLIST) $(C81FLAGS) -c -p $*.c   && mv $(*F).o $*.fp
	-rm -f $*.c

clean:
	-rm -f *.no *.np *.fo *.fp
#.c.a:;
#
#profiledlib:
#	$(MAKE) -f libm.mk -e libp.$(LIBNAME) LIBNAME=libp.$(LIBNAME) \
						CFLAGS="-p $(CFLAGS)"

install: all
	cp libm.a $(LIB)/
	cp libp.libm.a $(LIBP)/libm.a
	cp libmm.a $(LIB)/
	cp libp.libmm.a $(LIBP)/libmm.a

#clean:
#	-rm -f *.o

clobber:	clean
	-rm -f $(LIB10NAME) libp.$(LIB10NAME) $(LIB81NAME) libp.$(LIB81NAME)
