#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)libcrypt_x:libcrypt_x.mk	1.9"

#	Makefile for libcrypt

ROOT =

USRLIB = $(ROOT)/usr/lib

INC = $(ROOT)/usr/include

LDFLAGS =

CFLAGS = -O -I$(INC) 

STRIP = strip

SIZE = size

#top#
# Generated by makefile 1.47

MAKEFILE = libcrypt.mk


LIBRARY = libcrypt.a

OBJECTS =  crypt.o cryptio.o des_crypt.o des_dcrypt.o des_ncrypt.o \
	p2open.o

SOURCES =  crypt.c cryptio.c des_crypt.c des_dcrypt.c des_ncrypt.c \
	p2open.c

ALL:
	if [ -f des_dcrypt.c ] ; then \
		make -e -f libcrypt.mk $(LIBRARY) ; \
		cp $(LIBRARY) $(ROOT)/usr/lib/libcrypt.dom ; \
		make -e -f libcrypt.mk clobber ; \
		mv des_dcrypt.c des_dcrypt.dom; \
	fi
	make -e -f libcrypt.mk $(LIBRARY)
	if [ -f des_dcrypt.dom ] ; then \
		mv des_dcrypt.dom des_dcrypt.c ; \
	fi

$(LIBRARY):	$(LIBRARY)(p2open.o) $(LIBRARY)(des_ncrypt.o) \
		$(LIBRARY)(des_dcrypt.o) $(LIBRARY)(des_crypt.o) \
		$(LIBRARY)(cryptio.o) $(LIBRARY)(crypt.o) 


$(LIBRARY)(crypt.o):	 

$(LIBRARY)(cryptio.o):	 $(INC)/stdio.h \
		 $(INC)/signal.h	\
		 $(INC)/sys/signal.h 

$(LIBRARY)(des_dcrypt.o):	 

$(LIBRARY)(des_ncrypt.o):	 

$(LIBRARY)(p2open.o):	 $(INC)/stdio.h \
		 $(INC)/signal.h	\
		 $(INC)/sys/signal.h \
		 $(INC)/fcntl.h \
		 $(INC)/sys/fcntl.h 

GLOBALINCS = $(INC)/fcntl.h \
	$(INC)/signal.h \
	$(INC)/stdio.h \
	$(INC)/sys/fcntl.h \
	$(INC)/sys/signal.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(LIBRARY)

newmakefile:
	makefile -m -f $(MAKEFILE) -L $(LIBRARY)  -s INC $(INC)

#bottom#

$(LIBRARY)(des_crypt.o):	 
	if [ -s des_dcrypt.c ] ;\
	then \
		$(CC) -c $(CFLAGS) des_crypt.c ;\
	elif [ -s s.des_dcrypt.c ] ;\
	then \
		$(GET) s.des_crypt.c ;\
		$(CC) -c $(CFLAGS) des_crypt.c ;\
		rm -f des_crypt.c ;\
	else \
		$(CC) -c $(CFLAGS) -DINTERNATIONAL des_crypt.c ;\
	fi ;\
	ar rv $(LIBRARY) des_crypt.o ;\
	rm -f des_crypt.o

all : ALL

install: ALL
	if [ -f libcrypt_x.mk ] ;\
	then \
		mv $(LIBRARY) libcrypt_x.a ;\
		cpset libcrypt_x.a $(USRLIB) 0644 bin bin ;\
		mv libcrypt_x.a $(LIBRARY) ;\
	else \
		cpset $(LIBRARY) $(USRLIB) 0644 bin bin ;\
	fi 

size: ALL
	$(SIZE) $(LIBRARY)

strip: ALL

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(USRLIB) | tr ' ' '\012' | sort

product:
	@echo $(LIBRARY)  |  tr ' ' '\012'  | \
	sed 's;^;$(USRLIB)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(LIBRARY)
