/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#):getlogin.c	1.3"
/*LINTLIBRARY*/
#include <sys/types.h>
#include "utmp.h"

#define NULL 0

extern long lseek();
extern int open(), read(), close(), ttyslot();

static char utmp_file[] = "/etc/utmp";

char *
getlogin()
{
	register me, uf;
	struct utmp ubuf ;
	static char answer[sizeof(ubuf.ut_user)+1] ;

	if((me = ttyslot()) < 0)
		return(NULL);
	if((uf = open(utmp_file, 0)) < 0)
		return(NULL);
	(void) lseek(uf, (long)(me * sizeof(ubuf)), 0);
	if(read(uf, (char*)&ubuf, sizeof(ubuf)) != sizeof(ubuf)) {
		(void) close(uf);
		return(NULL);
	}
	(void) close(uf);
#ifdef	is68k
	if(ubuf.ut_name[0] == '\0')
		return(NULL);
	strncpy(&answer[0],&ubuf.ut_name[0],sizeof(ubuf.ut_name)) ;
	answer[sizeof(ubuf.ut_name)] = '\0' ;
#else	is68k
	if(ubuf.ut_user[0] == '\0')
		return(NULL);
	strncpy(&answer[0],&ubuf.ut_user[0],sizeof(ubuf.ut_user)) ;
	answer[sizeof(ubuf.ut_user)] = '\0' ;
#endif	is68k
	return(&answer[0]);
}
