#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.
#	"@(#):signal.s	1.2"

	file	"signal.s"
#   C-library signal() routine recoded for IEEE floating-point
# REMEMBER: SIGFPE is special in this environment!
#
#   In SVR3, five new system calls are added to this file. They are
#   sigset(), sighold(), sigrelse(), sigignore() and sigpause().

# **********
# Constants defined by the hardware and the OS
# **********
	set	SIGNAL,48	# second-level gate entry for signal
	set	EINVAL,22	# errno value for invalid system call
	set	SIGILL,4
	set	SIGFPE,8	# signal number for floating point

	# code no longer uses SIG_DFL, but does depend on it being 0
	set	SIG_IGN,1	# "ignore" signal
	set	SIG_HOLD,2	# "hold" signal

	# The following 5 definitions are also defined in signal.h
	set	SIGDEFER,0x100	# "defer" signal after caught one
	set	SIGHOLD,0x200	# "hold" signal
	set	SIGRELSE,0x400	# "release" signal
	set	SIGIGNORE,0x800	# "ignore" signal
	set	SIGPAUSE,0x1000	# "release" held signal and pause

# **********
# Global function names
# **********
	global	signal		# defined below
	global	sigset
	global	sighold
	global	sigignore
	global	sigrelse
	global	sigpause
	global	cerror%		# common C library error return
#
# The following is two tables of transfer vectors.
# Each table has one entry for each valid signal number.
#    tvect[] is the table of signal entry points from the kernel.
#    dvect[] is the corresponding table of user handlers.
# NSIG == number of vectors, so the  highest signal number is NSIG-1.
# tvect[0] is unused, but makes the calculations above easier.
#


	set	NSIG,0
tvect:
	bsr	savr;	set	NSIG,NSIG + 1	# entry 0, unused
			#.set	TSIZE,.-tvect	/* except to size BSBH
entry2:
	bsr	savr;	set	NSIG,NSIG + 1	# 1: SIGHUP
	bsr	savr;	set	NSIG,NSIG + 1	# 2: SIGINT
	bsr	savr;	set	NSIG,NSIG + 1	# 3: SIGQUIT
	bsr	savr;	set	NSIG,NSIG + 1	# 4: SIGILL
	bsr	savr;	set	NSIG,NSIG + 1	# 5: SIGTRAP
	bsr	savr;	set	NSIG,NSIG + 1	# 6: SIGABRT
	bsr	savr;	set	NSIG,NSIG + 1	# 7: SIGEMT
	bsr	savr;	set	NSIG,NSIG + 1	# 8: SIGFPE <-**
	bsr	savr;	set	NSIG,NSIG + 1	# 9: SIGKILL <unused>
	bsr	savr;	set	NSIG,NSIG + 1	#10: SIGBUS
	bsr	savr;	set	NSIG,NSIG + 1	#11: SIGSEGV
	bsr	savr;	set	NSIG,NSIG + 1	#12: SIGSYS
	bsr	savr;	set	NSIG,NSIG + 1	#13: SIGPIPE
	bsr	savr;	set	NSIG,NSIG + 1	#14: SIGALRM
	bsr	savr;	set	NSIG,NSIG + 1	#15: SIGTERM
	bsr	savr;	set	NSIG,NSIG + 1	#16: SIGUSR1
	bsr	savr;	set	NSIG,NSIG + 1	#17: SIGUSR2
	bsr	savr;	set	NSIG,NSIG + 1	#18: SIGCLD
	bsr	savr;	set	NSIG,NSIG + 1	#19: SIGPWR
	bsr	savr;	set	NSIG,NSIG + 1	#20: SIGWIND
	bsr	savr;	set	NSIG,NSIG + 1	#21: SIGPHONE
	bsr	savr;	set	NSIG,NSIG + 1	#22: SIGSEL

# define the parallel set of user vectors
# NOTE: the contents of dvect[i] will not correspond to the OS's idea:
#	1) for SIGKILL, where any attempt to catch, or ignore causes
#	   the kernel to return EINVAL to the signal() call.
#	2) if signal() is used and a signal has been caught,
#	   changing the handler to SIG_DFL.
#	3) if sigset() is used and a signal has been caught,
#	   holding subsequent signals of the same type.

	data	# define the parallel set of user vectors
	even
_m4_ifdef_(`SHLIB',
`',
`dvect:		zero	NSIG * 4	# and initialize to SIG_DFL
')
setflg:
	space	NSIG 		# sigset flag vector
	text
#
# **********
# Definition of signal entry point from the kernel
# **********
#
# SAVR: common entry point for all 
# The stack upon entry to savr is:
#
#	%sp ->	|		|
#		+---------------+
#		| tvect ret.	| <- address of tvect[n+1]
#		+===============+
#		| trapped PSW	| : GATE
#		+---------------+
#		| trapped PC	|
#		+===============+
#		| user stack	|
#
# Before doing anything we must save registers
# We then use the tvect return address to calculate our signal number,
# call the user handler, restore the registers, and return to the user.
savr:

	movm.l	&0xFFFE,-(%sp)		# save all regs 
	# calculate the signal number from the tvect return point
	mov.l	60(%sp),%d2		# pc after jsr 
	sub.l	&entry2,%d2		#  signal number * 4 
	mov.l	%d2,%a0
	asr.l	&2,%d2			#  signal number 
	# the user handler is passed one argument: the signal number
	mov.l	%d2,-(%sp)		# argument to function 
	add.l	&dvect,%a0		# tbl of signal functions 
	mov.l	(%a0),%a0		# fetch pointer to function 
	jsr	(%a0)			# in C terms: (*dvect[sig])(sig) 
	add.l	&4,%sp			# pop argument 
	lea	setflg,%a0
	add.l	%d2,%a0
	tst.b	(%a0)			# check to see whether it is
					# sigset or signal	
					# if sigset, release held signal 
	beq	norelse
	mov.l	%d2,-(%sp)
	jsr	sigrelse
	add.l	&4,%sp			# pop off arg 
norelse:
	movm.l	(%sp)+,&0x7FFF		# restore regs 
	add.l	&14,%sp			# clean up pc from jsr in handler
					# and pad, code, signo
	mov.w	(%sp)+,%cc		# restore status register 
	rts				# return 
#
# ******************
# Definition of sighold()
# ******************
#
# sighold(n)		/* hold signal n */
#
sighold:
	MCOUNT

	# is the signal number valid?  (0 < n < NSIG)
	tst.l	4(%sp)
	ble	L%ninvalid
	cmp.l	4(%sp),&NSIG
	bge	L%ninvalid

	or.l	&SIGHOLD,4(%sp)		# turn on SIGHOLD bit
	jmp 	L%nost

#
# ******************
# Definition of sigrelse()
# ******************
#
# sigrelse(n)		/* release signal n if there is one held */
#

sigrelse:
	MCOUNT

	# is the signal number valid?  (0 < n < NSIG)
	tst.l	4(%sp)
	ble	L%ninvalid
	cmp.l	4(%sp),&NSIG
	bge	L%ninvalid

	or.l	&SIGRELSE,4(%sp)	# turn on SIGRELSE bit
	jmp	L%nost

#
#************************
# Definition of sigignore()
# **********************
#
# sigignore(n)
#
#
sigignore:
	MCOUNT

	# is the signal number valid?  (0 < n < NSIG)
	tst.l	4(%sp)
	ble	L%ninvalid
	cmp.l	4(%sp),&NSIG
	bge	L%ninvalid

	or.l	&SIGIGNORE,4(%sp)		# turn on SIGIGNORE
	jmp	L%nost

#
#************************
# Definition of sigpause()
# **********************
#
# sigpause(n)
#
#
sigpause:
	MCOUNT

	# is the signal number valid?  (0 < n < NSIG)
	tst.l	4(%sp)
	ble	L%ninvalid
	cmp.l	4(%sp),&NSIG
	bge	L%ninvalid

	or.l	&SIGPAUSE,4(%sp)		# turn on SIGPAUSE bit
	#jmp	L%nost
L%nost:						# common gate instruction
	mov.l	4(%sp),%a0
	mov.l	&SIGNAL,%d0
	trap	&0
	bcc	noerror
	jmp	cerror%
noerror:
	rts

L%ninvalid:				# common error routine
	mov.l &EINVAL,%d0		# put error number in d0
	jmp	cerror%

#
# ************
# Definition of sigset()
# ************
#
# sigset(n, SIG_DFL); 	/* default action on signal n */
# sigset( n, SIG_IGN);	/* ignore signal n		*/
# sigset( n, handler);	/* call user handler on signal	*/
#
sigset:
	MCOUNT
	link	%fp,&0
	mov.l 	&1,%d1	# use d1 as the flag for sigset
	jmp 	L%sig1

#
# **********
# Definition of signal()
# **********
#
# signal( n, SIG_DFL);	/* default action on signal n	*/
# signal( n, SIG_IGN);	/* ignore signal n		*/
# signal( n, handler);	/* call user handler on signal	*/

signal:
	MCOUNT
	link	%fp,&0
	mov.l 	&0,%d1	# specify that this is signal()
L%sig1:

	# is the signal number valid?  (0 < n < NSIG)
	tst.l	8(%fp)
	ble	L%invalid
	cmp.l	8(%fp),&NSIG
	bge	L%invalid

	mov.l	8(%fp),%d0	# convert signal number into offset
	asl.l	&2,%d0		# into a table of 4-byte vectors

	lea	dvect,%a1
	add.l	%d0,%a1
	mov.l	(%a1),-(%sp)	# save old user entry at top of stack

	# if the signal action is changing from anything to DFL, IGN
	# or HOLD,
	# must call the OS before updating dvect[]
	cmp.l	12(%fp),&SIG_HOLD
	bls	L%sig3

	# update dvect[n] before issuing the system call
	mov.l	12(%fp),(%a1)

	# and replace user entry by signal's own tvect[n]
	mov.l	8(%fp),%d0	# index into tvect[] table
	asl.l	&2,%d0		# multiply by 4, to get byte offset 
	lea	tvect,%a0
	add.l	%d0,%a0
	mov.l	%a0,12(%fp)
L%sig3:
	mov.l 	8(%fp),%d0
	lea	setflg,%a0
	add.l	%d0,%a0
	clr.b	(%a0)			# setflg ==1 for sigset
					# setflg == 0 for signal
	tst.l	%d1			# if signal, don't turn on the
					# SIGDEFER flag
	beq	L%ost
	or.l	&SIGDEFER,8(%fp)	# turn on SIGDEFER bit for sigset
	mov.b	&1,(%a0)		# turn on setflg to remember
					# that common code was entered
					# from sigset instead of signal
L%ost:
	mov.l	8(%fp),%a0
	mov.l	12(%fp),%d1
	mov.l	%d1,-(%sp)		# push second arg
	mov.l	%a0,-(%sp)		# push first arg
	mov.l	&0,-(%sp)		# push 0 (kernel expects ret pc there)
	mov.l	&SIGNAL,%d0
	trap	&0
	add.l	&12,%sp
	bcs	L%_cerror0		# if kernel returned error

	# The kernel will return SIG_IGN, SIG_DFL, SIG_HOLD or the old handler.
	# This may be different from the value pushed IF
	# a signal has been handled, re-setting the kernel to SIG_DFL
	# while the signal code still thinks a handler is attached.
	# ALWAYS believe the kernel.
	cmp.l	%d0,&SIG_HOLD		# if SIG_DFL, SIG_IGN or SIG_HOLD
	bls	L%around		# return this action to user

	# kernel returned the old handler (tvect[n], not dvect[n])
	# so replace with the old value of dvect[n] off the stack
	mov.l	(%sp)+,%d0

L%around:
	# if we did not update dvect[] above and 4(%ap) is DFL or IGN,
	# and we need to update dvect[] here.
	cmp.l	12(%fp),&SIG_IGN
	bhi	L%around2
	mov.l	12(%fp),(%a1)

L%around2:
	mov	%d0,%a0			# For the sake of Rel 1.0 compiler
	unlk	%fp
	rts

L%invalid:
	mov.l	&EINVAL,%d0	# put error number in d0
L%_cerror0:
				# go to common library error return,
	unlk	%fp
	jmp	cerror%		# which moves d0 to errno, returns -1

