#
# $Header: libI77.mk,v 1.1 87/09/17 22:42:10 root Exp $
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)libI77:libI77.mk	1.13"
# F77 I/O library (libI77.a) makefile
#
.SUFFIXES: .no .np .fo .fp
CC = cc
AR = ar
RM=/bin/rm
STRIP = strip
MAKE=make
CFLAGS = -O -DGHS
C81FLAGS = -f -20 $(CFLAGS)
INS = install
LIB=$(ROOT)/lib
LIBP=$(ROOT)/usr/lib/libp
VARIANT = I77
LIB10NAME = libI77.a
LIB81NAME = libmI77.a
AR=ar
MAKE=make


FILES =	Version.no backspace.no dfe.no due.no iio.no \
	inquire.no rewind.no rsfe.no rdfmt.no sue.no \
	uio.no wsfe.no sfe.no fmt.no nio.no lio.no \
	lread.no open.no close.no util.no endfile.no \
	wrtfmt.no err.no fmtlib.no ecvt.no ltostr.no

PFILES = Version.np backspace.np dfe.np due.np iio.np \
	inquire.np rewind.np rsfe.np rdfmt.np sue.np \
	uio.np wsfe.np sfe.np fmt.np nio.np lio.np \
	lread.np open.np close.np util.np endfile.np \
	wrtfmt.np err.np fmtlib.np ecvt.np ltostr.np

FFILES = Version.fo backspace.fo dfe.fo due.fo iio.fo \
	inquire.fo rewind.fo rsfe.fo rdfmt.fo sue.fo \
	uio.fo wsfe.fo sfe.fo fmt.fo nio.fo lio.fo \
	lread.fo open.fo close.fo util.fo endfile.fo \
	wrtfmt.fo err.fo fmtlib.fo ecvt.fo ltostr.fo

FPFILES = Version.fp backspace.fp dfe.fp due.fp iio.fp \
	inquire.fp rewind.fp rsfe.fp rdfmt.fp sue.fp \
	uio.fp wsfe.fp sfe.fp fmt.fp nio.fp lio.fp \
	lread.fp open.fp close.fp util.fp endfile.fp \
	wrtfmt.fp err.fp fmtlib.fp ecvt.fp ltostr.fp


all: nonprof10 nonprof81 prof10 prof81 

nonprof10: $(FILES)
	-rm -f $(LIB10NAME)
	$(AR) rv $(LIB10NAME) $(FILES)

prof10: $(PFILES)
	-rm -f libp.$(LIB10NAME)
	$(AR) rv libp.$(LIB10NAME) $(PFILES)

nonprof81: $(FFILES)
	-rm -f $(LIB81NAME)
	$(AR) rv $(LIB81NAME) $(FFILES)

prof81: $(FPILES)
	-rm -f libp.$(LIB81NAME)
	$(AR) rv libp.$(LIB81NAME) $(FPFILES)


Version.no Version.np Version.fo Version.fp: Version.c
backspace.no backspace.np backspace.fo backspace.fp: backspace.c
dfe.no dfe.np dfe.fo dfe.fp: dfe.c
due.no due.np due.fo due.fp: due.c
iio.no iio.np iio.fo iio.fp: iio.c
inquire.no inquire.np inquire.fo inquire.fp: inquire.c
rewind.no rewind.np rewind.fo rewind.fp: rewind.c
rsfe.no rsfe.np rsfe.fo rsfe.fp: rsfe.c
rdfmt.no rdfmt.np rdfmt.fo rdfmt.fp: rdfmt.c
sue.no sue.np sue.fo sue.fp: sue.c
uio.no uio.fp uio.fo uio.fp: uio.c
wsfe.no wsfe.np wsfe.fo wsfe.fp: wsfe.c
sfe.no sfe.np sfe.fo sfe.fp: sfe.c
fmt.no fmt.np fmt.fo fmt.fp: fmt.c
nio.no nio.np nio.fo nio.fp: nio.c
lio.no lio.np lio.fo lio.fp: lio.c
lread.no lread.np lread.fo lread.fp: lread.c
open.no open.np open.fo open.fp: open.c
close.no close.np close.fo close.fp: close.c
util.no util.np util.fo util.fp: util.c
endfile.no endfile.np endfile.fo endfile.fp: endfile.c
wrtfmt.no wrtfmt.np wrtfmt.fo wrtfmt.fp: wrtfmt.c
err.no err.np err.fo err.fp: err.c
fmtlib.no fmtlib.np fmtlib.fo fmtlib.fp: fmtlib.c
ecvt.no ecvt.np ecvt.fo ecvt.fp: ecvt.c
ltostr.no ltostr.np ltostr.fo ltostr.fp: ltostr.c

# 
.c.no .c.np:
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(CFLAGS) -c $*.c && $(NONPROF)mv $*.o $*.no
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(CFLAGS) -c -p $*.c   && mv $(*F).o $*.np

.c~.no .c~.np:
	$(GET) s.$*.c
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(CFLAGS) -c $*.c && $(NONPROF) mv $*.o $*.no
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(CFLAGS) -c -p $*.c   && mv $(*F).o $*.np
	-rm -f $*.c

.c.fo .c.fp:
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(C81FLAGS) -c $*.c && 	$(NONPROF) mv $*.o $*.fo
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(C81FLAGS) -c -p $*.c   && mv $(*F).o $*.fp

.c~.fo .c~.fp:
	$(GET) s.$*.c
	$(NONPROF)@echo $*.c:
	$(NONPROF)$(CC) $(C81FLAGS) -c $*.c && 	$(NONPROF) mv $*.o $*.fo
	$(PROF)@echo $*.c:
	$(PROF)$(CC) $(C81FLAGS) -c -p $*.c   && mv $(*F).o $*.fp
	-rm -f $*.c


install: all
	cp $(LIB10NAME) $(LIB)/$(LIB10NAME)
	cp $(LIB81NAME) $(LIB)/$(LIB81NAME)
	cp libp.$(LIB10NAME) $(LIBP)/$(LIB10NAME)
	cp libp.$(LIB81NAME) $(LIBP)/$(LIB81NAME)
clean:
	-rm -f *.no *.np *.fo *.fp *.o

clobber:	clean
	-rm -f $(LIB10NAME) $(LIB81NAME) libp.$(LIB10NAME) libp.$(LIB81NAME)

