/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)whodo:whodo.c	1.1"

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "/usr/.include.BSD/a.out.h"
#include <utmp.h>
#include <pwd.h>
#include <sys/param.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/fcntl.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <machine/pte.h>
#include <sys/vm.h>
#include <sys/stat.h>
#include <math.h>
#include <errno.h>
#include <dirent.h>
#include <sys/utsname.h>

char *nl_names[] = {
	"_proc",
#define	X_PROC		0
	"_Usrptmap",
#define	X_USRPTMAP	1
	"_usrpt",
#define	X_USRPT		2
	"_nswap",
#define	X_NSWAP		3
	"_maxslp",
#define	X_MAXSLP	4
	"_nproc",
#define	X_NPROC		5
	"_dmmin",
#define	X_DMMIN		6
	"_dmmax",
#define	X_DMMAX		7
	""
};

struct nlist *nl;			/* all because we can't init unions */
int nllen;				/* # of nlist entries */

char *nlistf = "/vmunix";
char *kmemf = "/dev/kmem";
char *memf = "/dev/mem";
char *swapf = "/dev/drum";
char *utmpf = "/etc/utmp";
char *arg0;
int	kmem, mem, swap = -1, npr, pcbpf, argaddr;
int	nswap, nproc, dmmin, dmmax, Syssize, nttys;
struct	pte *Usrptmap, *usrpt, *Sysmap;

struct	proc *proc;
union {
	struct	user user;
	char	upages[UPAGES][NBPG];
} user;
#define u	user.user

long	lseek();
off_t	vtophys();

struct	ttys {
	dev_t	ttyd;
	int cand;
	char	name[DIRSIZ+1];
} *allttys;
int cand[16] = {-1, -1, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, -1};
struct lttys {
	struct ttys ttys;
	struct lttys *next;
} *lallttys;

struct smallu {
	dev_t	su_tty;
	long	su_tm;
	char	su_comm[DIRSIZ+1];
} *smallu;

struct utmp    *ut;
struct tm      *tm;
struct proc    *p, *proc;
unsigned        utmpend;
struct tm       *localtime();
char            *malloc();
char            *getty();

main(argc, argv)
char **argv;
{
	register i, j, procp;
	long clock;
	struct utsname uts;

        arg0 = argv[0];

        /**
         * print current time and date
         **/
        time(&clock);
        printf("%s", ctime(&clock));

        /**
         * print system name
         **/
        uname(&uts);
        printf("%s\n", uts.sysname);

	openfiles();
	getkvars();
	procp = getw(nl[X_PROC].n_value);
	nproc = getw(nl[X_NPROC].n_value);

	smallu = (struct smallu *)malloc(nproc * sizeof(struct smallu));
	if (smallu == NULL) {
		fprintf(stderr, "malloc error of user table\n");
		exit(1);
	}

	j = nproc * sizeof(struct proc);
	if ((proc = malloc(j)) == NULL) {
		fprintf(stderr, "malloc error of proc table\n");
		exit(1);
	}
	klseek(kmem, (long)procp, 0);
	if (read(kmem, (char *)proc, j) != j) {
		fprintf(stderr, "can't read proc table\n");
		exit(1);
	}
	
        /**
         * gather uarea and plug in applicable data
         * into the process table slot mask
         */
	for (i = 0 ; i < nproc; i++) {
                if (!proc[i].p_stat
		    || proc[i].p_stat==SZOMB || proc[i].p_stat==SIDL)
			continue;
		if (getu(i) == 0)
			proc[i].p_stat = 0;
	}

        /**
         * loop through utmp file, printing process info
         * about each logged in user
         **/
        for(; ut < (struct utmp *)utmpend; ut++) {
		for (i = 0 ; i < nttys ; i++)
			if (strncmp(ut->ut_line, allttys[i].name, DIRSIZ) == 0)
				break;
		if (i >= nttys)
			continue;

                tm = localtime(&ut->ut_time);
                printf("\n%-8.8s %-8.8s %2.1d:%2.2d\n",
                        ut->ut_line, ut->ut_name, tm->tm_hour, tm->tm_min);
		sproc(i);
        }
}

sproc(j)
int j;
{
        register struct proc    *p;
        register struct smallu   *up;
        register int i;
	register long time;
	dev_t ttyd = allttys[j].ttyd;
	char * line = allttys[j].name;


	for (i = 0 ; i < nproc; i++) {
		p = &proc[i];
		up = &smallu[i];
		if (up->su_tty == ttyd) {
                        if(p->p_stat == SZOMB || p->p_stat == SIDL)
                                printf("    %-7.7s %5d %4.1ld:%2.2ld %s\n",
                                        "  ?", p->p_pid, 0L, 0L, "<defunct>");
                        else {
                                printf("    %-7.7s %5d %4.1ld:%2.2ld %s\n",
                                        line, p->p_pid, up->su_tm/60L,
					up->su_tm%60L, up->su_comm);
                        }
                }
        }
}

getw(loc)
	unsigned long loc;
{
	int word;

	klseek(kmem, (long)loc, 0);
	if (read(kmem, (char *)&word, sizeof (word)) != sizeof (word))
		fprintf(stderr, "error reading kmem at %x\n", loc);
	return (word);
}

klseek(fd, loc, off)
	int fd, off;
	long loc;
{
	(void) lseek(fd, (long)loc, off);
}

openfiles()
{
	struct stat     sbuf;
	int fd;
	unsigned size;

	if ((kmem = open(kmemf, 0)) < 0) {
		perror(kmemf);
		exit(1);
	}
	if ((mem = open(memf, 0)) < 0) {
		perror(memf);
		exit(1);
	}
	if ((swap = open(swapf, 0)) < 0) {
		perror(swapf);
		exit(1);
	}

        /**
         * read in current /etc/utmp file
         **/
        if(stat(utmpf, &sbuf) == -1) {
		perror(utmpf);
                exit(1);
        }
        size = (unsigned)sbuf.st_size;
        if((ut = (struct utmp *)malloc(size)) == NULL) {
                fprintf(stderr, "malloc error of utmp file\n");
                exit(1);
        }
        if((fd = open(utmpf, O_RDONLY)) == -1) {
		perror(utmpf);
                exit(1);
        }
        if(read(fd, (char *)ut, size) == -1) {
		perror(utmpf);
                exit(1);
        }
        utmpend = (unsigned)ut + size;  /* ptr to end of utmp data */
        close(fd);
}

getkvars(argc, argv)
	char **argv;
{
	init_nlist();
	nlist(nlistf, nl);
	nttys = 0;

	getdev();

	if (nl[0].n_type == 0) {
		fprintf(stderr, "%s: No namelist\n", nlistf);
		exit(1);
	}
	usrpt = (struct pte *)nl[X_USRPT].n_value;
	Usrptmap = (struct pte *)nl[X_USRPTMAP].n_value;
	klseek(kmem, (long)nl[X_NSWAP].n_value, 0);
	if (read(kmem, (char *)&nswap, sizeof (nswap)) != sizeof (nswap)) {
		fprintf(stderr, "cant read /dev/swap\n");
		exit(1);
	}
	dmmin = getw(nl[X_DMMIN].n_value);
	dmmax = getw(nl[X_DMMAX].n_value);
}


struct	dirent *dbuf;
int	dialbase;

getdev()
{
	register DIR *df;
	struct ttys *t;
	struct lttys *lt;

	if (chdir("/dev") < 0) {
		perror("/dev");
		exit(1);
	}
	dialbase = -1;
	if ((df = opendir(".")) == NULL) {
		fprintf(stderr, "Can't open . in /dev\n");
		exit(1);
	}
	while ((dbuf = readdir(df)) != NULL) 
		maybetty();
	closedir(df);
	allttys = (struct ttys *)malloc(sizeof(struct ttys)*nttys);
	if (allttys == NULL) {
		fprintf(stderr, "ps: Can't malloc space for tty table\n");
		exit(1);
	}
	for (lt = lallttys, t = allttys; lt ; lt = lt->next, t++)
		*t = lt->ttys;
}

/*
 * Attempt to avoid stats by guessing minor device
 * numbers from tty names.  Console is known,
 * know that r(hp|up|mt) are unlikely as are different mem's,
 * floppy, null, tty, etc.
 */
maybetty()
{
	register char *cp = dbuf->d_name;
	static struct lttys *dp;
	struct lttys *olddp;
	int x, i;
	struct stat stb;

	switch (cp[0]) {

	case 'c':
		if (!strcmp(cp, "console")) {
			x = 0;
			goto donecand;
		}
		/* cu[la]? are possible!?! don't rule them out */
		break;

	case 'd':
		if (!strcmp(cp, "drum"))
			return;
		break;

	case 'f':
		if (!strcmp(cp, "floppy"))
			return;
		break;

	case 'k':
		cp++;
		if (*cp == 'U')
			cp++;
		goto trymem;

	case 'r':
		cp++;
#define is(a,b) cp[0] == 'a' && cp[1] == 'b'
		if (is(h,p) || is(r,a) || is(u,p) || is(h,k) 
		    || is(r,b) || is(m,t)) {
			cp += 2;
			if (isdigit(*cp) && cp[2] == 0)
				return;
		}
		break;

	case 'm':
trymem:
		if (cp[0] == 'm' && cp[1] == 'e' && cp[2] == 'm' && cp[3] == 0)
			return;
		if (cp[0] == 'm' && cp[1] == 't')
			return;
		break;

	case 'n':
		if (!strcmp(cp, "null"))
			return;
		if (!strncmp(cp, "nrmt", 4))
			return;
		break;

	case 'p':
		if (cp[1] && cp[1] == 't' && cp[2] == 'y')
			return;
		break;

	case 'v':
		if ((cp[1] == 'a' || cp[1] == 'p') && isdigit(cp[2]) &&
		    cp[3] == 0)
			return;
		break;
	}
	for (cp = dbuf->d_name, i = 0 ; i < DIRSIZ && *cp ; i++, cp++);
	cp--;
	x = 0;
	if (cp[-1] == 'd') {
		if (dialbase == -1) {
			if (stat("ttyd0", &stb) == 0)
				dialbase = stb.st_rdev & 017;
			else
				dialbase = -2;
		}
		if (dialbase == -2)
			x = 0;
		else
			x = 11;
	}
	if (cp > dbuf->d_name && isdigit(cp[-1]) && isdigit(*cp))
		x += 10 * (cp[-1] - ' ') + cp[0] - '0';
	else if (*cp >= 'a' && *cp <= 'f')
		x += 10 + *cp - 'a';
	else if (isdigit(*cp))
		x += *cp - '0';
	else
		x = -1;
donecand:
	olddp = dp;
	dp = (struct lttys *)malloc(sizeof(struct lttys));
	if (dp == NULL) {
		fprintf(stderr, "ps: Can't malloc space for tty table\n");
		exit(1);
	}
	if (lallttys == NULL)
		lallttys = dp;
	nttys++;
	if (olddp)
		olddp->next = dp;
	dp->next = NULL;
	(void) strncpy(dp->ttys.name, dbuf->d_name, DIRSIZ);
	if (stat(dp->ttys.name, &stb) == 0 &&
	   (stb.st_mode&S_IFMT)==S_IFCHR)
		dp->ttys.ttyd = x = stb.st_rdev;
	else {
		nttys--;
		if (lallttys == dp)
			lallttys = NULL;
		free(dp);
		dp = olddp;
		if (dp)
			dp->next = NULL;
		return;
	}
	if (x == -1)
		return;
	x &= 017;
	dp->ttys.cand = cand[x];
	cand[x] = nttys-1;
}

getu(j)
int j;
{
	struct pte *pteaddr, apte, arguutl[UPAGES+CLSIZE];
	register int i, ncl, size;
	struct proc *mproc = &proc[j];

	size = sizeof (struct user);
	if ((mproc->p_flag & SLOAD) == 0) {
		if (swap < 0)
			return (0);
		(void) lseek(swap, (long)dtob(mproc->p_swaddr), 0);
		if (read(swap, (char *)&user.user, size) != size) {
			fprintf(stderr, "ps: cant read u for pid %d from %s\n",
			    mproc->p_pid, swapf);
			return (0);
		}
		pcbpf = 0;
		argaddr = 0;
		goto settty;
	}
	pteaddr = &Usrptmap[btokmx(mproc->p_p0br) + mproc->p_szpt - 1];
	klseek(kmem, (long)pteaddr, 0);
	if (read(kmem, (char *)&apte, sizeof(apte)) != sizeof(apte)) {
		printf("ps: cant read indir pte to get u for pid %d from %s\n",
		    mproc->p_pid, kmemf);
		return (0);
	}
	lseek(mem,
	    (long)ctob(apte.pg_pfnum+1) - (UPAGES+CLSIZE) * sizeof (struct pte),
		0);
	if (read(mem, (char *)arguutl, sizeof(arguutl)) != sizeof(arguutl)) {
		printf("ps: cant read page table for u of pid %d from %s\n",
		    mproc->p_pid, memf);
		return (0);
	}
	if (arguutl[0].pg_fod == 0 && arguutl[0].pg_pfnum)
		argaddr = ctob(arguutl[0].pg_pfnum);
	else
		argaddr = 0;
	pcbpf = arguutl[CLSIZE].pg_pfnum;
	ncl = (size + NBPG*CLSIZE - 1) / (NBPG*CLSIZE);
	while (--ncl >= 0) {
		i = ncl * CLSIZE;
		lseek(mem, (long)ctob(arguutl[CLSIZE+i].pg_pfnum), 0);
		if (read(mem, user.upages[i], CLSIZE*NBPG) != CLSIZE*NBPG) {
			printf("ps: cant read page %d of u of pid %d from %s\n",
			    arguutl[CLSIZE+i].pg_pfnum, mproc->p_pid, memf);
			return(0);
		}
	}
settty:
	smallu[j].su_tty = u.u_ttyd;
	smallu[j].su_tm = u.u_ru.ru_utime.tv_sec + u.u_ru.ru_stime.tv_sec;
	strncpy(smallu[j].su_comm, u.u_comm, DIRSIZ);
	return (1);
}


/*
 * Given a base/size pair in virtual swap area,
 * return a physical base/size pair which is the
 * (largest) initial, physically contiguous block.
 */
vstodb(vsbase, vssize, dmp, dbp, rev)
	register int vsbase;
	int vssize;
	struct dmap *dmp;
	register struct dblock *dbp;
{
	register int blk = dmmin;
	register swblk_t *ip = dmp->dm_map;

	vsbase = ctod(vsbase);
	vssize = ctod(vssize);
	if (vsbase < 0 || vsbase + vssize > dmp->dm_size)
		printf("vstodb");
	while (vsbase >= blk) {
		vsbase -= blk;
		if (blk < dmmax)
			blk *= 2;
		ip++;
	}
	if (*ip <= 0 || *ip + blk > nswap)
		printf("vstodb *ip");
	dbp->db_size = vssize > (blk - vsbase) ? (blk - vsbase) : vssize;
	dbp->db_base = *ip + (rev ? blk - (vsbase + dbp->db_size) : vsbase);
}

/*
 * This routine was stolen from adb to simulate memory management
 * on the VAX.
 */
off_t
vtophys(loc)
long	loc;
{
	register	p;
	off_t	newloc;
	int	mask;

	mask = 0xF0000000;
	newloc = loc & ~mask;
	p = btop(newloc);
	if ((loc & mask) == 0) {
		fprintf(stderr, "Vtophys: translating non-kernel address\n");
		return((off_t) -1);
	}
	if (p >= Syssize) {
		fprintf(stderr, "Vtophys: page out of bound (%d>=%d)\n",
			p, Syssize);
		return((off_t) -1);
	}
	if (Sysmap[p].pg_v == 0
	&& (Sysmap[p].pg_fod || Sysmap[p].pg_pfnum == 0)) {
		fprintf(stderr, "Vtophys: page not valid\n");
		return((off_t) -1);
	}
	loc = (long) (ptob(Sysmap[p].pg_pfnum) + (loc & PGOFSET));
	return(loc);
}

/*
 * since we can't init unions, the cleanest way to use a.out.h instead
 * of nlist.h (required since nlist() uses some defines) is to do a
 * runtime copy into the nl array -- sigh
 */
init_nlist()
{
	register struct nlist *np;
	register char **namep;

	nllen = sizeof nl_names / sizeof (char *);
	np = nl = (struct nlist *) malloc(nllen * sizeof (struct nlist));
	if (np == NULL) {
		fprintf(stderr, "ps: out of memory allocating namelist\n");
		exit(1);
	}
	namep = &nl_names[0];
	while (nllen > 0) {
		np->n_un.n_name = *namep;
		if (**namep == '\0')
			break;
		namep++;
		np++;
	}
}

/*
 * nlist - retreive attributes from name list (string table version)
 * 	modified to add wait channels - Charles R. LaBrec 8/85
 */
nlist(name, list)
	char *name;
	struct nlist *list;
{
	register struct nlist *p, *q;
	register char *s1, *s2;
	register n, m;
	int maxlen, nreq, type;
	FILE *f, *sf;
	off_t sa, ss;
	struct exec buf;
	struct nlist space[BUFSIZ/sizeof (struct nlist)];
	char nambuf[BUFSIZ];

	maxlen = 0;
	for (q = list, nreq = 0; q->n_un.n_name && q->n_un.n_name[0]; q++, nreq++) {
		q->n_type = 0;
		q->n_value = 0;
		q->n_desc = 0;
		q->n_other = 0;
		n = strlen(q->n_un.n_name);
		if (n > maxlen)
			maxlen = n;
	}
	f = fopen(name, "r");
	if (f == NULL)
		return (-1);
	fread((char *)&buf, sizeof buf, 1, f);
	if (N_BADMAG(buf)) {
		fclose(f);
		return (-1);
	}
	sf = fopen(name, "r");
	if (sf == NULL) {
		/* ??? */
		fclose(f);
		return(-1);
	}
	sa = N_SYMOFF(buf);
	ss = sa + buf.a_syms;
	n = buf.a_syms;
	fseek(f, sa, 0);
	while (n) {
		m = sizeof (space);
		if (n < m)
			m = n;
		if (fread((char *)space, m, 1, f) != 1)
			break;
		n -= m;
		for (q = space; ((int)(m -= sizeof(struct nlist))) >= 0; q++) {
			if (q->n_un.n_strx == 0 || q->n_type & N_STAB)
				continue;
			/*
			 * since we know what type of symbols we will get,
			 * we can make a quick check here -- crl
			 */
			type = q->n_type & (N_TYPE | N_EXT);
			if ((q->n_type & N_TYPE) != N_ABS
			    && type != (N_EXT | N_DATA)
			    && type != (N_EXT | N_BSS))
				continue;
			fseek(sf, ss+q->n_un.n_strx, 0);
			fread(nambuf, maxlen+1, 1, sf);
			for (p = list; p->n_un.n_name && p->n_un.n_name[0]; p++) {
				s1 = p->n_un.n_name;
				s2 = nambuf;
				if (strcmp(p->n_un.n_name, nambuf) == 0) {
					p->n_value = q->n_value;
					p->n_type = q->n_type;
					p->n_desc = q->n_desc;
					p->n_other = q->n_other;
					--nreq;
					break;
				}
			}
		}
	}
alldone:
	fclose(f);
	fclose(sf);
	return (nreq);
}
