/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)umount.c	1.2"
#include <stdio.h>
#include <mntent.h>
#include <sys/file.h>
#include <sys/errno.h>

#define SEM_FILE	"/etc/.mnt.lock"

extern char *optarg;
extern int errno;

main(argc, argv)
    int  argc;
    char **argv;
{
	char	*prog, *strrchr();
	int   distflag = 0, c, temprec;
	register char	*special;

	prog = strrchr (*argv, '/');
	prog = (prog == NULL) ? *argv : (prog + 1);
	
	/*
	 *	Process arguments...
	 */
	while ((c = getopt (argc, argv, "d:")) != EOF)
	  switch (c) {
	    case 'd':
	      special = optarg;
	      distflag = 1;
	      break;

	    default:
	      Usage (prog);
	      exit (1);
	  }

	if (!distflag) {
	    Usage (prog);
	    exit (1);
	}

	if (geteuid() != 0) {
		fprintf(stderr, "umount: not super user\n");
		exit(2);
	}

	/*
	 *	Lock a temporary file to prevent many unmounts at once.
	 *	This is done to ensure integrity of the MNTTAB.
	 */

	if ((temprec = creat(SEM_FILE, 0600)) == -1 ||
	     lockf(temprec, F_LOCK, 0L) < 0) {
		fprintf(stderr, "mount: warning: cannot lock temp file <%s>\n", SEM_FILE);
	}

	/*
	 *	If the argument provided is a directory
	 *	(or the stat fails because a link has been broken,
	 *	then look for the special device name from the
	 *	/etc/fstab file.
	 */

	if (rumount(special) < 0) {
	    rpterr(special);
	    /*
	     *	If the rumount failed due to a link
	     *	being down, continue and remove the
	     *	remote resource from MNTTAB.
	     */
	    if (errno != ECOMM && errno != EINVAL) {
		exit(2);
	    }
	}

	clrmntent (special, MOUNTED);
	exit (0);
}

static
rpterr(s)
char *s;
{
	switch(errno){
	case EPERM:
		fprintf(stderr,"umount: not super user\n");
		break;
	case ENXIO:
		fprintf(stderr,"umount: %s no device\n",s);
		break;
	case ENOENT:
		fprintf(stderr,"umount: %s no such file or directory\n",s);
		break;
	case EINVAL:
		fprintf(stderr,"umount: %s not mounted\n",s);
		break;
	case EBUSY:
		fprintf(stderr,"umount: %s busy\n",s);
		break;
	case ENOTBLK:
		fprintf(stderr,"umount: %s block device required\n",s);
		break;
	case ECOMM:
		fprintf(stderr,"umount: warning: broken link detected\n");
		break;
	default:
		perror("umount");
		fprintf(stderr,"umount: cannot unmount %s\n",s);
	}
}

Usage (prog)
    char *prog;
{
    fprintf (stderr, "Usage: %s -d resource\n", prog);
}
