#include <stdio.h>
#include <mntent.h>
#include <sys/fcntl.h>

#ifndef lint
static clrmnt_sccs[] = "@(#)clrmntent.c	1.1";
#endif
#define TMPTAB "/tmp/mtab"

clrmntent (special, mtab)
    char *special, *mtab;
{
    FILE *mnttab, *tmptab;
    register struct mntent *mp;
    int found = 0;

    mnttab = setmntent (mtab, "r");
    if (mnttab == NULL) {
	fprintf (stderr, "Can't open %s for reading\n", mtab);
	return 0;
    }
    tmptab = setmntent (TMPTAB, "w");
    if (tmptab == NULL) {
	fprintf (stderr, "Can't open %s for writting\n", TMPTAB);
	return 0;
    }

    while ((mp = getmntent (mnttab)) != NULL)
      if (strcmp (mp->mnt_fsname, special) == 0)
	found = 1;
      else
	addmntent(tmptab, mp);

    if (!found) {
	fprintf (stderr, "%s not found in %s\n", special, mtab);
	return 0;
    }

    endmntent(mnttab);
    endmntent(tmptab);

    if (copy (TMPTAB, mtab))
      return (-1);
    unlink (TMPTAB);
    return 0;
}

copy (from, to)
    char *from, *to;
{
    int fromfd, tofd, cc;
    char buf[BUFSIZ];

    fromfd = open (from, O_RDONLY);
    if (fromfd < 0)
      return (-1);

    tofd = open (to, O_WRONLY|O_TRUNC);
    if (fromfd < 0)
      return (-1);

    while ((cc = read (fromfd, buf, BUFSIZ)) > 0)
      if (write (tofd, buf, cc) != cc)
	return (-1);

    close (fromfd);
    close (tofd);
    return (0);
}
