#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)tabs:tabs.mk	1.1"

#	Makefile for tabs

ROOT =

DIR = $(ROOT)/usr/bin

INC = $(ROOT)/usr/include

LDFLAGS = -lcurses

CFLAGS = -O -I$(INC)

STRIP = strip

SIZE = size

#top#
# Generated by makefile 1.47

MAKEFILE = tabs.mk


MAINS = tabs

OBJECTS =  tabs.o

SOURCES =  tabs.c

ALL:		$(MAINS)

tabs:		tabs.o 
	$(CC) $(CFLAGS)  -o tabs  tabs.o   $(LDFLAGS)


tabs.o:		 $(INC)/stdio.h $(INC)/signal.h \
		 $(INC)/sys/signal.h $(INC)/sys/types.h \
		 $(INC)/sys/stat.h $(INC)/curses.h \
		 $(INC)/stdio.h $(INC)/unctrl.h \
		 $(INC)/termio.h $(INC)/sys/termio.h \
		 $(INC)/term.h 

GLOBALINCS = $(INC)/curses.h $(INC)/signal.h \
	$(INC)/stdio.h $(INC)/sys/signal.h \
	$(INC)/sys/stat.h $(INC)/sys/termio.h \
	$(INC)/sys/types.h $(INC)/term.h $(INC)/termio.h \
	$(INC)/unctrl.h 


clean:
	rm -f $(OBJECTS)

clobber:
	rm -f $(OBJECTS) $(MAINS)

newmakefile:
	makefile -m -f $(MAKEFILE)  -s INC $(INC)
#bottom#

all : ALL

install: ALL
	cpset $(MAINS) $(DIR)

size: ALL
	$(SIZE) $(MAINS)

strip: ALL
	$(STRIP) $(MAINS)

#	These targets are useful but optional

partslist:
	@echo $(MAKEFILE) $(SOURCES) $(LOCALINCS)  |  tr ' ' '\012'  |  sort

productdir:
	@echo $(DIR) | tr ' ' '\012' | sort

product:
	@echo $(MAINS)  |  tr ' ' '\012'  | \
	sed 's;^;$(DIR)/;'

srcaudit:
	@fileaudit $(MAKEFILE) $(LOCALINCS) $(SOURCES) -o $(OBJECTS) $(MAINS)
