/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)sh:pwd.c	1.2"
/*
 *	UNIX shell
 */

#include		"mac.h"
#ifdef	is68k
#include	<sys/param.h>
#endif	is68k
#include	<sys/types.h>
#include	<dirent.h>
#include	<sys/stat.h>

#define	DOT		'.'
#define	NULL	0
#define	SLASH	'/'
#define MAXPWD	MAXNAMLEN

extern char	longpwd[];

static char saved_cwd[MAXPWD];
static char cwdname[MAXPWD];
static int 	didpwd = FALSE;

#ifdef	is68k
static char hostname[MAXHOSTNAMELEN];
unsigned long	rpid;
#endif	is68k

/*
 * These two routines are called from xec.c when doing a cd. 
 */
savecwd()
{
	strcpy (saved_cwd, cwdname);
}

restorecwd()
{
	strcpy (cwdname, saved_cwd);
}

char *
cwd(dir)
	register char *dir;
{
	register char *pcwd;
	register char *pdir;

	/* First remove extra /'s */

	rmslash(dir);

	/* Now remove any .'s */

	pdir = dir;
	while(*pdir) 			/* remove /./ by itself */
	{
		if((*pdir==DOT) && (*(pdir+1)==SLASH))
		{
			movstr(pdir+2, pdir);
			continue;
		}
		pdir++;
		while ((*pdir) && (*pdir != SLASH)) 
			pdir++;
		if (*pdir) 
			pdir++;
	}
	if(*(--pdir)==DOT && pdir>dir && *(--pdir)==SLASH)
		*pdir = NULL;
	

	/* Remove extra /'s */

	rmslash(dir);

	/* Now that the dir is canonicalized, process it */

	if(*dir==DOT && *(dir+1)==NULL)
	{
		return cwdname;
	}

	if(*dir==SLASH)
	{
		/* Absolute path */

		pcwd = cwdname;
		didpwd = TRUE;
	}
	else
	{
		/* Relative path */

		if (didpwd == FALSE) 
			return;
			
		pcwd = cwdname + length(cwdname) - 1;
		if(pcwd != cwdname+1)
		{
			*pcwd++ = SLASH;
		}
	}
	while(*dir)
	{
		if(*dir==DOT && 
		   *(dir+1)==DOT &&
		   (*(dir+2)==SLASH || *(dir+2)==NULL))
		{
			/* Parent directory, so backup one */

			if( pcwd > cwdname+2 )
				--pcwd;
			while(*(--pcwd) != SLASH)
				;
			pcwd++;
			dir += 2;
			if(*dir==SLASH)
			{
				dir++;
			}
			continue;
		}
		*pcwd++ = *dir++;
		while((*dir) && (*dir != SLASH))
			*pcwd++ = *dir++;
		if (*dir) 
			*pcwd++ = *dir++;
	}
	*pcwd = NULL;

	--pcwd;
	if(pcwd>cwdname && *pcwd==SLASH)
	{
		/* Remove trailing / */

		*pcwd = NULL;
	}
	return cwdname;
}

/*
 *	Print the current working directory.
 */

cwdprint()
{
	if (didpwd == FALSE)
		pwd();

	prs_buff(cwdname);
	prc_buff(NL);
	return;
}

/*
 *	This routine will remove repeated slashes from string.
 */

static
rmslash(string)
	char *string;
{
	register char *pstring;

	pstring = string;
	while(*pstring)
	{
		if(*pstring==SLASH && *(pstring+1)==SLASH)
		{
			/* Remove repeated SLASH's */

			movstr(pstring+1, pstring);
			continue;
		}
		pstring++;
	}

	--pstring;
	if(pstring>string && *pstring==SLASH)
	{
		/* Remove trailing / */

		*pstring = NULL;
	}
	return;
}

/*
 *	Find the current directory the hard way.
 */



static char dotdots[] =
"../../../../../../../../../../../../../../../../../../../../../../../../.";

extern char		*movstrn();

#define PRINT(x) prs(x)
#define ENTER_PWD "Entered pwd\n"
#define LEAVE_PWD "Leaving pwd\n"

static
pwd()
{
	struct stat		cdir;	/* current directory status */
	struct stat		tdir;
	struct stat		pdir;	/* parent directory status */
	DIR			*pdfd;	/* parent directory stream */

	struct dirent	*dir;
#ifdef notdef
	char 			*dot = dotdots + sizeof(dotdots) - 5;
	int				index = sizeof(dotdots) - 4;
#endif
	int				cwdindex = MAXPWD - 1;
	int dot_ino;
	int 			i;
	char			*err_str;
	
#ifdef	is68k
	hostname[0] = '\0';
	if ((pdfd = opendir(".")) == NULL) {
		error("pwd: cannot open .\n");
		goto bad;
	}
	if ((rpid = getrpid(pdfd->dd_fd)) < 0) {
		error("pwd: cannot obtain rpid\n");
		goto bad;
	} else if (rpid != 0) {
		if (getmachname(rpid, hostname, MAXHOSTNAMELEN) < 0) {
			error("pwd: failed getmachname\n");
			goto bad;
		}
	}
#endif	is68k
	cwdname[cwdindex] = 0;
	if (stat (".", &pdir) < 0)
	  error ("pwd: cannot stat .");

	for(;;)
	{
		/*
		 * The stat structure uses a short to hold the inode number.
		 * If the inode is greater than 64k it will be truncated and
		 * never found in the read loop of the parent directory.
		 * By using readdir on the current directory searching for
		 * '.' we can find the true 32bit number.
		 */
	      
	    	pdfd = opendir (".");
		if (pdfd == NULL) {
		    err_str = "pwd: cannot open .";
		    goto bad;
		}
		do {
		    dir = readdir (pdfd);
		    if (dir == NULL) {
			closedir (pdfd);
			err_str = "pwd: read error in .";
			goto bad;
		    }
		} while (strcmp (dir->d_name, "."));
		closedir (pdfd);
		dot_ino = dir->d_ino;

		cdir = pdir;

		if ((pdfd = opendir("..")) == 0)
		{
		    err_str = "pwd: cannot open ..";
		    goto bad;
		}

		if(fstat(pdfd->dd_fd, &pdir) < 0)
		{
			(void)closedir(pdfd);
			err_str = "pwd: cannot stat ..";
			goto bad;
		}

		chdir ("..");
		if(cdir.st_dev == pdir.st_dev)
		{
			if(dot_ino == pdir.st_ino)
			{
				didpwd = TRUE;
				(void)closedir(pdfd);
				if (cwdindex == (MAXPWD - 1))
					cwdname[--cwdindex] = SLASH;

				movstr(&cwdname[cwdindex], cwdname);
				chdir (cwdname);
#ifdef	is68k
				addhostname(hostname, cwdname);
#endif	is68k
				return;
			}

			do
			{
				if ((dir = readdir(pdfd)) == 0)
				{
					(void)closedir(pdfd);
					err_str = "pwd: read error in ..";
					goto bad;
				}
			}
			while (dir->d_ino != dot_ino);
		}
		else
		{
			do
			{
				if ((dir = readdir(pdfd)) == 0)
				{
					(void)closedir(pdfd);
					err_str = "pwd: read error in ..";
					goto bad;
				}
				stat(dir->d_name, &tdir);
			}		
			while(tdir.st_ino != dot_ino || tdir.st_dev != cdir.st_dev);
		}
		(void)closedir(pdfd);

		for (i = 0;; i++)
			if (dir->d_name[i] == 0)
				break;

		if (i > cwdindex - 1) {
		    err_str = longpwd;
		    goto bad;
		}
		else
		{
			cwdindex -= i;
			movstrn(dir->d_name, &cwdname[cwdindex], i);
			cwdname[--cwdindex] = SLASH;
		}

	}
bad:
	chdir (cwdname[cwdindex]);
	error (err_str);
}

#ifdef	is68k
addhostname(hostname, cwdname)
char *hostname, *cwdname;
{
	char tmpname[MAXPWD];

	if (*hostname != '\0' && 
			length(cwdname) + length(hostname) < MAXPWD) {
		movstrn("/@", tmpname, 2);
		movstrn(hostname, tmpname+2, length(hostname) - 1);
		movstrn(cwdname, tmpname+length(hostname)+1, length(cwdname));
		movstrn(tmpname, cwdname, length(tmpname));
		*hostname = '\0';
	}
}
#endif	is68k
