/*#define LD	"/usr/new/lx32"		/* loader */
#ident	"@(#)./cmd:compile.c	1.15"
/*#define CPP	"/lib/cpp"		/* C preprocessor for fortran */
/*#define STD	"/usr/new/lib"		/* directory for fcom,ccom,pcom */
/*#define AS	"/usr/new/mx32"		/* assembler */
/*#define M4	"/usr/bin/m4"		/* M4 macro preprocessor for fortran */
/*#define EFL	"/usr/bin/efl"		/* efl preprocessor for fortran */
/*#define RATFOR "/usr/bin/ratfor"	/* ratfor preprocessor for fortran */
/*#define LIB	"/usr/newlib"		/* standard library prefix */
/*#define TMP	"/tmp"			/* place for temporary files */
/*#define INCLUDE "/usr/include"	/* where to find include files */
/*#define C	1			/* defined if C */
/*#undef  PASCAL			/* defined if Pascal */
/*#undef  FORTRAN			/* defined if Fortran */

#ifndef SYSV
#define SKYFFP				/* turn on SKY FFP flags */
#endif SYSV

#define NEWLIB "/lib"			/* crt0.o access */

#include <stdio.h>
#include <signal.h>
/*
	-UU
	-t[PCF]
	-v: gotv: version number of compiler
	Pascal switches
	Green Hills C switches
	Use /tmp for .s file
	check for no M4, EFL, CPP, RATFOR
*/
#define true 1
#define false 0
char **dellist, **delptr;
char gotc;
char gotS;
char gotm;
char gotv;
char gotF;
char gotE;
char gotp;
char gotpg;
char gotg;
char goterror;

#ifdef	is68k
char gotM;
char gotf;
char got20;
#endif	is68k

char *onlyofile;

char *copy(s)
{
    char *s1;

    s1 = (char *)calloc(strlen(s)+1, sizeof(char));
    strcpy(s1, s);
    return (s1);
}

char *concat(s1, s2)
char *s1;
char *s2;
{
char *ret;
    ret = (char *)calloc(strlen(s1)+strlen(s2)+1, sizeof(char));
    strcpy(ret, s1);
    strcat(ret, s2);
    return(ret);
}

char *makeshort(s, c)
char *s;
char c;
{
    char *s1;

    s1 = s + strlen(s) - 1;
    while (s1[-1] != '.')
	s1--;
    *s1++ = c;
    *s1 = '\0';
    while (*s1 != '/' && s1 >= s)
	s1--;
    return(s1 + 1);
}

main(argc, argv, envp)
char **argv;
{
char **args,**argp;
char **ldargs, **ldargp;
char **fcomargs, **fcomargp;
char **ccomargs, **ccomargp;
char **pcomargs, **pcomargp;
char **asargs, **asargp;
char **m4args, **m4argp;
char **eflargs, **eflargp;
char **cppargs, **cppargp;
char **ratforargs, **ratforargp;
char **flist, **fptr;
char **liblist, **libptr;
char **x;
char *temp;
char *prog;
int count = 0;
int ocount = 0;
char *fcom;
char *ccom;
char *pcom;
int status;

#ifdef is68k
char TmpAsmFile[30];	
int  DotmpFile;	/* flag to turn of if tmp filenames are used */
#endif is68k

char *comm;

    gotc=0;
    gotS=0;
    gotm=0;
    gotv=0;
    gotF=0;
    gotE=0;
    gotp=0;
    gotpg=0;
    gotg=0;
    goterror = 0;
#ifdef is68k
    gotM = 0;
    gotf = 0;
    got20 = 0;
    sprintf(TmpAsmFile,"/tmp/ctm%05.5d",getpid());
#endif is68k
    onlyofile = 0;
    fcom = concat(STD, "/fcom");
    pcom = concat(STD, "/pcom");
    ccom = concat(STD, "/ccom");
    ldargp = ldargs = (char **)calloc(argc+50, sizeof(char *));
    fcomargp = fcomargs = (char **)calloc(argc+30, sizeof(char *));
    ccomargp = ccomargs = (char **)calloc(argc+30, sizeof(char *));
    pcomargp = pcomargs = (char **)calloc(argc+30, sizeof(char *));
    asargp = asargs = (char **)calloc(argc+30, sizeof(char *));
    cppargp = cppargs = (char **)calloc(argc+30, sizeof(char *));
    m4argp = m4args = (char **)calloc(argc+30, sizeof(char *));
    eflargp = eflargs = (char **)calloc(argc+30, sizeof(char *));
    ratforargp = ratforargs = (char **)calloc(argc+30, sizeof(char *));
    fptr = flist = (char **)calloc(argc+30, sizeof(char *));
    delptr = dellist = (char **)calloc(argc+30, sizeof(char *));
    libptr = liblist = (char **)calloc(argc+30, sizeof(char *));
    *asargp++ = "as";
    *fcomargp++ = "fcom";
    *fcomargp++ = "-X110";
    *ccomargp++ = "ccom";
    *ccomargp++ = "-X112";
    *pcomargp++ = "pcom";
    *pcomargp++ = "-X111";
    *ldargp++ = "ld";
#ifdef MC68000
    *ccomargp++ = "-X66";
    *pcomargp++ = "-X66";
    *fcomargp++ = "-X66";
#endif
#ifdef is68k
    *ccomargp++ = "-X250";	/* Turn on is68k specific mods in compiler*/
    *pcomargp++ = "-X250";
    *fcomargp++ = "-X250";

    *ccomargp++ = "-X12";
    *pcomargp++ = "-X12";
    *fcomargp++ = "-X12";
    *ccomargp++ = "-X96";
    *pcomargp++ = "-X96";
    *fcomargp++ = "-X96";
    *ccomargp++ = "-X125";
    *pcomargp++ = "-X125";
    *fcomargp++ = "-X125";
    *ccomargp++ = "-X134";
    *pcomargp++ = "-X134";
    *fcomargp++ = "-X134";
    *pcomargp++ = "-X140"; /*No C option yet, until stdio files are recomped*/
    *fcomargp++ = "-X140";
#ifdef SYSV
    /*
     *	ISI's System V compiler flags.
     */
	
    *ccomargp++ = "-X74";
    *pcomargp++ = "-X74";
    *fcomargp++ = "-X74";
    *ccomargp++ = "-X92";
    *fcomargp++ = "-X92";
    *pcomargp++ = "-X92";
#else
    /*
     *	ISI's generic (non System V) compiler flags.
     */

    *ccomargp++ = "-X14";
    *pcomargp++ = "-X14";
    *fcomargp++ = "-X14";
    *ccomargp++ = "-X114";
    *pcomargp++ = "-X114";
    *fcomargp++ = "-X114";
    *ccomargp++ = "-X136";
    *fcomargp++ = "-X136";
    *pcomargp++ = "-X136";
    *ldargp++ = "-X";

#endif SYSV

#endif is68k


#ifdef SINGLELIB
    *fcomargp++ = "-X71";
#endif
    *cppargp++ = "cpp";
    *cppargp++ = "-P";
    *m4argp++ = "m4";
    *eflargp++ = "efl";
    *ratforargp++ = "ratfor";
    for (argp = argv+1; argp < argv+argc; argp++)
	if ((*argp)[0] == '-')
	    switch((*argp)[1]) {
		case 'c':
		case 'S':
		case 'F':
		case 'm':
		    if (strcmp(*argp, "-c") == 0) {
			gotc = true;
		    } else if (strcmp(*argp, "-S") == 0) {
			gotS = true;
#ifdef FORTRAN
		    } else if (strcmp(*argp, "-F") == 0) {
			gotF = true;
		    } else if (strcmp(*argp, "-m") == 0) {
			gotm = true;
#endif
		    } else
			goto def;
		    break;
		case 'o':
#ifdef FORTRAN
		    if (strcmp(*argp, "-onetrip") == 0)
			goto fortranflag;
		    else
#endif
		    if (strcmp(*argp, "-o") == 0) {
			if (*(argp+1)) {
			    *ldargp++ = *argp++;
			    if ((*argp)[strlen(*argp)-2] == '.')
				switch ((*argp)[strlen(*argp)-1]) {
				case 'f': case 's': case 'c': case 'p':
				case 'F': case 'r': case 'e': case 'o':
				    printf("%s: -o would overwrite %s\n",
					   argv[0], *argp);
				    localexit(1);
				}
			    else if (strcmp(*argp+strlen(*argp)-4, ".plm")==0) {
				printf("%s: -o would overwrite %s\n",
				       argv[0], *argp);
				localexit(1);
			    }
			    *ldargp++ = *argp;
			}
		    } else
			goto def;
		    break;
		case 'v':
		    if (strcmp(*argp, "-v") == 0) {
			gotv = true;
		    } else
			goto def;
		    break;
		case 'M':
		    if (strcmp(*argp, "-M") == 0) {
			gotM = true;
			gotE = true;
			*cppargp++ = *argp;
		    }
		    break;
		case 'U':
#ifdef FORTRAN
		    if (strcmp(*argp, "-U") == 0)
			goto fortranflag;
#endif
		case 'D':
		case 'I':
		    *pcomargp++ = *argp;
		    *ccomargp++ = *argp;
		    *cppargp++ = *argp;
		    break;
		case 'l':
		       *libptr++ = (*argp)+2;
		    break;
		case 'w':
#ifdef FORTRAN
		    if (strcmp(*argp, "-w66") == 0)
			goto fortranflag;
#endif
		case 'O':
		case 'g':
		case 'p': 
		case 'X':
		case 'Z':
generalflag:
		    if (strcmp(*argp, "-go") == 0) {
/* until 4.2 symbols supported by all compilers */
			*argp = "-g";
			gotg = true;
		    } else if (strcmp(*argp, "-p") == 0)
			gotp = true;
		    else if (strcmp(*argp, "-pg") == 0)
			gotpg = true;
		    else if (strcmp(*argp, "-g") == 0)
			gotg = true;
#ifdef is68k
		    else if (strcmp(*argp, "-ga") == 0){
			*fcomargp++ = "-X23";
			*ccomargp++ = "-X23";
			*pcomargp++ = "-X23";
		    }
#endif is68k
		    else if (strcmp(*argp, "-R") == 0 || ((*argp)[1] == 'X') ||
				((*argp)[1] == 'Z') ||
			strcmp(*argp, "-ga") == 0 || 
			strcmp(*argp, "-O") == 0 || strcmp(*argp, "-O2") == 0 ||
			strcmp(*argp, "-w") == 0)
			;
		    else
			goto def;
		    *fcomargp++ = *argp;
		    *ccomargp++ = *argp;
		    *pcomargp++ = *argp;
		    break;
		case 'C':
		    if (strcmp(*argp, "-C") == 0) {
			*ccomargp++ = *argp;
#ifdef PASCAL
			*pcomargp++ = "-X57";
#endif
		    }
		case 'i':
		case 'u':
#ifdef FORTRAN
fortranflag:
		    if (strcmp(*argp, "-u") == 0 || strcmp(*argp, "-U") == 0 ||
			strcmp(*argp, "-onetrip") == 0 ||
			strcmp(*argp, "-C") == 0 ||
			strcmp(*argp, "-i2") == 0 || strcmp(*argp, "-w66") == 0)
			*fcomargp++ = *argp;
		    else
#endif
			goto def;
		    break;
#ifndef is68k
		case 't':
#endif is68k
#ifdef FORTRAN
		case 'N': /* This option appears not to be implemented
			   * in GHS Fortran.
			   */
#endif
		    break;
		case 'E':
		    if (strcmp(*argp, "-E") == 0) {
			gotE = true;
			*ccomargp++ = *argp;
		    }
#ifdef FORTRAN
		    else {
			(*argp)[1] = '-';
			*eflargp++ = (*argp)+1;
		    }
#endif
		    break;
		case 'B':
		    if (strcmp(*argp, "-B") == 0) {
			ccom = concat(STD, "/occom");
			fcom = concat(STD, "/ofcom");
			pcom = concat(STD, "/opcom");
		    } else {
			ccom = concat((*argp)+2, "/ccom");
			fcom = concat((*argp)+2, "/fcom");
			pcom = concat((*argp)+2, "/pcom");
		    }
		    break;
		case 'R':
		    if (strcmp(*argp, "-R") == 0) {
#ifdef is68k
			*asargp++ = *argp;
#endif is68k
			goto generalflag;
		    }
		    (*argp)[1] = '-';
		    *ratforargp++ = (*argp)+1;
		    break;
		case 's':
#ifdef PASCAL
		    if (strcmp(*argp, "-s") == 0) {
			*pcomargp++ = "-X56";
			*pcomargp++ = "-X57";
			break;
		    }
#endif
		    goto def;
#ifdef is68k
		case 'k':
		    if (strcmp(*argp, "-k") == 0) {
			*pcomargp++ = "-X109";	/* TEMP nnn REB */
			*ccomargp++ = "-X109";	/* TEMP nnn REB */
			*fcomargp++ = "-X109";	/* TEMP nnn REB */
			break;
		    } else
			goto def;
		case '2':
		    if (strcmp(*argp, "-20") == 0) {
			got20 = true;
			*pcomargp++ = "-X98";
			*ccomargp++ = "-X98";
			*fcomargp++ = "-X98";
			break;
		    } else
			goto def;
		case 'f':
		    if (strcmp(*argp, "-f") == 0) {
			gotf = true;
			break;

		    } else if (strcmp(*argp, "-fD") == 0) {
			printf("DEC floating point format not supported. -fD ignored.\n");
			break;
		    } else
			goto def;

#endif  is68k
		default:
def:
		    *fptr++ = *argp;
		    break;
	    }
	else if (strcmp(*argp+strlen(*argp)-4, ".plm") == 0) {
	    count++;
	    ocount++;
	    *fptr++ = *argp;
	} else if ((*argp)[strlen(*argp)-2] == '.')
	    switch ((*argp)[strlen(*argp)-1]) {
		case 'f': case 's': case 'c': case 'p': case 'F':
		case 'r': case 'e':
		    count++;
		case 'o':
		    ocount++;
		default:
		    *fptr++ = *argp;
		    break;
	    }
	else
	    *fptr++ = *argp;
#ifdef INCLUDE
    *ccomargp++ = concat("-I", INCLUDE);
#endif

#ifdef is68k
/*
 * When compiling for the source level debuggers, turn off all important 
 * optimizaitions.
 */
if (gotg)
	{
    	*ccomargp++ = "-X9";
    	*pcomargp++ = "-X9";
    	*fcomargp++ = "-X9";
    	*ccomargp++ = "-X18";
    	*pcomargp++ = "-X18";
    	*fcomargp++ = "-X18";
    	*ccomargp++ = "-X23";
    	*pcomargp++ = "-X23";
    	*fcomargp++ = "-X23";
    	*ccomargp++ = "-X39";
    	*pcomargp++ = "-X39";
    	*fcomargp++ = "-X39";
	}
/*
 * Select type of floating point code to be generated:
 * IEEE (68010 or 68020/68881) or SKY.
 * DEC is NOT supported.
 */
if ((gotf && got20) || (!gotf)) /* Generate IEEE constants if not sky */
	{
    	*ccomargp++ = "-X22";
    	*pcomargp++ = "-X22";
    	*fcomargp++ = "-X22";
    	}

if (gotf)		/* Was the floating point flag turned on? */
	{
	if (got20)  	/* if float flag and 68020 flags on, do 68881 */
		{
		*pcomargp++ = "-X99";
		*ccomargp++ = "-X99";
		*fcomargp++ = "-X99";
		*pcomargp++ = "-X129";
		*ccomargp++ = "-X129";
		*fcomargp++ = "-X129";
		*pcomargp++ = "-X130";
		*ccomargp++ = "-X130";
		*fcomargp++ = "-X130";
		}
	else		/* if the -20 flag is OFF, generate SKY FFP code */
		{

#ifdef SKYFFP
		*pcomargp++ = "-X30";
		*ccomargp++ = "-X30";
		*fcomargp++ = "-X30";
#else
		if (!got20)
			{
			gotf = 0;
			printf("No SKY support available\n");
    			*ccomargp++ = "-X22";
    			*pcomargp++ = "-X22";
    			*fcomargp++ = "-X22";
			}
#endif SKYFFP

		}
	}

    if (gotp)
	{
	if ((gotf) && (!got20))
		*ldargp++ = concat(NEWLIB, "/skymcrt0.o");
	else
		*ldargp++ = concat(NEWLIB, "/mcrt0.o");
	}
    else if (gotpg)
	{
	if ((gotf) && (!got20))
		*ldargp++ = concat(NEWLIB, "/skygcrt0.o");
	else
		*ldargp++ = concat(NEWLIB, "/gcrt0.o");
	}
    else
	{
	if ((gotf) && (!got20))
		*ldargp++ = concat(NEWLIB, "/skycrt0.o");
	else
		*ldargp++ = concat(NEWLIB, "/crt0.o");
	}
#endif is68k

    for (fptr = flist; *fptr; fptr++) {
	if ((*fptr)[strlen(*fptr)-2] != '.')
	    *ldargp++ = *fptr;
	else {
	    switch((*fptr)[strlen(*fptr)-1]) {
#ifdef FORTRAN
		case 'e':
		    if (gotE)
			break;
		    prog = EFL;
		    argp = eflargp;
		    args = eflargs;
		    goto bothp;
		case 'r':
		    if (gotE)
			break;
		    prog = RATFOR;
		    argp = ratforargp;
		    args = ratforargs;
    bothp:
		    temp = copy(*fptr);
		    *fptr = makeshort(*fptr, 'f');
		    comm = (char *)calloc(strlen(M4)+strlen(temp)+strlen(prog)+
					  strlen(*fptr)+10, sizeof(char));
		    if (gotm)
			sprintf(comm, "%s %s | %s > %s", M4, temp, prog, *fptr);
		    else
			sprintf(comm, "%s %s > %s", prog, temp, *fptr);
		    if (system(comm)) {
			goterror = true;
			break;
		    }
		    goto dotf;
		case 'F':
		    if (gotE)
			break;
		    cppargp[0] = copy(*fptr);
		    *fptr = makeshort(*fptr, 'f');
		    cppargp[1] = *fptr;
		    if (!gotF)
		        *delptr++ = copy(*fptr);
		    if (call(CPP, cppargs, envp) != 0)
			break;
		    goto dotf;
		case 'f':
		    if (gotE)
			break;
    dotf:
		    printf("%s:\n", *fptr);
#ifdef is68k
		    if (!gotS)
		        DotmpFile++;
#endif is68k
		    prog = fcom;
		    args = fcomargs;
		    argp = fcomargp;
		    goto allcomp;
#endif FORTRAN
		case 'c':
		    if (gotM) {
		        *cppargp = copy(*fptr);
		        call(CPP, cppargs, envp);
			break;
		    }
		    if (count > 1)
			printf("%s:\n", *fptr);
#ifdef is68k
		    if (!gotS)
		        DotmpFile++;
#endif is68k
		    prog = ccom;
		    args = ccomargs;
		    argp = ccomargp;
		    goto allcomp;
#ifdef PASCAL
		case 'p':
		    if (gotE)
			break;
		    if (count > 1)
			printf("%s:\n", *fptr);
#ifdef is68k
		    if (!gotS)
		        DotmpFile++;
#endif is68k
		    prog = pcom;
		    args = pcomargs;
		    argp = pcomargp;
		    goto allcomp;
#endif
    allcomp:
		    if (gotF)
			break;
		    *argp++ = *fptr;
#ifdef is68k
                    if ((DotmpFile)  && (!gotS) && (!gotE))
                        *argp++ = TmpAsmFile;
#endif is68k
#ifdef DIRECTOBJ
		    if (!gotS)
			*argp++ = "-X75";

#endif
		    if (call(prog, args, envp) != 0)
			break;
#ifdef DIRECTOBJ
		    if (!gotS) {
			*fptr = makeshort(*fptr, 'o');
			if (ocount == 1 && !gotc)
			    onlyofile = copy(*fptr);
			goto alldef;
		    }
#endif
		    *fptr = makeshort(*fptr, 's');

                    if (!gotS)
#ifdef is68k
			if (!gotE)
                           *delptr++ = copy(TmpAsmFile);
#else
                        *delptr++ = copy(*fptr);
#endif is68k
		    goto dots;
		case 's':

#ifdef is68k
		    DotmpFile = 0;		/* Do no tmp file if .s */ 
#endif is68k
		    if (count > 1)
			printf("%s:\n", *fptr);
dots:
		    if (gotE || gotS)
			break;
#ifdef is68k
                    asargp[0] = (DotmpFile) ? TmpAsmFile : copy(*fptr);
#else
		    asargp[0] = copy(*fptr);
#endif is68k
		    asargp[1] = "-o";
		    *fptr = makeshort(*fptr, 'o');
		    asargp[2] = *fptr;
#ifdef is68k
		    if ( got20 )
			asargp[3] = "-20";
#endif
		    if (ocount == 1 && !gotc)
			onlyofile = copy(*fptr);
		    if (call(AS, asargs, envp) != 0) 
			{
#ifndef is68k
			if (strcmp(asargp[0], delptr[-1]) == 0)
			    *--delptr = 0;
#endif is68k
			break;
		        }
#ifdef is68k
		    if (DotmpFile)
                        {
                        unlink(TmpAsmFile);
                        DotmpFile=0;
                        }
#endif is68k
		default:
alldef:
		    for (x = ldargs + 1; x <= ldargp; x++)
			if (strcmp(*x, *fptr) == 0)
			    goto brk;
		    *ldargp++ = *fptr;
brk:
		    break;
	    }
	}
    }
#ifdef FORTRAN
if (gotf)
    {
	if (got20)	/* 68020/68881 library names */
	    {
	    if (gotp || gotpg)
		{
    	    	*libptr++ = "mF77_p";
     	    	*libptr++ = "mI77_p";
#ifndef SYSV
    	    	*libptr++ = "mU77_p";
#endif SYSV
		}
	    else 
		{
    	    	*libptr++ = "mF77";
     	    	*libptr++ = "mI77";
#ifndef SYSV
    	    	*libptr++ = "mU77";
#endif SYSV
		}
	    }
	else		/* Sky floating point library names */ 
	   {
#ifdef SKYFFP
	   if (gotp || gotpg)
		{
    	   	*libptr++ = "skyF77_p";
    	   	*libptr++ = "skyI77_p";
#ifndef SYSV
     	   	*libptr++ = "skyU77_p";
#endif SYSV
		}
	   else
		{
    	   	*libptr++ = "skyF77";
    	   	*libptr++ = "skyI77";
#ifndef SYSV
     	   	*libptr++ = "skyU77";
#endif SYSV
		}
#endif SKYFFP
	   }
    }
else 			/* generic 68010 case */
    {
    if (gotp || gotpg)
	{
    	*libptr++ = "F77_p";
    	*libptr++ = "I77_p";
#ifndef	SYSV
    	*libptr++ = "U77_p";
#endif SYSV
	}
    else
	{
    	*libptr++ = "F77";
    	*libptr++ = "I77";
#ifndef SYSV
    	*libptr++ = "U77";
#endif SYSV
	}
    }

#ifndef SYSV
    *libptr++ = "termcap";
#endif
#endif
#ifdef PASCAL
    *libptr++ = "pc"; 
#endif
#ifdef FORTRAN
#ifdef SYSV
#endif
    *libptr++ = "m";
#else
#ifdef PASCAL
    *libptr++ = "m";
#endif
#endif
    if (gotf)			/* any special floating pt. flags selected?*/
	{
	if (gotp || gotpg)
        	*libptr++ = (got20 ? "mc_p" :"skyc_p"); /* alternate libc.a */
	else
        	*libptr++ = (got20 ? "mc" :"skyc"); 	/* alternate libc.a */
	}
    else
	*libptr++ = ((gotp || gotpg) ? "c_p" : "c" );

#ifdef is68k
    if (gotg)
	*ldargp++ = "-lg";
#endif

    for (libptr = liblist; *libptr; libptr++)
#ifndef LIB
	   
	{
	/* This is a "special case" kludge to rename the math library if any 
	 * alternate floating point code is generated.
	 */  
	if ((gotf) && (strcmp(*libptr,"m") == 0))  
		if (gotp || gotpg)
	           *libptr =(got20 ? "mm_p": "skym_p");
		else
	           *libptr =(got20 ? "mm": "skym");

    	*ldargp++ = concat("-l", *libptr);
	}
	
#else
#ifdef is68k
	{

	if (gotf && (!got20)){ 
	    
	    if (gotp || gotpg)
		*ldargp++ =concat(concat(concat(LIB,"/libsky"),*libptr),"_p.a");
	    else
		*ldargp++ = concat(concat(concat(LIB,"/libsky"),*libptr), ".a");
	}
	else		
	if (gotf && got20) {
	    if (gotp || gotpg)
		*ldargp++ = concat(concat(concat(LIB, "/libm"), *libptr), "_p.a");
	    else
		{
		*ldargp++ = concat(concat(concat(LIB, "/libm"), *libptr), ".a");
		}
	} else {
	    if (gotp || gotpg)
		*ldargp++ = concat(concat(concat(LIB, "/lib"), *libptr),"_p.a");
	    else
		if (strcmp(*libptr, "c") == 0)
			*ldargp++ = concat(concat(concat(STD, "/lib"),
				*libptr), ".a");
		else
			*ldargp++ = concat(concat(concat(LIB, "/lib"),
				*libptr), ".a");
	}
	}
#else
	if (gotp || gotpg)
	    *ldargp++ = concat(concat(concat(LIB, "/lib"), *libptr), "_p.a");
	else
	    *ldargp++ = concat(concat(concat(LIB, "/lib"), *libptr), ".a");
#endif
#endif
    if (/*ocount > 0 &&*/ !gotF && !gotS && !gotc && !gotE && !goterror) {
	goterror = call(LD, ldargs, envp);
	if (goterror)
	    onlyofile = NULL;
    }
    localexit(goterror);
}

call(prog, args, envp)
char *prog;
char **args;
char **envp;
{
    int status;
    int pid;
    char **argp;

    if (gotv) {
	printf("%s", prog);
	for (argp = args+1; *argp; argp++)
	    printf(" %s", *argp);
	printf("\n");
    }
#ifdef VFORK
    pid = vfork();
#else
    pid = fork();
#endif
    if (pid == -1) {
	perror("fork");
	localexit(1);
    } else if (pid == 0) {
	execve(prog, args, envp);
	perror(prog);
	localexit(1);
    } else {
	while (pid != wait(&status)) ;
	if ((status & 0xff) != 0) {
	    if ((status & 0xff) != 2 && (status & 0xff) != 9)
		fprintf(stderr, "Fatal error in %s\n", prog);
	    localexit(1);
	}
	status >>= 8;
	if (status)
	    goterror = true;
	return(status);
    }
}

localexit(status)
{
    if (gotv)
	if (*dellist || onlyofile)
	    printf("rm");
    for (delptr = dellist; *delptr; delptr++) {
	if (gotv)
	    printf(" %s", *delptr);
	unlink(*delptr);
    }
    if (onlyofile) {
	if (gotv)
	    printf(" %s", onlyofile);
	unlink(onlyofile);
    }
    if (gotv)
	if (*dellist || onlyofile)
	    printf("\n");
    exit(status);
}
