
/*	#ident	"@(#)as/m68k:parse.y	1.2"	*/
%{

/*			Motorola 68000/020 assembler			*/

#include	<stdio.h>
#include	<string.h>
#include	<scnhdr.h>
#include	"symbols.h"
#include	"instab.h"
#include	"gendefs.h"

extern unsigned short
		cline,		/* Line number from the .ln pseudo op.	*/
		line;		/* Current input file line number.	*/

extern FILE	*fdin;		/* Input source.			*/
extern short	opt;		/* Sdi optimization flag.		*/
extern char	file[],		/* Assembly input file name.		*/
		cfile[];	/* Original C file name.		*/

extern symbol	*dot;		/* Current pc pointer.			*/
extern long	newdot;		/* Up-to-date value of pc pointer.	*/
extern struct scnhdr sectab[];

struct arg	arglist[3];
struct arg	*ap = arglist;
struct	exp	explist[100];
struct	exp	*xp = explist;

long		outword;	/* Bit field accumulator.		*/
int		bitsout;	/* Number of bits accumulated.		*/
BYTE		bytesout;	/* Output displacement.			*/
int		swbegct;	/* Number of switch locations.		*/

#ifdef	M68020
int		scaleseen; 	/* only one reg can be scaled		*/
int		sizeseen;	/* only one reg can be sized		*/
int		regseen;	/* count registers as we see them	*/
int		indexreg;	/* remember position of index register	*/
int		ssflag;		/* have we seen a size-scale		*/
#endif  M68020

struct exp	*combine();	/* Handles expression arithmetic.	*/
extern upsymins	*lookup();	/* Symbol table lookup routine.		*/
extern short	mksect();
extern		deflab();	/* Define label for sdi handler.	*/
extern		gen1op();	/* Handles one-operand instructions.	*/
extern		gen2op();	/* Handles two-operand instructions.	*/
#ifdef	M68020
extern		gen3op();	/* Handles three-operand instructions.	*/
#endif	M68020
#ifdef	M68881
extern		fgenxop();	/* Handles floating point instructions.	*/
#endif	M68881
extern		resolve();	/* resolves all SDI's to known length   */

char		err_buf[BUFSIZ];
char		yytext[BUFSIZ];
int	txtsec = -1;
int	datsec = -1;
int	bsssec = -1;
	/* This is a temporary provision for 3 data sections
	   Can lead to problems if data directive is improper!! */
static char firstinstr = 1;
extern int previous;
static	char *as_version = "1.00";
%}

/* Symbolic Debugger Support Pseudo Operations				*/
%token	IFILE	ILN	IDEF	IENDEF	IVAL
%token	ITYPE	ILINE	ISCL	ITAG	ISIZE	IDIM


%token	ISET	IGLOBAL	IDATA	ITEXT	IBYTE	ISHORT	ILONG
%token	ISPACE	IORG	ICOMM	ILCOMM	IEVEN	ISWBEG

/* Added from release 3.0 */

%token	IVERS	IIDENT	ISECT	IPREV	IIL	IBSS	IZERO	IASCII

%token	COLON	AMP	NOCHAR	SPC	ALPH	DIGIT	SQ
%token	SH	CM	NL	LP	RP	SEMI	DQ	TWID
%token	CURL	CURR

%token	LBRKT	RBRKT	/*	68020 support	*/

%left	PLUS	MINUS
%left	MUL	DIV
%left	UMINUS		/* Only used for precedence--no such token.	*/

%token	<yname>	NAME
%token	<yinst>	INST0	INST1	INST2	INST01	INST3	REG
%token	<yinst>	FINST0	FINST01	FINST1	FINST12	FINST2	FPREG	/* 68881 */
%token	<yinst> BFINST
%token	<yint>	SIZE	PLUS	MINUS	MUL	DIV	LP	RP
%token	<ylong>	INT
%token	<ystr>	STRING
%token	<yint>	FSIZE					/* 68881 */

%type	<yinst>	reg.ss					/* 68020 */
%type	<yint>	optsize	optscl	ss			/* 68020 */
%type	<yint>	foptsize				/* 68881 */
%type	<yarg>	arg
%type	<yarg>	farg					/* 68881 */
%type	<yarg>	bfarg					/* 68881 */
%type	<yexp>	expr	disp

%%

file	:	/* empty */
	|	file linstruction NL
	{
		line++;
		dot->value = newdot;
		generate(0,NEWSTMT,(long) line,NULLSYM);
		ap = arglist;
		xp = explist;
	}
	|	file linstruction SEMI
	{
		dot->value = newdot;
		generate(0,NEWSTMT,(long) line,NULLSYM);
		ap = arglist;
		xp = explist;
	}
	|	file error NL
	{
		line++;
		yyerrok;
		dot->value = newdot;
		ap = arglist;
		xp = explist;
	}
	;


linstruction:	labels instruction
	;

labels	:	/* empty */
	|	labels NAME COLON
	{
		if (($2->styp & TYPE) != UNDEF)
		{
			strcpy(err_buf,"multiply defined label--");
			strcat(err_buf,yytext);
			yyerror(err_buf);
		}
		$2->value = newdot;
		$2->styp |= dot->styp;
		$2->sectnum = dot->sectnum;
		if (opt && ((dot->styp & TYPE) == TXT))
			deflab($2);
	}
	;

instruction:
		IFILE STRING
	{
		if (cfile[0] != '\0')
			yyerror("only one .file allowed");
		strcpy(cfile,$2);
		generate(0,SETFILE,0,NULLSYM);
	}
	|	ILN expr
	{
		cline = (short) $2->xvalue;
		generate(0,LINENBR,$2->xvalue,$2->xsymptr);
	}
	|	ILN expr CM expr
	{
		cline = (short) $2->xvalue;
		generate(0,LINENUM,$2->xvalue,$2->xsymptr);
		generate(0,LINEVAL,$4->xvalue,$4->xsymptr);
	}
	|	IDEF NAME
	{
		generate(0,DEFINE,0L,$2);
	}
	|	IENDEF
	{
		generate(0,ENDEF,0,NULLSYM);
	}
	|	IVAL expr
	{
		generate(0,SETVAL,$2->xvalue,$2->xsymptr);
	}
	|	ITYPE expr
	{
		generate(0,SETTYP,$2->xvalue,$2->xsymptr);
	}
	|	ILINE expr
	{
		generate(0,SETLNO,$2->xvalue,$2->xsymptr);
	}
	|	ISCL expr
	{
		generate(0,SETSCL,$2->xvalue,$2->xsymptr);
	}
	|	ITAG NAME
	{
		generate(0,SETTAG,0,$2);
	}
	|	ISIZE expr
	{
		generate(0,SETSIZ,$2->xvalue,$2->xsymptr);
	}
	|	dotdim
	|	ISET NAME CM expr
	{
		if (($4->xtype & TYPE) == UNDEF)
			yyerror("illegal expression in .set");
		if ($2 == NULL)
			yyerror("unable to define symbol in .set");
		else
		{
			$2->value = $4->xvalue;
			$2->styp = $4->xtype;
		}
	}
	|	IGLOBAL names
	|	IDATA
	{
		if(datsec < 0)
			datsec = mksect(lookup(_DATA,INSTALL,USRNAME)->stp,
								STYP_DATA);
		cgsect(datsec);
	}
	|	IDATA expr
	{
		/* This is only for backward compatibility */
		if(datsec < 0)
			datsec = mksect(lookup(_DATA,INSTALL,USRNAME)->stp,
								STYP_DATA);
		cgsect(datsec);
	}
	|	ITEXT
	{
		if(txtsec < 0)
			txtsec = mksect(lookup(_TEXT,INSTALL,USRNAME)->stp,
								STYP_TEXT);
		cgsect(txtsec);
	}
	/******************
	|	ITEXT expr
	{
		cgsect(TXT,$2->xvalue);
	}
	********************/
	|	IBYTE {bytesout = 1;} explist
	{
		if (bitsout)
		{
			generate(BITSPBY*bytesout,0,outword,NULLSYM);
			outword = 0;
			bitsout = 0;
		}
	}
	|	ISHORT {bytesout = 2;} explist
	{
		if (bitsout)
		{
			generate(BITSPBY*bytesout,0,outword,NULLSYM);
			outword = 0;
			bitsout = 0;
		}
	}
	|	ILONG {bytesout = 4;} explist
	{
		if (bitsout)
		{
			generate(BITSPBY*bytesout,0,outword,NULLSYM);
			outword = 0;
			bitsout = 0;
		}
	}
	|	ISPACE expr
	{
		if ($2->xtype != ABS)
			yyerror("space size not absolute");
		fill($2->xvalue);
	}
	|	IORG expr
	{
		if ($2->xtype != ABS)
			yyerror("org requires absolute operand");
		if (($2->xvalue - dot->value) < 0)
			yyerror("backwards org");
		else
		{
			if (opt && ((dot->styp & TYPE) == TXT) 
			    && dot->sectnum == 0)
			   resolve();	/* force PC to known value */
			fill($2->xvalue - dot->value);
		}
	}
	|	ICOMM NAME CM expr
	{
		if ($4->xtype != ABS)
			yyerror("comm size not absolute");
		if (($2->styp & TYPE) != UNDEF)
			yyerror("illegal attempt to redefine symbol");
		else
		{
			$2->styp = (EXTERN | UNDEF);
			$2->value = $4->xvalue;
		}
	}
	|	ILCOMM NAME CM expr
	{
		if ($4->xtype != ABS)
			yyerror("lcomm size not absolute");
		else if (($2->styp & TYPE) != UNDEF)
			yyerror("illegal attempt to redefine symbol");
		else
			bss($2,$4->xvalue,2,$4->xtype);
	}
	|	IEVEN
	{
		ckalign(2);
	}
	|	ISWBEG arg
	{
		generate(BITSPOW,SWBEG,0x4afc,NULLSYM);
		generate(BITSPOW,SWBEG,$2->xp->xvalue,NULLSYM);
		swbegct = $2->xp->xvalue;
	}
	|	IVERS STRING
	{
		if(strcmp($2,as_version) > 0) {
			yyerror("inappropriate assembler version");
			fprintf(stderr,"\tcurrent version is %s, expected version is %s or greater\n",as_version,$2);
		}
	}
	|	IIDENT STRING
	{
		comment($2);
	}
	|	IPREV
	{
		if(!previous)
			yyerror("'previous' invoked before any other section");
		cgsect(previous);
	}
	|	IIL
	{
		generate(0,SETEXPAND,NULLVAL,NULLSYM);
	}
	|	IZERO expr
	{
		if($2->xtype != ABS)
			yyerror("'zero' size not absolute");
		if($2->xvalue < 0)
			yyerror("invalid 'zero' size");
		if(dot->styp != DAT)
			yyerror("'zero' valid only in data");
		generate(0,DOTZERO,$2->xvalue,NULLSYM);
		newdot += $2->xvalue;
	}
	|	ISECT NAME CM STRING
	{			/* .section <id>[,<string>] */
		register char *s;
	 	register int att = 0;

		s = $4;
		while (*s) switch(*s++) {

			case 'b':
				/* zero initialized block */
				att |= STYP_BSS;
				break;
			case 'c':
				/* copy */
				att |= STYP_COPY;
				break;
			case 'i':
				/* info */
				att |= STYP_INFO;
				break;
			case 'd':
				/* dummy */
				att |= STYP_DSECT;
				break;
			case 'x':
				/* executable */
				att |= STYP_TEXT;
				break;
			case 'n':
				/* noload */
				att |= STYP_NOLOAD;
				break;
			case 'o':
				/* overlay */
				att |= STYP_OVER;
				break;
			case 'l':
				/* lib */
				att |= STYP_LIB;
				break;
			case 'w':
				/* writable */
				att |= STYP_DATA;
				break;
			default:
				yyerror("invalid section attribute");
				break;
		}
		cgsect(mksect($2,att));
	}
	|	ISECT NAME
	{
		cgsect(mksect($2,0));
	}
	|	IBSS NAME CM expr CM expr
	{			/*   .bss <id>,<expr>,<expr>   */
		if($6->xtype != ABS)
			aerror("'align' field not absolute");
		bss($2,$4->xvalue,$6->xvalue,$4->xtype);
	}
	|	IASCII STRING
	{
		register char *cp;

		cp = $2;
		while(*cp) 
			generate(BITSPBY,0,(*cp++) & 0xff,NULLSYM);
	}
	|	INST0
	{
		/* No operands, and no size attribute.			*/
		generate(BITSPOW,0,$1->opcode,NULLSYM);
	}
	|	INST01 optsize arg
	{
		/* solely meant for trapcc */
		gen1op($1,$2,$3);
	}
	|	INST01
	{
		/* solely meant for trapcc */
		generate(BITSPOW,0,($1->opcode | 4),NULLSYM);
	}
	|	INST1 optsize arg
	{
		gen1op($1,$2,$3);
	}
	|	INST2 optsize arg CM arg
	{
		gen2op($1,$2,$3,$5);
	}
	|	INST3 optsize arg CM arg CM arg
	{
		gen3op($1,$2,$3,$5,$7);
	}
	|	FINST0
	{
		/* mainly for fnop */
		fgenxop($1,0,NULL,NULL);
	}
	|	FINST01 optsize arg
	{
		/* solely meant for ftrapcc */
		fgenxop($1,$2,$3,NULL);
	}
	|	FINST01
	{
		/* solely meant for ftrapcc */
		fgenxop($1,NULL,NULL,NULL);
	}
	|	FINST1 foptsize farg
	{
		fgenxop($1,$2,$3,NULL);
	}
	|	FINST12 foptsize farg
	{
		fgenxop($1,$2,$3,NULL);
	}
	|	FINST12 foptsize farg CM farg
	{
		fgenxop($1,$2,$3,$5);
	}
	|	FINST2 foptsize farg CM farg
	{
		fgenxop($1,$2,$3,$5);
	}
	|	BFINST arg bfarg
	{
		bfgen($1,$2,$3,0);
	}
	|	BFINST REG CM arg bfarg
	{
		bfgen($1,$4,$5,$2);
	}
	|	BFINST arg bfarg CM REG
	{
		bfgen($1,$2,$3,$5);
	}
	|	/* empty */
	;

dotdim	:	IDIM expr
	{
		generate(0,SETDIM1,$2->xvalue,$2->xsymptr);
	}
	|	dotdim CM expr
	{
		generate(0,SETDIM2,$3->xvalue,$3->xsymptr);
	}
	;
names	:	NAME			/* Part of .globl handling.	*/
	{
		$1->styp |= EXTERN;
	}
	|	names CM NAME
	{
		$3->styp |= EXTERN;
	}
	;

optsize	:	SIZE
	{
		$$ = $1;
	}
	|	/* empty */
	{
		$$ = UNSPEC;
	}
	;

explist	:	outexpr
	|	explist CM outexpr
	;

outexpr	:	expr
	{
		if (bitsout)
		{
			generate(BITSPBY*bytesout,0,outword,NULLSYM);
			outword = 0;
			bitsout = 0;
		}
		if (swbegct-- > 0)
			generate(BITSPBY*bytesout,SWBEG,0,$1->xsymptr);
		else
			generate(BITSPBY*bytesout,GENRELOC,$1->xvalue,$1->xsymptr);
	}
	|	expr COLON expr
	{
		if ($1->xtype != ABS)
			yyerror("width expression not absolute");
		if ($1->xvalue > (BITSPBY * bytesout))
			yyerror("expression crosses field boundary");
		if (($1->xvalue + bitsout) > (BITSPBY * bytesout))
		{
			generate(BITSPBY*bytesout,0,outword,NULLSYM);
			bitsout = 0;
			outword = 0;
		}
		$3->xvalue <<= bitsout;
		outword |= $3->xvalue;
		bitsout += $1->xvalue;
	}
	;

farg	:	arg
	|	FPREG COLON FPREG
	{
		
		ap->atype = FPREGPAIR;
		ap->areg1 = $1;
		ap->areg2 = $3;
		$$ = ap++;
	}
	|	FPREG
	{
		
		ap->atype = $1->tag;
		ap->areg1 = $1;
		ap->areg2 = 0;
		$$ = ap++;
	}
	;

foptsize :	optsize
	|	FSIZE
	{
		$$ = $1;
	}
	;

bfarg	:	CURL off COLON width CURR
	{
		$$ = ap++;
	}
	;

off	:	REG
	{
		if($1->tag != ADREG)
			yyerror("offset field can have only a data register");
		ap->areg1 = $1;
	}
	|	expr
	{
		ap->areg1 = NULLREG;
		ap->xp1 = $1;
	}
	;

width	:	REG
	{
		if($1->tag != ADREG)
			yyerror("width field can have only a data register");
		ap->areg2 = $1;
	}
	|	expr
	{
		ap->areg1 = NULLREG;
		ap->xp2 = $1;
	}
	;

arg	:	expr
	{
		ap->atype = ABSL;
		ap->xp = $1;
		ap->areg1 = 0;
		ap->areg2 = 0;
		$$ = ap++;
	}
	|	REG COLON REG
	{
		
		ap->atype = REGPAIR;
		ap->areg1 = $1;
		ap->areg2 = $3;
		$$ = ap++;
	}
	|	REG
	{
		
		ap->atype = $1->tag;
		ap->areg1 = $1;
		ap->areg2 = 0;
		$$ = ap++;
	}
	|	MINUS LP REG RP
	{
		ap->atype = ADEC;
		if ($3->tag != AAREG)
			yyerror("predecrement requires address register");
		ap->areg1 = $3;
		ap->areg2 = 0;
		$$ = ap++;
	}
	|	LP REG RP PLUS
	{
		ap->atype = AINC;
		if ($2->tag != AAREG)
			yyerror("postincrement requires address register");
		ap->areg1 = $2;
		ap->areg2 = 0;
		$$ = ap++;
	} 
	|	LP REG RP
	{
		ap->atype = AIREG;
		if ($2->tag != AAREG)
			yyerror("indirect requires address register");
		ap->areg1 = $2;
		ap->areg2 = 0;
		$$ = ap++;
	}
	|	AMP expr
	{
		ap->atype = AIMM;
		ap->xp = $2;
		ap->areg1 = 0;
		ap->areg2 = 0;
		$$ = ap++;
	}
	|	ind
	{
		indxinit();	/* To rectify a problem in grammer */
		$$ = ap++;
	}
	;

/*	
 *	68020 - register indirect w/ index and displacement
 *
 *	three forms:
 *
 *	1. indexed indirect w/ displacement
 *
 *		( bd[.s], An, Rn[.t][*scale] )
 *
 *	2. memory indirect w/ pre-index and displacement
 *
 *		( od[.t], [bd[.t], An, Rn[.t][*scale]] )
 *
 *	3. memory indirect w/ post-index and displacement
 *
 *		( od[.t], [bd[.t], An], Rn[.t][*scale] )
 *
 */

ind	:	nmi
	|	memind
	|	expr LP REG RP			/* 68000 old forms */
	{
		mkindex_indirect(INDIRECT,$3,0,$1);
	}
	|	expr LP REG CM reg.ss RP	/* 68000 old forms */
	{	
		mkindex_indirect(INDIRECT,$3,$5,$1);
	}
	;


	/* nmi - No Memory Indirect */
nmi	:	LP disp CM reg.ss CM reg.ss RP
	{	
		mkindex_indirect(INDIRECT,$4,$6,$2);
	}
	|	LP reg.ss CM disp CM reg.ss RP
	{
		mkindex_indirect(INDIRECT,$2,$6,$4);
	}
	|	LP reg.ss CM reg.ss CM disp RP
	{
		mkindex_indirect(INDIRECT,$2,$4,$6);
	}
	|	LP disp CM reg.ss RP
	{
		mkindex_indirect(INDIRECT,$4,0,$2);
	}
	|	LP reg.ss CM disp RP
	{
		mkindex_indirect(INDIRECT,$2,0,$4);
	}
	|	LP reg.ss CM reg.ss RP
	{
		mkindex_indirect(INDIRECT,$2,$4,0);
	}
	|	LP reg.ss RP
	{
		mkindex_indirect(INDIRECT,$2,0,0);
	}
	|	LP disp RP
	{
		mkindex_indirect(INDIRECT,0,0,$2);
	}
	;


memind	:	postind
	{
		;
	}
	|	preind
	{
		;
	}
	;


postind	:	LP mbd CM reg.ss CM disp RP
	{
		mk_post_ind($4,$6);
	}
	|	LP reg.ss CM mbd CM disp RP
	{
		mk_post_ind($2,$6);
	}
	|	LP reg.ss CM disp CM mbd RP
	{
		mk_post_ind($2,$4);
	}
	|	LP disp CM reg.ss CM mbd RP
	{
		mk_post_ind($4,$2);
	}
	|	LP disp CM mbd CM reg.ss RP
	{
		mk_post_ind($6,$2);
	}
	|	LP mbd CM disp CM reg.ss RP
	{
		mk_post_ind($6,$4);
	}
	|	LP mbd CM disp RP
	{
		mk_post_ind(0,$4);
	}
	|	LP disp CM mbd RP
	{
		mk_post_ind(0,$2);
	}
	|	LP reg.ss CM mbd RP
	{
		mk_post_ind($2,0);
	}
	|	LP mbd CM reg.ss RP
	{
		mk_post_ind($4,0);
	}
	|	LP mbd RP
	{
		mk_post_ind(0,0);
	}
	;


preind	:	LP mbid CM disp RP
	{
		ap->xp2 = $4;
	}
	|	LP disp CM mbid RP
	{	
		ap->xp2 = $2;
	}
	|	LP mbid RP
	{
		ap->xp2 = 0;
	}
	;


mbd	:	LBRKT REG CM disp RBRKT
	{
		mkindex_indirect(POSTNDXMI,$2,0,$4);
	}
	|	LBRKT disp CM REG RBRKT
	{
		mkindex_indirect(POSTNDXMI,$4,0,$2);
	}
	|	LBRKT disp RBRKT
	{
		mkindex_indirect(POSTNDXMI,0,0,$2);
	}
	|	LBRKT REG RBRKT
	{
		mkindex_indirect(POSTNDXMI,$2,0,0);
	}
	;


mbid	:	LBRKT disp CM reg.ss CM reg.ss RBRKT
	{	
		mkindex_indirect(PRENDXMI,$4,$6,$2);
	}
	|	LBRKT reg.ss CM disp CM reg.ss RBRKT
	{ 
		mkindex_indirect(PRENDXMI,$2,$6,$4);
	}
	|	LBRKT reg.ss CM reg.ss CM disp RBRKT
	{
		mkindex_indirect(PRENDXMI,$2,$4,$6);
	}
	;


disp	:	expr optsize
	{
		xp->xsize = $2;
		$$ = $1;
	}
	;


reg.ss	:	REG ss
	{
		regseen++;
		if( $2 == SET )		/* mark index register if seen */
			indexreg = regseen;
		$$ = $1;
	}
	;


ss	:	optsize optscl
	{ 
		if( ssflag && ($1 != UNSPEC || $2 == SET) )
		{
			yyerror("only one index register allowed");
			$$ = NOTSET;
		} else if( $1 != UNSPEC || $2 == SET ) { /* This was different */
			ssflag++;
			ap->asize = $1;
			$$ = SET;
		}
	}
	;

optscl	:	MUL INT
	{
		switch($2)
		{
			case 1:
				ap->ascale = X1;
				break;
			case 2:
				ap->ascale = X2;
				break;
			case 4:
				ap->ascale = X4;
				break;
			case 8:
				ap->ascale = X8;
				break;
			default:
				yyerror("illegal scale for index register");
				ap->ascale = X1;
		}
		$$ = SET;
	}
	|	/* empty */
	{
		ap->ascale = X1;
		$$ = NOTSET;
	}
	;

expr	:	NAME
	{
		if ((xp->xtype = $1->styp & TYPE) == ABS)
		{
			xp->xvalue = $1->value;
			xp->xsymptr = NULL;
		}
		else
		{
			xp->xvalue = 0;
			xp->xsymptr = $1;
		}
		$$ = xp++;
	}
	|	INT
	{
		xp->xtype = ABS;
		xp->xvalue = $1;
		xp->xsymptr = NULL;
		$$ = xp++;
	}
	|	AMP INT 
	{			 
	/* This rule is a kluge to support the GHS 68020 assembler syntax 
	   of (%a0){&3:&3} for bfargs (bit field args). Actually the bfarg
	   should not be using the rules for "exp" because it permits the
	   usage of (%a0){3:3}. However, barring any documentation on this 
	   assembler it is unclear which constructs are legal and which are 
	   somebody's "extensions" . 
	*/
		xp->xtype = ABS; 
		xp->xvalue = $2;
		xp->xsymptr = NULL;
		$$ = xp++;
	}
	|	LP expr RP
	{
		$$ = $2;
	}
	|	expr PLUS expr
	{
		$$ = combine(PLUS,$1,$3);
	}
	|	expr MINUS expr
	{
		$$ = combine(MINUS,$1,$3);
	}
	|	expr MUL expr
	{
		$$ = combine(MUL,$1,$3);
	}
	|	expr DIV expr
	{
		$$ = combine(DIV,$1,$3);
	}
	|	MINUS expr				%prec UMINUS
	{
		xp->xtype = ABS;
		xp->xsymptr = NULL;
		xp->xvalue = 0;
		$$ = combine(MINUS,xp++,$2);
	}
	;

%%

int	type[] = {
	EOF,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	SPC,	NL,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	0,	0,	0,	0,	0,	0,	0,	0,
	SPC,	0,	DQ,	SH,	0,	REG,	AMP,	SQ,
	LP,	RP,	MUL,	PLUS,	CM,	MINUS,	SIZE,	DIV,
	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,	DIGIT,
	DIGIT,	DIGIT,	COLON,	SEMI,	0,	0,	0,	0,
	0,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,
	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,
	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,
	ALPH,	ALPH,	ALPH,	LBRKT,	0,	RBRKT,	0,	ALPH,
	0,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,
	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,
	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,	ALPH,
	ALPH,	ALPH,	ALPH,	CURL,	0,	CURR,	TWID,	0,
};

yylex()
{
	upsymins	istp;
	static BOOL	mnemseen = FALSE; /* Mnemonic seen on line yet?	*/
	register char	*yycharptr;
	register int	val;
	register int	ctype;
	register long	intval;

	while (type[(val = getc(fdin)) + 1] == SPC)
		;

	switch (ctype = type[val + 1])
	{

	case SEMI:	/* Reinitialize for next statement.		*/
		mnemseen = FALSE;
		return(SEMI);

	case SH:	/* Comment until the end of the line.		*/
		while ((val = getc(fdin)) != '\n' && val > 0)
			;
		/* Now same as in case NL.				*/

	case NL:	/* Reinitialize for next statement.		*/
		mnemseen = FALSE;
		return(NL);


	case TWID:
		val = '.';
	case ALPH:
		yycharptr = yytext;
		do
		{
#if FLEXNAMES
			if (yycharptr <= &yytext[BUFSIZ - 1])
#else
			if (yycharptr <= &yytext[NCPS])
#endif
				*yycharptr++ = val;
		} while ((ctype = type[(val = getc(fdin)) + 1]) == ALPH || ctype == DIGIT || ctype == REG);
		*yycharptr = '\0';
		while (val=='\t' || val==' ')
			val = getc(fdin);
		ungetc(val,fdin);
		if (val == ':')
			istp = *lookup(yytext,INSTALL,USRNAME);
		else
			if (mnemseen)
				istp = *lookup(yytext,INSTALL,USRNAME);
			else
			{
				istp = *lookup(yytext,N_INSTALL,MNEMON);
				if (istp.stp == NULL)
					yyerror("invalid instruction name");
				else if(firstinstr) {
					firstinstr = 0;
					cgsect(mksect(lookup(_TEXT,INSTALL,USRNAME)->stp,STYP_TEXT));
				}
				yylval.yinst = istp.itp;
				mnemseen = TRUE;
				return(istp.itp->val + 256);
			}
		yylval.yname = istp.stp;
		return(NAME);

	case REG:
		yycharptr = yytext;
		do
		{
#if FLEXNAMES
			if (yycharptr <= &yytext[BUFSIZ - 1])
#else
			if (yycharptr <= &yytext[NCPS])
#endif
				*yycharptr++ = val;
		} while ((ctype = type[(val = getc(fdin)) + 1]) == ALPH || ctype == DIGIT || ctype == REG);
		ungetc(val,fdin);
		*yycharptr = '\0';
		istp = *lookup(yytext,N_INSTALL,MNEMON);
#ifdef	M68881
		if (istp.stp == NULL || (istp.itp->val != REG-256 &&
				istp.itp->val != FPREG-256))
#else	M68881
		if (istp.stp == NULL || istp.itp->val != REG-256)
#endif	M68881
			yyerror("invalid register name");
		yylval.yinst = istp.itp;
#ifdef	M68881
		return((istp.itp->val == FPREG-256)? FPREG : REG);
#else	M68881
		return(REG);
#endif	M68881

	case DIGIT:
		intval = val - '0';
		if (val == '0')
		{
			val = getc(fdin);
			if (val == 'x' || val == 'X')
			{	/* hex base	*/
				while (type[(val = getc(fdin)) + 1] == DIGIT ||
					('a' <= val && val <= 'f' || 'A' <= val && val <= 'F'))
				{
					intval <<= 4;
					if ('a' <= val && val <= 'f')
						intval += val - 'a' + 10;
					else if ('A' <= val && val <= 'F')
						intval += val - 'A' + 10;
					else intval += val - '0';
				}
			}	/* hex base	*/
			else
				if (type[val + 1] == DIGIT)
					do
					{	/* octal base	*/
						intval <<= 3;
						intval += val - '0';
					} while (type[(val = getc(fdin)) + 1] == DIGIT);
		}	/* hex or octal base	*/
		else
		{	/* decimal base	*/
			while (type[(val = getc(fdin)) + 1] == DIGIT)
			{
				intval *= 10;
				intval += val - '0';
			}
		}	/* decimal base	*/
		ungetc(val,fdin);
		yylval.yint = intval;
		return(INT);

	case SIZE:
		val = getc(fdin);
		yylval.yint = UNSPEC;
		if (val == 'b' || val == 'B')
			yylval.yint = B;
		else if (val == 'w' || val == 'W')
			yylval.yint = W;
		else if (val == 'l' || val == 'L')
			yylval.yint = L;
		else if (val == 's' || val == 'S') {
			yylval.yint = S;
			return(FSIZE);
		}
		else if (val == 'x' || val == 'X') {
			yylval.yint = X;
			return(FSIZE);
		}
		else if (val == 'p' || val == 'P') {
			yylval.yint = P;
			return(FSIZE);
		}
		else if (val == 'd' || val == 'D') {
			yylval.yint = D;
			return(FSIZE);
		}
		else
			yyerror("unknown size specification");
		return(SIZE);

	case SQ:
		if ((val = getc(fdin)) == '\n')
			line++;
		if (val == '\\')
			switch (val = getc(fdin))
			{
			case 'n':
				val = '\n';
				break;
			case 'r':
				val = '\r';
				break;
			case '\\':
			case '\'':
				break;
			case 'b':
				val = '\b';
				break;
			case 't':
				val = '\t';
				break;
			case 'v':
				val = '\013';
				break;
			case 'f':
				val = '\f';
				break;
			default:
				yyerror("illegal escaped character");
			}
		yylval.yint = val;
		return(INT);

	case DQ:
		yylval.ystr = yycharptr = yytext;
		while ((val = getc(fdin)) != '"' && val != '\n' && val != EOF)
		{
			if (yycharptr < &yytext[BUFSIZ-1])
				*yycharptr++ = val;
		}
		*yycharptr = '\0';
		if (val != '"')
			yyerror("nonterminated string");
		return(STRING);

	case 0:
		yyerror("illegal character");
		return(NOCHAR);

	default:
		return(ctype);
	}
}	/* yylex()	*/



struct exp *
combine(operator,left,right)
int		operator;
register struct exp	*left,
		*right;
{
	switch (operator)
	{
	case PLUS:
		if (left->xsymptr == NULL)
		{
			left->xsymptr = right->xsymptr;
			left->xtype = right->xtype;
		}
		else if (right->xsymptr != NULL)
			yyerror("illegal addition");
		left->xvalue += right->xvalue;
		return(left);
	case MINUS:
		if (swbegct > 0)
			return(left);
		if (left->xsymptr == NULL)
		{
			if (right->xsymptr != NULL)
				yyerror("illegal subtraction");
			left->xvalue -= right->xvalue;
		}
		else if (right->xsymptr == NULL)
			left->xvalue -= right->xvalue;
		else if (left->xtype == right->xtype && left->xtype != UNDEF)
		{
			left->xtype = ABS;
			left->xvalue = left->xvalue - right->xvalue +
				       left->xsymptr->value - right->xsymptr->value;
			left->xsymptr = NULL;		/* no symbol now */
		}
		else
		{
			yyerror("illegal subtraction");
			left->xsymptr = NULL;
			left->xtype = ABS;
			left->xvalue = 0;
		}
		return(left);
	case MUL:
		if (left->xsymptr != NULL || right->xsymptr != NULL)
			yyerror("illegal multiplication");
		left->xsymptr = NULL;
		left->xtype = ABS;
		left->xvalue *= right->xvalue;
		return(left);
	case DIV:
		if (left->xsymptr != NULL || right->xsymptr != NULL)
			yyerror("illegal division");
		left->xsymptr = NULL;
		left->xtype = ABS;
		left->xvalue /= right->xvalue;
		return(left);
	}
}	/* combine()	*/



fill(nbytes)
register long	nbytes;
{
	register long	fillval;

	if (nbytes <= 0)
	    return;
	
	if (newdot & 1)			/* always use FILL to get to even
					** boundary
					*/
	{
	    nbytes--;
	    generate(BITSPBY,0,FILL,NULLSYM);
	}

	fillval = ((dot->styp & TYPE) == TXT) ? TXTFILL : FILL;

	while (nbytes >= 2)
	{
		generate(BITSPOW,0,fillval,NULLSYM);
		nbytes -= 2;
	}
	if (nbytes)			/* fill out odd byte with FILL */
		generate(BITSPBY,0,FILL,NULLSYM);
}	/* fill()	*/



ckalign(size)
register int	size;
{
	register int	mod;

	if ((mod = newdot % size) != 0)
		fill(size - mod);
}	/* ckalign()	*/

/*
 *		68020 SUPPORT FUNCTIONS
 *
 *	mkindex_indirect()	- enters with four arguments:
 *
 *		type (short)
 *		disp (struct *exp)
 *		reg1 (instr *)
 *		reg2 (instr *)
 *
 *	we're not absolutely sure which register is the
 *	base and which is the index when no size or scale
 *	has been specified up to this point, so we need
 *	to determine which is which.  the possible base
 *	registers are:
 *
 *		%an, %pc, %zan (the zero reg placeholder)
 *
 *	and the base register may be missing altogether.
 *
 *	possible index registers are:
 *
 *		%dn, %an, %zan, %zdn
 *
 */

#define NULLREG	(instr *)0


mkindex_indirect(type,reg1,reg2,disp)
short type;
instr	*reg1;
instr	*reg2;
struct	exp	*disp;
{
	instr	*tmpreg;

	/*
	 *	determine index register (if any and not specified)
	 *	and flip registers if necessary so base is reg1 and
	 *	index is reg2.
	 */
	
	if((indexreg == 0 && reg1 && (reg1->tag == NULDREG || reg1->tag == ADREG))
			|| (indexreg == 1 && reg1 && (reg1->tag == NULDREG || reg1->tag == ADREG)) )
	{
		tmpreg = reg1;
		reg1 = reg2;
		reg2 = tmpreg;
	}

	mk_full_ind(type,reg1,reg2,disp);
}


/*
 *	common routine to construct indexed indirect
 *	addressing argument.
 *
 *	we enter with 4 arguments:
 *
 *		type		- type of indirect addressing, 3 kinds
 *		base		- the base register
 *		index		- the index register
 *		base_disp	- the displacement (before indirection)
 *
 *	the regs are preordered before entering this routine so we
 *	need only to check that the regs are the proper types for
 *	the given argument.
 */


mk_full_ind(type,base,index,base_disp)
short	type;
instr	*base;
instr	*index;
struct exp	*base_disp;
{
	/*
	 *	check regs for proper types
	 */

	if( base && base->tag != AAREG && base->tag != PCREG 
		&& base->tag != NULAREG && base->tag != NULPCREG)
	{
		yyerror("base register must be %pc, %an, %zpc or %zan");
		base = NULLREG;		/* try and keep it sane! */
	}

	if( index && index->tag != ADREG && index->tag != AAREG 
		&& index->tag != NULDREG && index->tag != NULAREG )
	{
		yyerror("index register must be %dn, %an, %zdn or %zan");
		index = NULLREG;		/* try and keep it sane! */
	}

	/*
	 *	null out regs tagged NULxxx 
	 */

	if( base && (base->tag == NULAREG || base->tag == NULPCREG ))
		base = NULLREG;

	if( index && (index->tag == NULDREG || index->tag == NULAREG ))
		index = NULLREG;

	/*
	 *	set addressing mode, assign regs to argument and return
	 */

	if( base && base->tag == PCREG )
		ap->atype = APCNDX;
	else
		ap->atype = ANDX;

	ap->aflags = type;
	ap->xp1 = base_disp;
	ap->areg1 = base;
	ap->areg2 = index;
}


/*
 *	mk_post_ind():	add in index and displacement for 
 *			post index memory indirect.
 *
 *	obviously if there was an error in the previous
 *	mkindex_indirect() we can overlay an already incorrect
 *	argument descriptor part, not to worry - we're doomed.
 *	let's just continue for syntax checking as long as possible.
 */

mk_post_ind(index,disp)
instr	*index;
struct exp	*disp;
{
	if( index && index->tag != NULDREG && index->tag != ADREG
		&& index->tag != NULAREG && index->tag != AAREG )
	{
		yyerror("only %an,%zan,%dn,%zdn index in memory indirect");
		index = NULLREG;
	}

	if( index && (index->tag == NULDREG || index->tag == NULAREG ))
		index = NULLREG;

	if(index) ap->areg2 = index;
	if(disp)
		ap->xp2 = disp;		/* displacement after memory indirection */
}


/*
 * indxinit() : Initialises some global variables after parsing each
 *		instruction
 */

indxinit()
{
	ssflag = 0;
	regseen = 0;
	indexreg = 0;
}

bss(sym,val,alignment,valtype)
register symbol *sym;
long val,alignment;
short valtype;
{
	long mod;

	if (valtype != ABS)
		yyerror("`.bss' (or comm or lcomm) size not absolute");
	if (val < 0)
		yyerror("Invalid `.bss' (or comm or lcomm) size");
	if ((sym->styp & TYPE) != UNDEF)
		yyerror("multiply define label in `.bss'");
	if (bsssec < 0) bsssec = mksect(
		lookup(_BSS, INSTALL, USRNAME)->stp, STYP_BSS);
	if (mod = sectab[bsssec].s_size % alignment)
		sectab[bsssec].s_size += alignment - mod;
	sym->value = sectab[bsssec].s_size;
	sectab[bsssec].s_size += val;
	sym->sectnum = bsssec;
	sym->styp |= BSS;
} /* bss */
