#ident	"@(#)as/m68k:gencode.c	1.3"

#include	<stdio.h>
#include	"symbols.h"
#include	"instab.h"
#include	"gendefs.h"
#include	"expand.h"
#include	"expand2.h"


extern long	newdot;
extern short	opt;		/* No span-dependent optimization flag.	*/
extern upsymins	*lookup();

int		as10 = {1};	/* Default generation for 68010 */
#ifdef	M68020
int		as20 = {0};
#define	NULLREG	(instr	*)0
#endif	M68020

long 		object;
int		numwords;
long		word;
#ifdef	M68020
int		bdword, odword;
int		bdaction, odaction;
int		nbdwords, nodwords;
symbol		*bdsymptr, *odsymptr;
#endif	M68020
symbol		*symptr;
unsigned short	action;


eff_add(arg,tag,size)
register struct arg	*arg;
register int		tag;
register int		size;
{
	register int	sdiflag;

	numwords = 0;
	action = 0;
#ifdef	M68020
	bdword = odword = bdaction = odaction = nbdwords = nodwords = 0;
#endif	M68020
	switch (arg->atype)
	{
	case ADREG:
		if ((tag & 0x800) == 0)
		{
			yyerror("attempt to use incorrect addressing mode (%dn)");
			return;
		}
		object |= arg->atype;
		object |= arg->areg1->opcode;
		return;

	case AAREG:
		if ((tag & 0x400) == 0)
		{
			yyerror("attempt to use incorrect addressing mode (%an)");
			return;
		}
		object |= arg->atype;
		object |= arg->areg1->opcode;
		return;

	case AIREG:
		object |= arg->atype;
		object |= arg->areg1->opcode;
		return;

	case AINC:
		if ((tag & 0x100) == 0)
		{
			yyerror("attempt to use incorrect addressing mode ((%an)+)");
			return;
		}
		object |= arg->atype;
		object |= arg->areg1->opcode;
		return;

	case ADEC:
		if ((tag & 0x80) == 0)
		{
			yyerror("attempt to use incorrect addressing mode (-(%an))");
			return;
		}
		object |= arg->atype;
		object |= arg->areg1->opcode;
		return;

	case APCOFF:
		if ((tag & 0x4) == 0)
		{
			yyerror("attempt to use incorrect addressing mode (d(%pc))");
			return;
		}
	case AOFF:
		numwords = 1;
		action = (arg->xp->xsymptr == NULL) ? 0 : GENRELOC;
		object |= arg->atype;
		if (arg->atype == AOFF)
			object |= arg->areg1->opcode;
		word = arg->xp->xvalue;
		if (word > 32767L || word < -32768L)
			yyerror("displacement exceeds 16 bits");
		symptr = arg->xp->xsymptr;
		return;

#ifdef	M68020
	case APCNDX:
		if ((tag & 0x2) == 0)
		{
			yyerror("attempt to use incorrect addressing mode (d(%pc,%rn.A))");
			return;
		}
	case ANDX:
		if(arg->aflags == INDIRECT) {
			if(arg->areg1 != NULLREG && arg->areg2 == NULLREG &&
				arg->areg1->tag != ADREG &&
				arg->xp->xvalue <= 32767L &&
				arg->xp->xvalue >= -32768L) { /* (d16,An) */
				numwords = 1;
				action = (arg->xp->xsymptr == NULL) ? 0 : GENRELOC;
				if(arg->atype == ANDX)
					object |= (AOFF | arg->areg1->opcode);
				else object |= APCOFF;
				word = arg->xp->xvalue;
				symptr = arg->xp->xsymptr;
				return;
			} else if(arg->areg1 != NULLREG &&
					arg->areg2 != NULLREG &&
					arg->xp->xvalue <= 127 &&
					arg->xp->xvalue >= -128) { /* old form */
				numwords = 1;
				action = (arg->xp->xsymptr == NULL) ? 0 : NDXRELOC;
				object |= arg->atype;
				if (arg->atype == ANDX)
					object |= arg->areg1->opcode;
				word = (arg->areg2->tag == AAREG) ? (1 << 15) : 0;
				word |= ((arg->areg2->opcode << 12) |
						(arg->ascale << 9));
				word |= (arg->asize == W) ? 0 : (1 << 11);
				word |= (arg->xp->xvalue & 0xff);
				symptr = arg->xp->xsymptr;
				return;
			}
		}
		numwords = 1;
		object |= arg->atype;
		word = (1<<8); /* Full fmt */
		if(arg->areg1 == NULLREG)   /* base suppress */
			word |= (1 << 7);
		else if(arg->atype == ANDX)
			object |= (arg->areg1->opcode);
		if(arg->areg2 == NULLREG) /* index suppress */
			word |= (1 << 6);
		else {
			word |= (arg->areg2->tag == AAREG) ? (1 << 15) : 0;
			word |= ((arg->areg2->opcode << 12) | (arg->ascale << 9));
		}
		word |= (arg->asize == L) ? (1 << 11) : 0;
		if(arg->xp == NULL)
			word |= (1 << 4);
		else {
			word |= (1 << 5);
			bdword = arg->xp->xvalue;
			bdaction = (arg->xp->xsymptr == NULL) ? 0 : GENRELOC;
			bdsymptr = arg->xp->xsymptr;
			if(arg->xp->xvalue <= 32767L && arg->xp->xvalue >= -32768L && arg->xp->xsymptr == NULL)
				nbdwords = 1;
			else {
				nbdwords = 2;
				word |= (3 << 4);
			}
		}
		if(arg->aflags != INDIRECT) { /* memory indirect */
			if(arg->aflags == POSTNDXMI && arg->areg2)
				word |= (1 << 2);
			if(arg->xp2 == NULL)
				word |= 1;
			else {
				word |= (1 << 1);
				odword = arg->xp2->xvalue;
				odaction = (arg->xp2->xsymptr == NULL) ? 0 : GENRELOC;
				odsymptr = arg->xp2->xsymptr;
				if(arg->xp2->xvalue <= 32767L && arg->xp2->xvalue >= -32768L && arg->xp2->xsymptr == NULL)
					nodwords = 1;
				else {
					nodwords = 2;
					word |= 3;
				}
			}
		}
		return;

#else	M68020
	case APCNDX:
		if ((tag & 0x2) == 0)
		{
			yyerror("attempt to use incorrect addressing mode (d(%pc,%rn.A))");
			return;
		}
	case ANDX:
		numwords = 1;
		action = (arg->xp->xsymptr == NULL) ? 0 : NDXRELOC;
		object |= arg->atype;
		if (arg->atype == ANDX)
			object |= arg->areg1->opcode;
		word = (arg->areg2->tag == AAREG) ? (1 << 15) : 0;
		word |= (arg->areg2->opcode << 12);
		word |= (arg->asize == L) ? (1 << 11) : 0;
		word |= (arg->xp->xvalue & 0xff);
		if (arg->xp->xvalue > 127 || arg->xp->xvalue < -128)
			yyerror("index displacement exceeds 8 bits");
		symptr = arg->xp->xsymptr;
		return;

#endif	M68020
	case ABSW:
	case ABSL:
		if (tag & 0x1000)
		{
			numwords = 2;
			action = (arg->xp->xsymptr == NULL) ? 0 : GENRELOC;
			object |= ABSL;
			word = arg->xp->xvalue;
			symptr = arg->xp->xsymptr;
			return;
		}
		if (tag & 0x4000)
			sdiflag = SDI6;
		else if (tag & 0x2000)
			sdiflag = SDI5;
		else
			sdiflag = SDI4;
		if (opt)
			switch (shortsdi(arg->xp->xsymptr,arg->xp->xvalue,sdiflag))
		{
		case S_SDI:	/* abs.w guaranteed to work.		*/
			/* If the tag is CONTROL, then the instructions	*/
			/* is a jmp, jsr, pea or lea.  These will use	*/
			/* the pc-relative capability in the case that	*/
			/* the short form works.			*/
			numwords = 1;
			action = (arg->xp->xsymptr == NULL) ? 0 :
				((tag == CONTROL) ? BRLOC : GENRELOC);
			if (tag == CONTROL)
				object |= APCOFF;
			else
				object |= ABSW;
			word = arg->xp->xvalue;
			symptr = arg->xp->xsymptr;
			return;
		case U_SDI:	/* Don't know, so generate a short	*/
				/*	for now.			*/
			/* Again, if the tag is CONTROL, then we use	*/
			/* the pc-relative mode for now, and have a	*/
			/* special action routine handle things in the	*/
			/* second pass.					*/
			numwords = 1;
			if (tag == CONTROL)
			{
				action = ABSBR;
				object |= APCOFF;
			}
			else
			{
				action = ABSOPT;
				object |= ABSW;
			}
			word = arg->xp->xvalue;
			symptr = arg->xp->xsymptr;
			return;
		case L_SDI:
			break;
			/* Fall through to no-optimize code.		*/
		}
		numwords = 2;
		action = (arg->xp->xsymptr == NULL) ? 0 : GENRELOC;
		object |= ABSL;
		word = arg->xp->xvalue;
		symptr = arg->xp->xsymptr;
		return;

	case AIMM:
		if (tag & 0x1 == 0)
		{
			yyerror("attempt to use incorrect addressing mode (immediate)");
			return;
		}
		object |= AIMM;
		symptr = arg->xp->xsymptr;
		action = (symptr == NULL) ? 0 : GENRELOC;
		switch (size)
		{
		case B:
			numwords = 1;
			word = arg->xp->xvalue & 0xff;
			return;
		case W:
		case UNSPEC:
			numwords = 1;
			word = arg->xp->xvalue & 0xffff;
			return;
		case L:
#ifdef	M68881
		case S:
#endif	M68881
			numwords = 2;
			word = arg->xp->xvalue;
			return;
#ifdef	M68881
		/*
		 * the parser still doesn't handle values greater than
		 * 32 bits gracefully!!
		 */
		case D:
			numwords = 4;
			word = arg->xp->xvalue;
			return;
		case X:
		case P:
			numwords = 6;
			word = arg->xp->xvalue;
			return;
#endif	M68881
		}
	default:
		yyerror("invalid operand type for instruction");
	}
}	/* eff_add()	*/



gen1op(inst,size,arg1)
register instr		*inst;
register int		size;
register struct arg	*arg1;
{
	switch (inst->tag)
	{
	case TRAP:
		if (size != UNSPEC)
			yyerror("trap instruction should have no size attribute");
		if (arg1->atype != AIMM || arg1->xp->xtype != ABS)
			yyerror("trap vector must be absolute, immediate operand");
		if (arg1->xp->xvalue < 0 || arg1->xp->xvalue > 15)
		{
			yyerror("trap vector must be between 0 and 15");
			arg1->xp->xvalue &= 0xf;
		}
		object = inst->opcode | arg1->xp->xvalue;
		generate(BITSPOW,0,object,NULLSYM);
		return;

	case STOP:
		if (size != UNSPEC)
			yyerror("stop instruction should have no size attribute");
		if (arg1->atype != AIMM || arg1->xp->xtype != ABS)
			yyerror("stop operand must be absolute, immediate operand");
		if (arg1->xp->xvalue < -(1<<15) || arg1->xp->xvalue >= (1<<15))
		{
			werror("stop operand must fit into a word (masked)");
			arg1->xp->xvalue &= 0xffff;
		}
		generate(BITSPOW,0,inst->opcode,NULLSYM);
		generate(BITSPOW,0,arg1->xp->xvalue,NULLSYM);
		return;

	case SWAP:
		if (size == B || size == L)
			yyerror("only word size attribute allowed for swap instruction");
		if (arg1->atype != ADREG)
			yyerror("swap instruction operand must be a data register");
		object = inst->opcode | arg1->areg1->opcode;
		generate(BITSPOW,0,object,NULLSYM);
		return;

	case EXT:
		if (size == B)
			yyerror("ext instruction only allows word or long size attribute");
		if (arg1->atype != ADREG)
			yyerror("ext instruction operand must be a data register");
		object = inst->opcode | arg1->areg1->opcode;
		object |= (size == L) ? 0xc0 : 0x80;
		generate(BITSPOW,0,object,NULLSYM);
		return;
	
	case UNLK:
		if (size != UNSPEC)
			yyerror("unlk instruction should have no size attribute");
		if (arg1->atype != AAREG)
			yyerror("swap instruction operand must be an address register");
		object = inst->opcode | arg1->areg1->opcode;
		generate(BITSPOW,0,object,NULLSYM);
		return;

	case BRA:
		if (size == B)
		{
			generate(BITSPBY,0,inst->opcode >> BITSPBY,NULLSYM);
			generate(BITSPBY,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}
		else
		{
			if (opt)
				switch (shortsdi(arg1->xp->xsymptr,arg1->xp->xvalue,SDI1))
			{
			case S_SDI:	/* bra.w guaranteed to work.	*/
				generate(BITSPOW,0,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case U_SDI:	/* Don't know, so generate a	*/
					/*	short for now.		*/
				generate(BITSPOW,BRAOPT,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case L_SDI:
				break;
				/* Fall through to no-optimize code.	*/
			}
			object |= 0xff;
			generate(BITSPOW,0,object,NULLSYM);
			generate(2*BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}

	case BR:
		if (size == B)
		{
			generate(BITSPBY,0,inst->opcode >> BITSPBY,NULLSYM);
			generate(BITSPBY,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}
		else
		{
			if (opt)
				switch (shortsdi(arg1->xp->xsymptr,arg1->xp->xvalue,SDI2))
			{
			case S_SDI:	/* br.w guaranteed to work.	*/
				generate(BITSPOW,0,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case U_SDI:	/* Don't know, so generate a	*/
					/*	short for now.		*/
				generate(BITSPOW,BCCOPT,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case L_SDI:
				break;
				/* Fall through to no-optimize code.	*/
			}
			object |= 0xff;
			generate(BITSPOW,0,object,NULLSYM);
			generate(2*BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}

	case BSR:
		if (size == B)
		{
			generate(BITSPBY,0,inst->opcode >> BITSPBY,NULLSYM);
			generate(BITSPBY,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}
		else
		{
			if (opt)
				switch (shortsdi(arg1->xp->xsymptr,arg1->xp->xvalue,SDI3))
			{
			case S_SDI:	/* bsr.w guaranteed to work.	*/
				generate(BITSPOW,0,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case U_SDI:	/* Don't know, so generate a	*/
					/*	short for now.		*/
				generate(BITSPOW,BSROPT,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case L_SDI:
				break;
				/* Fall through to no-optimize code.	*/
			}
			object |= 0xff;
			generate(BITSPOW,0,object,NULLSYM);
			generate(2*BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}
	case RTD:
		if ( !as10 )
			werror("a 68010 instruction");
		if (size != UNSPEC)
			yyerror("rtd is unsized");
		if (arg1->xp->xvalue < -(1<<15) || arg1->xp->xvalue >= (1<<15))
		{
			werror("rtd displacement is 16 bit signed (masked)");
			arg1->xp->xvalue &= 0xffff;
		}
		generate(BITSPOW,0,inst->opcode,NULLSYM);
		if (arg1->atype != AIMM)
			yyerror("rtd instruction requires immediate operand");
		else
			generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg1->xp->xvalue,arg1->xp->xsymptr);
		return;

	case OPTSIZE:		/*	clr, neg, negx, not, tst.	*/
		if (size == UNSPEC)
			size = W;
		object = inst->opcode | (size << 6);
		eff_add(arg1,DATALT,size);
		generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
		genrest();
#else	M68020
		if (numwords == 1)
			generate(BITSPOW,action,word,symptr);
		else if (numwords == 2)
			generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		return;

#ifdef	M68020
	case BKPT:
		if(!as20)
			werror("a 68020 instruction");
		if (size != UNSPEC)
			yyerror("bkpt instruction should have no size attribute");
		if (arg1->atype != AIMM || arg1->xp->xtype != ABS)
			yyerror("bkpt vector must be absolute, immediate operand");
		if (arg1->xp->xvalue < 0 || arg1->xp->xvalue > 7)
		{
			yyerror("bkpt vector must be between 0 and 7");
			arg1->xp->xvalue &= 0x7;
		}
		object = inst->opcode | arg1->xp->xvalue;
		generate(BITSPOW,0,object,NULLSYM);
		return;

	case TRAPCC:
		if(!as20)
			werror("a 68020 instruction");
		if (size == B)
			yyerror("trapcc instruction should not have byte size attribute");
		if (arg1->atype != AIMM)
			yyerror("trapcc argument must be immediate operand");
		if(arg1->xp->xvalue < -(1<<15) || arg1->xp->xvalue >= (1<<15) ||
								size == L) {
			object = inst->opcode | 3;
			generate(BITSPOW,0,object,NULLSYM);
			generate(2*BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg1->xp->xvalue,arg1->xp->xsymptr);
		} else {
			object = inst->opcode | 2;
			generate(BITSPOW,0,object,NULLSYM);
			generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg1->xp->xvalue & 0xffff,arg1->xp->xsymptr);
		}
		return;

	case EXTB:
		if(!as20)
			werror("a 68020 instruction");
		if (size != L && size != UNSPEC)
			yyerror("extb instruction only allows long size attribute");
		if (arg1->atype != ADREG)
			yyerror("extb instruction operand must be a data register");
		object = inst->opcode | arg1->areg1->opcode;
		generate(BITSPOW,0,object,NULLSYM);
		return;
	
	case RTM:
		if(!as20)
			werror("a 68020 instruction");
		if (size != UNSPEC)
			yyerror("rtm instruction should have no size attribute");
		if (arg1->atype == AAREG)
			object = arg1->areg1->opcode | (1<<3);
		else if (arg1->atype == ADREG)
			object = arg1->areg1->opcode;
		else
			yyerror("rtm instruction operand must be a register");
		object |= inst->opcode;
		generate(BITSPOW,0,object,NULLSYM);
		return;

#endif	M68020
	default:	/* jmp, jsr, nbcd, pea, scc, tas		*/
		if (   size != UNSPEC		/* check for correct size */
		    && size != ((int)(unsigned char)inst->tag - DEFAULT))
			yyerror("incorrect size specification for instruction");
		object = inst->opcode;
		if (inst->tag == DEFAULT+B)
			eff_add(arg1,DATALT,size);
		else
			eff_add(arg1,CONTROL,size);
		if (action == BRLOC)
			generate(BITSPOW,0,object,NULLSYM);
		else
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
		genrest();
#else	M68020
		if (numwords == 1)
			generate(BITSPOW,action,word,symptr);
		else if (numwords == 2)
			generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		return;
	}
}	/* gen1op()	*/



gen2op(inst,size,arg1,arg2)
register instr		*inst;
register int		size;
register struct arg	*arg1,
			*arg2;
{
	char	instr_buf[NCPS];
	register int inst2wd;

	object = inst->opcode;
	inst2wd = 0;

	switch (inst->tag)
	{
	case EXG:
	    {
		register unsigned short regs = (arg1->areg1->opcode << 9) | arg2->areg1->opcode;
					/* assume normal register placement */

		if (size != L && size != UNSPEC)
			yyerror("exg requires long attribute, if any");
		if (arg1->atype == ADREG && arg2->atype == ADREG)
			object |= 0x40;		/* Data <==> data.	*/
		else if (arg1->atype == AAREG && arg2->atype == AAREG)
			object |= 0x48;		/* Address <==> address.*/
		else				/* Address <==> data */
		{
			object |= 0x88;
			if (arg1->atype == AAREG) /* must reverse regs. */
			    regs = (arg2->areg1->opcode << 9) | arg1->areg1->opcode;
		}
		object |= regs;
		generate(BITSPOW,0,object,NULLSYM);
		return;
	    }

	case LINK:
		if (size == B)
			yyerror("link instruction can not have byte attribute");
		if (arg1->atype != AAREG)
			yyerror("address register required as first operand of link instruction");
		else
			object |= arg1->areg1->opcode;
		if (arg2->atype != AIMM)
			yyerror("immediate operand required as second operand of link instruction");
#ifdef	M68020
		else if (arg2->xp->xvalue < -(1<<15) || arg2->xp->xvalue >= (1<<15) || size == L || (as20 && size == UNSPEC))
		{
			if(!as20)
				werror("a 68020 instruction");
			object &= 7;
			object |= 0x4808;
			generate(BITSPOW,0,object,NULLSYM);
			generate(2*BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 :
				GENRELOC, arg2->xp->xvalue,arg2->xp->xsymptr);
			return;
		}
#else	M68020
		else if (arg2->xp->xvalue < -(1<<15) || arg2->xp->xvalue >= (1<<15) || size == L) {
			werror("link displacement must fit into a word (masked)");
			arg2->xp->xvalue &= 0xffff;
		}
#endif	M68020
		generate(BITSPOW,0,object,NULLSYM);
		generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg2->xp->xvalue,arg2->xp->xsymptr);
		return;

	case DADD:
		if (size != UNSPEC && size != B)
			yyerror("BCD instructions are byte instructions");
		size = B;
	case XADD:
		if (arg1->atype == ADEC && arg2->atype == ADEC)
			object |= 0x8;
		else if (arg1->atype != ADREG || arg2->atype != ADREG)
		{
			yyerror("only data register or predecrement address register pairs allowed as operands");
			return;
		}
		object |= (arg2->areg1->opcode << 9);
		object |= (size << 6);
		object |= arg1->areg1->opcode;
		generate(BITSPOW,0,object,NULLSYM);
		return;

	case LOGAND:
	case LOGOR:
	case LOGEOR:
		if (arg1->atype == AIMM)
		{
			strcpy(instr_buf,inst->name);
			if(instr_buf[strlen(instr_buf)-1] != 'i')
				strcat(instr_buf,"i");
			inst = lookup(instr_buf,N_INSTALL,MNEMON)->itp;
			object = inst->opcode;
			if (arg2->atype == CCREG)
			{
				object |= 0x3c;
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			}
			else if (arg2->atype == SRREG)
			{
				object |= 0x7c;
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			}
			if (size == UNSPEC)
				size = W;
			object |= (size << 6);
			eff_add(arg2,DATALT,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			if (size == B)
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue & 0xff,arg1->xp->xsymptr);
			else if (size == W)
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue & 0xffff,arg1->xp->xsymptr);
			else
				generate(2*BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue,arg1->xp->xsymptr);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		if (size == UNSPEC)
			size = W;
		if (inst->tag == LOGEOR)
		{
			if (arg1->atype != ADREG)
			{
				yyerror("first operand for eor must be a data register");
				return;
			}
			object |= (arg1->areg1->opcode << 9);
			object |= (1 << 8);
			object |= (size << 6);
			eff_add(arg2,DATALT,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg2->atype == ADREG)
		{
			object |= (arg2->areg1->opcode << 9);
			object |= (size << 6);
			eff_add(arg1,DATAA,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else
		{
			object |= (arg1->areg1->opcode << 9);
			object |= (1 << 8);
			object |= (size << 6);
			eff_add(arg2,ALTMEM,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}

	case ASHFT:
	case LSHFT:
	case ROT:
	case ROTX:
		if (arg1->atype == AIMM && 
		    arg2->atype != ADREG && arg2->atype != AAREG &&
		    arg2->atype != APCOFF && arg2->atype != APCNDX &&
		    arg2->atype != AIMM)
		{
			if(arg1->xp->xvalue != 1)
				yyerror("rotate/shift of memory only by 1");
			if (size != W && size != UNSPEC)
				yyerror("rotate/shift of memory requires word attribute, if any");
			eff_add(arg2,ALTMEM,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else
		{
			/* Turn off the immedate, size and i/r	*/
			/*	fields so they can be set.	*/
			if(arg2->atype != ADREG)
				yyerror("rotate/shift greater than 1 req's (%d) register");
			object &= ~0xeff;
			if (inst->tag == LSHFT)
				object |= 0x8;
			else if (inst->tag == ROT)
				object |= 0x18;
			else if (inst->tag == ROTX)
				object |= 0x10;
			if (size == UNSPEC)
				size = W;
			object |= (size << 6);
			if (arg1->atype == ADREG)
			{
				object |= 0x20;
				object |= (arg1->areg1->opcode << 9);
				object |= arg2->areg1->opcode;
				generate(BITSPOW,0,object,NULLSYM);
				return;
			}
			else if (arg1->atype == AIMM)
			{
				object |= arg2->areg1->opcode;

				/* Shift amount has upper limit of 8.	*/
				/* Eight is encoded as 0 (since a shift	*/
				/* by zero makes little sense).  Shifts	*/
				/* are broken up into groups of shift-	*/
				/* by-eight plus any remaining shift.	*/
				/* Note that the shift amount must be	*/
				/* known in the first pass.		*/

				while (arg1->xp->xvalue >= 8)
				{
					generate(BITSPOW,0,object,NULLSYM);
					arg1->xp->xvalue -= 8;
				}
				if (arg1->xp->xvalue > 0)
				{
					object |= (arg1->xp->xvalue << 9);
					generate(BITSPOW,0,object,NULLSYM);
				}
				return;
			}
			else
				yyerror("invalid operands for shift/rotate instruction");
			return;
		}

	case LEA:
		if (size != UNSPEC && size != L)
			yyerror("lea instruction has incorrect size attribute");
		if (arg2->atype != AAREG)
			yyerror("lea instruction requires an address register for second operand");
		else
			object |= (arg2->areg1->opcode << 9);
		eff_add(arg1,CONTROL,size);
		if (action == BRLOC)
			generate(BITSPOW,0,object,NULLSYM);
		else
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
		genrest();
#else	M68020
		if (numwords == 1)
			generate(BITSPOW,action,word,symptr);
		else if (numwords == 2)
			generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		return;

	case MULT:
#ifdef	M68020
		if(size == B)
			yyerror("instruction has incorrect size attribute");
		if(size == W || size == UNSPEC) {
#else	M68020
		if (size != UNSPEC && size != W)
			yyerror("instruction has incorrect size attribute");
#endif	M68020
		if (arg2->atype != ADREG)
			yyerror("instruction requires data register for second operand");
		else
			object |= (arg2->areg1->opcode << 9);
		eff_add(arg1,DATAA,size);
		generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
		genrest();
#else	M68020
		if (numwords == 1)
			generate(BITSPOW,action,word,symptr);
		else if (numwords == 2)
			generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		return;
#ifdef	M68020
		}
		if(!as20)
			werror("a 68020 instruction");
		/* What follows is atrocious, any better suggestions? */
		/* The idea is to change the opcode, but done clumsily! */
		if(inst->opcode & (1<<14))  /* mul */
			object = 0x4c00L;
		else object = 0x4c40L;
		if(inst->opcode & (1<<8))	/* signed */
			inst2wd = (1 << 11);
		if (arg2->atype == ADREG)
			/*
			 * In case of mul also both register fields are
			 * made equal, even though not necessary
			 */
			inst2wd |= ((arg2->areg1->opcode << 12) |
						arg2->areg1->opcode);
		else if(arg2->atype == REGPAIR && arg2->areg1->tag == ADREG &&
						arg2->areg2->tag == ADREG) {
			if(arg2->areg1->opcode == arg2->areg2->opcode)
				werror("registers in the register pair are same");
			inst2wd |= ((1 << 10) | (arg2->areg2->opcode << 12) |
						arg2->areg1->opcode);
		} else
			yyerror("instruction requires data register (pair) for second operand");
		eff_add(arg1,DATAA,size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		generate(BITSPOW, 0, inst2wd, NULLSYM);
		genrest();
		return;

	case	DIVL:
#ifndef BOZO

		if(!as20)
			werror("a 68020 instruction");
		if(inst->name[4] == 's') /* signed or usigned division? */
			inst2wd = (1 << 11);
		if(arg2->atype == REGPAIR && arg2->areg1->tag == ADREG &&
						arg2->areg2->tag == ADREG) {
			if(arg2->areg1->opcode == arg2->areg2->opcode)
				werror("registers in the register pair are same");
			inst2wd |= ((arg2->areg2->opcode << 12) |
						arg2->areg1->opcode);
		} 
		else
		   { 	/* test for division without remainder */
		   if ((arg2->atype != REGPAIR) && (arg2->areg1->tag == ADREG))

		   /* To discard remainder, 2nd opcode should equal 1st opcode*/

		   inst2wd |= ((arg2->areg1->opcode << 12) |
						arg2->areg1->opcode);
		   }
		eff_add(arg1,DATAA,size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		generate(BITSPOW, 0, inst2wd, NULLSYM);
		genrest();
		return;
#else
		if(!as20)
			werror("a 68020 instruction");
		if(inst->name[3] == 's')	/* Signed division? */
			inst2wd = (1 << 11);
		if(arg2->atype == REGPAIR && arg2->areg1->tag == ADREG &&
						arg2->areg2->tag == ADREG) {
			if(arg2->areg1->opcode == arg2->areg2->opcode)
				werror("registers in the register pair are same");
			inst2wd |= ((arg2->areg2->opcode << 12) |
						arg2->areg1->opcode);
		} else
			yyerror("divl instruction requires data register pair for second operand");
		eff_add(arg1,DATAA,size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		generate(BITSPOW, 0, inst2wd, NULLSYM);
		genrest();
		return;
#endif BOZO
#endif	M68020
	case DBCC:
		if (size != UNSPEC && size != W)
			yyerror("dbCC instruction requires word attribute, if any");
		if (arg1->atype != ADREG)
			yyerror("dbCC instruction requires data register for first operand");
		else
			object |= arg1->areg1->opcode;
		generate(BITSPOW,0,object,NULLSYM);
		generate(BITSPOW,BRLOC,arg2->xp->xvalue,arg2->xp->xsymptr);
		return;

	case CMP:
		/* Keep in mind the syntactic change in the operand	*/
		/*	ordering.					*/
		if (size == UNSPEC)
		{
			yyerror("size needed on compare instruction");
			size = W;
		}
		if (arg1->atype == AINC && arg2->atype == AINC)
		{
			/*		cmpm				*/
			object |= (arg1->areg1->opcode << 9);
			object |= 0x108;
			object |= (size << 6);
			object |= arg2->areg1->opcode;
			generate(BITSPOW,0,object,NULLSYM);
			return;
		}
		else if (arg1->atype == AAREG)
		{
			/*		cmpa				*/
			if (size == B)
			{
				yyerror("byte size attribute illegal for compare address instruction");
				return;
			}
			object |= (arg1->areg1->opcode << 9);
			object |= (size == W) ? 0xc0 : 0x1c0;
			eff_add(arg2,ALL,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg2->atype == AIMM)
		{
			/*		cmpi				*/
			strcpy(instr_buf,inst->name);
			if(instr_buf[strlen(instr_buf)-1] != 'i')
				strcat(instr_buf,"i");
			inst = lookup(instr_buf,N_INSTALL,MNEMON)->itp;
			object = inst->opcode;
			object |= (size << 6);
			if (size == L)
				eff_add(arg1,DATALT | 0x4000,size);
			else
				eff_add(arg1,DATALT | 0x2000,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			if (size == B)
				generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg2->xp->xvalue & 0xff,arg2->xp->xsymptr);
			else if (size == W)
				generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg2->xp->xvalue & 0xffff,arg2->xp->xsymptr);
			else
				generate(2*BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg2->xp->xvalue,arg2->xp->xsymptr);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == ADREG)
		{
			object |= (arg1->areg1->opcode << 9);
			object |= (size << 6);
			eff_add(arg2,ALL,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else
		{
			yyerror("invalid operands for compare instruction");
			return;
		}

	case BCHG:
	case BTST:
		if (size != UNSPEC)
			yyerror("bit instructions should not have a size attribute");
		if (arg1->atype == ADREG)
		{
			object |= (arg1->areg1->opcode << 9);
			if (inst->tag == BTST)
				eff_add(arg2,DATNIM,size);
			else
				eff_add(arg2,DATALT,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		}
		else if (arg1->atype == AIMM)
		{
			/* Object code for bit instructions is 0x01?0	*/
			/*	when the bit number is dynamic (in a	*/
			/*	register), but 0x08?0 for a static bit	*/
			/*	number (bit number is immediate).	*/
			/*	Object code is converted by turning off	*/
			/*	the 1 bit and turning on the 8 bit.	*/
			object ^= 0x0100;
			object |= 0x0800;
			if (inst->tag == BTST)
				eff_add(arg2,DATNIM,size);
			else
				eff_add(arg2,DATALT,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,
				(arg1->xp->xsymptr == NULLSYM) ? 0 : GENRELOC,
				arg1->xp->xvalue,arg1->xp->xsymptr);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		}
		else
			yyerror("incorrect first operand to bit instruction");
		return;

	case ADD:
		if (arg1->atype == AIMM &&
			    arg1->xp->xsymptr == NULLSYM &&
			    arg1->xp->xvalue > 0 &&
			    arg1->xp->xvalue <= 8)
		{
			/* addq/subq */
			strcpy(instr_buf,inst->name);
			if(instr_buf[strlen(instr_buf)-1] != 'q')
				strcat(instr_buf,"q");
			inst = lookup(instr_buf,N_INSTALL,MNEMON)->itp;
			object = inst->opcode;
			if (arg1->xp->xvalue != 8)
				object |= (arg1->xp->xvalue << 9);
			if (size == UNSPEC)
				size = W;
			if (size == B && arg2->atype == AAREG)
			{
				yyerror("additive instruction with address destination cannot have byte attribute");
				size = W;
			}
			object |= (size << 6);
			eff_add(arg2,ALT,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg2->atype == AAREG)
		{
			/*		adda/suba		*/
			if (size == B)
				yyerror("additive instruction with address destination cannot have byte attribute");
			object |= (arg2->areg1->opcode << 9);
			object |= (size == L) ? 0x1c0 : 0xc0;
			eff_add(arg1,ALL,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == AIMM)
		{
			/* addi, where destination is not %an, and
			** literal is not between 1 and 8
			*/
			strcpy(instr_buf,inst->name);
			if(instr_buf[strlen(instr_buf)-1] != 'i')
				strcat(instr_buf,"i");
			inst = lookup(instr_buf,N_INSTALL,MNEMON)->itp;
			object = inst->opcode;
			if (size == UNSPEC)
				size = W;
			object |= (size << 6);
			if (size == L)
				eff_add(arg2,DATALT | 0x4000,size);
			else
				eff_add(arg2,DATALT | 0x2000,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			if (size == B)
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue & 0xff,arg1->xp->xsymptr);
			else if (size == W)
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue & 0xffff,arg1->xp->xsymptr);
			else
				generate(2*BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue,arg1->xp->xsymptr);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg2->atype == ADREG)
		{
			object |= (arg2->areg1->opcode << 9);
			if (size == UNSPEC)
				size = W;
			object |= (size << 6);
			eff_add(arg1,ALL,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == ADREG)
		{
			object |= (arg1->areg1->opcode << 9);
			object |= 0x100;
			object |= (size << 6);
			eff_add(arg2,ALTMEM,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else
			yyerror("illegal operand combination for additive instruction");
		return;

	case MOVM:
		if (size == B)
			yyerror("movm instruction allows only word and long attribute");
		if (size == L)
			object |= 0x40;
		if (arg2->atype == AIMM)
		{
			object |= 0x400;
			eff_add(arg1,CONPOST | 0x2000,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg2->xp->xvalue,arg2->xp->xsymptr);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		}
		else if (arg1->atype != AIMM)
			yyerror("incorrect operands for movm instruction");
		else
		{
			eff_add(arg2,CONPRE | 0x2000,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg1->xp->xvalue,arg1->xp->xsymptr);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
		}
		return;

	case MOVS:
		{
			if( !as10 )
				werror("a 68010 instruction");
			if ((inst2wd=(arg1->atype == AAREG)) || arg1->atype == ADREG)
			{
				eff_add(arg2,ALTMEM,size);
				inst2wd = (inst2wd << 15) | (arg1->areg1->opcode<< 12) | (1 << 11);
			}
			else if ((inst2wd=(arg2->atype == AAREG)) || arg2->atype == ADREG)
			{
				eff_add(arg1,ALTMEM,size);
				inst2wd = (inst2wd << 15) | (arg2->areg1->opcode<< 12);
			}
			else
				yyerror("one register operand req'd for movs");
			object |= (size == UNSPEC ? W : size) << 6;
			generate(BITSPOW,action,object,NULLSYM);
			generate(BITSPOW,0,inst2wd,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}

	case MOVP:
		if (size == B)
			yyerror("movp instruction allows only word and long attribute");
		if (arg1->atype == ADREG && arg2->atype == AOFF)
		{
			object |= (arg1->areg1->opcode << 9);
			object |= (((size == L) ? 7 : 6) << 6);
			object |= arg2->areg1->opcode;
			generate(BITSPOW,0,object,NULLSYM);
			generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg2->xp->xvalue,arg2->xp->xsymptr);
		}
		else if (arg1->atype == AOFF && arg2->atype == ADREG)
		{
			object |= (arg2->areg1->opcode << 9);
			object |= (((size == L) ? 5 : 4) << 6);
			object |= arg1->areg1->opcode;
			generate(BITSPOW,0,object,NULLSYM);
			generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg1->xp->xvalue,arg1->xp->xsymptr);
		}
		else
			yyerror("incorrect operands for movp instruction");
		return;

	case MOV:
		if (arg2->atype == CCREG)
		{
			object = 0x44c0;
			eff_add(arg1,DATAA,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == CCREG)
		{
			if( !as10 )
				werror("a 68010 instruction");
			object = 0x42c0;
			eff_add(arg2,DATALT,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == CTLREG )
		{
			if (size == UNSPEC )
				size = L;
			else if(size != L)
				yyerror("only long size attribute allowed");
			if (arg2->atype == AAREG)
			{
				if (arg1->areg1->opcode == USPREG)
				{	/* old form is one word */
					object = 0x4e68;
					object |= arg2->areg1->opcode;
					generate(BITSPOW,0,object,NULLSYM);
					return;
				}
				object = (0x8 | arg2->areg1->opcode) << 12;
			}
			else if (arg2->atype == ADREG)
				object = (arg2->areg1->opcode) << 12;
			else
				yyerror("destination operand must be a register");
			if( !as10 )
				werror("a 68010 instruction");
			object |= arg1->areg1->opcode;
			generate(BITSPOW,0,0x4e7a,NULLSYM);
			generate(BITSPOW,0,object,NULLSYM);
			return;
		}
		else if (arg2->atype == CTLREG )
		{
			if (size == UNSPEC )
				size = L;
			else if(size != L)
				yyerror("only long size attribute allowed");
			if (arg1->atype == AAREG)
			{
				if (arg2->areg1->opcode == USPREG)
				{
					object = 0x4e60;
					object |= arg1->areg1->opcode;
					generate(BITSPOW,0,object,NULLSYM);
					return;
				}
				object = (0x8 | arg1->areg1->opcode) << 12;
			}
			else if (arg1->atype == ADREG)
				object = (arg1->areg1->opcode) << 12;
			else
				yyerror("source operand must be a register");
			if( !as10 )
				werror("a 68010 instruction");
			object |= arg2->areg1->opcode;
			generate(BITSPOW,0,(0x4e7a | 0x1),NULLSYM);
			generate(BITSPOW,0,object,NULLSYM);
			return;
		}
		else if (arg2->atype == SRREG)
		{
			object = 0x46c0;
			eff_add(arg1,DATAA,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == SRREG)
		{
			object = 0x40c0;
			eff_add(arg2,DATALT,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else if (arg1->atype == AIMM && arg2->atype == ADREG &&
			 (size == L || size == UNSPEC) &&
			 arg1->xp->xsymptr == NULLSYM &&
			 arg1->xp->xvalue >= -128 && arg1->xp->xvalue <= 127)
		{
			object = 0x7000;
			object |= (arg2->areg1->opcode << 9);
			object |= (arg1->xp->xvalue & 0xff);
			generate(BITSPOW,0,object,NULLSYM);
			return;
		}
		else if (arg2->atype == AAREG)
		{
			object = 0x0040;
			if (size == B)
				yyerror("mov to address register cannot have byte attribute");
			object |= (((size == L) ? 0x2 : 0x3) << 12);
			object |= (arg2->areg1->opcode << 9);
			eff_add(arg1,ALL,size);
			generate(BITSPOW,action,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			return;
		}
		else
		{
			register long		savword;
			register int		savnum;
			register unsigned short	savaction;
			register symbol		*savsym;

			if (size == UNSPEC)
				size = W;
			savword = inst->opcode;
			eff_add(arg2,DATALT | 0x1000,size);
			/* Pick off mode and register for destination,	*/
			/*	and move them up to where they belong.	*/
			savword |= ((object & 07) << 9);
			savword |= ((object & 070) << 3);
			object = savword;
			savnum = numwords;
			savaction = action;
			savsym = symptr;
			savword = word;
			if (size == B)
				object |= 0x1000;
			else if (size == W)
				object |= 0x3000;
			else
				object |= 0x2000;
			eff_add(arg1,ALL | 0x1000,size);
			if (action == 0 && savaction == 0)
				generate(BITSPOW,0,object,NULLSYM);
			else
				generate(BITSPOW,MOVE,object,NULLSYM);
#ifdef	M68020
			genrest();
#else	M68020
			if (numwords == 1)
				generate(BITSPOW,action,word,symptr);
			else if (numwords == 2)
				generate(2*BITSPOW,action,word,symptr);
#endif	M68020
			if (savnum == 1)
				generate(BITSPOW,savaction,savword,savsym);
			else if (savnum == 2)
				generate(2*BITSPOW,savaction,savword,savsym);
			return;
		}

#ifdef	M68020
	case CALLM:
		if(!as20)
			werror("a 68020 instruction");
		if (size != UNSPEC)		/* check for correct size */
			yyerror("callm instruction is unsized");
		if (arg1->atype != AIMM)
			yyerror("callm should have first argument immediate");
		else if (arg1->xp->xvalue < 0 || arg1->xp->xvalue > 255) {
			yyerror("first arg to callm  must be between 0 and 255");
			arg1->xp->xvalue &= 0xff;
		}
		eff_add(arg2, (CONTROL | (1 << 31)),size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		generate(BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg1->xp->xvalue & 0xff,arg1->xp->xsymptr);
		genrest();
		return;

	case CHK:
		if(!as20)
			werror("a 68020 instruction");
		if (size == B)
			yyerror("chk instruction can not have byte attribute");
		if(size == UNSPEC) size = W;
		object |= (size << 6);
		if (arg2->atype != ADREG)
			yyerror("chk instruction requires data register for second operand");
		else
			object |= (arg2->areg1->opcode << 9);
		eff_add(arg1,DATAA,size);
		generate(BITSPOW,action,object,NULLSYM);
		genrest();
		return;

	case CHK2:
		inst2wd = 0x800;
	case CMP2:
		if(!as20)
			werror("a 68020 instruction");
		if (arg2->atype == AAREG)
			inst2wd |= 0x8000 | (arg2->areg1->opcode << 12);
		else if(arg2->atype == ADREG)
			inst2wd |= (arg2->areg1->opcode << 12);
		else
			yyerror("instruction requires a register for second operand");
		if(size == UNSPEC) size = W;
		object |= (size << 9);
		eff_add(arg1, (CONTROL | (1 << 31)),size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		generate(BITSPOW, 0, inst2wd, NULLSYM);
		genrest();
		return;

#endif	M68020
	default:
		yyerror("unknown two-operand instruction usage");
	}
}	/* gen2op()	*/



#ifdef	M68020
gen3op(inst,size,arg1,arg2,arg3)
register instr		*inst;
register int		size;
register struct arg	*arg1,
			*arg2,
			*arg3;
{
	object = inst->opcode;
	switch(inst->tag) {
	case PACK:
		if(!as20)
			werror("a 68020 instruction");
		if(size != UNSPEC)
			yyerror("instruction should have no size attribute");
		if (arg1->atype == ADEC && arg2->atype == ADEC)
			object |= 0x8;
		else if (arg1->atype != ADREG || arg2->atype != ADREG)
		{
			yyerror("only data register or predecrement address register pairs allowed as operands");
			return;
		}
		object |= (arg2->areg1->opcode << 9);
		object |= arg1->areg1->opcode;
		if (arg3->atype != AIMM)
			yyerror("immediate operand required as third operand of instruction");
		else if (arg3->xp->xvalue < -(1<<15) || arg3->xp->xvalue >= (1<<15))
		{
			werror("adjustment must fit into a word (masked)");
			arg3->xp->xvalue &= 0xffff;
		}
		generate(BITSPOW,0,object,NULLSYM);
		generate(BITSPOW,(arg3->xp->xsymptr == NULL) ? 0 : GENRELOC,
				 arg3->xp->xvalue,arg3->xp->xsymptr);
		return;

	case CAS:
		if(!as20)
			werror("a 68020 instruction");
		if(arg1->atype != ADREG || arg2->atype != ADREG)
			yyerror("cas instruction requires first two operands to be data registers");
		else {
			register int inst2wd;

			if(size == UNSPEC) size = W;
			object |= ((size + 1) << 9);
			inst2wd = (arg2->areg1->opcode << 6) |
							(arg1->areg1->opcode);
			eff_add(arg3, ALTMEM, size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW, 0, inst2wd, NULLSYM);
			genrest();
		}
		return;

	case CAS2:
		if(!as20)
			werror("a 68020 instruction");
		if(size == B)
			yyerror("invalid size specification for cas2 instruction");
		if(size == UNSPEC) size = W;
		if(arg1->atype != REGPAIR || arg2->atype != REGPAIR ||
						arg3->atype != REGPAIR)
			yyerror("all operands for cas2 instruction must be register pairs");
		else {
			register int inst2wd;

			if(arg1->areg1->tag != ADREG ||
				arg1->areg2->tag != ADREG ||
				arg2->areg1->tag != ADREG ||
				arg2->areg2->tag != ADREG)
				yyerror("first two operands for cas2 instruction must be data register pairs");
			object |= ((size + 1) << 9);
			generate(BITSPOW, 0, object, NULLSYM);
			if(arg3->areg1->tag == AAREG) inst2wd = (1<< 15);
			else inst2wd = 0;
			inst2wd |= ((arg3->areg1->opcode << 12) |
					(arg2->areg1->opcode << 6) |
					(arg1->areg1->opcode));
			generate(BITSPOW, 0, inst2wd, NULLSYM);
			if(arg3->areg2->tag == AAREG) inst2wd = (1<< 15);
			else inst2wd = 0;
			inst2wd |= ((arg3->areg2->opcode << 12) |
					(arg2->areg2->opcode << 6) |
					(arg1->areg2->opcode));
			generate(BITSPOW, 0, inst2wd, NULLSYM);
		}
		return;

	default:
		yyerror("Incomprehensible 3 operand instruction");
	}
}

bfgen(inst,arg1,arg2,arg3)
register instr		*inst;
register struct arg	*arg1,
			*arg2;
register instr		*arg3;
{
	register int inst2wd = 0;

	object = inst->opcode;
	if(!as20)
		werror("a 68020 instruction");
	if(arg3) {
		if(arg3->tag != ADREG)
			yyerror("one argument should be a data register for bit field instructions");
		else
			inst2wd |= (arg3->opcode << 12);
	}
	if(arg2->areg1 != NULLREG) {
		inst2wd |= ((1 << 11) | (arg2->areg1->opcode << 6));
	} else {
		if(arg2->xp == NULL)
			aerror("impossible null expression");
		if(arg2->xp->xtype != ABS)
			yyerror("offset for bit field instruction should be absolute");
		if(arg2->xp->xvalue < 0 || arg2->xp->xvalue > 31)
			yyerror("offset for bit field instruction should be between 0 and 31");
		inst2wd |= ((arg2->xp->xvalue & 31) << 6);
	}
	if(arg2->areg2 != NULLREG) {
		inst2wd |= ((1 << 5) | (arg2->areg2->opcode));
	} else {
		if(arg2->xp2 == NULL)
			aerror("impossible null expression");
		if(arg2->xp2->xtype != ABS)
			yyerror("offset for bit field instruction should be absolute");
		if(arg2->xp2->xvalue < 0 || arg2->xp->xvalue > 32)
			yyerror("offset for bit field instruction should be between 0 and 32");
		inst2wd |= (arg2->xp2->xvalue & 31);
	}
	if(inst->tag == BFCHG)
		eff_add(arg1,DRDALTC,0);
	else
		/* control + data register direct */
		eff_add(arg1,CONTROL|0x800,0);
	if (action == ABSOPT)
		generate(BITSPOW,IOPT,object,NULLSYM);
	else
		generate(BITSPOW,INSTI,object,NULLSYM);
	generate(BITSPOW, 0, inst2wd, NULLSYM);
	genrest();
}
		
#endif	M68020



flags(flag)
char	flag;
{
	char	errmsg[28];

	sprintf(errmsg,"illegal flag (%c) - ignored",flag);
	werror(errmsg);
}	/* flag()	*/

#ifdef	M68020
genrest()
{
	if (numwords == 1)
		generate(BITSPOW,action,word,symptr);
	else if (numwords == 2)
		generate(2*BITSPOW,action,word,symptr);
	else if (numwords != 0)
		yyerror("invalid immediate operand");
	if(nbdwords)
		generate(nbdwords*BITSPOW,bdaction,bdword,bdsymptr);
	if(nodwords)
		generate(nodwords*BITSPOW,odaction,odword,odsymptr);
}
#endif	M68020
