#ident	"@(#)as/m68k:fgencode.c	1.2"

#include	<stdio.h>
#include	"symbols.h"
#include	"instab.h"
#include	"gendefs.h"
#include	"expand.h"
#include	"expand2.h"

#define	HIWORD(x)	(((x) >> 16) & 0xffff)
#define	LOWORD(x)	((x) & 0xffff)

extern long	newdot;
extern short	opt;		/* No span-dependent optimization flag.	*/
extern upsymins	*lookup();

int		as68881 = {0};

long 		object;
int		numwords;
long		word;
symbol		*symptr;
unsigned short	action;

static int fsizes[] = { 6, 4, 0, 4, 1, 2, 3, 5}; /* for size to bit conv. */

fgenxop(inst,size,arg1,arg2)
register instr		*inst;
register int		size;
register struct arg	*arg1,
			*arg2;
{
	register int inst2wd;
	struct arg *arg3;		/* tmp storage for arg swap */

	if (inst->tag == FCMP_OPND) /* kludge in backwards motorola cmp bug */
		{
		arg3 = arg2; 		/* save  tmp 2nd operand */
		arg2 = arg1;		/* set 2nd operand to first */
		arg1 = arg3;		/* set 1st operand to prev second */
		}
		
	if(inst->nbits == (2*BITSPOW)) {
		object = HIWORD(inst->opcode);
		inst2wd = LOWORD(inst->opcode);
	} else {
		object = inst->opcode;
		inst2wd = 0;
	}
	switch (inst->tag) {

	case F12OPND:
		if(arg2 == (struct arg *)NULL) arg2 = arg1;

	case FCMP_OPND:
	case F2OPND:
		/* arg2 hopefully will not be null */

		if((arg2->atype != AFREG) && (inst->tag == FCMP_OPND))
			yyerror("first operand for the instruction should be floating-point data register");
		else
		    if(arg2->atype != AFREG)
			yyerror("second operand for the instruction should be floating-point data register");
		else {
			if(!as68881)
				werror("a 68881 instruction");
			if(arg1->atype == AFREG) {
				if(size == UNSPEC) size = X;
				else if(size != X)
					yyerror("size specification can only be .x");
				inst2wd |= ((arg1->areg1->opcode << 10) |
						(arg2->areg1->opcode << 7));
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW,0,inst2wd,NULLSYM);
			} else {
				if(size == UNSPEC) size = W;
				if(arg1->atype == ADREG && size > S)
					yyerror("invalid size specification for the instruction");
				inst2wd |= ((1 << 14) | (fsizes[size] << 10) |
						(arg2->areg1->opcode << 7));
				eff_add(arg1,DATAA,size);
				if (action == ABSOPT)
					generate(BITSPOW,IOPT,object,NULLSYM);
				else
					generate(BITSPOW,INSTI,object,NULLSYM);
				generate(BITSPOW,0,inst2wd,NULLSYM);
				/*
				 * What follows will not be adequate for
				 * immediate operands
				 */
				genrest();
			}
		}
		return;


	case FNOP:
		if(size != 0 || arg1 != (struct arg *)NULL ||
					arg2 != (struct arg *)NULL)
			yyerror("fnop is unsized with no arguments");
		if(!as68881)
			werror("a 68881 instruction");
		generate(BITSPOW, 0, object, NULLSYM);
		generate(BITSPOW, 0, inst2wd, NULLSYM);
		return;

	case FSINCOS:
		if(arg2->atype != FPREGPAIR)
			yyerror("second argument for fsincos should be floating-point data register pair");
		else {
			if(!as68881)
				werror("a 68881 instruction");
			if(arg1->atype == AFREG) {
				if(size == UNSPEC) size = X;
				else if(size != X)
					yyerror("size specification can only be .x");
				inst2wd |= ((arg1->areg1->opcode << 10) |
						(arg2->areg2->opcode << 7) |
						(arg2->areg1->opcode));
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW,0,inst2wd,NULLSYM);
			} else {
				if(size == UNSPEC) size = W;
				if(arg1->atype == ADREG && size > S)
					yyerror("invalid size specification for the instruction");
				inst2wd |= ((1 << 14) | (fsizes[size] << 10) |
						(arg2->areg2->opcode << 7) |
						(arg2->areg1->opcode));
				eff_add(arg1,DATAA,size);
				if (action == ABSOPT)
					generate(BITSPOW,IOPT,object,NULLSYM);
				else
					generate(BITSPOW,INSTI,object,NULLSYM);
				generate(BITSPOW,0,inst2wd,NULLSYM);
				/*
				 * What follows will not be adequate for
				 * immediate operands
				 */
				genrest();
			}
		}
		return;

	case FDBCC:
		if (size != UNSPEC)
			yyerror("fdbCC instruction should be unsized");
		if (arg1->atype != ADREG)
			yyerror("fdbCC instruction requires data register for first operand");
		else
			object |= arg1->areg1->opcode;
		if(!as68881)
			werror("a 68881 instruction");
		generate(BITSPOW,0,object,NULLSYM);
		generate(BITSPOW,0,inst2wd,NULLSYM);
		generate(BITSPOW,BRLOC,arg2->xp->xvalue,arg2->xp->xsymptr);
		return;

	case FBCC:
		if (size == B)
			yyerror("fbCC instruction should have word or long size specification if any");
		else
		{
			if(!as68881)
				werror("a 68881 instruction");
			if (opt)
				switch (shortsdi(arg1->xp->xsymptr,arg1->xp->xvalue,SDI2)) {
			case S_SDI:	/* br.w guaranteed to work.	*/
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case U_SDI:	/* Don't know, so generate a	*/
					/*	long for now.		*/
				generate(BITSPOW,FBCCOPT,inst->opcode,NULLSYM);
				generate(BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
				return;
			case L_SDI:
				break;
				/* Fall through to no-optimize code.	*/
			}
			object |= (1 << 6); /* long displacement */
			generate(BITSPOW,0,object,NULLSYM);
			generate(2*BITSPOW,BRLOC,arg1->xp->xvalue,arg1->xp->xsymptr);
			return;
		}

	case FSCC:
		if (size != UNSPEC && size != B)
			yyerror("incorrect size specification for fsCC instruction");
		if(!as68881)
			werror("a 68881 instruction");
		eff_add(arg1,DATALT,size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		generate(BITSPOW,0,inst2wd,NULLSYM);
		genrest();
		return;

	case FTST:
		if(!as68881)
			werror("a 68881 instruction");
		if(arg1->atype == AFREG) {
			if(size == UNSPEC) size = X;
			else if(size != X)
				yyerror("size specification can only be .x");
			inst2wd |= (arg1->areg1->opcode << 10);
			generate(BITSPOW,0,object,NULLSYM);
			generate(BITSPOW,0,inst2wd,NULLSYM);
		} else {
			if(size == UNSPEC) size = W;
			if(arg1->atype == ADREG && size > S)
				yyerror("invalid size specification for the instruction");
			inst2wd |= ((1 << 14) | (fsizes[size] << 10));
			eff_add(arg1,DATAA,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,0,inst2wd,NULLSYM);
			/*
			 * What follows will not be adequate for
			 * immediate operands
			 */
			genrest();
		}
		return;

	case FTRAPCC:
		if (size != W && size != L && size != UNSPEC)
			yyerror("illegal size attribute for ftrapcc instruction");
		if(!as68881)
			werror("a 68881 instruction");
		if(arg1 == NULL) {
			object |= 4;
			generate(BITSPOW, 0, object, NULLSYM);
			generate(BITSPOW, 0, inst2wd, NULLSYM);
		} else {
			if (arg1->atype != AIMM)
				yyerror("ftrapcc argument must be immediate operand");
			if(arg1->xp->xvalue < -(1<<15) ||
				arg1->xp->xvalue >= (1<<15) || size == L) {
				object = inst->opcode | 3;
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW, 0, inst2wd, NULLSYM);
				generate(2*BITSPOW,(arg1->xp->xsymptr == NULL) ? 0 : GENRELOC,
					 arg1->xp->xvalue,arg1->xp->xsymptr);
			} else {
				object = inst->opcode | 2;
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW, 0, inst2wd, NULLSYM);
				generate(BITSPOW,(arg1->xp->xsymptr == NULL) ?
						0 : GENRELOC,
						 arg1->xp->xvalue & 0xffff,
						 arg1->xp->xsymptr);
			}
		}
		return;

	case FSAVE:
		if (size != UNSPEC)
			yyerror("fsave instruction is unsized");
		if(!as68881)
			werror("a 68881 instruction");
		eff_add(arg1,CONPRE | 0x2000,size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		genrest();
		return;

	case FRESTORE:
		if (size != UNSPEC)
			yyerror("frestore instruction is unsized");
		if(!as68881)
			werror("a 68881 instruction");
		eff_add(arg1,CONPOST | 0x2000,size);
		if (action == ABSOPT)
			generate(BITSPOW,IOPT,object,NULLSYM);
		else
			generate(BITSPOW,INSTI,object,NULLSYM);
		genrest();
		return;

	case FMOVECR:
		if (size != UNSPEC && size != X)
			yyerror("fmovcr instruction should have .x attribute if any");
		if(!as68881)
			werror("a 68881 instruction");
		if (arg1->atype != AIMM || arg1->xp->xtype != ABS)
			yyerror("first argument for fmovcr must be absolute, immediate operand");
		if (arg1->xp->xvalue < 0 || arg1->xp->xvalue > 0x3f)
		{
			yyerror("first argument for fmovcr must be between 0 and 0x3f");
			arg1->xp->xvalue &= 0x3f;
		}
		inst2wd |= arg1->xp->xvalue;
		if(arg2->atype != AFREG)
			yyerror("second argument for fmovcr must be a floating-point data register");
		else
			inst2wd |= (arg2->areg1->opcode << 7);
		generate(BITSPOW,0,object,NULLSYM);
		generate(BITSPOW,0,inst2wd,NULLSYM);
		return;

	case FMOVEM:
		if (size != UNSPEC && size != X)
			yyerror("fmovm instruction allows only .x attribute if any");
		if(!as68881)
			werror("a 68881 instruction");
		if (arg2->atype == AIMM || arg2->atype == ADREG)
		{
			eff_add(arg1,CONPOST | 0x2000,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			if(arg2->atype == ADREG)
				inst2wd |= ((03 << 11) | (arg2->areg1->opcode << 4));
			else {
				if(arg2->xp->xvalue < 0 || arg2->xp->xvalue > 0xff) {
					yyerror("register list argument for fmovm must be between 0 and 0xff");
					arg2->xp->xvalue &= 0xff;
				}
				inst2wd |= ((2 << 11) | (arg2->xp->xvalue));
			}
			generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 :
							NDXRELOC,inst2wd,
							arg2->xp->xsymptr);
			genrest();
		} else if (arg1->atype == AIMM || arg1->atype == ADREG) {
			inst2wd |= (1 << 13);
			eff_add(arg2,CONPRE | 0x2000,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			if(arg1->atype == ADREG)
				inst2wd |= ((1 << 11) | (arg1->areg1->opcode << 4));
			else {
				if(arg1->xp->xvalue < 0 || arg1->xp->xvalue > 0xff) {
					yyerror("register list argument for fmovm must be between 0 and 0xff");
					arg1->xp->xvalue &= 0xff;
				}
				inst2wd |= arg1->xp->xvalue;
			}
			generate(BITSPOW,(arg2->xp->xsymptr == NULL) ? 0 :
							NDXRELOC,inst2wd,
							arg2->xp->xsymptr);
			genrest();
		}
		else
			yyerror("incorrect operands for fmovm instruction");
		return;

	case FMOVE:
		if(!as68881)
			werror("a 68881 instruction");
		if (arg1->atype == FCTLREG ) {
			if (size != UNSPEC && size != L)
				yyerror("only long size attribute allowed");
			if(arg2->atype == AAREG && arg1->areg1->opcode != FPIAR)
				yyerror("source operand must be %fpiar if destination is address register");
			inst2wd |= ((1 << 15) | (1 << 13) | (arg1->areg1->opcode << 10));
			eff_add(arg2,ALT,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,0,inst2wd,NULLSYM);
			genrest();
		} else if(arg2->atype == FCTLREG) {
			if (size != UNSPEC && size != L)
				yyerror("only long size attribute allowed");
			if(arg1->atype == AAREG && arg2->areg1->opcode != FPIAR)
				yyerror("destination operand must be %fpiar if source is address register");
			inst2wd |= ((1 << 15) | (arg1->areg1->opcode << 10));
			eff_add(arg2,ALL,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,0,inst2wd,NULLSYM);
			genrest();
		} else if (arg2->atype == AFREG) {
			if(arg1->atype == AFREG) {
				if(size != UNSPEC && size != X)
					yyerror("invalid size specification for the instruction");
				inst2wd |= ((arg1->areg1->opcode << 10) |
						(arg2->areg1->opcode << 7));
				generate(BITSPOW,0,object,NULLSYM);
				generate(BITSPOW,0,inst2wd,NULLSYM);
			} else {
				if(size == UNSPEC) size = W;
				if(arg1->atype == ADREG && size > S)
					yyerror("invalid size specification for the instruction");
				inst2wd |= ((1 << 14) | (fsizes[size] << 10) |
						(arg2->areg1->opcode << 7));
				eff_add(arg1,DATAA,size);
				if (action == ABSOPT)
					generate(BITSPOW,IOPT,object,NULLSYM);
				else
					generate(BITSPOW,INSTI,object,NULLSYM);
				generate(BITSPOW,0,inst2wd,NULLSYM);
				/*
				 * What follows will not be adequate for
				 * immediate operands
				 */
				genrest();
			}
		} else if (arg1->atype == AFREG) {
			if(size == UNSPEC) size = W;
			if(arg2->atype == ADREG && size > S)
				yyerror("invalid size specification for the instruction");
			inst2wd |= ((3 << 13) | (fsizes[size] << 10) |
					(arg1->areg1->opcode << 7));
			eff_add(arg2,DATALT,size);
			if (action == ABSOPT)
				generate(BITSPOW,IOPT,object,NULLSYM);
			else
				generate(BITSPOW,INSTI,object,NULLSYM);
			generate(BITSPOW,0,inst2wd,NULLSYM);
			/*
			 * What follows will not be adequate for
			 * immediate operands
			 */
			genrest();
		} else
			yyerror("invalid operands for fmov instruction");
		return;

	default:
		yyerror("unknown floating-point instruction usage");
	}
}	/* fgenxop()	*/
