
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)as/m68k:addr2.c	1.2"
#include <stdio.h>
#include <reloc.h>
#include <storclass.h>
#include <syms.h>
#include "systems.h"
#include "gendefs.h"
#include "symbols.h"
#include "codeout.h"
#include "scnhdr.h"
#include "instab.h"



extern unsigned short
		relent;	/* Number of reloc entries written to fdrel.	*/

extern long	newdot;

extern FILE	*fdrel,	/* File of relocation table information.	*/
		*fdcode;/* File of intermediate object code.		*/
extern upsymins
	*lookup();

extern BYTE	*longsdi;
extern struct scnhdr sectab[];

extern symbol
	symtab[],
	*dot;

extern short
	filedef;
extern char
	cfile[];


extern	setfile(),
	lineno(),
	linenum(),
	lineval(),
	define(),
	endef(),
	setval(),
	settyp(),
	setlno(),
	setscl(),
	settag(),
	setsiz(),
	setdim1(),
	setdim2(),
	newstmt(),
	genreloc(),
	brloc(),
	braopt(),
	bccopt(),
	bsropt(),
	absopt(),
	swbeg(),
	move(),
	iopt(),
	insti(),
	absbr(),
#ifdef	M68020
	fbccopt(),
	inline(),	/* from 3.0 */
	dotzero(),	/* from 3.0 */
#endif	M68020
	ndxreloc();


int	(*(modes[NACTION+2]))() =
	{
	0,
	setfile,
	lineno,
	linenum,
	lineval,
	define,
	endef,
	setval,
	settyp,
	setlno,
	setscl,
	settag,
	setsiz,
	setdim1,
	setdim2,
	newstmt,
	genreloc,
	brloc,
	braopt,
	bccopt,
	bsropt,
	absopt,
	swbeg,
	move,
	iopt,
	insti,
	absbr,
	ndxreloc,
#ifdef	M68020
	fbccopt,
	/* from 3.0 */
	inline,
	dotzero,
#endif	M68020
	0
	};


genreloc(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	char		*rsym;
	prelent		trelent;
	short		stype;
	long		testval;

	if (sym != NULLSYM)
	{
		code->cvalue += sym->value;
		stype = sym->styp & TYPE;
		testval = code->cvalue;
		if ((code->cnbits == BITSPBY && (testval < -128 || testval > 127)) ||
		    (code->cnbits == BITSPOW && (testval < -32768 || testval > 32767)))
			aerror("size of code generated cannot hold operand");
	}
	else
		return;

	switch (stype)
	{
	case ABS:
		return;
	case TXT:
	case DAT:
	case BSS:
		rsym = sectab[sym->sectnum].s_name;
		break;
	case UNDEF:
		if (sym->styp != SECTION)
			sym->styp |= EXTERN; /* make sure it gets in symbol table */
		rsym = sym->_name.name;
		break;
	default:
		aerror("attempt to relocate weird type");
	}

	trelent.relval = newdot;
	trelent.relname = rsym;
	if (code->cnbits == 8)
		trelent.reltype = R_RELBYTE;
	else if (code->cnbits == 16)
		trelent.reltype = R_RELWORD;
	else
		trelent.reltype = R_RELLONG;
	fwrite((char *)(&trelent),sizeof(prelent),1,fdrel);
	++relent;
}	/* genreloc()	*/



brloc(sym,code)
	register symbol	*sym;
	register codebuf	*code;
{
	prelent		trelent;
	register short	stype;
	register long	offset;

	offset = sym->value - newdot;
	if (code->cnbits == BITSPBY)
		offset -= 1;
	code->cvalue += offset;
	stype = sym->styp & TYPE;

	if (stype == UNDEF)
	{
		sym->styp |= EXTERN;	/* Make sure it gets into the	*/
		trelent.relval = newdot;/*	symbol table.		*/
		trelent.relname = sym->_name.name;
		if (code->cnbits == 8)
			trelent.reltype = R_PCRBYTE;
		else if(code->cnbits == 16)
			trelent.reltype = R_PCRWORD;
		else
			trelent.reltype = R_PCRLONG;
		fwrite((char *)(&trelent),sizeof(prelent),1,fdrel);
		++relent;
	}
	else				/* check for valid offset */
	{
#ifdef	m68k
	    if (offset == 0)
		yyerror("Illegal short branch with 0 offset");
#endif	m68k
	    if (offset < 0)
		offset = ~offset;	/* force sign bits to 0 */
	    if(code->cnbits == 8 && (offset & ~0x7fffL) != 0) { /* 32 bit off */
		codgen(code->cnbits,0xff);
		code->cnbits = 2*BITSPOW;
	    } else if(code->cnbits == 8  && (offset & ~0x7fL)   != 0) {
		codgen(code->cnbits,0x00);
		code->cnbits = BITSPOW;
	    } else if ((code->cnbits == 8  && (offset & ~0x7fL) != 0)
		|| (code->cnbits == 16 && (offset & ~0x7fffL) != 0))
		aerror("branch offset is too remote");
	}
}	/* brloc()	*/



braopt(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	if (*++longsdi)
	{
		code->cvalue |= 0xff;
		codgen(code->cnbits,code->cvalue);
		getcode(code);
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		code->cnbits = 2*BITSPOW;
		code->cvalue = 0;
		brloc(sym,code);
		return;
	}
	/* Otherwise, original bra.w is ok, so codgen gets code as-is.	*/
}	/* braopt()	*/



bccopt(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	if (*++longsdi)
	{	/* Original bcc.w is no good, and the second word	*/
		/* is only good for the symbol it contains.  Negate	*/
		/* the direction of the branch, then use this to branch	*/
		/* around a jmp.  Direction is reversed by toggling	*/
		/* eighth bit.						*/
		code->cvalue ^= 0x100;

		/* Add a displacement which will get past the jmp.	*/
		code->cvalue |= 6;
		codgen(code->cnbits,code->cvalue);
		codgen(BITSPOW,0x4ef9);			/*	jmp	*/
		getcode(code);
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		code->cnbits = 2*BITSPOW;
		code->cvalue = 0;
		genreloc(sym,code);	
		return;
	}
	/* Otherwise, original bcc.w is ok, so codgen gets code as-is.	*/
}	/* bccopt()	*/

bsropt(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	if (*++longsdi)
	{
		code->cvalue |= 0xff;
		codgen(code->cnbits,code->cvalue);
		getcode(code);
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		code->cnbits = 2*BITSPOW;
		code->cvalue = 0;
		brloc(sym,code);
		return;
	}
	/* Otherwise, original bsr.w is ok, so codgen gets code as-is.	*/
}	/* bsropt()	*/


#ifdef	M68020

fbccopt(sym,code)
	register symbol	*sym;
	register codebuf	*code;
{
	if (*++longsdi)
	{
		/*	Offset is long */
		code->cvalue |= (1 << 6);
		codgen(code->cnbits,code->cvalue);
		getcode(code);
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		code->cnbits = 2*BITSPOW;
		code->cvalue = 0;
		brloc(sym,code);	
		return;
	}
	/* Otherwise, original fbcc.w is ok, so codgen gets code as-is.	*/
}	/* fbccopt()	*/

#endif	M68020


absopt(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	if (*++longsdi)
	{	/* original abs.w is no good.  The mode field needs to	*/
		/* be changed to abs.l, and the next word has to be	*/
		/* expanded to two words.				*/
		code->cvalue |= 0x1;
	}
	codgen(code->cnbits,code->cvalue);
	getcode(code);
	if (*longsdi)
		code->cnbits = 2*BITSPOW;
	sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
	genreloc(sym,code);
}	/* absopt()	*/



swbeg(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	int		swbegct;
	int		i;
	long		swtabbase;

	codgen(code->cnbits,code->cvalue);
	getcode(code);
	swbegct = code->cvalue;
	codgen(code->cnbits,code->cvalue);
	/* Swbeg line ends in newline, followed by a line with just	*/
	/* the switch table beginning, then a newline, then "arg"	*/
	/* switch table elements, each accompanied by a newline.	*/
	getcode(code);
	sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
	newstmt(sym,code);
	getcode(code);
	sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
	newstmt(sym,code);
	swtabbase = newdot;	/* The value of the location counter	*/
				/*	for the right hand side of the	*/
				/*	label subtraction expression.	*/

	for (i = 1; i < swbegct; i++)
	{
		getcode(code);
		sym = symtab + code->cindex - 1;
		codgen(code->cnbits,sym->value - swtabbase);
		getcode(code);
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		newstmt(sym,code);
	}

	/* We've completed all but one of the elements of the switch	*/
	/* table.  Codout (the routine which invoked this routine)	*/
	/* will call codgen with what we leave in code.  Therefore, the	*/
	/* last element of the switch table is left in code for codout.	*/

	getcode(code);
	sym = symtab + code->cindex - 1;
	code->cvalue = sym->value - swtabbase;
}	/* swbeg()	*/



move(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	int		mode1;
	int		mode2;

	codgen(code->cnbits,code->cvalue);
	mode1 = code->cvalue & 070;
	mode2 = code->cvalue & 0700;
	if (mode1 > 040)	/* Source has more operand data.	*/
	{
		getcode(code);
		if (code->caction == GENRELOC)
		{
			sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
			genreloc(sym,code);
		}
		codgen(code->cnbits,code->cvalue);
	}
	if (mode2 > 0400)	/* Destination has more operand data.	*/
	{
		getcode(code);
		if (code->caction == GENRELOC)
		{
			sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
			genreloc(sym,code);
		}
		codgen(code->cnbits,code->cvalue);
	}
	code->cnbits = 0;
}	/* move()	*/



iopt(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	if (*++longsdi)
		code->cvalue |= 0x1;
	codgen(code->cnbits,code->cvalue);
	getcode(code);
	if (code->caction == GENRELOC)
	{
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		genreloc(sym,code);
	}
	codgen(code->cnbits,code->cvalue);
	getcode(code);
	if (*longsdi)
		code->cnbits = 2*BITSPOW;
	sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
	genreloc(sym,code);
}	/* iopt()	*/



insti(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	int		mode;

	mode = code->cvalue & 070;
	codgen(code->cnbits,code->cvalue);
	getcode(code);
	if (code->caction == GENRELOC)
	{
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		genreloc(sym,code);
	}
	if (mode > 040)
	{
		codgen(code->cnbits,code->cvalue);
		getcode(code);
		if (code->caction == GENRELOC)
		{
			sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
			genreloc(sym,code);
		}
	}
}	/* insti()	*/



absbr(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	if (*++longsdi)
	{	/* Original pc-relative instruction is no good, so we	*/
		/* convert it to the same instruction using the abs.l	*/
		/* mode.						*/
		code->cvalue ^= 03;
		codgen(code->cnbits,code->cvalue);
		getcode(code);
		code->cnbits = 2*BITSPOW;
		sym = code->cindex ? (symtab + code->cindex - 1) : NULLSYM;
		genreloc(sym,code);
		return;
	}
	codgen(code->cnbits,code->cvalue);
	getcode(code);
	if (code->cindex)
	{
		sym = symtab + code->cindex - 1;
		brloc(sym,code);
	}
}	/* absbr()	*/



ndxreloc(sym,code)
	register symbol	*sym;
	codebuf		*code;
{
	prelent		trelent;

	if (sym == NULLSYM)
		return;
	codgen(BITSPBY,code->cvalue >> BITSPBY);
	code->cvalue &= 0xff;
	code->cnbits = BITSPBY;
	genreloc(sym,code);
}	/* ndxreloc()	*/
