/*
 * $Header: opset.c,v 1.1 87/09/17 20:13:35 root Exp $
 */
#include "head.h"

/*
 *	UNIX debugger (taken from adb on is68k port)
 *	Instruction printing routines.
 *	MACHINE DEPENDENT
 */

/*
 * inst_ptr: Buffer pointer containing instruction to dissamble.
 * This buffer if filled in printins() otherwise assume to be empty
 * This was a KLUGE way of passing the ENTIRE opcode to das.
 */ 
unsigned short *inst_ptr;
int	errlev;

extern char *glob_linep;

# define MAXLEN 3
#define NOTEXT	0

long dis_dot();

printins(fmt,idsp)
char fmt;
{
	oincr = dis_dot(dot,idsp,fmt) - dot;
	if (oincr)
		printf("%-8s", glob_linep);
}

long
dis_dot(pc, idsp, fmt)
register unsigned int	*pc;
int	idsp;
char	fmt; 	/* unused */
{
	register long newdot, savdot;

	savdot = dot;
	if (getins(pc, idsp) < 0) {
		printf("text address not found");
		errlev++;
		return savdot;
	}
	newdot = dot;			/* das increments dot */
	dot = savdot;			/* restore */
	return newdot;
}

getins(pc, idsp)
register unsigned int	*pc;
int	idsp;
{
	unsigned int codebuf[MAXLEN];
	register unsigned short *opcode;

	opcode = inst_ptr = (unsigned short *)(codebuf);
	inst_ptr++;

	if (!chktxt(pc, idsp))
		return -1;
	  
	*codebuf = chkget(pc++, idsp);

	*(codebuf+1) = (chktxt(pc, idsp) ? (chkget(pc++, idsp)) : NOTEXT);
	*(codebuf+2) = (chktxt(pc, idsp) ? (chkget(pc, idsp)) : NOTEXT);

	dot += 2;
	if (das_print_ins(*opcode, 0))
		return -1;
	return 0;
}

#define MAXNAME 256 

psymbol (val, reloc)
int val;
int reloc;	/* not used */
{
	register int diff;
	char buf[MAXNAME];

	if (adrtoprocp(val) == badproc)
		sprintf(buf, "#0x%x", val);
	else {
		diff = adrtoext(val);
		strcpy(buf, sl_name);
		if (diff && diff > 0)
			sprintf(buf + strlen(buf), "+%x", diff);
	}
	LPrintf("%s", buf);
}

preloc (loc, val)
register long loc;
int val;
{
	psymbol(val, 0);
}
