#ident	"@(#)com:opset.c	1.2"

#include "head.h"

/*
 *	UNIX debugger (taken from adb on is68k port)
 *	Instruction printing routines.
 *	MACHINE DEPENDENT
 */

int	errlev;

extern char *glob_linep;

#define NOTEXT	0

long dis_dot();

printins(fmt,idsp)
char fmt;
{
	oincr = dis_dot(dot,idsp,fmt) - dot;
	if (oincr)
		printf("%-8s", glob_linep);
}

long
dis_dot(pc, idsp, fmt)
register unsigned int	*pc;
int	idsp;
char	fmt; 	/* unused */
{
	register long newdot, savdot;

	savdot = dot;
	if (getins(pc, idsp) < 0) {
		printf("text address not found");
		errlev++;
		return savdot;
	}
	newdot = dot;			/* das increments dot */
	dot = savdot;			/* restore */
	return newdot;
}

u_int *curr_pc;
static int count;

static union {
	u_int val;
	u_char chars[4];
} buf;

int
getnextbyte()
{
	if ((count % sizeof(u_int)) == 0)
		buf.val = chkget(curr_pc++,ISP);
	return buf.chars[count++ % sizeof(u_int)];
}

getins(pc, Idsp)
register u_int	*pc;
int	Idsp;
{

	curr_pc = pc;
	buf.val = chkget(curr_pc++,ISP);
	count = 2;
	dot += 2;
	if (das_print_ins(*(u_short *)&buf.val, 0))
		return -1;
	return 0;
}

#define MAXNAME 256 

psymbol (val, reloc)
int val;
int reloc;	/* not used */
{
	register int diff;
	char buf[MAXNAME];

	if (adrtoprocp(val) == badproc)
		sprintf(buf, "#0x%x", val);
	else {
		diff = adrtoext(val);
		strcpy(buf, sl_name);
		if (diff && diff > 0)
			sprintf(buf + strlen(buf), "+%x", diff);
	}
	LPrintf("%s", buf);
}

preloc (loc, val)
register long loc;
int val;
{
	psymbol(val, 0);
}
