/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)pwd:pwd.c	1.12"
/*
**	Print working (current) directory
*/


#include	<stdio.h>
#include	<sys/param.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<dirent.h>

struct	stat	d, dd;
struct	dirent	*dir;

char	dot[]	 = ".";
char	dotdot[] = "..";
char	name[MAXNAMLEN];

#ifdef	is68k
char		hostname[MAXHOSTNAMELEN] = '\0';
unsigned long	rpid;
#endif	is68k

DIR	*file;
int	off = -1;

main()
{
    	long dot_ino;
#ifdef	is68k
	if ((file = opendir(dot)) == NULL) {
		fprintf(stderr,"pwd: cannot open .\n");
		exit(2);
	}
	if ((rpid = getrpid(file->dd_fd)) < 0) {
		fprintf(stderr,"pwd: cannot obtain rpid.\n");
		exit(2);
	} else if (rpid != 0) {
		if (getmachname(rpid, hostname, MAXHOSTNAMELEN) < 0) {
			fprintf(stderr,"pwd: failed getmachname\n");
			exit(2);
		}
	}
#endif	is68k
	for(;;) {
		/*
		 * The stat structure uses a short to hold the inode number.
		 * If the inode is greater than 64k it will be truncated and
		 * never found in the read loop of the parent directory.
		 * By using readdir on the current directory searching for
		 * '.' we can find the true 32bit number.
		 */
	    	file = opendir (".");
		if (file == NULL) {
		    fprintf (stderr, "pwd: can't open .\n");
		    exit (2);
		}
		do {
		    dir = readdir (file);
		    if (dir == NULL) {
			fprintf (stderr, "pwd: read error in .\n");
			exit (2);
		    }
		} while (strcmp (dir->d_name, "."));
		dot_ino = dir->d_ino;
		closedir (file);

		if(stat(dot, &d) < 0) {
			fprintf(stderr, "pwd: cannot stat .!\n");
			exit(2);
		}
		if ((file = opendir(dotdot)) == NULL) {
			fprintf(stderr,"pwd: cannot open ..\n");
			exit(2);
		}
		if(fstat(file->dd_fd, &dd) < 0) {
			fprintf(stderr, "pwd: cannot stat ..!\n");
			exit(2);
		}
		if(chdir(dotdot) < 0) {
			fprintf(stderr, "pwd: cannot chdir to ..\n");
			exit(2);
		}
		if(d.st_dev == dd.st_dev) {
			if(dot_ino == dd.st_ino)
				prname();
			do
				if ((dir = readdir(file)) == NULL) {
					fprintf(stderr, "pwd: read error in ..\n");
					exit(2);
				}
			while (dir->d_ino != dot_ino);
		}
		else do {
				if((dir = readdir(file)) == NULL) {
					fprintf(stderr, "pwd: read error in ..\n");
					exit(2);
				}
				stat(dir->d_name, &dd);
		} while(dd.st_ino != dot_ino || dd.st_dev != d.st_dev);
		(void)closedir(file);
		cat();
	}
}

prname()
{
#ifdef	is68k
	if (*hostname != '\0') {
		write(1, "/@", 2);
		write(1, hostname, strlen(hostname));
		*hostname = '\0';
	}
#endif	is68k
	write(1, "/", 1);
	if (off<0)
		off = 0;
	name[off] = '\n';
	write(1, name, off+1);
	exit(0);
}

cat()
{
	register i, j;

	i = -1;
	while (dir->d_name[++i] != 0) 
	if ((off+i+2) > MAXNAMLEN - 1)
		prname();
	for(j=off+1; j>=0; --j)
		name[j+i+1] = name[j];
	off=i+off+1;
	name[i] = '/';
	for(--i; i>=0; --i)
		name[i] = dir->d_name[i];
}
