/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)ps:ps.c	1.3"

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include "/usr/.include.BSD/a.out.h"
#include <pwd.h>
#include <sys/param.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <machine/pte.h>
#include <sys/vm.h>
#include <sys/stat.h>
#include <math.h>
#include <errno.h>
#include <dirent.h>

char *nl_names[] = {
	"_proc",
#define	X_PROC		0
	"_Usrptmap",
#define	X_USRPTMAP	1
	"_usrpt",
#define	X_USRPT		2
	"_text",
#define	X_TEXT		3
	"_nswap",
#define	X_NSWAP		4
	"_maxslp",
#define	X_MAXSLP	5
	"_ccpu",
#define	X_CCPU		6
	"_ecmx",
#define	X_ECMX		7
	"_nproc",
#define	X_NPROC		8
	"_ntext",
#define	X_NTEXT		9
	"_dmmin",
#define	X_DMMIN		10
	"_dmmax",
#define	X_DMMAX		11
	"_Sysmap",
#define	X_SYSMAP	12
	"_Syssize",
#define	X_SYSSIZE	13
	"_inode",
#define X_INODE		14
	"_file",
#define X_FILE		15
	"_cfree",
#define X_CFREE		16
	"_callout",
#define X_CALLOUT	17
	"_swapmap",
#define X_SWAPMAP	18
	"_argmap",
#define X_ARGMAP	19
	"_kernelmap",
#define X_KERNELMAP	20
	"_mbmap",
#define X_MBMAP		21
	"_nch",
#define X_NCH		22
	"_quota",
#define X_QUOTA		23
	"_dquot",
#define X_DQUOT		24
	"_swbuf",
#define X_SWBUF		25
	"_buf",
#define X_BUF		26
	"_cmap",
#define X_CMAP		27
	"_buffers",
#define X_BUFFERS	28
	"_buffermap",
#ifdef	is68k
#define X_BUFFERMAP	29
	"_buf18",
#define X_BUF18		30
	"_bufffermap18",
#define X_BUFFERMAP18	31
	"_locklist",
#define X_LOCKLIST	32
	"_Client",
#define X_CLIENT	33
#endif	is68k
	""
};

struct nlist *nl;			/* all because we can't init unions */
int nllen;				/* # of nlist entries */

#define	NPROC	16
struct	proc proc[NPROC];		/* a few, for less syscalls */
struct	proc *mproc;

union {
	struct	user user;
	char	upages[UPAGES][NBPG];
} user;
#define u	user.user

char	*tptr, *gettty(), *getcmd(), state();
char	*calloc(), *sbrk(), *strcpy(), *strcat(), *strncat();
char	*strncpy(), *ttyname(), *malloc(), *realloc();
char	*kmemf, *memf, *swapf, *nlistf;
int	kmem, mem, swap = -1, npr, pcbpf, argaddr;
int	nswap, nproc, dmmin, dmmax, Syssize, nttys;

long	lseek();
off_t	vtophys();
struct	pte *Usrptmap, *usrpt, *Sysmap;

struct	ttys {
	dev_t	ttyd;
	int cand;
	char	name[DIRSIZ+1];
} *allttys;
int cand[16] = {-1, -1, -1, -1, -1, -1, -1, -1,
		-1, -1, -1, -1, -1, -1, -1, -1};
struct lttys {
	struct ttys ttys;
	struct lttys *next;
} *lallttys;

#define	pgtok(a)	(ctob(a)/1024)

#define	PSARGSZ	40 	/* size of command args string */
#define NTTYS	20	/* max number ttys that can be specified with the -t option  */
#define SIZ 	30	/* max number processes that can be specified with -p and -g */
#define ARGSIZ	30	/* size of buffer which holds args for -t, -p & -u options   */

#define MAXLOGIN	8	/*max number of char in userid that will be printed  */

struct udata {
	unsigned short uid;		/* numeric user id */
	char name[MAXLOGIN];
};

#define	UDQ	50
struct udata *ud;
struct udata uid_tbl[SIZ];		/* table to store selected uid's */

int	nud = 0, maxud = 0, nut = 0;
int	retcode=1, ntty = 0, npid = 0, ngrpid = 0;
int	c, sflg; lflg, cflg, eflg, uflg, aflg, dflg;
int	pflg, fflg, gflg, nflg, tflg, errflg;
int	pid[SIZ], grpid[SIZ];	

static char stdbuf[BUFSIZ];
char	*parg, *p1, argbuf[ARGSIZ], *tty[NTTYS];

main(argc, argv)
char **argv;
{
	int puid, ppid, ppgrp, found, pgerrflg = 0, i, j;
	extern int optind, num();
	off_t procp;
	unsigned size;
	register char **ttyp = tty, *getstr, *name, *p;
	extern char *optarg;
	char *usage="ps [ -edalf ] [ -c kmemfile ] [ -s swapdev ] [ -n namelist ] [ -t tlist ]";
	char *usage2="	[ -p plist ] [ -u ulist ] [ -g glist ]";

	getstr = "lfeadn:s:c:t:p:g:u:";	
	nlistf = "/vmunix";
	kmemf = "/dev/kmem";
	memf = "/dev/mem";
	swapf = "/dev/drum";
	setbuf(stdout, stdbuf);
	while ((c = getopt(argc,argv,getstr)) != EOF)
		switch(c) {
		case 'l':		/* long listing */
			lflg++;
			break;

		case 'f':		/* full listing */
			fflg++;
			break;

		case 'e':		/* list for every process */
			eflg++;
			tflg = uflg = pflg = gflg = 0;
			break;

		case 'a':	/* same as e except no proc grp leaders */
			aflg++; 	/* and no non-terminal processes     */
			break;

		case 'd':	/* same as e except no proc grp leaders */
			dflg++;
			break;

		case 'n':		/* alternate namelist */
			nflg++;
			nlistf = optarg;
			break;

		case 'c':		/* core file given */
			cflg++;
			kmemf = optarg;
			memf = kmemf;
			break;	

		case 's':		/* swap device given */
			sflg++;
			swapf = optarg;
			break;

		case 't':		/* terminals */
			tflg++;
			p1 = optarg;
			do {
				parg = argbuf;
				if (ntty >= NTTYS)
					break;
				getarg();
		        	if ((p = malloc(14)) == NULL) {
					fprintf(stderr,"ps: no memory\n");
					exit(1);
				}
		        	size = 14;
		        	if(isdigit(*parg)) {
		        	        strcpy(p, "tty");
		        	        size -= 3;
		        	}
		        	strncat(p, parg, size);
				*ttyp++ = p;
				ntty++;
			}
			while (*p1);
			break;

		case 'p':		/* proc ids */
			pflg++;
			p1 = optarg;
			parg = argbuf;
			do {
				if (npid >= SIZ)
					break;
				getarg();
				if (!num(parg)) {
					pgerrflg++;
					fprintf(stderr,
						"ps: %s in an invalid non-numeric argument for -p option\n", parg);
				}
				pid[npid++] = atoi(parg);
			}
			while (*p1);
			break;

		case 'g':		/* proc group */
			gflg++;
			p1 = optarg;
			parg = argbuf;
			do {
				if (ngrpid >= SIZ)
					break;
				getarg();
				if (!num(parg)) {
					pgerrflg++;
					fprintf(stderr,
						"ps: %s is an invalid non-numeric argument for -g option\n", parg);
				}
				grpid[ngrpid++] = atoi(parg);
			}
			while (*p1);
			break;

		case 'u':		/* user name or number */
			uflg++;
			p1 = optarg;
			parg = argbuf;
			do {
				getarg();
				if(nut < SIZ)
					strncpy(uid_tbl[nut++].name,parg,MAXLOGIN);
			}
			while (*p1);
			break;

		default:			/* error on ? and s, if not pdp11 */
			errflg++;
			break;
		}

	if (errflg || (optind < argc) || pgerrflg) {
		fprintf(stderr,"usage: %s\n%s\n",usage,usage2);
		exit(1);
	}
	if (tflg)
		*ttyp = 0;
						/* if specifying options not used, */
						/*    current terminal is default  */
	if ( !(aflg || eflg || dflg || uflg || tflg || pflg || gflg )) {
		name = 0;
		for (i = 2; i > -1; i--)
			if (isatty(i)) {
				name = ttyname(i);
				break;
			}
		if (name == 0) {
			fprintf(stderr, "ps: can't find controlling terminal\n");
			exit(1);
		}
		name += 5;
		if (strncmp (name, "tty", 3) == 0)
			name += 3;
		*ttyp++ = name;
		*ttyp = 0;
		ntty++;
		tflg++;
	}
	if (eflg)
		tflg = uflg = pflg = gflg = aflg = dflg = 0;
	if (aflg || dflg)
		tflg = 0;

	getpass();
	uconv();
	openfiles();
	getkvars();
	printhdr();
	procp = getw(nl[X_PROC].n_value);
	nproc = getw(nl[X_NPROC].n_value);
	for (i=0; i<nproc; i +=NPROC) {
		klseek(kmem, (long)procp, 0);
		j = nproc - i;
		if (j > NPROC)
			j = NPROC;
		j *= sizeof(struct proc);
		if (read(kmem, (char *)proc, j) != j) {
			cantread("proc table", kmemf);
			exit(1);
		}
		procp += j;
		for (j = j / sizeof (struct proc) - 1; j >= 0; j--) {
			mproc = &proc[j];
			found = 0;
			if (mproc->p_stat == 0)	
				continue;
			puid = mproc->p_uid;
			ppid = mproc->p_pid;
			ppgrp = mproc->p_pgrp;
			if ((ppid == ppgrp) && (dflg || aflg))
				continue;	
			if (eflg || dflg)
				found++;
			else if (pflg && search(pid, npid, ppid))
				found++;
			else if (uflg && ufind(puid))
				found++;
			else if (gflg && search(grpid, ngrpid, ppgrp))
				found++;
			if ( !found && !tflg && !aflg )
				continue;
			if (prcom(found, mproc)) {
				printf("\n");
				retcode = 0;
			}
		}
	}
	exit(retcode);
}

getw(loc)
	unsigned long loc;
{
	int word;

	klseek(kmem, (long)loc, 0);
	if (read(kmem, (char *)&word, sizeof (word)) != sizeof (word))
		printf("error reading kmem at %x\n", loc);
	return (word);
}

klseek(fd, loc, off)
	int fd, off;
	long loc;
{
	if (cflg) {
		if ((loc = vtophys(loc)) == -1)
			return;
	}
	(void) lseek(fd, (long)loc, off);
}

openfiles()
{
	kmem = open(kmemf, 0);
	if (kmem < 0) {
		perror(kmemf);
		exit(1);
	}
	if (cflg)  {
		mem = kmem;
		memf = kmemf;
	} else {
		mem = open(memf, 0);
		if (mem < 0) {
			perror(memf);
			exit(1);
		}
	}
	swap = open(swapf, 0);
	if (swap < 0) {
		perror(swapf);
		exit(1);
	}
}

getkvars(argc, argv)
	char **argv;
{
	init_nlist();
	if (!cflg)
		nl[X_SYSMAP].n_un.n_name = "";
	nlist(nlistf, nl);
	nttys = 0;
	getdev();

	if (nl[0].n_type == 0) {
		fprintf(stderr, "%s: No namelist\n", nlistf);
		exit(1);
	}
	if (cflg) {
		/* We must do the sys map first because klseek uses it */
		long	addr;

		Syssize = nl[X_SYSSIZE].n_value;
		Sysmap = (struct pte *)
			calloc((unsigned) Syssize, sizeof (struct pte));
		if (Sysmap == NULL) {
			fprintf(stderr, "Out of space for Sysmap\n");
			exit(1);
		}
		addr = (long) nl[X_SYSMAP].n_value;
#ifdef	is68k
		addr &= ~0xF0000000;
#else	is68k
		addr &= ~0x80000000;
#endif	is68k
		(void) lseek(kmem, addr, 0);
		read(kmem, (char *) Sysmap, Syssize * sizeof (struct pte));
	}
	usrpt = (struct pte *)nl[X_USRPT].n_value;
	Usrptmap = (struct pte *)nl[X_USRPTMAP].n_value;
	klseek(kmem, (long)nl[X_NSWAP].n_value, 0);
	if (read(kmem, (char *)&nswap, sizeof (nswap)) != sizeof (nswap)) {
		cantread("nswap", kmemf);
		exit(1);
	}
	dmmin = getw(nl[X_DMMIN].n_value);
	dmmax = getw(nl[X_DMMAX].n_value);
}

printhdr()
{
	if (fflg && lflg )
		printf(" F S     UID   PID  PPID  C PRI NI     ADDR     SZ    WCHAN    STIME TTY      TIME COMD\n");
	else if (fflg)
		printf("     UID   PID  PPID  C    STIME TTY      TIME COMMAND\n");
	else if (lflg)
		printf(" F S   UID   PID  PPID  C PRI NI     ADDR     SZ    WCHAN TTY      TIME COMD\n");
	else
		printf("   PID TTY      TIME COMMAND\n");
	(void) fflush(stdout);
}

cantread(what, fromwhat)
	char *what, *fromwhat;
{

	fprintf(stderr, "ps: error reading %s from %s\n", what, fromwhat);
}

struct	dirent *dbuf;
int	dialbase;

getdev()
{
	register DIR *df;
	struct ttys *t;
	struct lttys *lt;

	if (chdir("/dev") < 0) {
		perror("/dev");
		exit(1);
	}
	dialbase = -1;
	if ((df = opendir(".")) == NULL) {
		fprintf(stderr, "Can't open . in /dev\n");
		exit(1);
	}
	while ((dbuf = readdir(df)) != NULL) 
		maybetty();
	closedir(df);
	allttys = (struct ttys *)malloc(sizeof(struct ttys)*nttys);
	if (allttys == NULL) {
		fprintf(stderr, "ps: Can't malloc space for tty table\n");
		exit(1);
	}
	for (lt = lallttys, t = allttys; lt ; lt = lt->next, t++)
		*t = lt->ttys;
}

/*
 * Attempt to avoid stats by guessing minor device
 * numbers from tty names.  Console is known,
 * know that r(hp|up|mt) are unlikely as are different mem's,
 * floppy, null, tty, etc.
 */
maybetty()
{
	register char *cp = dbuf->d_name;
	static struct lttys *dp;
	struct lttys *olddp;
	int x, i;
	struct stat stb;

	switch (cp[0]) {

	case 'c':
		if (!strcmp(cp, "console")) {
			x = 0;
			goto donecand;
		}
		/* cu[la]? are possible!?! don't rule them out */
		break;

	case 'd':
		if (!strcmp(cp, "drum"))
			return;
		break;

	case 'f':
		if (!strcmp(cp, "floppy"))
			return;
		break;

	case 'k':
		cp++;
		if (*cp == 'U')
			cp++;
		goto trymem;

	case 'r':
		cp++;
#define is(a,b) cp[0] == 'a' && cp[1] == 'b'
		if (is(h,p) || is(r,a) || is(u,p) || is(h,k) 
		    || is(r,b) || is(m,t)) {
			cp += 2;
			if (isdigit(*cp) && cp[2] == 0)
				return;
		}
		break;

	case 'm':
trymem:
		if (cp[0] == 'm' && cp[1] == 'e' && cp[2] == 'm' && cp[3] == 0)
			return;
		if (cp[0] == 'm' && cp[1] == 't')
			return;
		break;

	case 'n':
		if (!strcmp(cp, "null"))
			return;
		if (!strncmp(cp, "nrmt", 4))
			return;
		break;

	case 'p':
		if (cp[1] && cp[1] == 't' && cp[2] == 'y')
			return;
		break;

	case 'v':
		if ((cp[1] == 'a' || cp[1] == 'p') && isdigit(cp[2]) &&
		    cp[3] == 0)
			return;
		break;
	}
	for (cp = dbuf->d_name, i = 0 ; i < DIRSIZ && *cp ; i++, cp++);
	cp--;
	x = 0;
	if (cp[-1] == 'd') {
		if (dialbase == -1) {
			if (stat("ttyd0", &stb) == 0)
				dialbase = stb.st_rdev & 017;
			else
				dialbase = -2;
		}
		if (dialbase == -2)
			x = 0;
		else
			x = 11;
	}
	if (cp > dbuf->d_name && isdigit(cp[-1]) && isdigit(*cp))
		x += 10 * (cp[-1] - ' ') + cp[0] - '0';
	else if (*cp >= 'a' && *cp <= 'f')
		x += 10 + *cp - 'a';
	else if (isdigit(*cp))
		x += *cp - '0';
	else
		x = -1;
donecand:
	olddp = dp;
	dp = (struct lttys *)malloc(sizeof(struct lttys));
	if (dp == NULL) {
		fprintf(stderr, "ps: Can't malloc space for tty table\n");
		exit(1);
	}
	if (lallttys == NULL)
		lallttys = dp;
	nttys++;
	if (olddp)
		olddp->next = dp;
	dp->next = NULL;
	(void) strncpy(dp->ttys.name, dbuf->d_name, DIRSIZ);
	if (uflg) {
		if (stat(dp->ttys.name, &stb) == 0 &&
		   (stb.st_mode&S_IFMT)==S_IFCHR)
			dp->ttys.ttyd = x = stb.st_rdev;
		else {
			nttys--;
			if (lallttys == dp)
				lallttys = NULL;
			free(dp);
			dp = olddp;
			if (dp)
				dp->next = NULL;
			return;
		}
	} else
		dp->ttys.ttyd = -1;
	if (x == -1)
		return;
	x &= 017;
	dp->ttys.cand = cand[x];
	cand[x] = nttys-1;
}

char *
gettty()
{
	register char *p;
	register struct ttys *dp;
	struct stat stb;
	int x;

	if (u.u_ttyp == 0)
		return("?");
	x = u.u_ttyd & 017;
	for (dp = &allttys[cand[x]]; dp != &allttys[-1];
	     dp = &allttys[dp->cand]) {
		if (dp->ttyd == -1) {
			if (stat(dp->name, &stb) == 0 &&
			   (stb.st_mode&S_IFMT)==S_IFCHR)
				dp->ttyd = stb.st_rdev;
			else
				dp->ttyd = -2;
		}
		if (dp->ttyd == u.u_ttyd)
			goto found;
	}
	/* ick */
	for (dp = allttys; dp < &allttys[nttys]; dp++) {
		if (dp->ttyd == -1) {
			if (stat(dp->name, &stb) == 0 &&
			   (stb.st_mode&S_IFMT)==S_IFCHR)
				dp->ttyd = stb.st_rdev;
			else
				dp->ttyd = -2;
		}
		if (dp->ttyd == u.u_ttyd)
			goto found;
	}
	return ("?");
found:
	p = dp->name;
	if (p[0]=='t' && p[1]=='t' && p[2]=='y')
		p += 3;
	return (p);
}

prcom(found, pp)			/* print info about the process */
int found;
struct proc	*pp;
{
	register char *tp, *cmdp, **ttyp, *str;
	char *ctime(), timbuf[26], *curtim = timbuf, *sttim, *s1;
	time_t *clock, *tloc, tim, time();
	long tm;
	int match, i;

	/* if process is zombie, call print routine and return */
	if (((mproc->p_stat==SZOMB) && (tflg && !found)) || (getu() == 0))
			return(0);
	cmdp = getcmd();
	if (cmdp == 0)
		return(0);

	/* get current terminal - if none (?) and aflg is set */
	/* then don't print info - if tflg is set, check if term */
	/* is in list of desired terminals and print if so   */
	tp = gettty();
	if ( aflg && (*tp == '?' ))
		return(0);
	if(tflg && !found) {	/* the t option */
		for (ttyp=tty, match=0; (str = *ttyp) !=0 && !match; ttyp++)
			if (strcmp(tp,str) == 0)
				match++;
		if(!match)
			return(0);
	}

	if (lflg)
		printf("%2x %c", mproc->p_flag&0377, state(mproc));   
	if (fflg) {
		i = getunam(mproc->p_uid);
		if (i >= 0)
			printf("%8.8s", ud[i].name);
		else
			printf("%8.8u", mproc->p_uid);
	}
	else if (lflg)
		printf("%6u", mproc->p_uid);
	printf("%6u",mproc->p_pid);
	if (lflg || fflg)
		printf("%6u%3d", mproc->p_ppid, mproc->p_cpu&0377);
	if (lflg) {
		printf("%4d%3d",mproc->p_pri, mproc->p_nice);	
		printf("%9x%7d", mproc->p_addr,
			 mproc->p_dsize + mproc->p_tsize + mproc->p_ssize);
		if (mproc->p_wchan && mproc->p_stat != SZOMB)
			printf("%9x",mproc->p_wchan);		
		else 
			printf("         ");
	}
	if (fflg) {		  /* STIME*/
		clock = (time_t *)&u.u_start;
		tim = time((time_t *) 0);
		tloc = &tim;
		s1 = ctime(tloc);
		strcpy(curtim,s1);
		sttim = ctime(clock);
		prtim(curtim, sttim);
	}
	printf(" %-7.14s", tp);	
	if (mproc->p_stat==SZOMB) 
		tm = 0;
	else
		tm = u.u_ru.ru_utime.tv_sec + u.u_ru.ru_stime.tv_sec;
	printf(" %2ld:%.2ld", tm/60, tm%60);
	if (!fflg)
		printf(" %.8s", cmdp);
	else if (lflg)
		printf(" %.35s", cmdp);
	else
		printf(" %.*s", PSARGSZ, cmdp);
	return(1);
}


getu()
{
	struct pte *pteaddr, apte, arguutl[UPAGES+CLSIZE];
	register int i, ncl, size;

	size = sflg ? ctob(UPAGES) : sizeof (struct user);
	if ((mproc->p_flag & SLOAD) == 0) {
		if (swap < 0)
			return (0);
		(void) lseek(swap, (long)dtob(mproc->p_swaddr), 0);
		if (read(swap, (char *)&user.user, size) != size) {
			fprintf(stderr, "ps: cant read u for pid %d from %s\n",
			    mproc->p_pid, swapf);
			return (0);
		}
		pcbpf = 0;
		argaddr = 0;
		return (1);
	}
	pteaddr = &Usrptmap[btokmx(mproc->p_p0br) + mproc->p_szpt - 1];
	klseek(kmem, (long)pteaddr, 0);
	if (read(kmem, (char *)&apte, sizeof(apte)) != sizeof(apte)) {
		printf("ps: cant read indir pte to get u for pid %d from %s\n",
		    mproc->p_pid, kmemf);
		return (0);
	}
	lseek(mem,
	    (long)ctob(apte.pg_pfnum+1) - (UPAGES+CLSIZE) * sizeof (struct pte),
		0);
	if (read(mem, (char *)arguutl, sizeof(arguutl)) != sizeof(arguutl)) {
		printf("ps: cant read page table for u of pid %d from %s\n",
		    mproc->p_pid, memf);
		return (0);
	}
	if (arguutl[0].pg_fod == 0 && arguutl[0].pg_pfnum)
		argaddr = ctob(arguutl[0].pg_pfnum);
	else
		argaddr = 0;
	pcbpf = arguutl[CLSIZE].pg_pfnum;
	ncl = (size + NBPG*CLSIZE - 1) / (NBPG*CLSIZE);
	while (--ncl >= 0) {
		i = ncl * CLSIZE;
		lseek(mem, (long)ctob(arguutl[CLSIZE+i].pg_pfnum), 0);
		if (read(mem, user.upages[i], CLSIZE*NBPG) != CLSIZE*NBPG) {
			printf("ps: cant read page %d of u of pid %d from %s\n",
			    arguutl[CLSIZE+i].pg_pfnum, mproc->p_pid, memf);
			return(0);
		}
	}
	return (1);
}

char cmdbuf[CLSIZE*NBPG];
char *
getcmd()
{
	union {
		char	argc[CLSIZE*NBPG];
		int	argi[CLSIZE*NBPG/sizeof (int) + 1];
	} argspac;
	register char *cp, c, *file;
	register int *ip, nbad;
	struct dblock db;

#ifdef	is68k
	if (mproc->p_stat == SZOMB || mproc->p_flag&SWEXIT)
#else	is68k
	if (mproc->p_stat == SZOMB || mproc->p_flag&(SSYS|SWEXIT))
#endif	is68k
		return ("<defunct>");
#ifdef	is68k
	if (mproc->p_flag&SSYS || u.u_ssize == 0)
		goto retucomm;
#endif	is68k
	if ((mproc->p_flag & SLOAD) == 0 || argaddr == 0) {
		if (swap < 0)
			goto retucomm;
		vstodb(0, CLSIZE, &u.u_smap, &db, 1);
		(void) lseek(swap, (long)dtob(db.db_base), 0);
		if (read(swap, (char *)&argspac, sizeof(argspac))
		    != sizeof(argspac))
			goto bad;
		file = swapf;
	} else {
		lseek(mem, (long)argaddr, 0);
		if (read(mem, (char *)&argspac, sizeof (argspac))
		    != sizeof (argspac))
			goto bad;
		file = memf;
	}
	ip = &argspac.argi[CLSIZE*NBPG/sizeof (int)];
	ip -= 2;		/* last arg word and .long 0 */
	while (*--ip)
		if (ip == argspac.argi)
			goto retucomm;
	*(char *)ip = ' ';
	ip++;
	nbad = 0;
	for (cp = (char *)ip; cp < &argspac.argc[CLSIZE*NBPG]; cp++) {
		c = *cp & 0177;
		if (c == 0)
			*cp = ' ';
		else if (c < ' ' || c > 0176) {
			if (++nbad >= 5*(eflg+1)) {
				*cp++ = ' ';
				break;
			}
			*cp = '?';
		} else if (eflg == 0 && c == '=') {
			while (*--cp != ' ')
				if (cp <= (char *)ip)
					break;
			break;
		}
	}
	*cp = 0;
	while (*--cp == ' ')
		*cp = 0;
	cp = (char *)ip;
	(void) strncpy(cmdbuf, cp, &argspac.argc[CLSIZE*NBPG] - cp);
	if (cp[0] == '-' || cp[0] == '?' || cp[0] <= ' ') {
		(void) strcat(cmdbuf, " (");
		(void) strncat(cmdbuf, u.u_comm, sizeof(u.u_comm));
		(void) strcat(cmdbuf, ")");
	}
	return (cmdbuf);

bad:
	fprintf(stderr, "ps: error locating command name for pid %d from %s\n",
	    mproc->p_pid, file);
retucomm:
	(void) strcpy(cmdbuf, " (");
	(void) strncat(cmdbuf, u.u_comm, sizeof (u.u_comm));
	(void) strcat(cmdbuf, ")");
	return (cmdbuf);
}

char 
state(mproc)
	register struct proc *mproc;
{
	char stat;

	switch (mproc->p_stat) {

	case SSTOP:
		stat = 'T';
		break;

	case SSLEEP:
		if (mproc->p_pri >= PZERO)
			if (mproc->p_slptime >= MAXSLP)
				stat = 'I';
			else
				stat = 'S';
		else if (mproc->p_flag & SPAGE)
			stat = 'P';
		else
			stat = 'D';
		break;

	case SWAIT:
	case SRUN:
	case SIDL:
		stat = 'R';
		break;

	case SZOMB:
		stat = 'Z';
		break;

	default:
		stat = '?';
	}
	return (stat);
}

/*
 * Given a base/size pair in virtual swap area,
 * return a physical base/size pair which is the
 * (largest) initial, physically contiguous block.
 */
vstodb(vsbase, vssize, dmp, dbp, rev)
	register int vsbase;
	int vssize;
	struct dmap *dmp;
	register struct dblock *dbp;
{
	register int blk = dmmin;
	register swblk_t *ip = dmp->dm_map;

	vsbase = ctod(vsbase);
	vssize = ctod(vssize);
	if (vsbase < 0 || vsbase + vssize > dmp->dm_size)
		printf("vstodb");
	while (vsbase >= blk) {
		vsbase -= blk;
		if (blk < dmmax)
			blk *= 2;
		ip++;
	}
	if (*ip <= 0 || *ip + blk > nswap)
		printf("vstodb *ip");
	dbp->db_size = vssize > (blk - vsbase) ? (blk - vsbase) : vssize;
	dbp->db_base = *ip + (rev ? blk - (vsbase + dbp->db_size) : vsbase);
}

/*
 * This routine was stolen from adb to simulate memory management
 * on the VAX.
 */
off_t
vtophys(loc)
long	loc;
{
	register	p;
	off_t	newloc;
	int	mask;

#ifdef	vax
	mask = 0xc0000000;
#endif	vax
#ifdef	is68k
	mask = 0xF0000000;
#endif	is68k
	newloc = loc & ~mask;
	p = btop(newloc);
	if ((loc & mask) == 0) {
		fprintf(stderr, "Vtophys: translating non-kernel address\n");
		return((off_t) -1);
	}
	if (p >= Syssize) {
		fprintf(stderr, "Vtophys: page out of bound (%d>=%d)\n",
			p, Syssize);
		return((off_t) -1);
	}
	if (Sysmap[p].pg_v == 0
	&& (Sysmap[p].pg_fod || Sysmap[p].pg_pfnum == 0)) {
		fprintf(stderr, "Vtophys: page not valid\n");
		return((off_t) -1);
	}
	loc = (long) (ptob(Sysmap[p].pg_pfnum) + (loc & PGOFSET));
	return(loc);
}

/*
 * since we can't init unions, the cleanest way to use a.out.h instead
 * of nlist.h (required since nlist() uses some defines) is to do a
 * runtime copy into the nl array -- sigh
 */
init_nlist()
{
	register struct nlist *np;
	register char **namep;

	nllen = sizeof nl_names / sizeof (char *);
	np = nl = (struct nlist *) malloc(nllen * sizeof (struct nlist));
	if (np == NULL) {
		fprintf(stderr, "ps: out of memory allocating namelist\n");
		exit(1);
	}
	namep = &nl_names[0];
	while (nllen > 0) {
		np->n_un.n_name = *namep;
		if (**namep == '\0')
			break;
		namep++;
		np++;
	}
}

/*
 * nlist - retreive attributes from name list (string table version)
 * 	modified to add wait channels - Charles R. LaBrec 8/85
 */
nlist(name, list)
	char *name;
	struct nlist *list;
{
	register struct nlist *p, *q;
	register char *s1, *s2;
	register n, m;
	int maxlen, nreq, type;
	FILE *f, *sf;
	off_t sa, ss;
	struct exec buf;
	struct nlist space[BUFSIZ/sizeof (struct nlist)];
	char nambuf[BUFSIZ];

	maxlen = 0;
	for (q = list, nreq = 0; q->n_un.n_name && q->n_un.n_name[0]; q++, nreq++) {
		q->n_type = 0;
		q->n_value = 0;
		q->n_desc = 0;
		q->n_other = 0;
		n = strlen(q->n_un.n_name);
		if (n > maxlen)
			maxlen = n;
	}
	f = fopen(name, "r");
	if (f == NULL)
		return (-1);
	fread((char *)&buf, sizeof buf, 1, f);
	if (N_BADMAG(buf)) {
		fclose(f);
		return (-1);
	}
	sf = fopen(name, "r");
	if (sf == NULL) {
		/* ??? */
		fclose(f);
		return(-1);
	}
	sa = N_SYMOFF(buf);
	ss = sa + buf.a_syms;
	n = buf.a_syms;
	fseek(f, sa, 0);
	while (n) {
		m = sizeof (space);
		if (n < m)
			m = n;
		if (fread((char *)space, m, 1, f) != 1)
			break;
		n -= m;
		for (q = space; ((int)(m -= sizeof(struct nlist))) >= 0; q++) {
			if (q->n_un.n_strx == 0 || q->n_type & N_STAB)
				continue;
			/*
			 * since we know what type of symbols we will get,
			 * we can make a quick check here -- crl
			 */
			type = q->n_type & (N_TYPE | N_EXT);
			if ((q->n_type & N_TYPE) != N_ABS
			    && type != (N_EXT | N_DATA)
			    && type != (N_EXT | N_BSS))
				continue;
			fseek(sf, ss+q->n_un.n_strx, 0);
			fread(nambuf, maxlen+1, 1, sf);
			for (p = list; p->n_un.n_name && p->n_un.n_name[0]; p++) {
				s1 = p->n_un.n_name;
				s2 = nambuf;
				if (strcmp(p->n_un.n_name, nambuf) == 0) {
					p->n_value = q->n_value;
					p->n_type = q->n_type;
					p->n_desc = q->n_desc;
					p->n_other = q->n_other;
					--nreq;
					break;
				}
			}
		}
	}
alldone:
	fclose(f);
	fclose(sf);
	return (nreq);
}

/* Get the passwd file data into the ud structure */
getpass()
{
	struct passwd *pw, *getpwent();

	ud = NULL;
	nud = 0;
	maxud = 0;

	while((pw=getpwent()) != NULL) {
		while(nud >= maxud) {
			maxud += UDQ;
			ud = (struct udata *) ((ud == NULL) ?
				malloc(sizeof(struct udata) * maxud) :
				realloc(ud, sizeof(struct udata) * maxud));
			if(ud == NULL) {
				fprintf(stderr,"ps: not enough memory for %d users\n", maxud);
				exit(1);
			}
		}
		/* copy fields from pw file structure to udata */
		ud[nud].uid = pw->pw_uid;
		strncpy(ud[nud].name, pw->pw_name, MAXLOGIN);
		nud++;
	}
	endpwent();
}

uconv()
{
	int found, pwuid, i, j;

	/* search thru name array for oarg */
	for (i=0; i<nut; i++) {
		found = -1;
		for(j=0; j<nud; j++) {
			if (strncmp(uid_tbl[i].name, ud[j].name, MAXLOGIN)==0) {
				found = j;
				break;
			}
		}
		/* if not found and oarg is numeric */
		/* then search through number array */
		if (found < 0 && (uid_tbl[i].name[0] >= '0' && uid_tbl[i].name[0] <= '9')) {
			pwuid = atoi(uid_tbl[i].name);
			for (j=0; j<nud; j++) {
				if (pwuid == ud[j].uid) {
					found = j;
					break;
				}
			}
		}

		/* if found then enter found index into tbl array */
		if ( found != -1 ) {
			uid_tbl[i].uid = ud[found].uid;
			strncpy(uid_tbl[i].name,ud[found].name,MAXLOGIN);
		}else {
			fprintf(stderr,"ps: unknown user %s\n",uid_tbl[i].name);
			for(j=i+1; j<nut; j++) {
				strncpy(uid_tbl[j-1].name,uid_tbl[j].name,MAXLOGIN);
			}
			nut--;
			if (nut <= 0) exit(1);
			i--;
		}
	}
	return;
}


/* search returns 1 if arg is found in array arr */
/* which has length num, and returns 0 if not found */

search(arr, number, arg)
int arr[], number, arg;
{
	int i;

	for (i = 0; i < number; i++)
		if (arg == arr[i])
			return(1);
	return(0);
}

/* after the u option */
/* for full command (-f flag) print user name instead of number */
/* search thru existing table of userid numbers and if puid is found, */
/* return corresponding name.  Else search thru /etc/passwd */

getunam(puid)
int puid;
{
	int i;

	for(i=0; i<nud; i++)
		if(ud[i].uid == puid)
			return(i);
	return(-1);
}

/* ufind will return 1 if puid is in table ; if not return 0 */
ufind(puid)
int puid;
{
	int i;

	for(i=0; i<nut; i++)
		if(uid_tbl[i].uid == puid)
			return(1);
	return(0);
}



/* getarg finds next argument in list and copies arg into argbuf  */
/* p1 first pts to arg passed back from getopt routine.  p1 is then */
/* bumped to next character that is not a comma or blank - p1 null */
/* indicates end of list    */

getarg()
{
	char *parga;

	parga = argbuf;
	while(*p1 && *p1 != ',' && *p1 != ' ')
		*parga++ = *p1++;
	*parga = '\0';

	while( *p1 && ( *p1 == ',' || *p1 == ' ') )
		p1++;
}

/* print starting time of process unless process started more */
/* than 24 hours ago in which case date is printed   */
/* sttim is start time and it is compared to curtim (current time ) */

prtim(curtim, sttim)
char *curtim, *sttim;
{
	char *ptr1, *ptr2;
	char dayst[3], daycur[3];

	if ( strncmp(curtim, sttim, 11) == 0) {
		ptr1 = sttim + 11;
		ptr2 = ptr1 + 8;
	}
	else {
		ptr1 = sttim + 4;
		ptr2 = ptr1 + 7;
		/* if time is < 24 hours different, then print time */
		if (strncmp(curtim+4, sttim+4, 3) == 0) {
			strncpy(dayst,sttim+8, 2);
			strcat(dayst,"");
			strncpy(daycur,curtim+8,2);
			strcat(daycur,"");
			if ((atoi(dayst) +1 == atoi(daycur)) &&
				 (strncmp(curtim+11,sttim+11,8)<=0)) {
				ptr1 = sttim + 11;
				ptr2 = ptr1 + 8;
			}
		}
	}
	*ptr2 = '\0';
	printf("%9.9s",ptr1);
}
