/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)mailx:lock.c	1.2"
#

/*
 * mailx -- a modified version of a University of California at Berkeley
 *	mail program
 *
 * Stuff to do version 7 style locking.
 */

#include "rcv.h"
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/proc.h>
#include <errno.h>

extern int errno;
static char		curlock;		/* Last used name of lock */
static	int		locked;			/* To note that we locked it */
#define	MFMODE	0660

lock(file)
char *file;
{
	if (locked)
		return;
	if ((curlock = open(file, O_WRONLY|O_CREAT, MFMODE)) < 0) {
		fprintf (stderr, "Cannot open ");
		perror(file);
		exit(1);
	} else {
		setuniverse(UNIVERSE_BSD ,0);
		flock(curlock, LOCK_EX);
		bsd_setuniv(UNIVERSE_SYSV);
		locked = 1;
	}
}
unlock()
{
	if (locked == 0) 
		return;
	setuniverse(UNIVERSE_BSD ,0);
	flock(curlock, LOCK_UN);
	bsd_setuniv(UNIVERSE_SYSV);
	locked = 0;
}
