
#ident	"@(#)lpr:lpstat.c	1.1"
/* lpstat -- display line printer status */


#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <grp.h>
#include "lp.local.h"

char errmsg[100];
int tflag;
int nlist;
char *lpqargv[50];
char prnarg[50];
char *printer;

main(argc, argv)
int argc;
char *argv[];
{
	int i;
	char *arg, letter;
	extern struct passwd *getpwuid();
	struct passwd *pw;
	char * getenv();


	addlist(BSDLPQ);
	if(argc == 1) {
		if ((pw = getpwuid(getuid())) == NULL)
			fatal("Who are you?");
		addlist(pw->pw_name);
	} else {
	    for(i = 1; i < argc; i++) {
		    arg = argv[i];
		    if(*arg == '-') {
			    letter = tolower(*(arg + 1));
			    if(! islower(letter)) {
				    sprintf(errmsg, "unknown option \"%s\"",
				       arg);
				    fatal(errmsg);
				    continue;
			    }
			    switch(letter) {
			    case 'd':	/* default destination */
				    if ((printer = getenv("LPDEST")) == NULL)
					    printer = DEFLP;
				    printf("Default destination is %s\n",
						printer);
				    break;
			    case 'o':	/* output for destinations */
				    addlist(arg + 2);
				    break;
			    case 'p':	/* printer status */
				    printer = arg + 2;
				    break;
			    case 't':	/* print all info */
				    tflag++;
				    break;
			    case 'u':	/* output for user list */
				    addlist(arg + 2);
				    break;
			    default:
				    sprintf(errmsg, "unknown option \"%s\"",
				       arg);
				    fatal(errmsg);
			    }
		    }
		    else
			    addlist(arg);
	    }
	}
	if (tflag)
		nlist = 1;
	if (printer == NULL && (printer = getenv("LPDEST")) == NULL)
                printer = DEFLP;
	strcat(prnarg, "-P");
	strcat(prnarg, printer);
	addlist(prnarg);
	lpqargv[nlist] = 0;
	execv(BSDLPQ, lpqargv);
	fatal("exec BSD lpq failed");
}

addlist(list)
register char *list;
{
	if (*list == '\0')
		return;

	lpqargv[nlist++] = list;
	while (*list) {
		if (*list == ',') {
			*list = '\0';
			list++;
			lpqargv[nlist++] = list;
		} else
			list++;
	}
}

fatal(msg)
char *msg;
{
	printf("%s\n", msg);
	exit(-1);
}
