#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#ident	"@(#)lpr:lp.mk	1.2"
# Makefile for lp line printer spooler system

ROOT	= 
BINCOMP = cancel lp lpstat
LPCOMP  = pokelpd
USRDIR	= $(ROOT)/usr/bin
ADMDIR	= $(ROOT)/usr/lib
CFLAGS	= -O
LDFLAGS	= -s -n
LOAD	= $(CC) $(LDFLAGS) -o $@ $@.o printcap.o sys.o
BSDCC 	= /.bin.BSD/cc
INS 	= install

all:	$(BINCOMP) $(LPCOMP)

cancel:	cancel.c lp.local.h
	$(CC) $(CFLAGS) $(LDFLAGS) -o $@ $@.c
	
lp:	lp.c printcap.o sys.o
	$(CC) $(CFLAGS) $(LDFLAGS) -o $@ $@.c printcap.o sys.o

lpstat:	lpstat.c
	$(CC) $(CFLAGS) $(LDFLAGS) -o $@ $@.c

pokelpd: pokelpd.c
	$(BSDCC) -o pokelpd pokelpd.c

printcap.o: printcap.c
	$(CC) -c $(CFLAGS) $(LDFLAGS) printcap.c

sys.o: sys.s
	$(CC) -c sys.s

install: $(BINCOMP) $(LPCOMP)
	for c in $(BINCOMP) ;\
	do \
		$(INS) -f $(USRDIR) -m 6775 -u root -g daemon $$c; \
	done
	for c in $(LPCOMP) ;\
	do \
		$(INS) -f $(ADMDIR) -m 6775 -u root -g daemon $$c; \
	done

clean:	
	rm -f  *.o

clobber:	clean
	rm -f $(BINCOMP) $(LPCOMP)
